/*
 * Decompiled with CFR 0.152.
 */
package com.example.speedrunnerswap.tracking;

import com.example.speedrunnerswap.SpeedrunnerSwap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.CompassMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class TrackerManager {
    private final SpeedrunnerSwap plugin;
    private volatile BukkitTask trackerTask;
    private boolean isJammed = false;
    private final Object taskLock = new Object();
    private final Map<UUID, Integer> compassSlotCache = new HashMap<UUID, Integer>();
    private final Set<UUID> endHintNotifiedOnce = new HashSet<UUID>();
    private volatile Location lastRunnerOverworldLocation;
    private volatile Location lastRunnerEndPortalLocation;

    public TrackerManager(SpeedrunnerSwap plugin) {
        this.plugin = plugin;
    }

    public void cleanupPlayer(UUID id) {
        if (id == null) {
            return;
        }
        this.compassSlotCache.remove(id);
        this.endHintNotifiedOnce.remove(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startTracking() {
        if (!this.plugin.getConfigManager().isTrackerEnabled()) {
            this.stopTracking();
            return;
        }
        Object object = this.taskLock;
        synchronized (object) {
            if (this.trackerTask != null) {
                this.trackerTask.cancel();
            }
            int updateTicks = Math.max(10, this.plugin.getConfigManager().getTrackerUpdateTicks());
            this.trackerTask = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
                if (!this.plugin.getConfigManager().isTrackerEnabled()) {
                    this.stopTracking();
                    return;
                }
                if (!this.hasOnlineHunters()) {
                    this.stopTracking();
                    return;
                }
                Player activeRunner = this.plugin.getGameManager().getActiveRunner();
                if (activeRunner == null || !activeRunner.isOnline() || !this.plugin.getGameManager().isGameRunning()) {
                    return;
                }
                this.cacheRunnerPositions(activeRunner);
                for (Player hunter : this.plugin.getGameManager().getHunters()) {
                    if (!hunter.isOnline()) continue;
                    this.updateHunterCompass(hunter, activeRunner);
                }
            }, 0L, (long)updateTicks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopTracking() {
        Object object = this.taskLock;
        synchronized (object) {
            if (this.trackerTask != null) {
                this.trackerTask.cancel();
                this.trackerTask = null;
            }
        }
    }

    public void giveTrackingCompass(Player hunter) {
        if (hunter == null || !hunter.isOnline()) {
            return;
        }
        if (!this.hasCompass(hunter)) {
            ItemStack compass = new ItemStack(Material.COMPASS);
            hunter.getInventory().addItem(new ItemStack[]{compass});
            this.compassSlotCache.remove(hunter.getUniqueId());
        }
        this.updateCompass(hunter);
    }

    public void updateCompass(Player hunter) {
        Player activeRunner = this.plugin.getGameManager().getActiveRunner();
        if (activeRunner != null && activeRunner.isOnline()) {
            this.updateHunterCompass(hunter, activeRunner);
        }
    }

    private void updateHunterCompass(Player hunter, Player activeRunner) {
        Location target;
        World rw;
        if (hunter == null || activeRunner == null) {
            return;
        }
        if (!hunter.isOnline()) {
            return;
        }
        if (this.isJammed) {
            return;
        }
        World hw = hunter.getWorld();
        if (hw.equals(rw = activeRunner.getWorld())) {
            target = activeRunner.getLocation();
        } else {
            World.Environment he = hw.getEnvironment();
            World.Environment re = rw.getEnvironment();
            Location rloc = activeRunner.getLocation();
            if (re == World.Environment.THE_END) {
                if (this.lastRunnerEndPortalLocation != null && this.lastRunnerEndPortalLocation.getWorld() != null) {
                    target = this.lastRunnerEndPortalLocation.clone();
                } else {
                    if (this.endHintNotifiedOnce.add(hunter.getUniqueId())) {
                        hunter.sendMessage("\u00a7eTracker: Runner is in \u00a75The End\u00a7e. Fallback compass target set to spawn.");
                    }
                    target = hw.getSpawnLocation();
                }
            } else {
                target = he == World.Environment.NORMAL && re == World.Environment.NETHER ? (this.lastRunnerOverworldLocation != null && this.lastRunnerOverworldLocation.getWorld() != null ? this.lastRunnerOverworldLocation.clone() : hw.getSpawnLocation()) : (he == World.Environment.NETHER && re == World.Environment.NORMAL ? new Location(hw, rloc.getX() / 8.0, rloc.getY(), rloc.getZ() / 8.0) : hw.getSpawnLocation());
            }
        }
        PlayerInventory inv = hunter.getInventory();
        ItemStack off = inv.getItemInOffHand();
        Consumer<ItemStack> updateCompass = item -> {
            void cm;
            if (item == null || item.getType() != Material.COMPASS) {
                return;
            }
            ItemMeta im = item.getItemMeta();
            if (!(im instanceof CompassMeta)) {
                return;
            }
            CompassMeta compassMeta = (CompassMeta)im;
            cm.setLodestone(target);
            cm.setLodestoneTracked(false);
            item.setItemMeta((ItemMeta)cm);
        };
        updateCompass.accept(off);
        ItemStack[] itemStackArray = inv.getContents();
        int n = itemStackArray.length;
        int n2 = 0;
        while (n2 < n) {
            ItemStack it = itemStackArray[n2];
            updateCompass.accept(it);
            ++n2;
        }
    }

    public void updateAllHunterCompasses() {
        Player activeRunner = this.plugin.getGameManager().getActiveRunner();
        if (activeRunner != null && activeRunner.isOnline()) {
            if (!this.hasOnlineHunters()) {
                this.stopTracking();
                return;
            }
            for (Player hunter : this.plugin.getGameManager().getHunters()) {
                if (!hunter.isOnline()) continue;
                this.updateHunterCompass(hunter, activeRunner);
            }
        }
    }

    private void cacheRunnerPositions(Player runner) {
        if (runner == null) {
            return;
        }
        Location loc = runner.getLocation();
        if (loc == null || loc.getWorld() == null) {
            return;
        }
        World.Environment env = loc.getWorld().getEnvironment();
        if (env == World.Environment.NORMAL) {
            this.lastRunnerOverworldLocation = loc.clone();
        }
    }

    public void setLastRunnerOverworldLocation(Location location) {
        if (location == null || location.getWorld() == null) {
            return;
        }
        if (location.getWorld().getEnvironment() != World.Environment.NORMAL) {
            return;
        }
        this.lastRunnerOverworldLocation = location.clone();
    }

    public void setLastRunnerEndPortalLocation(Location location) {
        if (location == null || location.getWorld() == null) {
            return;
        }
        this.lastRunnerEndPortalLocation = location.clone();
        this.endHintNotifiedOnce.clear();
    }

    public void jamCompasses(long durationTicks) {
        this.isJammed = true;
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            this.isJammed = false;
        }, durationTicks);
    }

    private boolean hasCompass(Player player) {
        ItemStack stack;
        if (player == null) {
            return false;
        }
        PlayerInventory inv = player.getInventory();
        if (inv.contains(Material.COMPASS, 1)) {
            return true;
        }
        if (inv.getItemInOffHand() != null && inv.getItemInOffHand().getType() == Material.COMPASS) {
            return true;
        }
        ItemStack[] itemStackArray = inv.getContents();
        int n = itemStackArray.length;
        int n2 = 0;
        while (n2 < n) {
            stack = itemStackArray[n2];
            if (stack != null && stack.getType() == Material.COMPASS) {
                return true;
            }
            ++n2;
        }
        itemStackArray = player.getEnderChest().getContents();
        n = itemStackArray.length;
        n2 = 0;
        while (n2 < n) {
            stack = itemStackArray[n2];
            if (stack != null && stack.getType() == Material.COMPASS) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean hasOnlineHunters() {
        List<Player> hunters = this.plugin.getGameManager().getHunters();
        if (hunters == null || hunters.isEmpty()) {
            return false;
        }
        for (Player hunter : hunters) {
            if (hunter == null || !hunter.isOnline()) continue;
            return true;
        }
        return false;
    }
}

