/*
 * Decompiled with CFR 0.152.
 */
package com.example.speedrunnerswap.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Locale;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;

public final class BukkitCompat {
    private BukkitCompat() {
    }

    public static double getMaxHealthValue(LivingEntity entity) {
        AttributeInstance inst;
        Attribute attr = BukkitCompat.resolveAttribute("GENERIC_MAX_HEALTH", "MAX_HEALTH");
        if (attr != null && (inst = entity.getAttribute(attr)) != null) {
            return inst.getValue();
        }
        return 20.0;
    }

    public static Attribute resolveAttribute(String ... names) {
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            try {
                Field f = Attribute.class.getField(name);
                Object v = f.get(null);
                if (v instanceof Attribute) {
                    return (Attribute)v;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ++n2;
        }
        return null;
    }

    public static PotionEffectType resolvePotionEffect(String id) {
        String key;
        if (id == null) {
            return null;
        }
        key = switch (key = id.toLowerCase(Locale.ROOT).trim()) {
            case "increase_damage" -> "strength";
            case "damage_resistance", "resistance" -> "resistance";
            case "slowness", "slow" -> "slowness";
            case "jump" -> "jump_boost";
            case "slow_digging" -> "mining_fatigue";
            case "nausea", "confusion" -> "nausea";
            case "glow", "glowing" -> "glowing";
            case "dolphins_grace", "dolphin" -> "dolphins_grace";
            case "hero_of_the_village", "hov" -> "hero_of_the_village";
            default -> key;
        };
        try {
            Class<?> nsk = Class.forName("org.bukkit.NamespacedKey");
            Method minecraft = nsk.getMethod("minecraft", String.class);
            Object namespacedKey = minecraft.invoke(null, key);
            Method getByKey = PotionEffectType.class.getMethod("getByKey", nsk);
            Object type = getByKey.invoke(null, namespacedKey);
            if (type instanceof PotionEffectType) {
                return (PotionEffectType)type;
            }
        }
        catch (Throwable nsk) {
            // empty catch block
        }
        try {
            Method getByName = PotionEffectType.class.getMethod("getByName", String.class);
            Object type = getByName.invoke(null, key.toUpperCase(Locale.ROOT));
            if (type instanceof PotionEffectType) {
                return (PotionEffectType)type;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static Double getServerTPS() {
        try {
            double[] arr;
            Method m = Bukkit.class.getMethod("getTPS", new Class[0]);
            Object tpsObj = m.invoke(null, new Object[0]);
            if (tpsObj instanceof double[] && (arr = (double[])tpsObj).length > 0) {
                return arr[0];
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static void showTitle(Player player, String title, String subtitle, int fadeInTicks, int stayTicks, int fadeOutTicks) {
        if (player == null) {
            return;
        }
        try {
            Class<?> compCls = Class.forName("net.kyori.adventure.text.Component");
            Class<?> titleCls = Class.forName("net.kyori.adventure.title.Title");
            Class<?> timesCls = Class.forName("net.kyori.adventure.title.Title$Times");
            Method text = compCls.getMethod("text", String.class);
            Object main = text.invoke(null, title);
            Object sub = text.invoke(null, subtitle);
            Class<?> durationCls = Class.forName("java.time.Duration");
            Method ofMillis = durationCls.getMethod("ofMillis", Long.TYPE);
            Object fadeIn = ofMillis.invoke(null, (long)fadeInTicks * 50L);
            Object stay = ofMillis.invoke(null, (long)stayTicks * 50L);
            Object fadeOut = ofMillis.invoke(null, (long)fadeOutTicks * 50L);
            Method timesFactory = timesCls.getMethod("times", durationCls, durationCls, durationCls);
            Object times = timesFactory.invoke(null, fadeIn, stay, fadeOut);
            Method titleFactory = titleCls.getMethod("title", compCls, compCls, timesCls);
            Object advTitle = titleFactory.invoke(null, main, sub, times);
            Method showTitle = player.getClass().getMethod("showTitle", titleCls);
            showTitle.invoke((Object)player, advTitle);
            return;
        }
        catch (Throwable compCls) {
            try {
                Method send = player.getClass().getMethod("sendTitle", String.class, String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE);
                send.invoke((Object)player, title, subtitle, fadeInTicks, stayTicks, fadeOutTicks);
            }
            catch (Throwable ignored) {
                try {
                    player.sendMessage("\u00a76\u00a7l" + title);
                    if (subtitle != null && !subtitle.isEmpty()) {
                        player.sendMessage("\u00a77" + subtitle);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return;
        }
    }

    public static Entity getTargetEntity(Player player, int maxDistance) {
        if (player == null) {
            return null;
        }
        try {
            Method m = Player.class.getMethod("getTargetEntity", Integer.TYPE, Boolean.TYPE);
            Object ent = m.invoke((Object)player, maxDistance, false);
            return (Entity)ent;
        }
        catch (NoSuchMethodException m) {
        }
        catch (Throwable m) {
            // empty catch block
        }
        try {
            Method m = Player.class.getMethod("getTargetEntity", Integer.TYPE);
            Object ent = m.invoke((Object)player, maxDistance);
            return (Entity)ent;
        }
        catch (NoSuchMethodException m) {
        }
        catch (Throwable m) {
            // empty catch block
        }
        try {
            Location eye = player.getEyeLocation();
            Vector dir = eye.getDirection();
            RayTraceResult res = player.getWorld().rayTraceEntities(eye, dir, (double)maxDistance, e -> e != player);
            if (res != null) {
                return res.getHitEntity();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }
}

