/*
 * Decompiled with CFR 0.152.
 */
package com.example.speedrunnerswap.utils;

import com.example.speedrunnerswap.models.PlayerState;
import com.example.speedrunnerswap.utils.BukkitCompat;
import java.util.ArrayList;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;

public class PlayerStateUtil {
    public static PlayerState capturePlayerState(Player player) {
        return new PlayerState((ItemStack[])player.getInventory().getContents().clone(), (ItemStack[])player.getInventory().getArmorContents().clone(), player.getInventory().getItemInOffHand().clone(), player.getLocation().clone(), player.getHealth(), player.getFoodLevel(), player.getSaturation(), player.getExhaustion(), player.getTotalExperience(), player.getExp(), player.getLevel(), player.getFireTicks(), player.getRemainingAir(), player.getMaximumAir(), player.getGameMode(), player.getFallDistance(), player.getAllowFlight(), player.isFlying(), new ArrayList<PotionEffect>(player.getActivePotionEffects()), player.getAbsorptionAmount(), player.getVehicle(), player.isInsideVehicle(), player.getTicksLived(), player.getLastDamage(), player.getNoDamageTicks(), player.isGliding(), player.getWalkSpeed(), player.getFlySpeed(), player.getPortalCooldown());
    }

    public static void applyPlayerState(Player player, PlayerState state) {
        if (player == null || state == null) {
            return;
        }
        player.getInventory().clear();
        player.getInventory().setContents(state.getInventory());
        player.getInventory().setArmorContents(state.getArmor());
        player.getInventory().setItemInOffHand(state.getOffhand());
        if (state.getLocation() != null) {
            try {
                player.teleport(state.getLocation());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        double max = BukkitCompat.getMaxHealthValue((LivingEntity)player);
        double clamped = Math.max(0.0, Math.min(max, state.getHealth()));
        try {
            player.setHealth(clamped);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        player.setFoodLevel(state.getFoodLevel());
        player.setSaturation(state.getSaturation());
        player.setExhaustion(state.getExhaustion());
        player.setTotalExperience(state.getTotalExperience());
        player.setExp(state.getExp());
        player.setLevel(state.getLevel());
        player.setFireTicks(state.getFireTicks());
        try {
            player.setMaximumAir(state.getMaximumAir());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            player.setRemainingAir(state.getRemainingAir());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (state.getGameMode() != null) {
            player.setGameMode(state.getGameMode());
        }
        player.setFallDistance(state.getFallDistance());
        try {
            player.setAllowFlight(state.isAllowFlight());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            player.setFlying(state.isFlying());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            for (PotionEffect e : player.getActivePotionEffects()) {
                player.removePotionEffect(e.getType());
            }
            if (state.getActivePotionEffects() != null) {
                for (PotionEffect e : state.getActivePotionEffects()) {
                    player.addPotionEffect(e);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            player.setAbsorptionAmount(state.getAbsorptionAmount());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (state.isGliding()) {
                player.setGliding(true);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            player.setTicksLived(state.getTicksLived());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            player.setNoDamageTicks(state.getNoDamageTicks());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            player.setWalkSpeed(state.getWalkSpeed());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            player.setFlySpeed(state.getFlySpeed());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            player.setPortalCooldown(state.getPortalCooldown());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

