/*
 * Decompiled with CFR 0.152.
 */
package com.example.speedrunnerswap.game;

import com.example.speedrunnerswap.SpeedrunnerSwap;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EnderDragonChangePhaseEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;

public class DragonManager
implements Listener {
    private final Map<UUID, Double> dragonHealthCache = new HashMap<UUID, Double>();
    private final Map<UUID, Long> lastHealthUpdate = new HashMap<UUID, Long>();
    private boolean isSwapInProgress = false;

    public DragonManager(SpeedrunnerSwap plugin) {
    }

    public void onSwapStart() {
        this.isSwapInProgress = true;
        this.saveDragonHealth();
    }

    public void onSwapComplete() {
        this.restoreDragonHealth();
        this.isSwapInProgress = false;
    }

    private void saveDragonHealth() {
        for (World world : Bukkit.getWorlds()) {
            if (world.getEnvironment() != World.Environment.THE_END) continue;
            for (Entity entity : world.getEntities()) {
                if (!(entity instanceof EnderDragon)) continue;
                EnderDragon dragon = (EnderDragon)entity;
                this.dragonHealthCache.put(dragon.getUniqueId(), dragon.getHealth());
                this.lastHealthUpdate.put(dragon.getUniqueId(), System.currentTimeMillis());
            }
        }
    }

    private void restoreDragonHealth() {
        for (World world : Bukkit.getWorlds()) {
            if (world.getEnvironment() != World.Environment.THE_END) continue;
            for (Entity entity : world.getEntities()) {
                Long lastUpdate;
                EnderDragon dragon;
                Double savedHealth;
                if (!(entity instanceof EnderDragon) || (savedHealth = this.dragonHealthCache.get((dragon = (EnderDragon)entity).getUniqueId())) == null || (lastUpdate = this.lastHealthUpdate.get(dragon.getUniqueId())) == null || System.currentTimeMillis() - lastUpdate >= 1000L) continue;
                dragon.setHealth(savedHealth.doubleValue());
            }
        }
    }

    @EventHandler
    public void onDragonDamage(EntityDamageEvent event) {
        if (!(event.getEntity() instanceof EnderDragon)) {
            return;
        }
        EnderDragon dragon = (EnderDragon)event.getEntity();
        this.dragonHealthCache.put(dragon.getUniqueId(), dragon.getHealth() - event.getFinalDamage());
        this.lastHealthUpdate.put(dragon.getUniqueId(), System.currentTimeMillis());
    }

    @EventHandler
    public void onDragonHeal(EntityRegainHealthEvent event) {
        if (!(event.getEntity() instanceof EnderDragon)) {
            return;
        }
        EnderDragon dragon = (EnderDragon)event.getEntity();
        if (event.getRegainReason() == EntityRegainHealthEvent.RegainReason.REGEN) {
            this.dragonHealthCache.put(dragon.getUniqueId(), dragon.getHealth() + event.getAmount());
            this.lastHealthUpdate.put(dragon.getUniqueId(), System.currentTimeMillis());
        } else if (this.isSwapInProgress) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onDragonPhaseChange(EnderDragonChangePhaseEvent event) {
        EnderDragon dragon = event.getEntity();
        this.dragonHealthCache.put(dragon.getUniqueId(), dragon.getHealth());
        this.lastHealthUpdate.put(dragon.getUniqueId(), System.currentTimeMillis());
    }

    public Map<UUID, Double> getDragonHealths() {
        HashMap<UUID, Double> currentHealths = new HashMap<UUID, Double>();
        for (World world : Bukkit.getWorlds()) {
            if (world.getEnvironment() != World.Environment.THE_END) continue;
            for (Entity entity : world.getEntities()) {
                if (!(entity instanceof EnderDragon)) continue;
                EnderDragon dragon = (EnderDragon)entity;
                currentHealths.put(dragon.getUniqueId(), dragon.getHealth());
            }
        }
        return currentHealths;
    }

    public boolean hasDragons() {
        for (World world : Bukkit.getWorlds()) {
            if (world.getEnvironment() != World.Environment.THE_END) continue;
            for (Entity entity : world.getEntities()) {
                if (!(entity instanceof EnderDragon)) continue;
                return true;
            }
        }
        return false;
    }

    public void clearCache() {
        this.dragonHealthCache.clear();
        this.lastHealthUpdate.clear();
    }
}

