/*
 * Decompiled with CFR 0.152.
 */
package com.example.speedrunnerswap.utils;

import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.meta.ItemMeta;

public final class GuiCompat {
    private GuiCompat() {
    }

    public static Inventory createInventory(InventoryHolder holder, int size, String title) {
        try {
            return Bukkit.createInventory((InventoryHolder)holder, (int)size, (Component)Component.text((String)title));
        }
        catch (Throwable t) {
            return GuiCompat.createInventoryLegacy(holder, size, title);
        }
    }

    private static Inventory createInventoryLegacy(InventoryHolder holder, int size, String title) {
        return Bukkit.createInventory((InventoryHolder)holder, (int)size, (String)title);
    }

    public static void setDisplayName(ItemMeta meta, String name) {
        try {
            meta.displayName((Component)Component.text((String)name));
        }
        catch (Throwable t) {
            GuiCompat.setDisplayNameLegacy(meta, name);
        }
    }

    public static String getDisplayName(ItemMeta meta) {
        try {
            Component c = meta.displayName();
            if (c != null) {
                return PlainTextComponentSerializer.plainText().serialize(c);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return GuiCompat.getDisplayNameLegacy(meta);
    }

    public static void setLore(ItemMeta meta, List<String> legacyLore) {
        try {
            ArrayList<TextComponent> list = new ArrayList<TextComponent>();
            for (String s : legacyLore) {
                list.add(Component.text((String)s));
            }
            meta.lore(list);
        }
        catch (Throwable t) {
            GuiCompat.setLoreLegacy(meta, legacyLore);
        }
    }

    private static void setDisplayNameLegacy(ItemMeta meta, String name) {
        try {
            meta.setDisplayName(name);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static String getDisplayNameLegacy(ItemMeta meta) {
        try {
            return meta.getDisplayName();
        }
        catch (Throwable throwable) {
            return "";
        }
    }

    private static void setLoreLegacy(ItemMeta meta, List<String> legacyLore) {
        try {
            meta.setLore(legacyLore);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

