/*
 * Decompiled with CFR 0.152.
 */
package com.example.speedrunnerswap.game;

import com.example.speedrunnerswap.SpeedrunnerSwap;
import com.example.speedrunnerswap.models.PlayerState;
import com.example.speedrunnerswap.models.Team;
import com.example.speedrunnerswap.utils.ActionBarUtil;
import com.example.speedrunnerswap.utils.BukkitCompat;
import com.example.speedrunnerswap.utils.Msg;
import com.example.speedrunnerswap.utils.PlayerStateUtil;
import com.example.speedrunnerswap.utils.SafeLocationFinder;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.title.Title;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Vector;

public class GameManager {
    private final SpeedrunnerSwap plugin;
    private boolean gameRunning;
    private boolean gamePaused;
    private Player activeRunner;
    private int activeRunnerIndex;
    private List<Player> runners;
    private List<Player> hunters;
    private BukkitTask swapTask;
    private BukkitTask hunterSwapTask;
    private BukkitTask actionBarTask;
    private BukkitTask titleTask;
    private BukkitTask freezeCheckTask;
    private BukkitTask cageTask;
    private long nextSwapTime;
    private final Map<UUID, PlayerState> playerStates;
    private final Map<UUID, List<BlockState>> builtCages = new HashMap<UUID, List<BlockState>>();
    private final Map<UUID, Location> cageCenters = new HashMap<UUID, Location>();

    public GameManager(SpeedrunnerSwap plugin) {
        this.plugin = plugin;
        this.gameRunning = false;
        this.gamePaused = false;
        this.activeRunnerIndex = 0;
        this.runners = new ArrayList<Player>();
        this.hunters = new ArrayList<Player>();
        this.playerStates = new HashMap<UUID, PlayerState>();
    }

    public boolean startGame() {
        if (this.gameRunning) {
            return false;
        }
        if (!this.canStartGame()) {
            Msg.broadcast("\u00a7cGame cannot start: At least one runner and one hunter are required.");
            return false;
        }
        new BukkitRunnable(){
            int count = 3;

            public void run() {
                if (this.count > 0) {
                    Title title = Title.title((Component)((TextComponent)Component.text((String)("Starting in " + this.count)).color((TextColor)NamedTextColor.GREEN)).decorate(TextDecoration.BOLD), (Component)Component.text((String)"Made by muj3b").color((TextColor)NamedTextColor.GRAY), (Title.Times)Title.Times.times((Duration)Duration.ofMillis(500L), (Duration)Duration.ofMillis(3500L), (Duration)Duration.ofMillis(500L)));
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        player.showTitle(title);
                    }
                    --this.count;
                } else {
                    this.cancel();
                    GameManager.this.gameRunning = true;
                    GameManager.this.gamePaused = false;
                    GameManager.this.activeRunnerIndex = 0;
                    GameManager.this.activeRunner = GameManager.this.runners.get(GameManager.this.activeRunnerIndex);
                    GameManager.this.saveAllPlayerStates();
                    if (GameManager.this.plugin.getConfigManager().isKitsEnabled()) {
                        for (Player player : GameManager.this.runners) {
                            GameManager.this.plugin.getKitManager().giveKit(player, "runner");
                        }
                        for (Player hunter : GameManager.this.hunters) {
                            GameManager.this.plugin.getKitManager().giveKit(hunter, "hunter");
                        }
                    }
                    GameManager.this.applyInactiveEffects();
                    GameManager.this.scheduleNextSwap();
                    GameManager.this.scheduleNextHunterSwap();
                    GameManager.this.startActionBarUpdates();
                    GameManager.this.startTitleUpdates();
                    GameManager.this.startCageEnforcement();
                    if (GameManager.this.plugin.getConfigManager().isTrackerEnabled()) {
                        GameManager.this.plugin.getTrackerManager().startTracking();
                        for (Player hunter : GameManager.this.hunters) {
                            if (!hunter.isOnline()) continue;
                            GameManager.this.plugin.getTrackerManager().giveTrackingCompass(hunter);
                        }
                    }
                    if (GameManager.this.plugin.getConfig().getBoolean("stats.enabled", true)) {
                        GameManager.this.plugin.getStatsManager().startTracking();
                    }
                    if (GameManager.this.plugin.getConfigManager().isFreezeMechanicEnabled()) {
                        GameManager.this.startFreezeChecking();
                    }
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 20L);
        return true;
    }

    public void endGame(final Team winner) {
        TextComponent titleText;
        if (!this.gameRunning) {
            return;
        }
        String runnerSubtitle = "";
        String hunterSubtitle = "";
        if (winner == Team.RUNNER) {
            titleText = Component.text((String)"RUNNERS WIN!", (TextColor)NamedTextColor.GREEN, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD});
            runnerSubtitle = "bro y'all are locked in, good stuff";
            hunterSubtitle = "bro y'all are locked in, good stuff";
        } else if (winner == Team.HUNTER) {
            titleText = Component.text((String)"HUNTERS WIN!", (TextColor)NamedTextColor.RED, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD});
            runnerSubtitle = "you ain't the main character unc";
            hunterSubtitle = "bro those speedrunners are trash asf";
        } else {
            titleText = Component.text((String)"GAME OVER", (TextColor)NamedTextColor.RED, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD});
            runnerSubtitle = "No winner declared.";
            hunterSubtitle = "No winner declared.";
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            TextComponent subtitleText = this.isRunner(player) ? Component.text((String)runnerSubtitle, (TextColor)NamedTextColor.YELLOW) : Component.text((String)hunterSubtitle, (TextColor)NamedTextColor.YELLOW);
            Title endTitle = Title.title((Component)titleText, (Component)subtitleText, (Title.Times)Title.Times.times((Duration)Duration.ofMillis(500L), (Duration)Duration.ofMillis(5000L), (Duration)Duration.ofMillis(500L)));
            player.showTitle(endTitle);
        }
        if (this.swapTask != null) {
            this.swapTask.cancel();
        }
        if (this.hunterSwapTask != null) {
            this.hunterSwapTask.cancel();
        }
        if (this.actionBarTask != null) {
            this.actionBarTask.cancel();
        }
        if (this.titleTask != null) {
            this.titleTask.cancel();
        }
        if (this.freezeCheckTask != null) {
            this.freezeCheckTask.cancel();
        }
        if (this.cageTask != null) {
            this.cageTask.cancel();
            this.cageTask = null;
        }
        this.plugin.getTrackerManager().stopTracking();
        try {
            this.plugin.getStatsManager().stopTracking();
        }
        catch (Exception exception) {
            // empty catch block
        }
        new BukkitRunnable(){

            public void run() {
                if (GameManager.this.plugin.getConfig().getBoolean("swap.preserve_runner_progress_on_end", false)) {
                    try {
                        if (GameManager.this.activeRunner != null && GameManager.this.activeRunner.isOnline() && !GameManager.this.runners.isEmpty()) {
                            PlayerState finalState = PlayerStateUtil.capturePlayerState(GameManager.this.activeRunner);
                            for (Player r : GameManager.this.runners) {
                                GameManager.this.playerStates.put(r.getUniqueId(), finalState);
                            }
                        }
                    }
                    catch (Exception ex) {
                        GameManager.this.plugin.getLogger().warning("Failed to capture/apply final runner state: " + ex.getMessage());
                    }
                }
                GameManager.this.cleanupAllCages();
                GameManager.this.restoreAllPlayerStates();
                GameManager.this.gameRunning = false;
                GameManager.this.gamePaused = false;
                GameManager.this.activeRunner = null;
                if (GameManager.this.plugin.getConfigManager().isBroadcastGameEvents()) {
                    String winnerMessage = winner != null ? winner.name() + " team won!" : "Game ended!";
                    Msg.broadcast("\u00a7a[SpeedrunnerSwap] Game ended! " + winnerMessage);
                }
                GameManager.this.broadcastDonationMessage();
            }
        }.runTaskLater((Plugin)this.plugin, 200L);
    }

    private void broadcastDonationMessage() {
        String donateUrl = this.plugin.getConfig().getString("donation.url", "https://donate.stripe.com/8x29AT0H58K03judnR0Ba01");
        TextComponent spacer = Component.text((String)"");
        Component header = ((TextComponent)Component.text((String)"=== Support the Creator ===").color((TextColor)NamedTextColor.GOLD)).decorate(TextDecoration.BOLD);
        Component desc = Component.text((String)"Enjoyed the game? Help keep updates coming!").color((TextColor)NamedTextColor.YELLOW);
        Component donate = ((TextComponent)((TextComponent)((TextComponent)Component.text((String)"\u2764 Click to Donate").color((TextColor)NamedTextColor.LIGHT_PURPLE)).decorate(TextDecoration.BOLD)).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Open donation page", (TextColor)NamedTextColor.GOLD)))).clickEvent(ClickEvent.openUrl((String)donateUrl));
        for (Player player : Bukkit.getOnlinePlayers()) {
            player.sendMessage((Component)spacer);
            player.sendMessage(header);
            player.sendMessage(desc);
            player.sendMessage(donate);
            player.sendMessage((Component)spacer);
        }
    }

    public void stopGame() {
        this.endGame(null);
    }

    public boolean isHunter(Player player) {
        return this.hunters.contains(player);
    }

    public boolean isRunner(Player player) {
        return this.runners.contains(player);
    }

    public boolean isGameRunning() {
        return this.gameRunning;
    }

    public Player getActiveRunner() {
        return this.activeRunner;
    }

    public List<Player> getRunners() {
        return this.runners;
    }

    public List<Player> getHunters() {
        return this.hunters;
    }

    public void refreshSwapSchedule() {
        if (this.gameRunning && !this.gamePaused) {
            this.scheduleNextSwap();
        }
    }

    public void refreshActionBar() {
        if (this.gameRunning && !this.gamePaused) {
            this.updateActionBar();
        }
    }

    public PlayerState getPlayerState(Player player) {
        if (player == null) {
            return null;
        }
        return this.playerStates.computeIfAbsent(player.getUniqueId(), id -> PlayerStateUtil.capturePlayerState(player));
    }

    public boolean canStartGame() {
        if (this.gameRunning) {
            return false;
        }
        this.loadTeams();
        return !this.runners.isEmpty() && !this.hunters.isEmpty();
    }

    public void updateTeams() {
        ArrayList<Player> newRunners = new ArrayList<Player>();
        ArrayList<Player> newHunters = new ArrayList<Player>();
        for (Player runner : this.runners) {
            if (!runner.isOnline()) continue;
            newRunners.add(runner);
        }
        for (Player hunter : this.hunters) {
            if (!hunter.isOnline()) continue;
            newHunters.add(hunter);
        }
        this.runners = newRunners;
        this.hunters = newHunters;
        if (this.gameRunning && (this.runners.isEmpty() || this.hunters.isEmpty())) {
            if (this.plugin.getConfigManager().isPauseOnDisconnect()) {
                this.pauseGame();
                if (this.plugin.getConfigManager().isBroadcastGameEvents()) {
                    Msg.broadcast("\u00a7e[SpeedrunnerSwap] Game paused: waiting for players to return.");
                }
            } else {
                this.plugin.getLogger().warning("A team is empty; game continues (pause_on_disconnect=false)");
            }
        }
    }

    public void handlePlayerQuit(Player player) {
        if (!this.gameRunning) {
            return;
        }
        if (player.equals(this.activeRunner)) {
            if (this.plugin.getConfigManager().isPauseOnDisconnect()) {
                this.pauseGame();
            } else {
                this.performSwap();
            }
        }
        this.savePlayerState(player);
    }

    public int getTimeUntilNextSwap() {
        return (int)((this.nextSwapTime - System.currentTimeMillis()) / 1000L);
    }

    private void saveAllPlayerStates() {
        for (Player runner : this.runners) {
            this.savePlayerState(runner);
        }
    }

    private void savePlayerState(Player player) {
        if (player == null || !player.isOnline()) {
            return;
        }
        PlayerState state = PlayerStateUtil.capturePlayerState(player);
        this.playerStates.put(player.getUniqueId(), state);
    }

    private void restoreAllPlayerStates() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            PotionEffectType eff;
            if (this.playerStates.containsKey(player.getUniqueId())) {
                this.restorePlayerState(player);
            }
            if ((eff = BukkitCompat.resolvePotionEffect("blindness")) != null) {
                player.removePotionEffect(eff);
            }
            if ((eff = BukkitCompat.resolvePotionEffect("darkness")) != null) {
                player.removePotionEffect(eff);
            }
            if ((eff = BukkitCompat.resolvePotionEffect("weakness")) != null) {
                player.removePotionEffect(eff);
            }
            if ((eff = BukkitCompat.resolvePotionEffect("slow_falling")) != null) {
                player.removePotionEffect(eff);
            }
            if ((eff = BukkitCompat.resolvePotionEffect("slowness")) != null) {
                player.removePotionEffect(eff);
            }
            if ((eff = BukkitCompat.resolvePotionEffect("jump_boost")) != null) {
                player.removePotionEffect(eff);
            }
            if (player.getGameMode() != GameMode.SPECTATOR || !this.runners.contains(player)) continue;
            player.setGameMode(GameMode.SURVIVAL);
        }
    }

    private void restorePlayerState(Player player) {
        if (player == null || !player.isOnline()) {
            return;
        }
        PlayerState state = this.playerStates.get(player.getUniqueId());
        if (state != null) {
            try {
                player.getInventory().clear();
                for (PotionEffect effect : player.getActivePotionEffects()) {
                    player.removePotionEffect(effect.getType());
                }
                player.setHealth(BukkitCompat.getMaxHealthValue((LivingEntity)player));
                player.setFoodLevel(20);
                player.setFireTicks(0);
                player.setFallDistance(0.0f);
                player.setInvulnerable(false);
                PlayerStateUtil.applyPlayerState(player, state);
                Location loc = state.getLocation();
                if (loc != null && !loc.getBlock().getType().isSolid()) {
                    player.teleport(loc);
                } else {
                    player.teleport(this.plugin.getConfigManager().getSpawnLocation());
                    player.setGameMode(GameMode.SURVIVAL);
                    player.getInventory().clear();
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Failed to restore state for player " + player.getName() + ": " + e.getMessage());
                player.teleport(this.plugin.getConfigManager().getSpawnLocation());
                player.setGameMode(GameMode.SURVIVAL);
                player.getInventory().clear();
            }
        }
    }

    private void loadTeams() {
        Player player;
        this.runners.clear();
        this.hunters.clear();
        for (String name : this.plugin.getConfigManager().getRunnerNames()) {
            player = Bukkit.getPlayerExact((String)name);
            if (player == null || !player.isOnline()) continue;
            this.runners.add(player);
        }
        for (String name : this.plugin.getConfigManager().getHunterNames()) {
            player = Bukkit.getPlayerExact((String)name);
            if (player == null || !player.isOnline()) continue;
            this.hunters.add(player);
        }
    }

    private void scheduleNextSwap() {
        long intervalSeconds;
        if (this.swapTask != null) {
            this.swapTask.cancel();
        }
        if (this.plugin.getConfigManager().isSwapRandomized()) {
            double mean = this.plugin.getConfigManager().getSwapInterval();
            double stdDev = this.plugin.getConfigManager().getJitterStdDev();
            double jitteredInterval = ThreadLocalRandom.current().nextGaussian() * stdDev + mean;
            if (this.plugin.getConfigManager().isClampJitter()) {
                int min = this.plugin.getConfigManager().getMinSwapInterval();
                int max = this.plugin.getConfigManager().getMaxSwapInterval();
                jitteredInterval = Math.max((double)min, Math.min((double)max, jitteredInterval));
            }
            intervalSeconds = Math.round(jitteredInterval);
        } else {
            intervalSeconds = this.plugin.getConfigManager().getSwapInterval();
        }
        long intervalTicks = intervalSeconds * 20L;
        this.nextSwapTime = System.currentTimeMillis() + intervalSeconds * 1000L;
        this.swapTask = Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, this::performSwap, intervalTicks);
    }

    private void scheduleNextHunterSwap() {
        if (this.hunterSwapTask != null) {
            this.hunterSwapTask.cancel();
        }
        if (!this.plugin.getConfigManager().isHunterSwapEnabled()) {
            return;
        }
        long intervalTicks = (long)this.plugin.getConfigManager().getHunterSwapInterval() * 20L;
        this.hunterSwapTask = Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, this::performHunterSwap, intervalTicks);
    }

    private void startActionBarUpdates() {
        if (this.actionBarTask != null) {
            this.actionBarTask.cancel();
        }
        this.actionBarTask = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            if (!this.gameRunning) {
                return;
            }
            this.updateActionBar();
        }, 0L, 20L);
    }

    private void startTitleUpdates() {
        if (this.titleTask != null) {
            this.titleTask.cancel();
        }
        this.titleTask = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            if (!this.gameRunning || this.gamePaused) {
                return;
            }
            this.updateTitles();
        }, 0L, 5L);
    }

    private void updateActionBar() {
        if (!this.gameRunning || this.gamePaused) {
            return;
        }
        int timeLeft = this.getTimeUntilNextSwap();
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (player.equals(this.activeRunner) && timeLeft <= 10) {
                String msg = String.format("\u00a7eSwap in: \u00a7c%ds", Math.max(0, timeLeft));
                ActionBarUtil.sendActionBar(player, msg);
                continue;
            }
            ActionBarUtil.sendActionBar(player, "");
        }
    }

    private void applyInactiveEffects() {
        String freezeMode = this.plugin.getConfigManager().getFreezeMode();
        for (Player runner : this.runners) {
            if (runner.equals(this.activeRunner)) {
                this.removeCageFor(runner);
                PotionEffectType eff = BukkitCompat.resolvePotionEffect("blindness");
                if (eff != null) {
                    runner.removePotionEffect(eff);
                }
                if ((eff = BukkitCompat.resolvePotionEffect("darkness")) != null) {
                    runner.removePotionEffect(eff);
                }
                if ((eff = BukkitCompat.resolvePotionEffect("slowness")) != null) {
                    runner.removePotionEffect(eff);
                }
                if ((eff = BukkitCompat.resolvePotionEffect("slow_falling")) != null) {
                    runner.removePotionEffect(eff);
                }
                runner.setGameMode(GameMode.SURVIVAL);
                try {
                    runner.setAllowFlight(false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    runner.setFlying(false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                for (Player viewer : Bukkit.getOnlinePlayers()) {
                    viewer.showPlayer((Plugin)this.plugin, runner);
                }
                continue;
            }
            if (freezeMode.equalsIgnoreCase("EFFECTS")) {
                PotionEffectType slowFalling;
                PotionEffectType slowness;
                PotionEffectType darkness;
                blindness = BukkitCompat.resolvePotionEffect("blindness");
                if (blindness != null) {
                    runner.addPotionEffect(new PotionEffect(blindness, Integer.MAX_VALUE, 1, false, false));
                }
                if ((darkness = BukkitCompat.resolvePotionEffect("darkness")) != null) {
                    runner.addPotionEffect(new PotionEffect(darkness, Integer.MAX_VALUE, 1, false, false));
                }
                if ((slowness = BukkitCompat.resolvePotionEffect("slowness")) != null) {
                    runner.addPotionEffect(new PotionEffect(slowness, Integer.MAX_VALUE, 255, false, false));
                }
                if ((slowFalling = BukkitCompat.resolvePotionEffect("slow_falling")) != null) {
                    runner.addPotionEffect(new PotionEffect(slowFalling, Integer.MAX_VALUE, 128, false, false));
                }
            } else if (freezeMode.equalsIgnoreCase("SPECTATOR")) {
                runner.setGameMode(GameMode.SPECTATOR);
            } else if (freezeMode.equalsIgnoreCase("LIMBO")) {
                Location limboLocation = this.plugin.getConfigManager().getLimboLocation();
                Location safe = SafeLocationFinder.findSafeLocation(limboLocation, this.plugin.getConfigManager().getSafeSwapHorizontalRadius(), this.plugin.getConfigManager().getSafeSwapVerticalDistance(), this.plugin.getConfigManager().getDangerousBlocks());
                runner.teleport(safe != null ? safe : limboLocation);
                runner.setGameMode(GameMode.ADVENTURE);
                PotionEffectType blindness2 = BukkitCompat.resolvePotionEffect("blindness");
                if (blindness2 != null) {
                    runner.addPotionEffect(new PotionEffect(blindness2, Integer.MAX_VALUE, 1, false, false));
                }
            } else if (freezeMode.equalsIgnoreCase("CAGE")) {
                this.createCageFor(runner);
                blindness = BukkitCompat.resolvePotionEffect("blindness");
                if (blindness != null) {
                    runner.addPotionEffect(new PotionEffect(blindness, Integer.MAX_VALUE, 1, false, false));
                }
                runner.setGameMode(GameMode.ADVENTURE);
                try {
                    runner.setAllowFlight(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    runner.setFlying(false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            for (Player viewer : Bukkit.getOnlinePlayers()) {
                if (viewer.equals(runner)) continue;
                viewer.hidePlayer((Plugin)this.plugin, runner);
            }
        }
    }

    private void startFreezeChecking() {
        int interval = this.plugin.getConfigManager().getFreezeCheckIntervalTicks();
        this.freezeCheckTask = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            Player hunter;
            if (!this.gameRunning || this.gamePaused || this.activeRunner == null) {
                return;
            }
            int maxDistance = (int)this.plugin.getConfigManager().getFreezeMaxDistance();
            Entity target = BukkitCompat.getTargetEntity(this.activeRunner, maxDistance);
            if (target instanceof Player && this.isHunter(hunter = (Player)target)) {
                PotionEffectType jumpBoost;
                int duration = this.plugin.getConfigManager().getFreezeDurationTicks();
                PotionEffectType slowness2 = BukkitCompat.resolvePotionEffect("slowness");
                if (slowness2 != null) {
                    hunter.addPotionEffect(new PotionEffect(slowness2, duration, 255, false, false));
                }
                if ((jumpBoost = BukkitCompat.resolvePotionEffect("jump_boost")) != null) {
                    hunter.addPotionEffect(new PotionEffect(jumpBoost, duration, 128, false, false));
                }
                if (this.plugin.getConfigManager().isBroadcastGameEvents()) {
                    hunter.sendMessage("\u00a7cYou have been frozen by the runner!");
                }
            }
        }, 0L, (long)interval);
    }

    public void refreshFreezeMechanic() {
        if (this.freezeCheckTask != null) {
            this.freezeCheckTask.cancel();
            this.freezeCheckTask = null;
        }
        if (this.gameRunning && this.plugin.getConfigManager().isFreezeMechanicEnabled()) {
            this.startFreezeChecking();
        }
        if (this.gameRunning) {
            this.applyInactiveEffects();
            if (!"CAGE".equalsIgnoreCase(this.plugin.getConfigManager().getFreezeMode())) {
                this.cleanupAllCages();
            }
        }
    }

    private void performSwap() {
        long duration;
        if (!this.gameRunning || this.gamePaused || this.runners.isEmpty()) {
            return;
        }
        if (this.activeRunner != null && this.activeRunner.isOnline()) {
            this.savePlayerState(this.activeRunner);
        }
        int attempts = 0;
        do {
            this.activeRunnerIndex = (this.activeRunnerIndex + 1) % this.runners.size();
            if (++attempts < this.runners.size()) continue;
            this.plugin.getLogger().warning("No online runners found during swap - pausing game");
            this.pauseGame();
            return;
        } while (!this.runners.get(this.activeRunnerIndex).isOnline());
        Player nextRunner = this.runners.get(this.activeRunnerIndex);
        Player previousRunner = this.activeRunner;
        if (previousRunner != null && previousRunner.equals(nextRunner)) {
            this.scheduleNextSwap();
            if (this.plugin.getConfigManager().isPowerUpsEnabled()) {
                this.applyRandomPowerUp(nextRunner);
            }
            return;
        }
        this.activeRunner = nextRunner;
        int gracePeriodTicks = this.plugin.getConfigManager().getGracePeriodTicks();
        if (gracePeriodTicks > 0) {
            nextRunner.setInvulnerable(true);
            Player finalNextRunner = nextRunner;
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                if (finalNextRunner.isOnline()) {
                    finalNextRunner.setInvulnerable(false);
                }
            }, (long)gracePeriodTicks);
        }
        if (previousRunner != null && previousRunner.isOnline()) {
            Location swapLocation;
            Location safeLocation;
            PlayerState prevState = PlayerStateUtil.capturePlayerState(previousRunner);
            PlayerStateUtil.applyPlayerState(nextRunner, prevState);
            if (this.plugin.getConfigManager().isSafeSwapEnabled() && (safeLocation = SafeLocationFinder.findSafeLocation(swapLocation = previousRunner.getLocation(), this.plugin.getConfigManager().getSafeSwapHorizontalRadius(), this.plugin.getConfigManager().getSafeSwapVerticalDistance(), this.plugin.getConfigManager().getDangerousBlocks())) != null) {
                nextRunner.teleport(safeLocation);
            }
            for (PotionEffect effect : previousRunner.getActivePotionEffects()) {
                previousRunner.removePotionEffect(effect.getType());
            }
            previousRunner.getInventory().clear();
            previousRunner.getInventory().setArmorContents(new ItemStack[0]);
            previousRunner.getInventory().setItemInOffHand(null);
            previousRunner.updateInventory();
        } else if (this.plugin.getConfigManager().isKitsEnabled()) {
            nextRunner.getInventory().clear();
            this.plugin.getKitManager().giveKit(nextRunner, "runner");
        }
        this.applyInactiveEffects();
        this.scheduleNextSwap();
        if (this.plugin.getConfigManager().isPowerUpsEnabled()) {
            this.applyRandomPowerUp(nextRunner);
        }
        if (this.plugin.getConfigManager().isCompassJammingEnabled() && (duration = (long)this.plugin.getConfigManager().getCompassJamDuration()) > 0L) {
            this.plugin.getTrackerManager().jamCompasses(duration);
        }
    }

    public void triggerImmediateSwap() {
        if (!this.gameRunning || this.gamePaused) {
            return;
        }
        Bukkit.getScheduler().runTask((Plugin)this.plugin, this::performSwap);
    }

    public void triggerImmediateHunterSwap() {
        if (!this.gameRunning || this.gamePaused) {
            return;
        }
        Bukkit.getScheduler().runTask((Plugin)this.plugin, this::performHunterSwap);
    }

    private void performHunterSwap() {
        if (!this.gameRunning || this.gamePaused || this.hunters.size() < 2) {
            return;
        }
        Collections.shuffle(this.hunters);
        this.plugin.getTrackerManager().updateAllHunterCompasses();
        if (this.plugin.getConfigManager().isBroadcastsEnabled()) {
            Msg.broadcast("\u00a7c[SpeedrunnerSwap] Hunters have been swapped!");
        }
    }

    private void applyRandomPowerUp(Player player) {
        boolean isGoodEffect;
        PotionEffectType t;
        PotionEffectType t2;
        String k;
        int n;
        String[] stringArray;
        String[] defaults;
        PotionEffectType t3;
        List<String> good = this.plugin.getConfigManager().getGoodPowerUps();
        List<String> bad = this.plugin.getConfigManager().getBadPowerUps();
        ArrayList<PotionEffectType> goodTypes = new ArrayList<PotionEffectType>();
        ArrayList<PotionEffectType> badTypes = new ArrayList<PotionEffectType>();
        for (String id : good) {
            t3 = this.resolveEffect(id);
            if (t3 == null) continue;
            goodTypes.add(t3);
        }
        for (String id : bad) {
            t3 = this.resolveEffect(id);
            if (t3 == null) continue;
            badTypes.add(t3);
        }
        if (goodTypes.isEmpty()) {
            stringArray = defaults = new String[]{"speed", "regeneration", "resistance", "night_vision", "dolphins_grace"};
            n = defaults.length;
            int t4 = 0;
            while (t4 < n) {
                k = stringArray[t4];
                t2 = BukkitCompat.resolvePotionEffect(k);
                if (t2 != null) {
                    goodTypes.add(t2);
                }
                ++t4;
            }
            if (goodTypes.isEmpty() && (t = BukkitCompat.resolvePotionEffect("speed")) != null) {
                goodTypes.add(t);
            }
        }
        if (badTypes.isEmpty()) {
            stringArray = defaults = new String[]{"slowness", "weakness", "hunger", "darkness", "glowing"};
            n = defaults.length;
            int t4 = 0;
            while (t4 < n) {
                k = stringArray[t4];
                t2 = BukkitCompat.resolvePotionEffect(k);
                if (t2 != null) {
                    badTypes.add(t2);
                }
                ++t4;
            }
            if (badTypes.isEmpty() && (t = BukkitCompat.resolvePotionEffect("slowness")) != null) {
                badTypes.add(t);
            }
        }
        ArrayList<PotionEffectType> effectPool = (isGoodEffect = ThreadLocalRandom.current().nextBoolean()) ? goodTypes : badTypes;
        PotionEffectType effectType = (PotionEffectType)effectPool.get(ThreadLocalRandom.current().nextInt(effectPool.size()));
        int duration = ThreadLocalRandom.current().nextInt(10, 21) * 20;
        int amplifier = ThreadLocalRandom.current().nextInt(2);
        player.addPotionEffect(new PotionEffect(effectType, duration, amplifier));
        String effectName = effectType.getKey().getKey().replace("_", " ").toLowerCase();
        String effectLevel = amplifier == 0 ? "I" : "II";
        player.sendMessage(String.format("\u00a7%sYou received a %s power-up: %s %s!", isGoodEffect ? "a" : "c", isGoodEffect ? "good" : "bad", effectName, effectLevel));
    }

    private PotionEffectType resolveEffect(String id) {
        return BukkitCompat.resolvePotionEffect(id);
    }

    public boolean pauseGame() {
        if (!this.gameRunning || this.gamePaused) {
            return false;
        }
        this.gamePaused = true;
        if (this.swapTask != null) {
            this.swapTask.cancel();
        }
        if (this.hunterSwapTask != null) {
            this.hunterSwapTask.cancel();
        }
        if (this.actionBarTask != null) {
            this.actionBarTask.cancel();
        }
        if (this.titleTask != null) {
            this.titleTask.cancel();
        }
        return true;
    }

    public boolean resumeGame() {
        if (!this.gameRunning || !this.gamePaused) {
            return false;
        }
        this.gamePaused = false;
        this.scheduleNextSwap();
        this.scheduleNextHunterSwap();
        this.startActionBarUpdates();
        this.startTitleUpdates();
        this.startCageEnforcement();
        return true;
    }

    public boolean isGamePaused() {
        return this.gamePaused;
    }

    public void setRunners(List<Player> players) {
        ArrayList<String> names = new ArrayList<String>();
        for (Player p : players) {
            names.add(p.getName());
        }
        this.plugin.getConfigManager().setRunnerNames(names);
        List<String> currentHunters = this.plugin.getConfigManager().getHunterNames();
        currentHunters.removeAll(names);
        this.plugin.getConfigManager().setHunterNames(currentHunters);
        this.runners = new ArrayList<Player>(players);
    }

    public void setHunters(List<Player> players) {
        ArrayList<String> names = new ArrayList<String>();
        for (Player p : players) {
            names.add(p.getName());
        }
        this.plugin.getConfigManager().setHunterNames(names);
        List<String> currentRunners = this.plugin.getConfigManager().getRunnerNames();
        currentRunners.removeAll(names);
        this.plugin.getConfigManager().setRunnerNames(currentRunners);
        this.hunters = new ArrayList<Player>(players);
    }

    private void updateTitles() {
        int timeLeft = this.getTimeUntilNextSwap();
        Player current = this.activeRunner;
        boolean isSneak = current != null && current.isSneaking();
        boolean isSprint = current != null && current.isSprinting();
        Component sub = Component.text((String)String.format("Sneaking: %s  |  Running: %s", isSneak ? "Yes" : "No", isSprint ? "Yes" : "No")).color((TextColor)NamedTextColor.YELLOW);
        for (Player p : Bukkit.getOnlinePlayers()) {
            boolean shouldShow;
            if (!this.runners.contains(p)) continue;
            boolean isActive = p.equals(current);
            boolean bl = shouldShow = !isActive;
            if (!shouldShow) continue;
            Component titleText = ((TextComponent)Component.text((String)String.format("Swap in: %ds", Math.max(0, timeLeft))).color((TextColor)(isActive ? NamedTextColor.RED : NamedTextColor.GOLD))).decorate(TextDecoration.BOLD);
            Title title = Title.title((Component)titleText, (Component)sub, (Title.Times)Title.Times.times((Duration)Duration.ZERO, (Duration)Duration.ofMillis(600L), (Duration)Duration.ZERO));
            p.showTitle(title);
        }
    }

    private void createCageFor(Player runner) {
        if (runner == null || !runner.isOnline()) {
            return;
        }
        Location existing = this.cageCenters.get(runner.getUniqueId());
        if (existing != null) {
            if (existing.getWorld() != runner.getWorld()) {
                this.removeCageFor(runner);
            } else {
                return;
            }
        }
        Location base = this.plugin.getConfigManager().getLimboLocation();
        World world = runner.getWorld();
        int y = world.getMaxHeight() - 10;
        int index = Math.max(0, this.runners.indexOf(runner));
        int spacing = 10;
        int cx = (int)Math.round(base.getX()) + index * spacing;
        int cz = (int)Math.round(base.getZ());
        Location center = new Location(world, (double)cx + 0.5, (double)y, (double)cz + 0.5);
        center.getChunk().load(true);
        ArrayList<BlockState> changed = new ArrayList<BlockState>();
        int dx = -2;
        while (dx <= 2) {
            int dy = -1;
            while (dy <= 3) {
                int dz = -2;
                while (dz <= 2) {
                    boolean isShell;
                    Block block = world.getBlockAt(cx + dx, y + dy, cz + dz);
                    boolean bl = isShell = dx == -2 || dx == 2 || dz == -2 || dz == 2 || dy == -1 || dy == 3;
                    if (isShell) {
                        changed.add(block.getState());
                        block.setType(Material.BEDROCK, false);
                    } else {
                        changed.add(block.getState());
                        block.setType(Material.AIR, false);
                    }
                    ++dz;
                }
                ++dy;
            }
            ++dx;
        }
        dx = -3;
        while (dx <= 3) {
            int dz = -3;
            while (dz <= 3) {
                Block floor = world.getBlockAt(cx + dx, y - 1, cz + dz);
                changed.add(floor.getState());
                floor.setType(Material.BEDROCK, false);
                ++dz;
            }
            ++dx;
        }
        this.builtCages.put(runner.getUniqueId(), changed);
        this.cageCenters.put(runner.getUniqueId(), center.clone());
        runner.teleport(center);
        try {
            runner.setAllowFlight(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            runner.setFlying(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void removeCageFor(Player runner) {
        if (runner == null) {
            return;
        }
        List<BlockState> states = this.builtCages.remove(runner.getUniqueId());
        this.cageCenters.remove(runner.getUniqueId());
        if (states != null) {
            for (BlockState s : states) {
                try {
                    s.update(true, false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private void cleanupAllCages() {
        HashSet<UUID> ids = new HashSet<UUID>(this.builtCages.keySet());
        for (UUID id : ids) {
            Player p = Bukkit.getPlayer((UUID)id);
            if (p == null) continue;
            this.removeCageFor(p);
        }
        this.builtCages.clear();
        this.cageCenters.clear();
    }

    private void startCageEnforcement() {
        if (this.cageTask != null) {
            this.cageTask.cancel();
            this.cageTask = null;
        }
        this.cageTask = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            if (!this.gameRunning || this.gamePaused) {
                return;
            }
            if (!"CAGE".equalsIgnoreCase(this.plugin.getConfigManager().getFreezeMode())) {
                return;
            }
            for (Player r : this.runners) {
                boolean outside;
                if (r.equals(this.activeRunner) || !r.isOnline()) continue;
                this.createCageFor(r);
                Location center = this.cageCenters.get(r.getUniqueId());
                if (center == null) continue;
                Location loc = r.getLocation();
                double dx = Math.abs(loc.getX() - center.getX());
                double dy = loc.getY() - center.getY();
                double dz = Math.abs(loc.getZ() - center.getZ());
                boolean bl = outside = dx > 1.2 || dz > 1.2 || dy < -0.2 || dy > 2.8;
                if (outside) {
                    r.teleport(center);
                    r.setVelocity(new Vector(0, 0, 0));
                    r.setFallDistance(0.0f);
                    r.setNoDamageTicks(Math.max(10, r.getNoDamageTicks()));
                    continue;
                }
                try {
                    r.setAllowFlight(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    r.setFlying(false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }, 0L, 5L);
    }
}

