/*
 * Decompiled with CFR 0.152.
 */
package com.example.speedrunnerswap.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Locale;
import org.bukkit.Location;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;

public final class BukkitCompat {
    private BukkitCompat() {
    }

    public static double getMaxHealthValue(LivingEntity entity) {
        AttributeInstance inst;
        Attribute attr = BukkitCompat.resolveAttribute("GENERIC_MAX_HEALTH", "MAX_HEALTH");
        if (attr != null && (inst = entity.getAttribute(attr)) != null) {
            return inst.getValue();
        }
        return 20.0;
    }

    public static Attribute resolveAttribute(String ... names) {
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            try {
                Field f = Attribute.class.getField(name);
                Object v = f.get(null);
                if (v instanceof Attribute) {
                    return (Attribute)v;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ++n2;
        }
        return null;
    }

    public static PotionEffectType resolvePotionEffect(String id) {
        String key;
        if (id == null) {
            return null;
        }
        key = switch (key = id.toLowerCase(Locale.ROOT).trim()) {
            case "increase_damage" -> "strength";
            case "damage_resistance" -> "resistance";
            case "slow" -> "slowness";
            case "jump" -> "jump_boost";
            case "slow_digging" -> "mining_fatigue";
            case "confusion" -> "nausea";
            default -> key;
        };
        try {
            Class<?> nsk = Class.forName("org.bukkit.NamespacedKey");
            Method minecraft = nsk.getMethod("minecraft", String.class);
            Object namespacedKey = minecraft.invoke(null, key);
            Method getByKey = PotionEffectType.class.getMethod("getByKey", nsk);
            Object type = getByKey.invoke(null, namespacedKey);
            if (type instanceof PotionEffectType) {
                return (PotionEffectType)type;
            }
        }
        catch (Throwable nsk) {
            // empty catch block
        }
        try {
            Method getByName = PotionEffectType.class.getMethod("getByName", String.class);
            Object type = getByName.invoke(null, key.toUpperCase(Locale.ROOT));
            if (type instanceof PotionEffectType) {
                return (PotionEffectType)type;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static Entity getTargetEntity(Player player, int maxDistance) {
        if (player == null) {
            return null;
        }
        try {
            Method m = Player.class.getMethod("getTargetEntity", Integer.TYPE, Boolean.TYPE);
            Object ent = m.invoke((Object)player, maxDistance, false);
            return (Entity)ent;
        }
        catch (NoSuchMethodException m) {
        }
        catch (Throwable m) {
            // empty catch block
        }
        try {
            Method m = Player.class.getMethod("getTargetEntity", Integer.TYPE);
            Object ent = m.invoke((Object)player, maxDistance);
            return (Entity)ent;
        }
        catch (NoSuchMethodException m) {
        }
        catch (Throwable m) {
            // empty catch block
        }
        try {
            Location eye = player.getEyeLocation();
            Vector dir = eye.getDirection();
            RayTraceResult res = player.getWorld().rayTraceEntities(eye, dir, (double)maxDistance, e -> e != player);
            if (res != null) {
                return res.getHitEntity();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }
}

