/*
 * Decompiled with CFR 0.152.
 */
package com.example.speedrunnerswap.commands;

import com.example.speedrunnerswap.SpeedrunnerSwap;
import com.example.speedrunnerswap.gui.ControlGui;
import com.example.speedrunnerswap.models.PlayerState;
import com.example.speedrunnerswap.models.Team;
import com.example.speedrunnerswap.task.TaskDefinition;
import com.example.speedrunnerswap.task.TaskManagerMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class SwapCommand
implements CommandExecutor,
TabCompleter {
    private final SpeedrunnerSwap plugin;

    public SwapCommand(SpeedrunnerSwap plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        try {
            String subCommand;
            if (args.length == 0) {
                return this.handleMainCommand(sender);
            }
            switch (subCommand = args[0].toLowerCase()) {
                case "start": {
                    return this.handleStart(sender);
                }
                case "stop": {
                    return this.handleStop(sender);
                }
                case "pause": {
                    return this.handlePause(sender);
                }
                case "resume": {
                    return this.handleResume(sender);
                }
                case "status": {
                    return this.handleStatus(sender);
                }
                case "creator": {
                    return this.handleCreator(sender);
                }
                case "setrunners": {
                    return this.handleSetRunners(sender, Arrays.copyOfRange(args, 1, args.length));
                }
                case "sethunters": {
                    return this.handleSetHunters(sender, Arrays.copyOfRange(args, 1, args.length));
                }
                case "reload": {
                    return this.handleReload(sender);
                }
                case "gui": {
                    return this.handleMainCommand(sender);
                }
                case "mode": {
                    return this.handleMode(sender, Arrays.copyOfRange(args, 1, args.length));
                }
                case "clearteams": {
                    return this.handleClearTeams(sender);
                }
                case "tasks": {
                    return this.handleTasks(sender, Arrays.copyOfRange(args, 1, args.length));
                }
                case "complete": {
                    return this.handleTaskComplete(sender, Arrays.copyOfRange(args, 1, args.length));
                }
            }
            sender.sendMessage("\u00a7cUnknown subcommand. Use /swap for help.");
            return false;
        }
        catch (Exception e) {
            sender.sendMessage("\u00a7cAn internal error occurred while executing that command. Check server logs for details.");
            this.plugin.getLogger().log(Level.SEVERE, "Unhandled exception while executing /swap by " + (sender == null ? "UNKNOWN" : sender.getName()), e);
            return false;
        }
    }

    private boolean handleMode(CommandSender sender, String[] rest) {
        boolean force;
        if (!sender.hasPermission("speedrunnerswap.admin")) {
            sender.sendMessage("\u00a7cYou don't have permission to change mode.");
            return false;
        }
        if (rest.length == 0) {
            sender.sendMessage("\u00a7eCurrent mode: \u00a7f" + this.plugin.getCurrentMode().name().toLowerCase());
            sender.sendMessage("\u00a77Usage: /swap mode <dream|sapnap|task> [--force]");
            sender.sendMessage("\u00a77       /swap mode default <dream|sapnap|task>");
            return true;
        }
        String mode = rest[0].toLowerCase();
        if ("default".equals(mode)) {
            if (rest.length < 2) {
                sender.sendMessage("\u00a7eDefault mode: \u00a7f" + this.plugin.getConfigManager().getDefaultMode().name().toLowerCase());
                sender.sendMessage("\u00a77Usage: /swap mode default <dream|sapnap>");
                return true;
            }
            String val = rest[1].toLowerCase();
            if (!(val.equals("dream") || val.equals("sapnap") || val.equals("task"))) {
                sender.sendMessage("\u00a7cUnknown mode: " + val);
                return false;
            }
            SpeedrunnerSwap.SwapMode m = switch (val) {
                case "sapnap" -> SpeedrunnerSwap.SwapMode.SAPNAP;
                case "task" -> SpeedrunnerSwap.SwapMode.TASK;
                default -> SpeedrunnerSwap.SwapMode.DREAM;
            };
            this.plugin.getConfigManager().setDefaultMode(m);
            sender.sendMessage("\u00a7aDefault mode set to \u00a7f" + val + "\u00a7a.");
            return true;
        }
        boolean bl = force = rest.length > 1 && ("--force".equalsIgnoreCase(rest[1]) || "-f".equalsIgnoreCase(rest[1]) || "force".equalsIgnoreCase(rest[1]));
        if (this.plugin.getGameManager().isGameRunning() && !force) {
            sender.sendMessage("\u00a7cStop the current game before switching modes. Add --force to end it and switch now.");
            return false;
        }
        if (force && this.plugin.getGameManager().isGameRunning()) {
            this.plugin.getGameManager().stopGame();
        }
        switch (mode) {
            case "dream": {
                this.plugin.setCurrentMode(SpeedrunnerSwap.SwapMode.DREAM);
                sender.sendMessage("\u00a7aMode set to \u00a7fDream\u00a7a (runners + hunters)");
                if (sender instanceof Player) {
                    Player p = (Player)sender;
                    this.plugin.getGuiManager().openMainMenu(p);
                }
                return true;
            }
            case "sapnap": 
            case "sapnaps": 
            case "runner": 
            case "runners": {
                this.plugin.setCurrentMode(SpeedrunnerSwap.SwapMode.SAPNAP);
                sender.sendMessage("\u00a7aMode set to \u00a7fSapnap\u00a7a (runners only)");
                if (sender instanceof Player) {
                    Player p = (Player)sender;
                    try {
                        new ControlGui(this.plugin).openMainMenu(p);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                return true;
            }
            case "task": {
                this.plugin.setCurrentMode(SpeedrunnerSwap.SwapMode.TASK);
                sender.sendMessage("\u00a7aMode set to \u00a76Task Manager\u00a7a (runners only, secret tasks)");
                if (sender instanceof Player) {
                    Player p = (Player)sender;
                    this.plugin.getGuiManager().openMainMenu(p);
                }
                return true;
            }
        }
        sender.sendMessage("\u00a7cUnknown mode: " + mode + ". Use dream|sapnap|task");
        return false;
    }

    private boolean handleCreator(CommandSender sender) {
        String donateUrl = this.plugin.getConfig().getString("donation.url", "https://donate.stripe.com/8x29AT0H58K03judnR0Ba01");
        sender.sendMessage("\u00a76\u00a7lSpeedrunner Swap");
        sender.sendMessage("\u00a7eCreated by \u00a7f m u j 3 b");
        sender.sendMessage("\u00a7d\u2764 Donate to support development");
        sender.sendMessage("\u00a7b" + donateUrl);
        return true;
    }

    private boolean handleMainCommand(CommandSender sender) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a7cThis command can only be used by players.");
            return false;
        }
        if (!sender.hasPermission("speedrunnerswap.command")) {
            sender.sendMessage("\u00a7cYou don't have permission to use this command.");
            return false;
        }
        if (this.plugin.getGuiManager() == null) {
            sender.sendMessage("\u00a7cError: GUI Manager not initialized properly. Please report this to the plugin developer.");
            this.plugin.getLogger().log(Level.SEVERE, "GUI Manager is null when trying to open main menu");
            return false;
        }
        try {
            this.plugin.getGuiManager().openDirectGamemodeSelector((Player)sender);
            return true;
        }
        catch (Exception e) {
            sender.sendMessage("\u00a7cError opening GUI: " + e.getMessage());
            this.plugin.getLogger().log(Level.SEVERE, "Error opening GUI for player " + sender.getName(), e);
            return false;
        }
    }

    private boolean handleStart(CommandSender sender) {
        if (!sender.hasPermission("speedrunnerswap.command")) {
            sender.sendMessage("\u00a7cYou don't have permission to use this command.");
            return false;
        }
        if (this.plugin.getGameManager().isGameRunning()) {
            sender.sendMessage("\u00a7cThe game is already running.");
            return false;
        }
        boolean success = this.plugin.getGameManager().startGame();
        if (success) {
            sender.sendMessage("\u00a7aGame started successfully.");
        } else {
            SpeedrunnerSwap.SwapMode mode = this.plugin.getCurrentMode();
            if (mode == SpeedrunnerSwap.SwapMode.DREAM) {
                sender.sendMessage("\u00a7cFailed to start. Dream mode requires at least \u00a7e1 runner\u00a7c and \u00a7e1 hunter\u00a7c.");
            } else {
                sender.sendMessage("\u00a7cFailed to start. You must set at least \u00a7e1 runner\u00a7c.");
            }
        }
        return success;
    }

    private boolean handleStop(CommandSender sender) {
        if (!sender.hasPermission("speedrunnerswap.admin")) {
            sender.sendMessage("\u00a7cYou do not have permission to run this.");
            return true;
        }
        if (!this.plugin.getGameManager().isGameRunning()) {
            sender.sendMessage("\u00a7cThe game is not running.");
            return false;
        }
        this.plugin.getGameManager().stopGame();
        sender.sendMessage("\u00a7aGame stopped.");
        return true;
    }

    private boolean handlePause(CommandSender sender) {
        if (!sender.hasPermission("speedrunnerswap.admin")) {
            sender.sendMessage("\u00a7cYou do not have permission to run this.");
            return true;
        }
        this.plugin.getGameManager().pauseGame();
        sender.sendMessage("\u00a7eGame paused.");
        return true;
    }

    private boolean handleResume(CommandSender sender) {
        if (!sender.hasPermission("speedrunnerswap.admin")) {
            sender.sendMessage("\u00a7cYou do not have permission to run this.");
            return true;
        }
        this.plugin.getGameManager().resumeGame();
        sender.sendMessage("\u00a7aGame resumed.");
        return true;
    }

    private boolean handleStatus(CommandSender sender) {
        if (!sender.hasPermission("speedrunnerswap.admin")) {
            sender.sendMessage("\u00a7cYou do not have permission to run this.");
            return true;
        }
        sender.sendMessage("\u00a76=== SpeedrunnerSwap Status ===");
        sender.sendMessage("\u00a7eGame Running: \u00a7f" + this.plugin.getGameManager().isGameRunning());
        sender.sendMessage("\u00a7eGame Paused: \u00a7f" + this.plugin.getGameManager().isGamePaused());
        if (this.plugin.getGameManager().isGameRunning()) {
            Player activeRunner = this.plugin.getGameManager().getActiveRunner();
            sender.sendMessage("\u00a7eActive Runner: \u00a7f" + (activeRunner != null ? activeRunner.getName() : "None"));
            sender.sendMessage("\u00a7eTime Until Next Swap: \u00a7f" + this.plugin.getGameManager().getTimeUntilNextSwap() + "s");
            List<Player> runners = this.plugin.getGameManager().getRunners();
            List<Player> hunters = this.plugin.getGameManager().getHunters();
            sender.sendMessage("\u00a7eRunners: \u00a7f" + runners.stream().map(Player::getName).collect(Collectors.joining(", ")));
            sender.sendMessage("\u00a7eHunters: \u00a7f" + hunters.stream().map(Player::getName).collect(Collectors.joining(", ")));
        }
        return true;
    }

    private boolean handleSetRunners(CommandSender sender, String[] playerNames) {
        if (!sender.hasPermission("speedrunnerswap.command")) {
            sender.sendMessage("\u00a7cYou don't have permission to use this command.");
            return false;
        }
        if (playerNames.length == 0) {
            sender.sendMessage("\u00a7cUsage: /swap setrunners <player1> [player2] [player3] ...");
            return false;
        }
        ArrayList<Player> players = new ArrayList<Player>();
        for (String name : playerNames) {
            Player player = Bukkit.getPlayerExact((String)name);
            if (player != null) {
                players.add(player);
                continue;
            }
            sender.sendMessage("\u00a7cPlayer not found: " + name);
        }
        if (players.isEmpty()) {
            sender.sendMessage("\u00a7cNo valid players specified.");
            return false;
        }
        this.plugin.getGameManager().setRunners(players);
        sender.sendMessage("\u00a7aRunners set: " + players.stream().map(Player::getName).collect(Collectors.joining(", ")));
        return true;
    }

    private boolean handleSetHunters(CommandSender sender, String[] playerNames) {
        if (!sender.hasPermission("speedrunnerswap.command")) {
            sender.sendMessage("\u00a7cYou don't have permission to use this command.");
            return false;
        }
        if (playerNames.length == 0) {
            sender.sendMessage("\u00a7cUsage: /swap sethunters <player1> [player2] [player3] ...");
            return false;
        }
        ArrayList<Player> players = new ArrayList<Player>();
        for (String name : playerNames) {
            Player player = Bukkit.getPlayerExact((String)name);
            if (player != null) {
                players.add(player);
                continue;
            }
            sender.sendMessage("\u00a7cPlayer not found: " + name);
        }
        if (players.isEmpty()) {
            sender.sendMessage("\u00a7cNo valid players specified.");
            return false;
        }
        this.plugin.getGameManager().setHunters(players);
        sender.sendMessage("\u00a7aHunters set: " + players.stream().map(Player::getName).collect(Collectors.joining(", ")));
        return true;
    }

    private boolean handleReload(CommandSender sender) {
        if (!sender.hasPermission("speedrunnerswap.admin")) {
            sender.sendMessage("\u00a7cYou don't have permission to use this command.");
            return false;
        }
        if (this.plugin.getGameManager().isGameRunning()) {
            this.plugin.getGameManager().stopGame();
        }
        this.plugin.getConfigManager().loadConfig();
        sender.sendMessage("\u00a7aConfiguration reloaded.");
        return true;
    }

    private boolean handleTasks(CommandSender sender, String[] rest) {
        String sub;
        if (!sender.hasPermission("speedrunnerswap.admin")) {
            sender.sendMessage("\u00a7cYou don't have permission to manage tasks.");
            return false;
        }
        if (rest.length == 0) {
            sender.sendMessage("\u00a7eUsage: /swap tasks <list|reroll|endwhenoneleft <on|off|toggle>|reload>");
            return true;
        }
        switch (sub = rest[0].toLowerCase()) {
            case "list": {
                TaskManagerMode tmm = this.plugin.getTaskManagerMode();
                if (tmm == null) {
                    sender.sendMessage("\u00a7cTask Manager not initialized.");
                    return false;
                }
                Map<UUID, String> map = tmm.getAssignments();
                if (map.isEmpty()) {
                    sender.sendMessage("\u00a77No task assignments.");
                    return true;
                }
                sender.sendMessage("\u00a76Task Assignments:");
                for (Map.Entry<UUID, String> e : map.entrySet()) {
                    TaskDefinition def;
                    UUID uuid = e.getKey();
                    String taskId = e.getValue();
                    String name = this.plugin.getServer().getOfflinePlayer(uuid).getName();
                    if (name == null) {
                        name = uuid.toString().substring(0, 8);
                    }
                    String desc = (def = tmm.getTask(taskId)) != null ? def.description() : taskId;
                    sender.sendMessage("\u00a7e" + name + "\u00a77: \u00a7f" + desc + " (\u00a78" + taskId + "\u00a77)");
                }
                return true;
            }
            case "reroll": {
                if (this.plugin.getGameManager().isGameRunning()) {
                    sender.sendMessage("\u00a7cYou can only reroll before the game starts.");
                    return false;
                }
                if (this.plugin.getCurrentMode() != SpeedrunnerSwap.SwapMode.TASK) {
                    sender.sendMessage("\u00a7cSwitch to Task Manager mode first: /swap mode task");
                    return false;
                }
                TaskManagerMode tmm = this.plugin.getTaskManagerMode();
                if (tmm == null) {
                    sender.sendMessage("\u00a7cTask Manager not initialized.");
                    return false;
                }
                ArrayList<Player> selectedRunners = new ArrayList<Player>();
                for (Player p : Bukkit.getOnlinePlayers()) {
                    PlayerState st = this.plugin.getGameManager().getPlayerState(p);
                    if (st == null || st.getSelectedTeam() != Team.RUNNER) continue;
                    selectedRunners.add(p);
                }
                if (selectedRunners.isEmpty()) {
                    sender.sendMessage("\u00a7cNo selected runners found. Use the Team Selector first.");
                    return false;
                }
                tmm.assignAndAnnounceTasks(selectedRunners);
                sender.sendMessage("\u00a7aRerolled tasks for \u00a7f" + selectedRunners.size() + "\u00a7a selected runners.");
                return true;
            }
            case "endwhenoneleft": {
                String opt;
                boolean cur = this.plugin.getConfig().getBoolean("task_manager.end_when_one_left", false);
                cur = rest.length >= 2 ? ((opt = rest[1].toLowerCase()).equals("on") || opt.equals("true") ? true : (opt.equals("off") || opt.equals("false") ? false : !cur)) : !cur;
                this.plugin.getConfig().set("task_manager.end_when_one_left", (Object)cur);
                this.plugin.saveConfig();
                sender.sendMessage("\u00a7eEnd When One Runner Left: " + (cur ? "\u00a7aON" : "\u00a7cOFF"));
                return true;
            }
            case "reload": {
                TaskManagerMode tmm = this.plugin.getTaskManagerMode();
                if (tmm == null) {
                    sender.sendMessage("\u00a7cTask Manager not initialized.");
                    return false;
                }
                tmm.reloadTasks();
                sender.sendMessage("\u00a7a[Task Manager] Tasks reloaded from config without restarting!");
                return true;
            }
        }
        sender.sendMessage("\u00a7cUnknown tasks subcommand. Use list|reroll|endwhenoneleft|reload");
        return false;
    }

    private boolean handleClearTeams(CommandSender sender) {
        if (!sender.hasPermission("speedrunnerswap.admin")) {
            sender.sendMessage("\u00a7cYou don't have permission to use this command.");
            return false;
        }
        if (this.plugin.getGameManager().isGameRunning()) {
            this.plugin.getGameManager().stopGame();
        }
        this.plugin.getGameManager().setRunners(new ArrayList<Player>());
        this.plugin.getGameManager().setHunters(new ArrayList<Player>());
        sender.sendMessage("\u00a7aCleared all teams (runners and hunters).");
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions;
        block8: {
            block10: {
                block9: {
                    block7: {
                        completions = new ArrayList<String>();
                        if (args.length != 1) break block7;
                        List<String> subCommands = Arrays.asList("start", "stop", "pause", "resume", "status", "creator", "setrunners", "sethunters", "reload", "gui", "mode", "clearteams", "tasks", "complete");
                        for (String subCommand : subCommands) {
                            if (!subCommand.startsWith(args[0].toLowerCase())) continue;
                            completions.add(subCommand);
                        }
                        break block8;
                    }
                    if (args.length <= 1) break block8;
                    if (!args[0].equalsIgnoreCase("setrunners") && !args[0].equalsIgnoreCase("sethunters")) break block9;
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        String name = player.getName();
                        if (!name.toLowerCase().startsWith(args[args.length - 1].toLowerCase())) continue;
                        completions.add(name);
                    }
                    break block8;
                }
                if (!args[0].equalsIgnoreCase("complete") || args.length != 2) break block10;
                if (!"confirm".startsWith(args[1].toLowerCase())) break block8;
                completions.add("confirm");
                break block8;
            }
            if (args[0].equalsIgnoreCase("mode") && args.length == 2) {
                for (String opt : new String[]{"dream", "sapnap", "default"}) {
                    if (!opt.startsWith(args[1].toLowerCase())) continue;
                    completions.add(opt);
                }
            } else if (args[0].equalsIgnoreCase("mode") && args.length == 3 && "default".startsWith(args[1].toLowerCase())) {
                for (String opt : new String[]{"dream", "sapnap"}) {
                    if (!opt.startsWith(args[2].toLowerCase())) continue;
                    completions.add(opt);
                }
            }
        }
        return completions;
    }

    private boolean handleTaskComplete(CommandSender sender, String[] rest) {
        String description;
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a7cOnly players can complete tasks.");
            return false;
        }
        Player player = (Player)sender;
        if (this.plugin.getCurrentMode() != SpeedrunnerSwap.SwapMode.TASK) {
            sender.sendMessage("\u00a7cTask completion is only available in Task Manager mode.");
            return false;
        }
        if (!this.plugin.getGameManager().isGameRunning()) {
            sender.sendMessage("\u00a7cTasks can only be completed during an active game.");
            return false;
        }
        TaskManagerMode taskMode = this.plugin.getTaskManagerMode();
        if (taskMode == null) {
            sender.sendMessage("\u00a7cTask Manager not initialized.");
            return false;
        }
        String assignedTask = taskMode.getAssignedTask(player);
        if (assignedTask == null) {
            sender.sendMessage("\u00a7cYou don't have a task assigned. Join the game as a runner first.");
            return false;
        }
        TaskDefinition taskDef = taskMode.getTask(assignedTask);
        String string = description = taskDef != null ? taskDef.description() : assignedTask;
        if (rest.length == 0) {
            player.sendMessage("\u00a76========== \u00a7e\u00a7lYOUR TASK \u00a76==========");
            player.sendMessage("\u00a7f" + description);
            player.sendMessage("");
            player.sendMessage("\u00a7a\u00a7lTo complete your task:");
            player.sendMessage("\u00a7e/swap complete confirm");
            player.sendMessage("");
            player.sendMessage("\u00a77When you use this command, you will win the game!");
            player.sendMessage("\u00a77Only use it when you have actually finished your task.");
            player.sendMessage("\u00a76" + "=".repeat(35));
            return true;
        }
        String action = rest[0].toLowerCase();
        if (!"confirm".equals(action)) {
            sender.sendMessage("\u00a7cUse '/swap complete confirm' to complete your task, or '/swap complete' to see your task.");
            return false;
        }
        player.sendMessage("\u00a7a\u00a7lCongratulations! You completed your task:");
        player.sendMessage("\u00a7f" + description);
        taskMode.complete(player);
        return true;
    }
}

