/*
 * Decompiled with CFR 0.152.
 */
package com.example.speedrunnerswap.game;

import com.example.speedrunnerswap.SpeedrunnerSwap;
import com.example.speedrunnerswap.utils.Msg;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class WorldBorderManager {
    private final SpeedrunnerSwap plugin;
    private boolean isActive;
    private BukkitTask borderWarningTask;

    public WorldBorderManager(SpeedrunnerSwap plugin) {
        this.plugin = plugin;
        this.isActive = false;
        this.borderWarningTask = null;
    }

    public void startBorderShrinking() {
        if (this.isActive) {
            return;
        }
        this.isActive = true;
        int initialSize = this.plugin.getConfig().getInt("world_border.initial_size", 2000);
        int finalSize = this.plugin.getConfig().getInt("world_border.final_size", 100);
        long shrinkDuration = this.plugin.getConfig().getLong("world_border.shrink_duration", 1800L);
        for (World world : Bukkit.getWorlds()) {
            WorldBorder border = world.getWorldBorder();
            border.setCenter(0.0, 0.0);
            border.setSize((double)initialSize);
            border.setSize((double)finalSize, shrinkDuration);
            Msg.broadcast("\u00a7c\u00a7lWorld Border will shrink from " + initialSize + " blocks to " + finalSize + " blocks over " + shrinkDuration / 60L + " minutes!");
        }
        this.scheduleBorderWarnings();
    }

    public void stopBorderShrinking() {
        if (!this.isActive) {
            return;
        }
        this.isActive = false;
        int initialSize = this.plugin.getConfig().getInt("world_border.initial_size", 2000);
        for (World world : Bukkit.getWorlds()) {
            WorldBorder border = world.getWorldBorder();
            border.setSize((double)initialSize);
        }
        if (this.borderWarningTask != null) {
            this.borderWarningTask.cancel();
            this.borderWarningTask = null;
        }
    }

    private void scheduleBorderWarnings() {
        if (this.borderWarningTask != null) {
            this.borderWarningTask.cancel();
            this.borderWarningTask = null;
        }
        int warnEverySec = Math.max(30, this.plugin.getConfig().getInt("world_border.warning_interval", 120));
        long period = (long)warnEverySec * 20L;
        this.borderWarningTask = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            if (!this.isActive) {
                return;
            }
            try {
                for (World world : Bukkit.getWorlds()) {
                    double size = world.getWorldBorder().getSize();
                    Msg.broadcast("\u00a7eWorld Border current size: \u00a7f" + (int)size + "\u00a7e blocks.");
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }, period, period);
    }

    public boolean isActive() {
        return this.isActive;
    }
}

