/*
 * Decompiled with CFR 0.152.
 */
package com.example.speedrunnerswap.gui;

import com.example.speedrunnerswap.SpeedrunnerSwap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.Plugin;

public class ChatInputHandler
implements Listener {
    private final SpeedrunnerSwap plugin;
    private final Map<UUID, InputState> activeInputs = new HashMap<UUID, InputState>();

    public ChatInputHandler(SpeedrunnerSwap plugin) {
        this.plugin = plugin;
    }

    public void expectTaskId(Player player) {
        this.activeInputs.put(player.getUniqueId(), new InputState(InputState.Type.TASK_ID));
    }

    public void expectTaskDescription(Player player, String taskId) {
        InputState state = new InputState(InputState.Type.TASK_DESCRIPTION);
        state.taskId = taskId;
        this.activeInputs.put(player.getUniqueId(), state);
    }

    public void expectTaskDescription(Player player) {
        this.activeInputs.put(player.getUniqueId(), new InputState(InputState.Type.TASK_DESCRIPTION));
    }

    public void expectDonationUrl(Player player) {
        this.activeInputs.put(player.getUniqueId(), new InputState(InputState.Type.DONATION_URL));
    }

    public void expectConfigString(Player player, String path) {
        InputState st = new InputState(InputState.Type.CONFIG_STRING);
        st.configPath = path;
        this.activeInputs.put(player.getUniqueId(), st);
    }

    public void expectConfigListAdd(Player player, String path) {
        InputState st = new InputState(InputState.Type.CONFIG_LIST_ADD);
        st.configPath = path;
        this.activeInputs.put(player.getUniqueId(), st);
    }

    @EventHandler
    public void onChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        UUID uuid = player.getUniqueId();
        if (!this.activeInputs.containsKey(uuid)) {
            return;
        }
        event.setCancelled(true);
        InputState state = this.activeInputs.remove(uuid);
        String msg = event.getMessage();
        this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
            switch (state.type.ordinal()) {
                case 0: {
                    this.expectTaskDescription(player, msg.trim());
                    player.sendMessage("\u00a76Enter a \u00a7bdescription \u00a76for task \u00a7e" + msg.trim());
                    break;
                }
                case 1: {
                    Object id = state.taskId != null ? state.taskId.trim() : "custom_" + System.currentTimeMillis();
                    List list = this.plugin.getConfig().getStringList("task_manager.custom_tasks");
                    list.add(msg.trim());
                    this.plugin.getConfig().set("task_manager.custom_tasks", (Object)list);
                    this.plugin.saveConfig();
                    player.sendMessage("\u00a7aAdded custom task \u00a7e" + (String)id + "\u00a7a: \u00a7f" + msg.trim());
                    break;
                }
                case 2: {
                    this.plugin.getConfig().set("donation.url", (Object)msg.trim());
                    this.plugin.saveConfig();
                    player.sendMessage("\u00a7aUpdated donation URL.");
                    break;
                }
                case 3: {
                    this.plugin.getConfig().set(state.configPath, (Object)msg.trim());
                    this.plugin.saveConfig();
                    player.sendMessage("\u00a7aUpdated \u00a7e" + state.configPath + "\u00a7a.");
                    break;
                }
                case 4: {
                    List l = this.plugin.getConfig().getStringList(state.configPath);
                    l.add(msg.trim());
                    this.plugin.getConfig().set(state.configPath, (Object)l);
                    this.plugin.saveConfig();
                    player.sendMessage("\u00a7aAppended to \u00a7e" + state.configPath + "\u00a7a.");
                }
            }
        });
    }

    public void clearInput(Player player) {
        this.activeInputs.remove(player.getUniqueId());
    }

    private static class InputState {
        final Type type;
        String taskId;
        String configPath;

        InputState(Type type) {
            this.type = type;
        }

        static enum Type {
            TASK_ID,
            TASK_DESCRIPTION,
            DONATION_URL,
            CONFIG_STRING,
            CONFIG_LIST_ADD;

        }
    }
}

