/*
 * Decompiled with CFR 0.152.
 */
package com.example.speedrunnerswap.gui;

import com.example.speedrunnerswap.SpeedrunnerSwap;
import com.example.speedrunnerswap.gui.ControlGuiHolder;
import com.example.speedrunnerswap.gui.ControlGuiListener;
import com.example.speedrunnerswap.utils.GuiCompat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class ControlGui {
    private final SpeedrunnerSwap plugin;
    private final Set<UUID> pendingOpens = Collections.synchronizedSet(new HashSet());

    public ControlGui(SpeedrunnerSwap plugin) {
        this.plugin = plugin;
    }

    public void openMainMenu(Player player) {
        boolean running = this.plugin.getGameManager().isGameRunning();
        List<Player> runners = this.plugin.getGameManager().getRunners();
        int runnerCount = runners != null ? runners.size() : 0;
        boolean paused = this.plugin.getGameManager().isGamePaused();
        Player activeRunner = this.plugin.getGameManager().getActiveRunner();
        int rows = 5;
        int size = rows * 9;
        String title = "\u00a7b\u00a7lSapnap: Multi-Runner Cooperation" + (running ? (paused ? " \u00a7e\u00a7l[PAUSED]" : " \u00a7a\u00a7l[LIVE]") : "");
        Inventory inv = GuiCompat.createInventory(new ControlGuiHolder(ControlGuiHolder.Type.MAIN), size, title);
        ItemStack border = new ItemStack(Material.CYAN_STAINED_GLASS_PANE);
        ItemMeta bm = border.getItemMeta();
        GuiCompat.setDisplayName(bm, " ");
        border.setItemMeta(bm);
        this.fillBorder(inv, border);
        inv.setItem(0, this.button(Material.ARROW, "back", "\u00a77\u00a7lBack", List.of("\u00a77Return to mode selector")));
        ArrayList<String> statusLore = new ArrayList<String>();
        statusLore.add("\u00a77Runners: \u00a7b" + runnerCount);
        statusLore.add("\u00a77Status: " + (running ? (paused ? "\u00a7ePaused" : "\u00a7aRunning") : "\u00a7cNot Running"));
        if (running) {
            statusLore.add("\u00a77Active: \u00a7a" + (activeRunner != null ? activeRunner.getName() : "None"));
            statusLore.add("\u00a77Next Swap: \u00a7e" + this.plugin.getGameManager().getTimeUntilNextSwap() + "s");
        }
        inv.setItem(4, this.named(Material.CLOCK, "\u00a76\u00a7lGame Status", statusLore));
        if (!running) {
            ArrayList<String> startLore = new ArrayList<String>();
            startLore.add("\u00a77Begin cooperative swapping");
            if (runnerCount < 2) {
                startLore.add("\u00a7cNeed at least 2 runners!");
                inv.setItem(10, this.button(Material.GRAY_WOOL, "start", "Start Game", startLore));
            } else {
                startLore.add("\u00a77Interval: \u00a7a" + this.plugin.getConfigManager().getSwapInterval() + "s");
                inv.setItem(10, this.button(Material.LIME_WOOL, "start", "\u00a7a\u00a7lStart Game", startLore));
            }
        } else {
            inv.setItem(10, this.button(Material.RED_WOOL, "stop", "\u00a7c\u00a7lStop Game", List.of("\u00a77End current session")));
        }
        if (running && !paused) {
            inv.setItem(12, this.button(Material.YELLOW_WOOL, "pause", "\u00a7e\u00a7lPause", List.of("\u00a77Temporarily pause swapping")));
        } else if (running && paused) {
            inv.setItem(12, this.button(Material.ORANGE_WOOL, "resume", "\u00a7a\u00a7lResume", List.of("\u00a77Resume cooperative swapping")));
        } else {
            inv.setItem(12, this.button(Material.GRAY_WOOL, "pause", "Pause", List.of("\u00a77Game not running")));
        }
        inv.setItem(14, this.button(Material.NETHER_STAR, "shuffle", "\u00a7d\u00a7lShuffle Queue", List.of("\u00a77Randomize runner order")));
        inv.setItem(16, this.namedWithId(Material.PLAYER_HEAD, "\u00a7b\u00a7lManage Runners", List.of("\u00a77Select/deselect participants"), "manage_runners"));
        boolean randomize = this.plugin.getConfigManager().isSwapRandomized();
        ArrayList<String> randomizeLore = new ArrayList<String>();
        randomizeLore.add("\u00a77Current: " + (randomize ? "\u00a7aRandom" : "\u00a7bFixed"));
        if (randomize) {
            randomizeLore.add("\u00a77Range: \u00a7e" + this.plugin.getConfigManager().getMinSwapInterval() + "-" + this.plugin.getConfigManager().getMaxSwapInterval() + "s");
        }
        inv.setItem(19, this.named(Material.COMPARATOR, (randomize ? "\u00a7a" : "\u00a7b") + "\u00a7lTiming: " + (randomize ? "Random" : "Fixed"), randomizeLore));
        int interval = this.plugin.getConfigManager().getSwapInterval();
        ArrayList<String> intervalLore = new ArrayList<String>();
        intervalLore.add("\u00a77Base swap interval");
        inv.setItem(21, this.named(Material.PAPER, "Interval: " + interval + "s", intervalLore));
        inv.setItem(20, this.named(Material.ARROW, "-5s", List.of("\u00a77Decrease interval")));
        inv.setItem(22, this.named(Material.ARROW, "+5s", List.of("\u00a77Increase interval")));
        boolean betaToggle = this.plugin.getConfigManager().isBetaIntervalEnabled();
        inv.setItem(23, this.named(betaToggle ? Material.REDSTONE_TORCH : Material.LEVER, "Experimental Intervals: " + (betaToggle ? "ON" : "OFF"), List.of("\u00a77Allow <30s and >max intervals")));
        String freeze = this.plugin.getConfigManager().getFreezeMode();
        Material freezeIcon = switch (freeze.toUpperCase()) {
            case "SPECTATOR" -> Material.ENDER_EYE;
            case "LIMBO" -> Material.ENDER_PEARL;
            case "CAGE" -> Material.BEDROCK;
            default -> Material.POTION;
        };
        inv.setItem(28, this.named(freezeIcon, "\u00a76\u00a7lInactive State: \u00a7a" + freeze, List.of("\u00a77Cycle inactive-runner behavior")));
        boolean safeSwap = this.plugin.getConfigManager().isSafeSwapEnabled();
        inv.setItem(29, this.named(safeSwap ? Material.SLIME_BLOCK : Material.MAGMA_BLOCK, (safeSwap ? "\u00a7a" : "\u00a7c") + "\u00a7lSafe Swaps: " + (safeSwap ? "ON" : "OFF"), List.of("\u00a77Prevent dangerous swap locations")));
        boolean singlePlayerSleep = this.plugin.getConfigManager().isSinglePlayerSleepEnabled();
        inv.setItem(30, this.named(singlePlayerSleep ? Material.WHITE_BED : Material.RED_BED, (singlePlayerSleep ? "\u00a7a" : "\u00a7c") + "\u00a7lSingle Sleep: " + (singlePlayerSleep ? "ON" : "OFF"), List.of("\u00a77Only active runner can sleep")));
        boolean applyDefault = this.plugin.getConfigManager().getApplyDefaultOnModeSwitch();
        inv.setItem(31, this.named(applyDefault ? Material.NOTE_BLOCK : Material.GRAY_DYE, "Apply Mode Default on Switch: " + (applyDefault ? "Yes" : "No"), List.of("\u00a77Apply mode default interval on switch")));
        inv.setItem(32, this.named(Material.WRITABLE_BOOK, "Save as Mode Default", List.of("\u00a77Set current interval as default")));
        inv.setItem(33, this.named(Material.BARRIER, "Reset Interval", List.of("\u00a77Reset to this mode's default")));
        this.openInventorySoon(player, inv);
    }

    private void openInventorySoon(Player player, Inventory inv) {
        if (player == null || inv == null) {
            return;
        }
        UUID uuid = player.getUniqueId();
        if (this.pendingOpens.contains(uuid)) {
            return;
        }
        this.pendingOpens.add(uuid);
        this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
            try {
                if (player.isOnline()) {
                    this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                        if (player.isOnline()) {
                            player.openInventory(inv);
                        }
                        this.pendingOpens.remove(uuid);
                    }, 1L);
                } else {
                    this.pendingOpens.remove(uuid);
                }
            }
            catch (Exception e) {
                this.pendingOpens.remove(uuid);
                this.plugin.getLogger().warning("Failed to open Sapnap inventory for " + player.getName() + ": " + e.getMessage());
            }
        });
    }

    private void fillBorder(Inventory inv, ItemStack filler) {
        int size = inv.getSize();
        int cols = 9;
        int rows = size / cols;
        for (int c = 0; c < cols; ++c) {
            inv.setItem(c, filler);
            inv.setItem((rows - 1) * cols + c, filler);
        }
        for (int r = 1; r < rows - 1; ++r) {
            inv.setItem(r * cols, filler);
            inv.setItem(r * cols + (cols - 1), filler);
        }
    }

    public void openRunnerSelector(Player player) {
        int rows = Math.max(2, this.plugin.getConfigManager().getGuiTeamSelectorRows());
        int size = rows * 9;
        String title = this.plugin.getConfigManager().getGuiTeamSelectorTitle();
        Inventory inv = GuiCompat.createInventory(new ControlGuiHolder(ControlGuiHolder.Type.RUNNER_SELECTOR), size, title);
        ItemStack filler = new ItemStack(Material.BLACK_STAINED_GLASS_PANE);
        ItemMeta fm = filler.getItemMeta();
        GuiCompat.setDisplayName(fm, " ");
        filler.setItemMeta(fm);
        for (int i = 0; i < inv.getSize(); ++i) {
            inv.setItem(i, filler);
        }
        Set<String> pending = ControlGuiListener.getPendingSelection(player.getUniqueId());
        List<String> selected = pending != null ? new ArrayList<String>(pending) : this.plugin.getConfigManager().getRunnerNames();
        int idx = 0;
        for (Player p : Bukkit.getOnlinePlayers()) {
            ItemStack icon = new ItemStack(Material.PLAYER_HEAD);
            try {
                SkullMeta sm = (SkullMeta)icon.getItemMeta();
                sm.setOwningPlayer((OfflinePlayer)p);
                GuiCompat.setDisplayName((ItemMeta)sm, p.getName());
                boolean isSel = selected.contains(p.getName());
                ArrayList<String> legacy = new ArrayList<String>();
                legacy.add(isSel ? "Selected: Yes" : "Selected: No");
                GuiCompat.setLore((ItemMeta)sm, legacy);
                icon.setItemMeta((ItemMeta)sm);
            }
            catch (Throwable t) {
                ItemMeta im = icon.getItemMeta();
                GuiCompat.setDisplayName(im, p.getName());
                icon.setItemMeta(im);
            }
            if (idx < size - 9) {
                inv.setItem(idx, icon);
            }
            ++idx;
        }
        inv.setItem(size - 8, this.named(Material.ARROW, "\u00a77\u00a7lBack", List.of("\u00a77Return to control menu")));
        inv.setItem(size - 6, this.named(Material.EMERALD_BLOCK, "Save", List.of("Apply selected runners")));
        inv.setItem(size - 4, this.named(Material.BARRIER, "Cancel", List.of("Discard changes")));
        this.openInventorySoon(player, inv);
    }

    private ItemStack named(Material mat, String name, List<String> loreText) {
        ItemStack it = new ItemStack(mat);
        ItemMeta im = it.getItemMeta();
        GuiCompat.setDisplayName(im, name);
        if (loreText != null && !loreText.isEmpty()) {
            GuiCompat.setLore(im, loreText);
        }
        it.setItemMeta(im);
        return it;
    }

    private ItemStack button(Material mat, String id, String display, List<String> lore) {
        ItemStack it = new ItemStack(mat);
        ItemMeta im = it.getItemMeta();
        GuiCompat.setDisplayName(im, display);
        if (lore != null && !lore.isEmpty()) {
            GuiCompat.setLore(im, lore);
        }
        try {
            PersistentDataContainer pdc = im.getPersistentDataContainer();
            pdc.set(new NamespacedKey((Plugin)this.plugin, "btn"), PersistentDataType.STRING, (Object)id);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        it.setItemMeta(im);
        return it;
    }

    private ItemStack namedWithId(Material mat, String name, List<String> loreText, String buttonId) {
        ItemStack it = new ItemStack(mat);
        ItemMeta im = it.getItemMeta();
        GuiCompat.setDisplayName(im, name);
        if (loreText != null && !loreText.isEmpty()) {
            GuiCompat.setLore(im, loreText);
        }
        if (buttonId != null && !buttonId.isEmpty()) {
            NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "ssw_button_id");
            im.getPersistentDataContainer().set(key, PersistentDataType.STRING, (Object)buttonId);
        }
        it.setItemMeta(im);
        return it;
    }

    public void openTeamCoordinationMenu(Player player) {
        Inventory inv = GuiCompat.createInventory(new ControlGuiHolder(ControlGuiHolder.Type.COORDINATION), 45, "\u00a7e\u00a7lTeam Coordination Hub");
        ItemStack filler = new ItemStack(Material.YELLOW_STAINED_GLASS_PANE);
        ItemMeta fm = filler.getItemMeta();
        GuiCompat.setDisplayName(fm, " ");
        filler.setItemMeta(fm);
        for (int i = 0; i < inv.getSize(); ++i) {
            inv.setItem(i, filler);
        }
        inv.setItem(0, this.named(Material.ARROW, "\u00a77\u00a7lBack", List.of("\u00a77Return to main menu")));
        inv.setItem(10, this.named(Material.BELL, "\u00a76\u00a7lBroadcast Location", List.of("\u00a77Share your current coordinates", "\u00a77with all team members", "\u00a77Click to announce position")));
        inv.setItem(11, this.named(Material.CHEST, "\u00a76\u00a7lInventory Status", List.of("\u00a77Share key items in inventory", "\u00a77Shows tools, food, resources", "\u00a77Click to broadcast status")));
        inv.setItem(12, this.named(Material.REDSTONE_TORCH, "\u00a7c\u00a7lEmergency Pause", List.of("\u00a77Request immediate game pause", "\u00a77Use for urgent situations", "\u00a77Will notify all runners")));
        inv.setItem(13, this.named(Material.ENDER_EYE, "\u00a7d\u00a7lMark Waypoint", List.of("\u00a77Set a team waypoint here", "\u00a77All runners will see direction", "\u00a77Great for meeting points")));
        boolean gameRunning = this.plugin.getGameManager().isGameRunning();
        if (gameRunning) {
            List<Player> runners = this.plugin.getGameManager().getRunners();
            Player activeRunner = this.plugin.getGameManager().getActiveRunner();
            inv.setItem(19, this.named(Material.PLAYER_HEAD, "\u00a7b\u00a7lTeam Overview", List.of("\u00a77Active: \u00a7a" + (activeRunner != null ? activeRunner.getName() : "None"), "\u00a77Total Runners: \u00a7e" + runners.size(), "\u00a77Next swap in: \u00a7e" + this.plugin.getGameManager().getTimeUntilNextSwap() + "s")));
        } else {
            inv.setItem(19, this.named(Material.BARRIER, "\u00a77Team Overview", List.of("\u00a77Game not currently running")));
        }
        ArrayList<String> tipsLore = new ArrayList<String>();
        tipsLore.add("\u00a77Enhanced cooperation tips:");
        tipsLore.add("\u00a7a\u2022 \u00a7fUse F3+F to adjust view distance");
        tipsLore.add("\u00a7a\u2022 \u00a7fPress Tab to see all player positions");
        tipsLore.add("\u00a7a\u2022 \u00a7fLeave signs with important info");
        tipsLore.add("\u00a7a\u2022 \u00a7fKeep shared storage accessible");
        tipsLore.add("\u00a7a\u2022 \u00a7fUse compass to stay oriented");
        tipsLore.add("\u00a7a\u2022 \u00a7fCommunicate upcoming plans");
        inv.setItem(25, this.named(Material.BOOK, "\u00a7e\u00a7lAdvanced Tips", tipsLore));
        ArrayList<String> voiceChatLore = new ArrayList<String>();
        voiceChatLore.add("\u00a77Smart voice communication setup:");
        voiceChatLore.add("\u00a7a\u2022 \u00a7fDiscord: Best for team coordination");
        voiceChatLore.add("\u00a7a\u2022 \u00a7fTeamSpeak: Professional alternative");
        voiceChatLore.add("\u00a7a\u2022 \u00a7fMumble: Low-latency option");
        voiceChatLore.add("");
        voiceChatLore.add("\u00a76Active Runner Protocol:");
        voiceChatLore.add("\u00a7e1. \u00a77Narrate all major actions");
        voiceChatLore.add("\u00a7e2. \u00a77Call out incoming threats");
        voiceChatLore.add("\u00a7e3. \u00a77Share resource locations");
        voiceChatLore.add("\u00a7e4. \u00a77Announce swap preparation");
        voiceChatLore.add("");
        voiceChatLore.add("\u00a7bWaiting Runners:");
        voiceChatLore.add("\u00a7b\u2022 \u00a77Plan ahead strategically");
        voiceChatLore.add("\u00a7b\u2022 \u00a77Prepare resources for handoff");
        voiceChatLore.add("\u00a7b\u2022 \u00a77Watch for coordination opportunities");
        inv.setItem(28, this.named(Material.NOTE_BLOCK, "\u00a7d\u00a7lSmart Voice Chat", voiceChatLore));
        if (gameRunning) {
            List<Player> runners = this.plugin.getGameManager().getRunners();
            Player activeRunner = this.plugin.getGameManager().getActiveRunner();
            ArrayList<String> analysisLore = new ArrayList<String>();
            analysisLore.add("\u00a76\u00a7lTeam Performance Analysis:");
            analysisLore.add("\u00a77Active: \u00a7a" + (activeRunner != null ? activeRunner.getName() : "None"));
            analysisLore.add("\u00a77Total Runners: \u00a7e" + runners.size());
            analysisLore.add("\u00a77Next swap: \u00a7e" + this.plugin.getGameManager().getTimeUntilNextSwap() + "s");
            analysisLore.add("");
            analysisLore.add("\u00a7b\u00a7lSmart Recommendations:");
            if (runners.size() <= 2) {
                analysisLore.add("\u00a7e\u2022 Small team: Focus on efficiency");
                analysisLore.add("\u00a7e\u2022 Longer intervals recommended");
            } else if (runners.size() >= 5) {
                analysisLore.add("\u00a7c\u2022 Large team: Monitor performance");
                analysisLore.add("\u00a7c\u2022 Consider shorter intervals");
                analysisLore.add("\u00a7c\u2022 Watch for coordination delays");
            } else {
                analysisLore.add("\u00a7a\u2022 Optimal team size detected");
                analysisLore.add("\u00a7a\u2022 Perfect for balanced cooperation");
            }
            int timeLeft = this.plugin.getGameManager().getTimeUntilNextSwap();
            if (timeLeft <= 10) {
                analysisLore.add("\u00a7c\u2022 \u00a7lSwap imminent - prepare for transition!");
            } else if (timeLeft >= 60) {
                analysisLore.add("\u00a7b\u2022 Good time for strategic planning");
            }
            inv.setItem(34, this.named(Material.SPYGLASS, "\u00a76\u00a7lTeam Analytics", analysisLore));
        } else {
            inv.setItem(34, this.named(Material.BARRIER, "\u00a77Team Analytics", List.of("\u00a77Available during active games")));
        }
        ArrayList<String> emergencyLore = new ArrayList<String>();
        emergencyLore.add("\u00a7c\u00a7lEmergency Procedures:");
        emergencyLore.add("\u00a77Quick response protocols:");
        emergencyLore.add("");
        emergencyLore.add("\u00a7c1. Immediate Danger:");
        emergencyLore.add("\u00a77   \u2022 Use emergency pause button");
        emergencyLore.add("\u00a77   \u2022 Call out in voice chat");
        emergencyLore.add("\u00a77   \u2022 Broadcast location if trapped");
        emergencyLore.add("");
        emergencyLore.add("\u00a7e2. Resource Emergency:");
        emergencyLore.add("\u00a77   \u2022 Share inventory status");
        emergencyLore.add("\u00a77   \u2022 Mark waypoint to resources");
        emergencyLore.add("\u00a77   \u2022 Coordinate supply drop");
        emergencyLore.add("");
        emergencyLore.add("\u00a7b3. Communication Loss:");
        emergencyLore.add("\u00a77   \u2022 Use in-game chat");
        emergencyLore.add("\u00a77   \u2022 Leave signs at key locations");
        emergencyLore.add("\u00a77   \u2022 Follow predetermined protocols");
        inv.setItem(16, this.named(Material.REDSTONE_TORCH, "\u00a7c\u00a7lEmergency Protocols", emergencyLore));
        this.openInventorySoon(player, inv);
    }
}

