/*
 * Decompiled with CFR 0.152.
 */
package com.example.speedrunnerswap.gui;

import com.example.speedrunnerswap.SpeedrunnerSwap;
import com.example.speedrunnerswap.gui.ControlGui;
import com.example.speedrunnerswap.gui.ControlGuiHolder;
import com.example.speedrunnerswap.utils.BukkitCompat;
import com.example.speedrunnerswap.utils.GuiCompat;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class ControlGuiListener
implements Listener {
    private final SpeedrunnerSwap plugin;
    private static final Map<UUID, Set<String>> pendingRunnerSelections = new HashMap<UUID, Set<String>>();

    public static Set<String> getPendingSelection(UUID uuid) {
        return pendingRunnerSelections.get(uuid);
    }

    private void handleAboutClick(Player player, ItemStack clicked) {
        if (clicked == null || !clicked.hasItemMeta()) {
            return;
        }
        Material type = clicked.getType();
        String name = GuiCompat.getDisplayName(clicked.getItemMeta());
        if (type == Material.ARROW || name != null && name.contains("Back")) {
            new ControlGui(this.plugin).openMainMenu(player);
            return;
        }
        if (type == Material.PLAYER_HEAD && name != null && name.contains("Creator")) {
            String url = this.plugin.getConfig().getString("donation.url", "https://buymeacoffee.com/muj3b");
            player.sendMessage("\u00a76Support the creator: \u00a7b" + url);
            player.sendMessage("\u00a77Copy or click the link above in chat.");
        }
    }

    public static void setPendingSelection(UUID uuid, Set<String> sel) {
        if (sel == null) {
            pendingRunnerSelections.remove(uuid);
        } else {
            pendingRunnerSelections.put(uuid, sel);
        }
    }

    public ControlGuiListener(SpeedrunnerSwap plugin) {
        this.plugin = plugin;
    }

    private String getButtonId(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return null;
        }
        ItemMeta im = item.getItemMeta();
        try {
            PersistentDataContainer pdc = im.getPersistentDataContainer();
            String id = (String)pdc.get(new NamespacedKey((Plugin)this.plugin, "btn"), PersistentDataType.STRING);
            if (id != null && !id.isEmpty()) {
                return id;
            }
            id = (String)pdc.get(new NamespacedKey((Plugin)this.plugin, "ssw_button_id"), PersistentDataType.STRING);
            if (id != null && !id.isEmpty()) {
                return id;
            }
        }
        catch (Throwable pdc) {
            // empty catch block
        }
        String name = GuiCompat.getDisplayName(im);
        if (name == null) {
            return null;
        }
        String plain = ChatColor.stripColor((String)name).toLowerCase(Locale.ROOT);
        if (plain.contains("back")) {
            return "back";
        }
        if (plain.contains("start")) {
            return "start";
        }
        if (plain.contains("stop")) {
            return "stop";
        }
        if (plain.contains("pause")) {
            return "pause";
        }
        if (plain.contains("resume")) {
            return "resume";
        }
        if (plain.contains("about")) {
            return "about";
        }
        if (plain.contains("runner") && plain.contains("select")) {
            return "manage_runners";
        }
        return null;
    }

    private boolean isMain(Inventory inv) {
        ControlGuiHolder holder;
        InventoryHolder inventoryHolder;
        return inv != null && (inventoryHolder = inv.getHolder()) instanceof ControlGuiHolder && (holder = (ControlGuiHolder)inventoryHolder).getType() == ControlGuiHolder.Type.MAIN;
    }

    private boolean isRunnerSelector(Inventory inv) {
        ControlGuiHolder holder;
        InventoryHolder inventoryHolder;
        return inv != null && (inventoryHolder = inv.getHolder()) instanceof ControlGuiHolder && (holder = (ControlGuiHolder)inventoryHolder).getType() == ControlGuiHolder.Type.RUNNER_SELECTOR;
    }

    private boolean isCoordination(Inventory inv) {
        ControlGuiHolder holder;
        InventoryHolder inventoryHolder;
        return inv != null && (inventoryHolder = inv.getHolder()) instanceof ControlGuiHolder && (holder = (ControlGuiHolder)inventoryHolder).getType() == ControlGuiHolder.Type.COORDINATION;
    }

    private boolean isAbout(Inventory inv) {
        ControlGuiHolder holder;
        InventoryHolder inventoryHolder;
        return inv != null && (inventoryHolder = inv.getHolder()) instanceof ControlGuiHolder && (holder = (ControlGuiHolder)inventoryHolder).getType() == ControlGuiHolder.Type.ABOUT;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onInventoryClick(InventoryClickEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        Inventory top = event.getView().getTopInventory();
        if (top == null) {
            return;
        }
        if (!(this.isMain(top) || this.isRunnerSelector(top) || this.isCoordination(top) || this.isAbout(top))) {
            return;
        }
        event.setCancelled(true);
        this.plugin.getLogger().fine("GUI Click detected - Slot: " + event.getSlot() + ", RawSlot: " + event.getRawSlot());
        if (event.getRawSlot() >= top.getSize()) {
            return;
        }
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null || clicked.getType() == Material.AIR) {
            return;
        }
        this.plugin.getLogger().fine("Processing click on item: " + String.valueOf(clicked.getType()));
        if (this.isMain(top)) {
            this.handleMainClick(player, clicked);
        } else if (this.isRunnerSelector(top)) {
            this.handleRunnerSelectorClick(player, clicked, event.getRawSlot(), top.getSize());
        } else if (this.isCoordination(top)) {
            this.handleCoordinationClick(player, clicked);
        } else if (this.isAbout(top)) {
            this.handleAboutClick(player, clicked);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onInventoryDrag(InventoryDragEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Inventory top = event.getView().getTopInventory();
        if (top == null) {
            return;
        }
        if (!(this.isMain(top) || this.isRunnerSelector(top) || this.isCoordination(top))) {
            return;
        }
        event.setCancelled(true);
        this.plugin.getLogger().fine("Blocked drag attempt in GUI");
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onInventoryMoveItem(InventoryMoveItemEvent event) {
        Inventory source = event.getSource();
        Inventory destination = event.getDestination();
        if (source != null && (this.isMain(source) || this.isRunnerSelector(source) || this.isCoordination(source) || this.isAbout(source)) || destination != null && (this.isMain(destination) || this.isRunnerSelector(destination) || this.isCoordination(destination) || this.isAbout(destination))) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        HumanEntity humanEntity = event.getPlayer();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        Inventory top = event.getView().getTopInventory();
        if (top == null) {
            return;
        }
        if (this.isRunnerSelector(top)) {
            pendingRunnerSelections.remove(player.getUniqueId());
        }
    }

    private void handleMainClick(Player player, ItemStack clicked) {
        int current;
        String name;
        Material type = clicked.getType();
        boolean running = this.plugin.getGameManager().isGameRunning();
        String itemName = GuiCompat.getDisplayName(clicked.getItemMeta());
        this.plugin.getLogger().fine("Main GUI click - Material: " + String.valueOf(type) + ", Display Name: " + itemName);
        String buttonId = this.getButtonId(clicked);
        if (buttonId != null) {
            this.plugin.getLogger().fine("Found button ID: " + buttonId);
            switch (buttonId) {
                case "back": {
                    this.plugin.getGuiManager().openModeSelector(player);
                    return;
                }
                case "start": {
                    if (!running) {
                        this.plugin.setCurrentMode(SpeedrunnerSwap.SwapMode.SAPNAP);
                        List<String> names = Bukkit.getOnlinePlayers().stream().map(Player::getName).collect(Collectors.toList());
                        this.plugin.getConfigManager().setRunnerNames(names);
                        this.plugin.getGameManager().setRunners(new ArrayList<Player>(Bukkit.getOnlinePlayers()));
                        this.plugin.getGameManager().startGame();
                        player.sendMessage("\u00a7aGame started!");
                    } else {
                        player.sendMessage("\u00a7cGame is already running!");
                    }
                    new ControlGui(this.plugin).openMainMenu(player);
                    return;
                }
                case "stop": {
                    if (running) {
                        this.plugin.getGameManager().stopGame();
                        player.sendMessage("\u00a7cGame stopped!");
                    } else {
                        player.sendMessage("\u00a7cGame is not running!");
                    }
                    new ControlGui(this.plugin).openMainMenu(player);
                    return;
                }
                case "pause": {
                    if (running && !this.plugin.getGameManager().isGamePaused()) {
                        this.plugin.getGameManager().pauseGame();
                        player.sendMessage("\u00a7eGame paused!");
                    } else {
                        player.sendMessage("\u00a7cCannot pause - game not running or already paused!");
                    }
                    new ControlGui(this.plugin).openMainMenu(player);
                    return;
                }
                case "resume": {
                    if (running && this.plugin.getGameManager().isGamePaused()) {
                        this.plugin.getGameManager().resumeGame();
                        player.sendMessage("\u00a7aGame resumed!");
                    } else {
                        player.sendMessage("\u00a7cCannot resume - game not running or not paused!");
                    }
                    new ControlGui(this.plugin).openMainMenu(player);
                    return;
                }
                case "shuffle": {
                    if (this.plugin.getGameManager().shuffleQueue()) {
                        player.sendMessage("\u00a7aShuffled runner queue successfully.");
                    } else {
                        player.sendMessage("\u00a7cCannot shuffle queue - need at least 2 runners.");
                    }
                    new ControlGui(this.plugin).openMainMenu(player);
                    return;
                }
                case "manage_runners": {
                    this.plugin.getLogger().info("Processing manage_runners button");
                    HashSet<String> initial = new HashSet<String>(this.plugin.getConfigManager().getRunnerNames());
                    ControlGuiListener.setPendingSelection(player.getUniqueId(), initial);
                    new ControlGui(this.plugin).openRunnerSelector(player);
                    return;
                }
            }
        }
        if (type == Material.LIME_WOOL) {
            this.plugin.getLogger().fine("Processing LIME_WOOL (Start Game) click");
            if (!running) {
                this.plugin.setCurrentMode(SpeedrunnerSwap.SwapMode.SAPNAP);
                List<String> names = Bukkit.getOnlinePlayers().stream().map(Player::getName).collect(Collectors.toList());
                this.plugin.getConfigManager().setRunnerNames(names);
                this.plugin.getGameManager().setRunners(new ArrayList<Player>(Bukkit.getOnlinePlayers()));
                this.plugin.getGameManager().startGame();
                player.sendMessage("\u00a7aGame started!");
            } else {
                player.sendMessage("\u00a7cGame is already running!");
            }
            new ControlGui(this.plugin).openMainMenu(player);
            return;
        }
        if (type == Material.RED_WOOL) {
            this.plugin.getLogger().fine("Processing RED_WOOL (Stop Game) click");
            if (running) {
                this.plugin.getGameManager().stopGame();
                player.sendMessage("\u00a7cGame stopped!");
            } else {
                player.sendMessage("\u00a7cGame is not running!");
            }
            new ControlGui(this.plugin).openMainMenu(player);
            return;
        }
        if (type == Material.YELLOW_WOOL) {
            this.plugin.getLogger().fine("Processing YELLOW_WOOL (Pause Game) click");
            if (running && !this.plugin.getGameManager().isGamePaused()) {
                this.plugin.getGameManager().pauseGame();
                player.sendMessage("\u00a7eGame paused!");
            } else {
                player.sendMessage("\u00a7cCannot pause - game not running or already paused!");
            }
            new ControlGui(this.plugin).openMainMenu(player);
            return;
        }
        if (type == Material.ORANGE_WOOL) {
            this.plugin.getLogger().fine("Processing ORANGE_WOOL (Resume Game) click");
            if (running && this.plugin.getGameManager().isGamePaused()) {
                this.plugin.getGameManager().resumeGame();
                player.sendMessage("\u00a7aGame resumed!");
            } else {
                player.sendMessage("\u00a7cCannot resume - game not running or not paused!");
            }
            new ControlGui(this.plugin).openMainMenu(player);
            return;
        }
        if (type == Material.NETHER_STAR) {
            this.plugin.getLogger().fine("Processing NETHER_STAR (Shuffle Queue) click");
            if (this.plugin.getGameManager().shuffleQueue()) {
                player.sendMessage("\u00a7aShuffled runner queue successfully.");
            } else {
                player.sendMessage("\u00a7cCannot shuffle queue - need at least 2 runners.");
            }
            new ControlGui(this.plugin).openMainMenu(player);
            return;
        }
        if (type == Material.PLAYER_HEAD) {
            name = GuiCompat.getDisplayName(clicked.getItemMeta());
            this.plugin.getLogger().fine("Processing PLAYER_HEAD click with name: " + name);
            if (name != null && name.contains("Manage Runners")) {
                this.plugin.getLogger().info("Opening runner selector");
                HashSet<String> initial = new HashSet<String>(this.plugin.getConfigManager().getRunnerNames());
                pendingRunnerSelections.put(player.getUniqueId(), initial);
                new ControlGui(this.plugin).openRunnerSelector(player);
                return;
            }
        }
        if (type == Material.BOOK && (name = GuiCompat.getDisplayName(clicked.getItemMeta())) != null && name.contains("Cooperation Tips")) {
            player.sendMessage("\u00a76=== \u00a7e\u00a7lSapnap Mode Cooperation Tips \u00a76===");
            player.sendMessage("\u00a7b1. Communication is Key!\u00a77 Use voice chat or text to coordinate");
            player.sendMessage("\u00a7b2. Share Everything!\u00a77 Leave items for teammates in shared chests");
            player.sendMessage("\u00a7b3. Plan Ahead!\u00a77 Discuss strategies while inactive");
            player.sendMessage("\u00a7b4. Stay Informed!\u00a77 Active runner should narrate their actions");
            player.sendMessage("\u00a7b5. Resource Management!\u00a77 Don't waste materials when time is limited");
            player.sendMessage("\u00a7b6. Safe Locations!\u00a77 Try to swap in secure areas");
            player.sendMessage("\u00a7b7. Emergency Protocols!\u00a77 Agree on what to do in dangerous situations");
            player.sendMessage("\u00a7b8. Goal Coordination!\u00a77 Work together toward the Ender Dragon!");
            player.sendMessage("\u00a76========================================");
            return;
        }
        if (type == Material.WRITABLE_BOOK && "Save as Mode Default".equals(name = GuiCompat.getDisplayName(clicked.getItemMeta()))) {
            int curr = this.plugin.getConfigManager().getSwapInterval();
            this.plugin.getConfigManager().setModeDefaultInterval(this.plugin.getCurrentMode(), curr);
            player.sendMessage("\u00a7aSaved " + curr + "s as default for this mode.");
            new ControlGui(this.plugin).openMainMenu(player);
            return;
        }
        if (type == Material.GOLDEN_SWORD && (name = GuiCompat.getDisplayName(clicked.getItemMeta())) != null && name.contains("Quick Actions")) {
            this.handleQuickActions(player);
            return;
        }
        if (type == Material.ENCHANTED_BOOK) {
            name = GuiCompat.getDisplayName(clicked.getItemMeta());
            if (name != null && name.contains("Live Analytics")) {
                this.showDetailedAnalytics(player);
                return;
            }
            if (name != null && name.contains("Smart Help")) {
                this.showSmartHelp(player);
                return;
            }
        }
        if (type == Material.BARRIER && (name = GuiCompat.getDisplayName(clicked.getItemMeta())) != null && name.contains("Performance Alert")) {
            this.showOptimizationTips(player);
            return;
        }
        if (type == Material.COMPASS && (name = GuiCompat.getDisplayName(clicked.getItemMeta())) != null && name.contains("Team Coordination")) {
            new ControlGui(this.plugin).openTeamCoordinationMenu(player);
            return;
        }
        if (type == Material.REDSTONE && (name = GuiCompat.getDisplayName(clicked.getItemMeta())) != null && name.contains("Advanced Settings")) {
            this.plugin.getGuiManager().openSettingsMenu(player);
            return;
        }
        if (type == Material.CLOCK && (name = GuiCompat.getDisplayName(clicked.getItemMeta())) != null && name.contains("Game Status")) {
            player.sendMessage("\u00a76=== \u00a7b\u00a7lSapnap Mode Status \u00a76===");
            player.sendMessage("\u00a7eMode: \u00a7bMulti-Runner Cooperation");
            player.sendMessage("\u00a7eRunning: \u00a7f" + this.plugin.getGameManager().isGameRunning());
            player.sendMessage("\u00a7ePaused: \u00a7f" + this.plugin.getGameManager().isGamePaused());
            if (this.plugin.getGameManager().isGameRunning()) {
                Player active = this.plugin.getGameManager().getActiveRunner();
                player.sendMessage("\u00a7eActive Runner: \u00a7f" + (active != null ? active.getName() : "None"));
                player.sendMessage("\u00a7eNext Swap: \u00a7f" + this.plugin.getGameManager().getTimeUntilNextSwap() + "s");
                List<Player> runnersList = this.plugin.getGameManager().getRunners();
                String runners = runnersList != null ? runnersList.stream().map(Player::getName).collect(Collectors.joining(", ")) : "None";
                player.sendMessage("\u00a7eRunners: \u00a7f" + runners);
                player.sendMessage("\u00a7eQueue Position: \u00a7f" + this.getQueueInfo(player));
            }
            player.sendMessage("\u00a76===========================");
            return;
        }
        if ((type == Material.ARMOR_STAND || type == Material.ENDER_EYE || type == Material.ENDER_PEARL || type == Material.BEDROCK || type == Material.POTION) && (name = GuiCompat.getDisplayName(clicked.getItemMeta())) != null && name.contains("Inactive State:")) {
            String mode = this.plugin.getConfigManager().getFreezeMode();
            String next = switch (mode.toUpperCase()) {
                case "EFFECTS" -> "SPECTATOR";
                case "SPECTATOR" -> "LIMBO";
                case "LIMBO" -> "CAGE";
                default -> "EFFECTS";
            };
            this.plugin.getConfigManager().setFreezeMode(next);
            player.sendMessage("\u00a7eInactive runner state: \u00a7a" + next);
            this.plugin.getGameManager().reapplyStates();
            new ControlGui(this.plugin).openMainMenu(player);
            return;
        }
        if (type == Material.SLIME_BLOCK || type == Material.MAGMA_BLOCK) {
            boolean enabled = this.plugin.getConfigManager().isSafeSwapEnabled();
            this.plugin.getConfigManager().setSafeSwapEnabled(!enabled);
            player.sendMessage("\u00a7eSafe Swap: " + (!enabled ? "\u00a7aEnabled" : "\u00a7cDisabled"));
            new ControlGui(this.plugin).openMainMenu(player);
            return;
        }
        if (type == Material.WHITE_BED || type == Material.RED_BED) {
            boolean enabled = this.plugin.getConfigManager().isSinglePlayerSleepEnabled();
            this.plugin.getConfigManager().setSinglePlayerSleepEnabled(!enabled);
            player.sendMessage("\u00a7eSingle Player Sleep: " + (!enabled ? "\u00a7aEnabled" : "\u00a7cDisabled"));
            new ControlGui(this.plugin).openMainMenu(player);
            return;
        }
        if ((type == Material.LEVER || type == Material.REDSTONE_TORCH) && (name = GuiCompat.getDisplayName(clicked.getItemMeta())) != null && name.startsWith("Experimental Intervals:")) {
            boolean enabled = this.plugin.getConfigManager().isBetaIntervalEnabled();
            this.plugin.getConfigManager().setBetaIntervalEnabled(!enabled);
            player.sendMessage("\u00a7eExperimental Intervals: " + (!enabled ? "\u00a7aEnabled" : "\u00a7cDisabled"));
            new ControlGui(this.plugin).openMainMenu(player);
            return;
        }
        if ((type == Material.NOTE_BLOCK || type == Material.GRAY_DYE) && (name = GuiCompat.getDisplayName(clicked.getItemMeta())) != null && name.startsWith("Apply Mode Default on Switch:")) {
            current = this.plugin.getConfigManager().getApplyDefaultOnModeSwitch();
            this.plugin.getConfigManager().setApplyDefaultOnModeSwitch(current == 0);
            player.sendMessage("\u00a7eApply Default on Switch: " + (current == 0 ? "\u00a7aYes" : "\u00a7cNo"));
            new ControlGui(this.plugin).openMainMenu(player);
            return;
        }
        if (type == Material.BARRIER && "Reset Interval".equals(name = GuiCompat.getDisplayName(clicked.getItemMeta()))) {
            this.plugin.getConfigManager().applyModeDefaultInterval(this.plugin.getCurrentMode());
            this.plugin.getGameManager().refreshSwapSchedule();
            player.sendMessage("\u00a7eInterval reset to mode default.");
            new ControlGui(this.plugin).openMainMenu(player);
            return;
        }
        if (type == Material.ARROW) {
            name = GuiCompat.getDisplayName(clicked.getItemMeta());
            if (name != null) {
                if (name.equals("-5s")) {
                    current = this.plugin.getConfigManager().getSwapInterval();
                    boolean beta = this.plugin.getConfigManager().isBetaIntervalEnabled();
                    int minAllowed = beta ? 10 : this.plugin.getConfigManager().getMinSwapInterval();
                    int maxAllowed = this.plugin.getConfigManager().getSwapIntervalMax();
                    int interval = current - 5;
                    interval = beta ? Math.max(minAllowed, interval) : Math.max(minAllowed, Math.min(maxAllowed, interval));
                    this.plugin.getConfigManager().setSwapInterval(interval);
                    player.sendMessage("\u00a7eInterval decreased to: \u00a7a" + interval + "s");
                    if (interval < 30) {
                        player.sendMessage("\u00a7cBETA: Intervals below 30s are experimental and may be unstable.");
                        if (interval < 15) {
                            player.sendMessage("\u00a7cWarning: Intervals under 15s may impact performance.");
                        }
                    }
                    if (interval > maxAllowed) {
                        player.sendMessage("\u00a7cBETA: Intervals above configured maximum are experimental.");
                    }
                    this.plugin.getGameManager().refreshSwapSchedule();
                    new ControlGui(this.plugin).openMainMenu(player);
                    return;
                }
                if (name.equals("+5s")) {
                    current = this.plugin.getConfigManager().getSwapInterval();
                    boolean beta = this.plugin.getConfigManager().isBetaIntervalEnabled();
                    int minAllowed = beta ? 10 : this.plugin.getConfigManager().getMinSwapInterval();
                    int maxAllowed = this.plugin.getConfigManager().getSwapIntervalMax();
                    int interval = current + 5;
                    interval = beta ? Math.max(minAllowed, interval) : Math.max(minAllowed, Math.min(maxAllowed, interval));
                    this.plugin.getConfigManager().setSwapInterval(interval);
                    player.sendMessage("\u00a7eInterval increased to: \u00a7a" + interval + "s");
                    if (interval > maxAllowed) {
                        player.sendMessage("\u00a7cBETA: Intervals above configured maximum are experimental and may be unstable.");
                    }
                    this.plugin.getGameManager().refreshSwapSchedule();
                    new ControlGui(this.plugin).openMainMenu(player);
                    return;
                }
            }
            if ("\u00a77\u00a7lBack".equals(name)) {
                this.plugin.getGuiManager().openModeSelector(player);
                return;
            }
        }
        if (type == Material.COMPARATOR) {
            boolean randomize = this.plugin.getConfigManager().isSwapRandomized();
            this.plugin.getConfigManager().setSwapRandomized(!randomize);
            player.sendMessage("\u00a7eRandomize swaps: " + (!randomize ? "\u00a7aEnabled" : "\u00a7cDisabled"));
            new ControlGui(this.plugin).openMainMenu(player);
            return;
        }
        if (type == Material.PAPER) {
            name = GuiCompat.getDisplayName(clicked.getItemMeta());
            this.plugin.getLogger().info("Processing PAPER click with name: " + name);
            if ("Status".equals(name)) {
                player.sendMessage("\u00a76=== Runner-Only Status ===");
                player.sendMessage("\u00a7eGame Running: \u00a7f" + this.plugin.getGameManager().isGameRunning());
                player.sendMessage("\u00a7eGame Paused: \u00a7f" + this.plugin.getGameManager().isGamePaused());
                if (this.plugin.getGameManager().isGameRunning()) {
                    Player active = this.plugin.getGameManager().getActiveRunner();
                    player.sendMessage("\u00a7eActive Runner: \u00a7f" + (active != null ? active.getName() : "None"));
                    player.sendMessage("\u00a7eTime Until Next Swap: \u00a7f" + this.plugin.getGameManager().getTimeUntilNextSwap() + "s");
                    List<Player> runnersList = this.plugin.getGameManager().getRunners();
                    String runners = runnersList != null ? runnersList.stream().map(Player::getName).collect(Collectors.joining(", ")) : "None";
                    player.sendMessage("\u00a7eRunners: \u00a7f" + runners);
                }
                return;
            }
        }
        this.plugin.getLogger().warning("Unhandled GUI click - Material: " + String.valueOf(type) + ", Display Name: " + itemName);
        player.sendMessage("\u00a7eClick detected but not handled. Material: " + String.valueOf(type) + ". Check console for details.");
    }

    private void handleRunnerSelectorClick(Player player, ItemStack clicked, int rawSlot, int size) {
        Material type = clicked.getType();
        if (rawSlot >= size - 9) {
            if (type == Material.BARRIER) {
                pendingRunnerSelections.remove(player.getUniqueId());
                new ControlGui(this.plugin).openMainMenu(player);
                return;
            }
            if (type == Material.ARROW) {
                new ControlGui(this.plugin).openMainMenu(player);
                return;
            }
            if (type == Material.EMERALD_BLOCK) {
                Set<String> sel = pendingRunnerSelections.remove(player.getUniqueId());
                if (sel == null) {
                    sel = new HashSet<String>();
                }
                this.plugin.getConfigManager().setRunnerNames(new ArrayList<String>(sel));
                ArrayList<Player> players = new ArrayList<Player>();
                for (String name : sel) {
                    Player p = Bukkit.getPlayerExact((String)name);
                    if (p == null || !p.isOnline()) continue;
                    players.add(p);
                }
                this.plugin.getGameManager().setRunners(players);
                player.sendMessage("\u00a7aRunners set: \u00a7f" + String.join((CharSequence)", ", sel));
                new ControlGui(this.plugin).openMainMenu(player);
                return;
            }
        }
        if (type == Material.PLAYER_HEAD) {
            String name = GuiCompat.getDisplayName(clicked.getItemMeta());
            if (name == null || name.isBlank()) {
                return;
            }
            Set sel = pendingRunnerSelections.computeIfAbsent(player.getUniqueId(), k -> new HashSet<String>(this.plugin.getConfigManager().getRunnerNames()));
            if (sel.contains(name)) {
                sel.remove(name);
            } else {
                sel.add(name);
            }
            new ControlGui(this.plugin).openRunnerSelector(player);
        }
    }

    private String getQueueInfo(Player player) {
        List<Player> runners = this.plugin.getGameManager().getRunners();
        Player active = this.plugin.getGameManager().getActiveRunner();
        if (runners == null || runners.isEmpty()) {
            return "No runners configured";
        }
        if (!runners.contains(player)) {
            return "Not in queue";
        }
        if (player == active) {
            return "Currently Active";
        }
        int position = runners.indexOf(player);
        int activeIndex = runners.indexOf(active);
        if (activeIndex == -1) {
            return "Position " + (position + 1) + " of " + runners.size();
        }
        int swapsUntilTurn = position > activeIndex ? position - activeIndex : runners.size() - activeIndex + position;
        return "Next in " + swapsUntilTurn + " swap(s)";
    }

    private void handleCoordinationClick(Player player, ItemStack clicked) {
        String name;
        Material type = clicked.getType();
        if (type == Material.ARROW) {
            new ControlGui(this.plugin).openMainMenu(player);
            return;
        }
        if (type == Material.BELL && (name = GuiCompat.getDisplayName(clicked.getItemMeta())) != null && name.contains("Broadcast Location")) {
            try {
                String location = String.format("%d, %d, %d in %s", (int)player.getLocation().getX(), (int)player.getLocation().getY(), (int)player.getLocation().getZ(), player.getWorld().getName());
                String message = "\u00a76[\u00a7eTeam\u00a76] \u00a7b" + player.getName() + "\u00a77 is at: \u00a7f" + location;
                List<Player> runners = this.plugin.getGameManager().getRunners();
                int broadcastCount = 0;
                if (runners != null) {
                    for (Player runner : runners) {
                        if (runner == null || !runner.isOnline()) continue;
                        runner.sendMessage(message);
                        ++broadcastCount;
                    }
                }
                player.sendMessage("\u00a7aLocation broadcasted to " + broadcastCount + " team members!");
            }
            catch (Exception e) {
                player.sendMessage("\u00a7cError broadcasting location. Please try again.");
            }
            return;
        }
        if (type == Material.CHEST && (name = GuiCompat.getDisplayName(clicked.getItemMeta())) != null && name.contains("Inventory Status")) {
            ArrayList<CallSite> importantItems = new ArrayList<CallSite>();
            for (ItemStack item : player.getInventory().getContents()) {
                if (item == null || item.getType() == Material.AIR) continue;
                Material mat = item.getType();
                int amount = item.getAmount();
                if (!mat.name().contains("SWORD") && !mat.name().contains("AXE") && !mat.name().contains("PICKAXE") && !mat.name().contains("SHOVEL") && mat != Material.BOW && mat != Material.CROSSBOW && mat != Material.BREAD && mat != Material.COOKED_BEEF && mat != Material.ENDER_PEARL && mat != Material.BLAZE_ROD && mat != Material.DIAMOND && mat != Material.EMERALD && mat != Material.IRON_INGOT && mat != Material.GOLD_INGOT) continue;
                String itemName = mat.name().toLowerCase().replace("_", " ");
                importantItems.add((CallSite)((Object)(amount + "x " + itemName)));
            }
            String statusMsg = importantItems.isEmpty() ? "\u00a76[\u00a7eTeam\u00a76] \u00a7b" + player.getName() + "\u00a77 has no important items" : "\u00a76[\u00a7eTeam\u00a76] \u00a7b" + player.getName() + "\u00a77 has: \u00a7f" + String.join((CharSequence)", ", importantItems);
            List<Player> runners = this.plugin.getGameManager().getRunners();
            if (runners != null) {
                for (Player runner : runners) {
                    if (runner == null || !runner.isOnline()) continue;
                    runner.sendMessage(statusMsg);
                }
            }
            player.sendMessage("\u00a7aInventory status shared with team!");
            return;
        }
        if (type == Material.REDSTONE_TORCH && (name = GuiCompat.getDisplayName(clicked.getItemMeta())) != null && name.contains("Emergency Pause")) {
            if (this.plugin.getGameManager().isGameRunning() && !this.plugin.getGameManager().isGamePaused()) {
                this.plugin.getGameManager().pauseGame();
                String pauseMsg = "\u00a7c[\u00a7lEMERGENCY\u00a7c] \u00a76" + player.getName() + "\u00a7e requested emergency pause!";
                List<Player> runners = this.plugin.getGameManager().getRunners();
                if (runners != null) {
                    for (Player runner : runners) {
                        if (runner == null || !runner.isOnline()) continue;
                        runner.sendMessage(pauseMsg);
                        BukkitCompat.showTitle(runner, "\u00a7c\u00a7lEMERGENCY PAUSE", "\u00a76Requested by " + player.getName(), 10, 40, 10);
                    }
                }
                player.sendMessage("\u00a7aGame paused! Emergency pause activated.");
            } else {
                player.sendMessage("\u00a7cGame is not running or already paused!");
            }
            return;
        }
        if (type == Material.ENDER_EYE && (name = GuiCompat.getDisplayName(clicked.getItemMeta())) != null && name.contains("Mark Waypoint")) {
            String location = String.format("%d, %d, %d", (int)player.getLocation().getX(), (int)player.getLocation().getY(), (int)player.getLocation().getZ());
            String waypointMsg = "\u00a7d[\u00a7lWAYPOINT\u00a7d] \u00a7b" + player.getName() + "\u00a77 marked: \u00a7f" + location + "\u00a77 - Check your compass!";
            List<Player> runners = this.plugin.getGameManager().getRunners();
            if (runners != null) {
                for (Player runner : runners) {
                    if (runner == null || !runner.isOnline()) continue;
                    runner.sendMessage(waypointMsg);
                }
            }
            player.sendMessage("\u00a7aWaypoint marked and shared with team!");
            return;
        }
    }

    private void handleQuickActions(Player player) {
        if (!this.plugin.getGameManager().isGameRunning()) {
            player.sendMessage("\u00a7cQuick actions only available during active games!");
            return;
        }
        try {
            String location = String.format("%d, %d, %d in %s", (int)player.getLocation().getX(), (int)player.getLocation().getY(), (int)player.getLocation().getZ(), player.getWorld().getName());
            double health = (double)Math.round(player.getHealth() * 10.0) / 10.0;
            int food = player.getFoodLevel();
            String gamemode = player.getGameMode().name().toLowerCase();
            String quickMsg = "\u00a7e[\u00a7lQUICK\u00a7e] \u00a7b" + player.getName() + "\u00a77: \u00a7f" + location + "\u00a77 | Health: \u00a7c" + health + "/20 \u00a77| Food: \u00a76" + food + "/20 \u00a77| Mode: \u00a7d" + gamemode;
            List<Player> runners = this.plugin.getGameManager().getRunners();
            if (runners != null && !runners.isEmpty()) {
                for (Player runner : runners) {
                    if (runner == null || !runner.isOnline()) continue;
                    runner.sendMessage(quickMsg);
                }
            }
            player.sendMessage("\u00a7a\u26a1 Quick status broadcasted to " + (runners != null ? runners.size() : 0) + " runners!");
            Player activeRunner = this.plugin.getGameManager().getActiveRunner();
            if (activeRunner != null && !activeRunner.equals((Object)player) && activeRunner.isOnline()) {
                BukkitCompat.showTitle(activeRunner, "\u00a7e\u00a7lTEAM UPDATE", "\u00a7b" + player.getName() + "\u00a77 shared location", 5, 30, 5);
            }
        }
        catch (Exception e) {
            player.sendMessage("\u00a7cError sending quick update. Please try again.");
        }
    }

    private void showDetailedAnalytics(Player player) {
        if (!this.plugin.getGameManager().isGameRunning()) {
            player.sendMessage("\u00a7cAnalytics only available during active games!");
            return;
        }
        player.sendMessage("\u00a76========== \u00a7b\u00a7lDETAILED ANALYTICS \u00a76==========");
        Player activeRunner = this.plugin.getGameManager().getActiveRunner();
        List<Player> runners = this.plugin.getGameManager().getRunners();
        int timeLeft = this.plugin.getGameManager().getTimeUntilNextSwap();
        player.sendMessage("\u00a7e\u00a7lGame Status:");
        player.sendMessage("\u00a77  Active Runner: \u00a7b" + (activeRunner != null ? activeRunner.getName() : "None"));
        player.sendMessage("\u00a77  Total Runners: \u00a7e" + (runners != null ? runners.size() : 0));
        player.sendMessage("\u00a77  Next Swap: \u00a7e" + timeLeft + "s");
        player.sendMessage("\u00a77  Game Paused: \u00a7f" + this.plugin.getGameManager().isGamePaused());
        if (timeLeft <= 15) {
            player.sendMessage("\u00a7c\u00a7lSwap Imminent - Immediate Actions:");
            player.sendMessage("\u00a77  \u26a1 Finish current objective quickly!");
            player.sendMessage("\u00a77  \u26a1 Move to safe location if possible");
            player.sendMessage("\u00a77  \u26a1 Communicate handoff plans");
            player.sendMessage("\u00a77  \u26a1 Prepare next runner via voice chat");
            player.sendMessage("\u00a77  \u26a1 Use emergency pause if in danger");
        } else {
            player.sendMessage("\u00a7a\u00a7lGame Active - Cooperation Tips:");
            player.sendMessage("\u00a77  \u2713 Use Quick Actions for instant communication");
            player.sendMessage("\u00a77  \u2713 Monitor Live Analytics for performance");
            player.sendMessage("\u00a77  \u2713 Share locations and inventory status");
            player.sendMessage("\u00a77  \u2713 Mark waypoints for important locations");
            player.sendMessage("\u00a77  \u2713 Active runner should narrate actions");
            player.sendMessage("\u00a77  \u2713 Waiting runners should plan ahead");
        }
    }

    private void showSmartHelp(Player player) {
        boolean running = this.plugin.getGameManager().isGameRunning();
        boolean paused = this.plugin.getGameManager().isGamePaused();
        int timeLeft = this.plugin.getGameManager().getTimeUntilNextSwap();
        player.sendMessage("\u00a76========== \u00a7e\u00a7lSMART HELP \u00a76==========");
        if (!running) {
            player.sendMessage("\u00a7aGetting Started:");
            player.sendMessage("\u00a77  \u2713 Select runners via Manage Runners");
            player.sendMessage("\u00a77  \u2713 Adjust interval with \u00b15s arrows");
            player.sendMessage("\u00a77  \u2713 Configure freeze mode and safe swaps");
            player.sendMessage("\u00a77  \u2713 Click \u00a7aStart Game\u00a77 when ready");
        } else if (paused) {
            player.sendMessage("\u00a7eGame Paused:");
            player.sendMessage("\u00a77  \u2713 Discuss next objectives");
            player.sendMessage("\u00a77  \u2713 Use coordination hub to share info");
            player.sendMessage("\u00a77  \u2713 Click \u00a7aResume\u00a77 when ready");
        } else if (timeLeft <= 15) {
            player.sendMessage("\u00a7cSwap Imminent:");
            player.sendMessage("\u00a77  \u26a1 Prepare handoff and move to safety");
        } else {
            player.sendMessage("\u00a7aActive Play Tips:");
            player.sendMessage("\u00a77  \u2713 Use Quick Actions for instant updates");
            player.sendMessage("\u00a77  \u2713 Monitor Live Analytics and Performance Alerts");
            player.sendMessage("\u00a77  \u2713 Use coordination tools for teamwork");
        }
        player.sendMessage("\u00a76================================");
    }

    private void showOptimizationTips(Player player) {
        player.sendMessage("\u00a76========== \u00a7c\u00a7lOPTIMIZATION TIPS \u00a76==========");
        try {
            Double tps = BukkitCompat.getServerTPS();
            Runtime runtime = Runtime.getRuntime();
            long maxMemory = runtime.maxMemory() / 1024L / 1024L;
            long usedMemory = (runtime.totalMemory() - runtime.freeMemory()) / 1024L / 1024L;
            int memoryPercent = (int)(usedMemory * 100L / maxMemory);
            player.sendMessage("\u00a77Current Performance:");
            player.sendMessage("\u00a77  TPS: \u00a7f" + (tps != null ? String.format("%.2f", tps) : "N/A"));
            player.sendMessage("\u00a77  Memory: \u00a7f" + usedMemory + "/" + maxMemory + "MB (" + memoryPercent + "%)");
            if (tps != null && tps < 18.0) {
                player.sendMessage("\u00a7eServer TPS low:");
                player.sendMessage("\u00a77  \u26a0 \u00a7cReduce team size (remove 1-2 runners)");
                player.sendMessage("\u00a77  \u26a0 \u00a7cIncrease swap interval (60s+ recommended)");
                player.sendMessage("\u00a77  \u26a0 \u00a7cConsider pausing temporarily");
            }
            if (memoryPercent > 85) {
                player.sendMessage("\u00a7eHigh memory usage:");
                player.sendMessage("\u00a77  \u26a0 \u00a7cReduce render distance (8-12 chunks)");
                player.sendMessage("\u00a77  \u26a0 \u00a7cClose unnecessary applications");
                player.sendMessage("\u00a77  \u26a0 \u00a7cRestart server if possible");
            }
        }
        catch (Exception e) {
            player.sendMessage("\u00a77  Performance metrics unavailable");
        }
        player.sendMessage("");
        player.sendMessage("\u00a7eGeneral Recommendations:");
        player.sendMessage("\u00a77  1. Keep team size between 2-4 players");
        player.sendMessage("\u00a77  2. Use 45-60s swap intervals for stability");
        player.sendMessage("\u00a77  3. Enable Safe Swaps to prevent lag spikes");
        player.sendMessage("\u00a77  4. Prefer SPECTATOR freeze mode for performance");
        player.sendMessage("\u00a77  5. Restart sessions if problems persist");
        player.sendMessage("\u00a76" + "=".repeat(44));
    }
}

