/*
 * Decompiled with CFR 0.152.
 */
package com.example.speedrunnerswap.gui;

import com.example.speedrunnerswap.SpeedrunnerSwap;
import com.example.speedrunnerswap.gui.ControlGui;
import com.example.speedrunnerswap.gui.ControlGuiHolder;
import com.example.speedrunnerswap.gui.GuiManager;
import com.example.speedrunnerswap.gui.PluginGuiHolder;
import com.example.speedrunnerswap.models.PlayerState;
import com.example.speedrunnerswap.models.Team;
import com.example.speedrunnerswap.task.TaskDefinition;
import com.example.speedrunnerswap.task.TaskManagerMode;
import com.example.speedrunnerswap.utils.GuiCompat;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class GuiListener
implements Listener {
    private final SpeedrunnerSwap plugin;
    private final GuiManager guiManager;

    public GuiListener(SpeedrunnerSwap plugin, GuiManager guiManager) {
        this.plugin = plugin;
        this.guiManager = guiManager;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onInventoryClick(InventoryClickEvent event) {
        boolean holderMarked;
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        Inventory top = event.getView().getTopInventory();
        if (top != null && top.getHolder() instanceof ControlGuiHolder) {
            return;
        }
        String title = this.getPlainTitle(event.getView());
        boolean bl = holderMarked = top != null && top.getHolder() instanceof PluginGuiHolder;
        if (holderMarked || this.isPluginGui(title)) {
            event.setCancelled(true);
            int topSize = event.getView().getTopInventory().getSize();
            if (event.getRawSlot() >= topSize) {
                return;
            }
            ItemStack clickedItem = event.getCurrentItem();
            if (!player.hasPermission("speedrunnerswap.admin") && this.isAdminMenu(title)) {
                player.sendMessage("\u00a7cYou do not have permission to use this menu.");
                return;
            }
            if (clickedItem == null || clickedItem.getType() == Material.AIR) {
                return;
            }
            String backId = this.getButtonId(clickedItem);
            if ("back_settings".equals(backId)) {
                this.guiManager.openSettingsMenu(player);
                return;
            }
            if ("back_mode".equals(backId)) {
                this.guiManager.openModeSelector(player);
                return;
            }
            if ("back_kits".equals(backId)) {
                this.guiManager.openKitsMenu(player);
                return;
            }
            if (this.isBackButton(clickedItem)) {
                this.routeBack(title, player);
                return;
            }
            this.handleGuiClick(event, title);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onInventoryDrag(InventoryDragEvent event) {
        boolean holderMarked;
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Inventory top = event.getView().getTopInventory();
        if (top != null && top.getHolder() instanceof ControlGuiHolder) {
            return;
        }
        String title = this.getPlainTitle(event.getView());
        boolean bl = holderMarked = top != null && top.getHolder() instanceof PluginGuiHolder;
        if (holderMarked || this.isPluginGui(title)) {
            event.setCancelled(true);
        }
    }

    private String getPlainTitle(InventoryView view) {
        block11: {
            if (view == null) {
                return "";
            }
            try {
                Method m = view.getClass().getMethod("title", new Class[0]);
                Object comp = m.invoke((Object)view, new Object[0]);
                if (comp == null) break block11;
                try {
                    Class<?> serCls = Class.forName("net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer");
                    Method plainText = serCls.getMethod("plainText", new Class[0]);
                    Object serializer = plainText.invoke(null, new Object[0]);
                    Class<?> componentCls = Class.forName("net.kyori.adventure.text.Component");
                    Method serialize = serializer.getClass().getMethod("serialize", componentCls);
                    Object s = serialize.invoke(serializer, comp);
                    if (s != null) {
                        return String.valueOf(s);
                    }
                }
                catch (Throwable ignored) {
                    try {
                        Method content = comp.getClass().getMethod("content", new Class[0]);
                        Object s = content.invoke(comp, new Object[0]);
                        if (s != null) {
                            return String.valueOf(s);
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    return String.valueOf(comp);
                }
            }
            catch (Throwable m) {
                // empty catch block
            }
        }
        try {
            Method m2 = view.getClass().getMethod("getTitle", new Class[0]);
            Object s2 = m2.invoke((Object)view, new Object[0]);
            return s2 != null ? String.valueOf(s2) : "";
        }
        catch (Throwable throwable) {
            return "";
        }
    }

    private void routeBack(String title, Player player) {
        try {
            if (title.contains("Task Manager: Secret Missions") || title.contains("Task Settings") || title.contains("Custom Tasks")) {
                this.guiManager.openTaskManagerMenu(player);
                return;
            }
            if (title.contains("Dream Settings") || title.contains("Compass Settings") || title.contains("World Border") || title.contains("Bounty System") || title.contains("Last Stand")) {
                this.guiManager.openDreamMenu(player);
                return;
            }
            if (title.contains("Power-up Durations") || title.contains("Positive Effects") || title.contains("Negative Effects")) {
                this.guiManager.openPowerUpsMenu(player);
                return;
            }
            if (title.contains("Power-ups")) {
                this.guiManager.openDreamMenu(player);
                return;
            }
            if (title.contains("Advanced Config") || title.contains("List Editor") || title.contains("Statistics")) {
                this.guiManager.openSettingsMenu(player);
                return;
            }
            if (title.contains("Broadcast Settings") || title.contains("Limbo Configuration") || title.contains("UI Performance") || title.contains("Kit Management") || title.contains("Kit Editor")) {
                this.guiManager.openSettingsMenu(player);
                return;
            }
            if (title.contains("Team Selector")) {
                this.guiManager.openMainMenu(player);
                return;
            }
            if (title.contains("Confirm Mode Switch") || title.contains("Mode Selection") || title.contains("Choose Gamemode")) {
                this.guiManager.openModeSelector(player);
                return;
            }
            if (title.contains("Confirm Reset All Settings")) {
                this.guiManager.openSettingsMenu(player);
                return;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.guiManager.openMainMenu(player);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onInventoryMoveItem(InventoryMoveItemEvent event) {
        Inventory src = event.getSource();
        Inventory dst = event.getDestination();
        if (src != null && src.getHolder() instanceof PluginGuiHolder) {
            event.setCancelled(true);
            return;
        }
        if (dst != null && dst.getHolder() instanceof PluginGuiHolder) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onInventoryClose(InventoryCloseEvent event) {
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getPlayer();
        Inventory top = event.getView().getTopInventory();
        if (top != null && top.getHolder() instanceof PluginGuiHolder && !(top.getHolder() instanceof ControlGuiHolder)) {
            this.plugin.getLogger().fine("Player " + player.getName() + " closed plugin GUI, state cleaned");
        }
    }

    private boolean isPluginGui(String title) {
        if (title == null || title.isEmpty()) {
            return false;
        }
        return title.contains("SpeedrunnerSwap") || title.contains("Speedrunner Swap") || title.contains("Mode Selector") || title.contains("Choose Gamemode") || title.contains("Mode Selection") || title.contains("Confirm Mode Switch") || title.contains("Main Menu") || title.contains("Team Selector") || title.contains("Settings") || title.contains("Kits") || title.contains("Edit ") && title.contains(" Kit") || title.contains("Kit Editor") || title.contains("Effects") || title.contains("Power-ups") || title.contains("Power-up Durations") || title.contains("World Border") || title.contains("Bounty") || title.contains("Last Stand") || title.contains("Compass") || title.contains("Sudden Death") || title.contains("Statistics") || title.contains("Statistics & Tracking") || title.contains("Dangerous Blocks") || title.contains("Custom Tasks") || title.contains("Task Manager") || title.contains("Task Settings") || title.contains("Dream Settings") || title.contains("Advanced Config") || title.contains("List Editor") || title.contains("Dream") || title.contains("Sapnap");
    }

    private boolean isAdminMenu(String title) {
        if (title == null || title.isEmpty()) {
            return false;
        }
        return title.contains("Settings") || title.contains("Kits") || title.contains("Edit ") && title.contains(" Kit") || title.contains("Effects") || title.contains("Power-ups") || title.contains("Power-up Durations") || title.contains("World Border") || title.contains("Bounty") || title.contains("Last Stand") || title.contains("Compass") || title.contains("Sudden Death");
    }

    private void handleGuiClick(InventoryClickEvent event, String title) {
        Player player = (Player)event.getWhoClicked();
        ItemStack clickedItem = event.getCurrentItem();
        String earlyId = this.getButtonId(clickedItem);
        if (earlyId != null) {
            switch (earlyId) {
                case "back_mode": {
                    this.guiManager.openModeSelector(player);
                    return;
                }
                case "statistics": {
                    this.guiManager.openStatisticsMenu(player);
                    return;
                }
                case "world_border": {
                    this.guiManager.openWorldBorderMenu(player);
                    return;
                }
                case "power_ups": {
                    this.guiManager.openPowerUpsMenu(player);
                    return;
                }
                case "team_selector": {
                    this.guiManager.openTeamSelector(player);
                    return;
                }
                case "task_settings": {
                    this.guiManager.openTaskSettingsMenu(player);
                    return;
                }
                case "dream_settings": {
                    this.guiManager.openDreamSettingsMenu(player);
                    return;
                }
                case "advanced_config_root": {
                    this.guiManager.openAdvancedConfigMenu(player, "", 0);
                    return;
                }
                case "direct_dream_menu": {
                    this.plugin.setCurrentMode(SpeedrunnerSwap.SwapMode.DREAM);
                    this.guiManager.openMainMenu(player);
                    return;
                }
                case "direct_sapnap_menu": {
                    this.plugin.setCurrentMode(SpeedrunnerSwap.SwapMode.SAPNAP);
                    try {
                        new ControlGui(this.plugin).openMainMenu(player);
                    }
                    catch (Throwable t) {
                        player.sendMessage("\u00a7cSapnap GUI failed to open: " + t.getMessage());
                        this.plugin.getLogger().warning("Sapnap GUI error: " + t.getMessage());
                    }
                    return;
                }
                case "direct_task_menu": {
                    this.plugin.setCurrentMode(SpeedrunnerSwap.SwapMode.TASK);
                    this.guiManager.openMainMenu(player);
                    return;
                }
                case "broadcast_settings": {
                    this.guiManager.openBroadcastSettingsMenu(player);
                    return;
                }
                case "limbo_settings": {
                    this.guiManager.openLimboSettingsMenu(player);
                    return;
                }
                case "ui_performance": {
                    this.guiManager.openUIPerformanceMenu(player);
                    return;
                }
                case "custom_tasks_menu": {
                    this.guiManager.openCustomTasksMenu(player);
                    return;
                }
                case "dangerous_blocks": {
                    this.guiManager.openDangerousBlocksMenu(player);
                    return;
                }
                case "cage_settings": {
                    this.guiManager.openSettingsMenu(player);
                    return;
                }
            }
        }
        if (this.maybeHandlePowerUpDurationsMenu(event, title)) {
            return;
        }
        if (this.maybeHandleDangerousBlocksMenu(event, title)) {
            return;
        }
        if (title.contains("Mode Selector")) {
            this.handleModeSelectorClick(event);
            return;
        }
        if (title.contains("Choose Gamemode")) {
            this.handleDirectGamemodeSelectorClick(event);
            return;
        }
        if (title.contains("Main Menu") || title.contains("SpeedrunnerSwap")) {
            if (this.plugin.getCurrentMode() == SpeedrunnerSwap.SwapMode.SAPNAP && this.plugin.getGameManager().isGameRunning()) {
                ((Player)event.getWhoClicked()).sendMessage("\u00a7cYou're in Sapnap mode. Stop the game to switch.");
                event.setCancelled(true);
                return;
            }
            this.handleMainMenuClick(event);
        } else if (title.contains("Team Selector")) {
            this.handleTeamSelectorClick(event);
        } else if (title.contains("World Border")) {
            this.handleWorldBorderClick(event);
        } else if (title.contains("Compass")) {
            this.handleCompassSettingsClick(event);
        } else if (title.contains("Sudden Death")) {
            this.handleSuddenDeathClick(event);
        } else if (title.contains("Broadcast Settings")) {
            this.handleBroadcastSettingsClick(event);
        } else if (title.contains("Limbo Configuration")) {
            this.handleLimboSettingsClick(event);
        } else if (title.contains("UI Performance")) {
            this.handleUIPerformanceClick(event);
        } else if (title.contains("Settings")) {
            this.handleSettingsClick(event);
        } else if (title.contains("Edit ") && title.contains(" Kit")) {
            this.handleKitEditorClick(event, title);
        } else if (title.contains("Kits")) {
            this.handleKitsMenuClick(event);
        } else if (title.contains("Power-ups")) {
            this.handlePowerUpsMenuClick(event);
        } else if (title.contains("Effects")) {
            this.handleEffectsMenuClick(event, title);
        } else if (title.contains("Bounty")) {
            this.handleBountyMenuClick(event);
        } else if (title.contains("Last Stand")) {
            this.handleLastStandClick(event);
        } else if (title.contains("Statistics")) {
            this.handleStatisticsClick(event);
        } else if (title.contains("Custom Tasks")) {
            this.handleCustomTasksClick(event);
        } else if (title.contains("Task Settings")) {
            this.handleTaskSettingsClick(event);
        } else if (title.contains("Dream Settings")) {
            this.handleDreamSettingsClick(event);
        } else if (title.contains("Advanced Config")) {
            this.handleAdvancedConfigClick(event);
        } else if (title.contains("List Editor")) {
            this.handleConfigListClick(event);
        }
    }

    private void handleDirectGamemodeSelectorClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null || !clicked.hasItemMeta()) {
            return;
        }
        String id = this.getButtonId(clicked);
        if ("direct_dream_menu".equals(id)) {
            this.plugin.setCurrentMode(SpeedrunnerSwap.SwapMode.DREAM);
            this.guiManager.openMainMenu(player);
        } else if ("direct_sapnap_menu".equals(id)) {
            this.plugin.setCurrentMode(SpeedrunnerSwap.SwapMode.SAPNAP);
            try {
                new ControlGui(this.plugin).openMainMenu(player);
            }
            catch (Throwable t) {
                player.sendMessage("\u00a7cSapnap GUI failed to open: " + t.getMessage());
                this.plugin.getLogger().warning("Sapnap GUI error: " + t.getMessage());
            }
        } else if ("direct_task_menu".equals(id)) {
            this.plugin.setCurrentMode(SpeedrunnerSwap.SwapMode.TASK);
            this.guiManager.openMainMenu(player);
        }
    }

    private void handleModeSelectorClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null || !clicked.hasItemMeta()) {
            return;
        }
        String id = this.getButtonId(clicked);
        if ("mode_dream".equals(id)) {
            if (this.plugin.getGameManager().isGameRunning()) {
                if (!player.hasPermission("speedrunnerswap.admin")) {
                    player.sendMessage("\u00a7cStop the current game before switching modes.");
                    return;
                }
                this.guiManager.openForceConfirm(player, SpeedrunnerSwap.SwapMode.DREAM);
                return;
            }
            this.plugin.setCurrentMode(SpeedrunnerSwap.SwapMode.DREAM);
            this.guiManager.openMainMenu(player);
            return;
        }
        if ("mode_task".equals(id)) {
            if (this.plugin.getGameManager().isGameRunning()) {
                if (!player.hasPermission("speedrunnerswap.admin")) {
                    player.sendMessage("\u00a7cStop the current game before switching modes.");
                    return;
                }
                this.guiManager.openForceConfirm(player, SpeedrunnerSwap.SwapMode.TASK);
                return;
            }
            this.plugin.setCurrentMode(SpeedrunnerSwap.SwapMode.TASK);
            this.guiManager.openMainMenu(player);
            return;
        }
        if ("mode_sapnap".equals(id)) {
            if (this.plugin.getGameManager().isGameRunning()) {
                if (!player.hasPermission("speedrunnerswap.admin")) {
                    player.sendMessage("\u00a7cStop the current game before switching modes.");
                    return;
                }
                this.guiManager.openForceConfirm(player, SpeedrunnerSwap.SwapMode.SAPNAP);
                return;
            }
            this.plugin.setCurrentMode(SpeedrunnerSwap.SwapMode.SAPNAP);
            try {
                new ControlGui(this.plugin).openMainMenu(player);
            }
            catch (Throwable t) {
                player.sendMessage("\u00a7cSapnap GUI failed to open: " + t.getMessage());
            }
            return;
        }
        if ("admin_force_stop".equals(id)) {
            if (!player.hasPermission("speedrunnerswap.admin")) {
                player.sendMessage("\u00a7cYou don't have permission for admin actions.");
                return;
            }
            if (this.plugin.getGameManager().isGameRunning()) {
                this.plugin.getGameManager().stopGame();
                player.sendMessage("\u00a7aGame force-stopped. You can now switch modes.");
            }
            this.guiManager.openModeSelector(player);
            return;
        }
        if ("force_yes_dream".equals(id)) {
            if (!player.hasPermission("speedrunnerswap.admin")) {
                return;
            }
            if (this.plugin.getGameManager().isGameRunning()) {
                this.plugin.getGameManager().stopGame();
            }
            this.plugin.setCurrentMode(SpeedrunnerSwap.SwapMode.DREAM);
            this.guiManager.openMainMenu(player);
            return;
        }
        if ("force_yes_sapnap".equals(id)) {
            if (!player.hasPermission("speedrunnerswap.admin")) {
                return;
            }
            if (this.plugin.getGameManager().isGameRunning()) {
                this.plugin.getGameManager().stopGame();
            }
            this.plugin.setCurrentMode(SpeedrunnerSwap.SwapMode.SAPNAP);
            try {
                new ControlGui(this.plugin).openMainMenu(player);
            }
            catch (Throwable ignored) {
                player.sendMessage("\u00a7cSapnap GUI failed to open.");
            }
            return;
        }
        if ("force_yes_task".equals(id)) {
            if (!player.hasPermission("speedrunnerswap.admin")) {
                return;
            }
            if (this.plugin.getGameManager().isGameRunning()) {
                this.plugin.getGameManager().stopGame();
            }
            this.plugin.setCurrentMode(SpeedrunnerSwap.SwapMode.TASK);
            this.guiManager.openMainMenu(player);
            return;
        }
        if ("force_no".equals(id)) {
            this.guiManager.openModeSelector(player);
            return;
        }
    }

    private void handleMainMenuClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null || !clicked.hasItemMeta()) {
            return;
        }
        String buttonId = this.getButtonId(clicked);
        if (buttonId != null) {
            switch (buttonId) {
                case "start_game": {
                    if (!this.plugin.getGameManager().isGameRunning()) {
                        if (this.plugin.getGameManager().startGame()) {
                            player.sendMessage("\u00a7aGame started successfully!");
                        } else {
                            player.sendMessage("\u00a7cFailed to start game. Check team assignments.");
                        }
                    }
                    this.guiManager.openMainMenu(player);
                    break;
                }
                case "stop_game": {
                    if (this.plugin.getGameManager().isGameRunning()) {
                        this.plugin.getGameManager().stopGame();
                        player.sendMessage("\u00a7cGame stopped.");
                    }
                    this.guiManager.openMainMenu(player);
                    break;
                }
                case "pause_game": {
                    if (this.plugin.getGameManager().isGameRunning() && !this.plugin.getGameManager().isGamePaused()) {
                        this.plugin.getGameManager().pauseGame();
                        player.sendMessage("\u00a7eGame paused.");
                    }
                    this.guiManager.openMainMenu(player);
                    break;
                }
                case "resume_game": {
                    if (this.plugin.getGameManager().isGameRunning() && this.plugin.getGameManager().isGamePaused()) {
                        this.plugin.getGameManager().resumeGame();
                        player.sendMessage("\u00a7aGame resumed.");
                    }
                    this.guiManager.openMainMenu(player);
                    break;
                }
                case "team_selector": {
                    this.guiManager.openTeamSelector(player);
                    break;
                }
                case "advanced_settings": {
                    this.guiManager.openSettingsMenu(player);
                    break;
                }
                case "power_ups": {
                    this.guiManager.openPowerUpsMenu(player);
                    break;
                }
                case "world_border": {
                    this.guiManager.openWorldBorderMenu(player);
                    break;
                }
                case "kits": {
                    this.guiManager.openKitsMenu(player);
                    break;
                }
                case "bounty": {
                    this.guiManager.openBountyMenu(player);
                    break;
                }
                case "last_stand": {
                    this.guiManager.openLastStandMenu(player);
                    break;
                }
                case "dream_tracking": {
                    this.guiManager.openCompassSettingsMenu(player);
                    break;
                }
                case "sudden_death": {
                    this.guiManager.openSuddenDeathMenu(player);
                    break;
                }
                case "statistics": {
                    this.guiManager.openStatisticsMenu(player);
                    break;
                }
                case "task_settings": {
                    this.guiManager.openTaskSettingsMenu(player);
                    break;
                }
                case "custom_tasks_menu": {
                    this.guiManager.openCustomTasksMenu(player);
                    break;
                }
                case "task_assignments": {
                    TaskManagerMode tmm = this.plugin.getTaskManagerMode();
                    if (tmm != null && !tmm.getAssignments().isEmpty()) {
                        player.sendMessage("\u00a76=== Current Task Assignments ===");
                        for (Map.Entry<UUID, String> entry : tmm.getAssignments().entrySet()) {
                            String name = this.plugin.getServer().getOfflinePlayer(entry.getKey()).getName();
                            TaskDefinition task = tmm.getTask(entry.getValue());
                            player.sendMessage("\u00a7b" + name + ": \u00a77" + (task != null ? task.description() : entry.getValue()));
                        }
                        player.sendMessage("\u00a76===========================");
                        break;
                    }
                    player.sendMessage("\u00a7eNo task assignments yet. Start a game to assign tasks.");
                    break;
                }
                case "reroll_tasks": {
                    if (!this.plugin.getGameManager().isGameRunning()) {
                        TaskManagerMode tmm = this.plugin.getTaskManagerMode();
                        if (tmm != null) {
                            tmm.assignAndAnnounceTasks(this.plugin.getGameManager().getRunners());
                            player.sendMessage("\u00a7aTask assignments have been rerolled!");
                        }
                    } else {
                        player.sendMessage("\u00a7cCannot reroll tasks while game is running.");
                    }
                    this.guiManager.openMainMenu(player);
                }
            }
            return;
        }
        this.plugin.getLogger().warning("Unhandled main menu click: " + (clicked.hasItemMeta() && clicked.getItemMeta().hasDisplayName() ? GuiCompat.getDisplayName(clicked.getItemMeta()) : clicked.getType().name()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleSettingsClick(InventoryClickEvent event) {
        Player player;
        block146: {
            ItemStack clicked;
            block147: {
                player = (Player)event.getWhoClicked();
                clicked = event.getCurrentItem();
                if (clicked == null || !clicked.hasItemMeta()) {
                    return;
                }
                String buttonId = this.getButtonId(clicked);
                if (buttonId == null) break block147;
                switch (buttonId) {
                    case "back_main": {
                        this.guiManager.openMainMenu(player);
                        return;
                    }
                    case "swap_interval": {
                        break;
                    }
                    case "interval_minus": {
                        int current = this.plugin.getConfigManager().getSwapInterval();
                        boolean beta = this.plugin.getConfigManager().isBetaIntervalEnabled();
                        int minAllowed = beta ? 10 : this.plugin.getConfigManager().getMinSwapInterval();
                        int maxAllowed = this.plugin.getConfigManager().getSwapIntervalMax();
                        int val = Math.max(minAllowed, current - 5);
                        if (!beta) {
                            val = Math.min(maxAllowed, val);
                        }
                        this.plugin.getConfigManager().setSwapInterval(val);
                        if (this.plugin.getGameManager().isGameRunning()) {
                            this.plugin.getGameManager().refreshSwapSchedule();
                            break;
                        }
                        break block146;
                    }
                    case "interval_plus": {
                        int current = this.plugin.getConfigManager().getSwapInterval();
                        boolean beta = this.plugin.getConfigManager().isBetaIntervalEnabled();
                        int minAllowed = beta ? 10 : this.plugin.getConfigManager().getMinSwapInterval();
                        int maxAllowed = this.plugin.getConfigManager().getSwapIntervalMax();
                        int val = current + 5;
                        val = Math.max(minAllowed, val);
                        if (!beta) {
                            val = Math.min(maxAllowed, val);
                        }
                        this.plugin.getConfigManager().setSwapInterval(val);
                        if (this.plugin.getGameManager().isGameRunning()) {
                            this.plugin.getGameManager().refreshSwapSchedule();
                            break;
                        }
                        break block146;
                    }
                    case "random_swaps": {
                        this.toggleRandomSwaps(player);
                        break;
                    }
                    case "beta_intervals": {
                        boolean en = this.plugin.getConfigManager().isBetaIntervalEnabled();
                        this.plugin.getConfigManager().setBetaIntervalEnabled(!en);
                        break;
                    }
                    case "random_range": {
                        int delta;
                        int min = this.plugin.getConfigManager().getMinSwapInterval();
                        int max = this.plugin.getConfigManager().getMaxSwapInterval();
                        int n = delta = event.isShiftClick() ? 15 : 5;
                        if (event.isLeftClick()) {
                            min = Math.max(1, Math.min(min + delta, max));
                            this.plugin.getConfig().set("swap.min_interval", (Object)min);
                        }
                        if (event.isRightClick()) {
                            max = Math.max(min, max - delta);
                            this.plugin.getConfig().set("swap.max_interval", (Object)max);
                        }
                        this.plugin.saveConfig();
                        break;
                    }
                    case "safe_swaps": {
                        this.toggleSafeSwaps(player);
                        break;
                    }
                    case "pause_disconnect": {
                        boolean enabled = this.plugin.getConfigManager().isPauseOnDisconnect();
                        this.plugin.getConfig().set("swap.pause_on_disconnect", (Object)(!enabled ? 1 : 0));
                        this.plugin.saveConfig();
                        break;
                    }
                    case "hunter_swap": {
                        boolean enabled = this.plugin.getConfigManager().isHunterSwapEnabled();
                        this.plugin.getConfig().set("swap.hunter_swap.enabled", (Object)(!enabled ? 1 : 0));
                        this.plugin.saveConfig();
                        break;
                    }
                    case "hunter_swap_interval": {
                        int delta;
                        int val = this.plugin.getConfigManager().getHunterSwapInterval();
                        int n = delta = event.isShiftClick() ? 60 : 30;
                        if (event.isLeftClick()) {
                            val += delta;
                        }
                        if (event.isRightClick()) {
                            val -= delta;
                        }
                        val = Math.max(30, Math.min(600, val));
                        this.plugin.getConfig().set("swap.hunter_swap.interval", (Object)val);
                        this.plugin.saveConfig();
                        break;
                    }
                    case "hot_potato": {
                        boolean enabled = this.plugin.getConfigManager().isHotPotatoModeEnabled();
                        this.plugin.getConfig().set("swap.hot_potato_mode.enabled", (Object)(!enabled ? 1 : 0));
                        this.plugin.saveConfig();
                        break;
                    }
                    case "single_sleep": {
                        boolean enabled = this.plugin.getConfigManager().isSinglePlayerSleepEnabled();
                        this.plugin.getConfigManager().setSinglePlayerSleepEnabled(!enabled);
                        player.sendMessage("\u00a7eSingle Player Sleep: " + (!enabled ? "\u00a7aEnabled" : "\u00a7cDisabled"));
                        break;
                    }
                    case "freeze_toggle": {
                        boolean enabled = this.plugin.getConfigManager().isFreezeMechanicEnabled();
                        this.plugin.getConfig().set("freeze_mechanic.enabled", (Object)(!enabled ? 1 : 0));
                        this.plugin.saveConfig();
                        if (this.plugin.getGameManager().isGameRunning()) {
                            this.plugin.getGameManager().refreshFreezeMechanic();
                            break;
                        }
                        break block146;
                    }
                    case "freeze_mode": {
                        String current = this.plugin.getConfigManager().getFreezeMode();
                        String next = switch (current.toUpperCase()) {
                            case "EFFECTS" -> "SPECTATOR";
                            case "SPECTATOR" -> "LIMBO";
                            case "LIMBO" -> "CAGE";
                            default -> "EFFECTS";
                        };
                        this.plugin.getConfig().set("freeze_mode", (Object)next);
                        this.plugin.saveConfig();
                        if (this.plugin.getGameManager().isGameRunning()) {
                            this.plugin.getGameManager().refreshFreezeMechanic();
                            break;
                        }
                        break block146;
                    }
                    case "freeze_duration": {
                        int delta;
                        int val = this.plugin.getConfigManager().getFreezeDurationTicks();
                        int n = delta = event.isShiftClick() ? 100 : 20;
                        if (event.isLeftClick()) {
                            val += delta;
                        }
                        if (event.isRightClick()) {
                            val -= delta;
                        }
                        val = Math.max(20, Math.min(6000, val));
                        this.plugin.getConfig().set("freeze_mechanic.duration_ticks", (Object)val);
                        this.plugin.saveConfig();
                        if (this.plugin.getGameManager().isGameRunning()) {
                            this.plugin.getGameManager().refreshFreezeMechanic();
                            break;
                        }
                        break block146;
                    }
                    case "freeze_check_interval": {
                        int delta;
                        int val = this.plugin.getConfigManager().getFreezeCheckIntervalTicks();
                        int n = delta = event.isShiftClick() ? 20 : 5;
                        if (event.isLeftClick()) {
                            val += delta;
                        }
                        if (event.isRightClick()) {
                            val -= delta;
                        }
                        val = Math.max(1, Math.min(200, val));
                        this.plugin.getConfig().set("freeze_mechanic.check_interval_ticks", (Object)val);
                        this.plugin.saveConfig();
                        if (this.plugin.getGameManager().isGameRunning()) {
                            this.plugin.getGameManager().refreshFreezeMechanic();
                            break;
                        }
                        break block146;
                    }
                    case "freeze_max_distance": {
                        int delta;
                        int val = (int)Math.round(this.plugin.getConfigManager().getFreezeMaxDistance());
                        int n = delta = event.isShiftClick() ? 20 : 5;
                        if (event.isLeftClick()) {
                            val += delta;
                        }
                        if (event.isRightClick()) {
                            val -= delta;
                        }
                        val = Math.max(5, Math.min(256, val));
                        this.plugin.getConfig().set("freeze_mechanic.max_distance", (Object)val);
                        this.plugin.saveConfig();
                        if (this.plugin.getGameManager().isGameRunning()) {
                            this.plugin.getGameManager().refreshFreezeMechanic();
                            break;
                        }
                        break block146;
                    }
                    case "tracker_toggle": {
                        boolean enabled = this.plugin.getConfigManager().isTrackerEnabled();
                        this.plugin.getConfigManager().setTrackerEnabled(!enabled);
                        if (!enabled) {
                            this.plugin.getTrackerManager().startTracking();
                            for (Player hunter : this.plugin.getGameManager().getHunters()) {
                                if (!hunter.isOnline()) continue;
                                this.plugin.getTrackerManager().giveTrackingCompass(hunter);
                            }
                            break block146;
                        } else {
                            this.plugin.getTrackerManager().stopTracking();
                            break;
                        }
                    }
                    case "force_swap": {
                        this.plugin.getGameManager().triggerImmediateSwap();
                        break;
                    }
                    case "force_hunter_shuffle": {
                        this.plugin.getGameManager().triggerImmediateHunterSwap();
                        break;
                    }
                    case "update_compasses": {
                        this.plugin.getTrackerManager().updateAllHunterCompasses();
                        break;
                    }
                    case "swap_min_interval": {
                        int min = this.plugin.getConfigManager().getMinSwapInterval();
                        if (event.isLeftClick()) {
                            min += event.isShiftClick() ? 15 : 5;
                        }
                        if (event.isRightClick()) {
                            min -= event.isShiftClick() ? 15 : 5;
                        }
                        int max = this.plugin.getConfigManager().getMaxSwapInterval();
                        min = Math.max(1, Math.min(min, max));
                        this.plugin.getConfig().set("swap.min_interval", (Object)min);
                        this.plugin.saveConfig();
                        break;
                    }
                    case "swap_max_interval": {
                        int max = this.plugin.getConfigManager().getMaxSwapInterval();
                        if (event.isLeftClick()) {
                            max += event.isShiftClick() ? 15 : 5;
                        }
                        if (event.isRightClick()) {
                            max -= event.isShiftClick() ? 15 : 5;
                        }
                        int min = this.plugin.getConfigManager().getMinSwapInterval();
                        max = Math.max(min, max);
                        this.plugin.getConfig().set("swap.max_interval", (Object)max);
                        this.plugin.saveConfig();
                        break;
                    }
                    case "jitter_stddev": {
                        int sd = (int)Math.round(this.plugin.getConfigManager().getJitterStdDev());
                        if (event.isLeftClick()) {
                            sd += event.isShiftClick() ? 5 : 1;
                        }
                        if (event.isRightClick()) {
                            sd -= event.isShiftClick() ? 5 : 1;
                        }
                        sd = Math.max(0, Math.min(600, sd));
                        this.plugin.getConfig().set("swap.jitter.stddev", (Object)sd);
                        this.plugin.saveConfig();
                        break;
                    }
                    case "jitter_clamp": {
                        boolean clamp = this.plugin.getConfigManager().isClampJitter();
                        this.plugin.getConfig().set("swap.jitter.clamp", (Object)(!clamp ? 1 : 0));
                        this.plugin.saveConfig();
                        break;
                    }
                    case "grace_period": {
                        int gp = this.plugin.getConfigManager().getGracePeriodTicks();
                        if (event.isLeftClick()) {
                            gp += event.isShiftClick() ? 40 : 10;
                        }
                        if (event.isRightClick()) {
                            gp -= event.isShiftClick() ? 40 : 10;
                        }
                        gp = Math.max(0, Math.min(1200, gp));
                        this.plugin.getConfig().set("swap.grace_period_ticks", (Object)gp);
                        this.plugin.saveConfig();
                        break;
                    }
                    case "safe_h_radius": {
                        int val = this.plugin.getConfigManager().getSafeSwapHorizontalRadius();
                        if (event.isLeftClick()) {
                            val += event.isShiftClick() ? 5 : 1;
                        }
                        if (event.isRightClick()) {
                            val -= event.isShiftClick() ? 5 : 1;
                        }
                        val = Math.max(1, Math.min(64, val));
                        this.plugin.getConfig().set("safe_swap.horizontal_radius", (Object)val);
                        this.plugin.saveConfig();
                        break;
                    }
                    case "safe_v_distance": {
                        int val = this.plugin.getConfigManager().getSafeSwapVerticalDistance();
                        if (event.isLeftClick()) {
                            val += event.isShiftClick() ? 5 : 1;
                        }
                        if (event.isRightClick()) {
                            val -= event.isShiftClick() ? 5 : 1;
                        }
                        val = Math.max(1, Math.min(64, val));
                        this.plugin.getConfig().set("safe_swap.vertical_distance", (Object)val);
                        this.plugin.saveConfig();
                        break;
                    }
                    case "dangerous_blocks": {
                        this.guiManager.openDangerousBlocksMenu(player);
                        break;
                    }
                    case "voice_chat": {
                        boolean enabled = this.plugin.getConfigManager().isVoiceChatIntegrationEnabled();
                        this.plugin.getConfigManager().setVoiceChatIntegrationEnabled(!enabled);
                        break;
                    }
                    case "mute_inactive_toggle": {
                        boolean enabled = this.plugin.getConfigManager().isMuteInactiveRunners();
                        this.plugin.getConfig().set("voice_chat.mute_inactive_runners", (Object)(!enabled ? 1 : 0));
                        this.plugin.saveConfig();
                        break;
                    }
                    case "reset_all_settings": {
                        this.guiManager.openResetConfirmMenu(player);
                        return;
                    }
                    case "reset_confirm_no": {
                        this.guiManager.openSettingsMenu(player);
                        return;
                    }
                    case "reset_confirm_yes": {
                        try {
                            this.plugin.saveResource("config.yml", true);
                            this.plugin.reloadConfig();
                            this.plugin.getConfigManager().loadConfig();
                            player.sendMessage("\u00a7a[Settings] All settings restored to defaults.");
                        }
                        catch (Throwable t) {
                            player.sendMessage("\u00a7c[Settings] Failed to reset settings: " + t.getMessage());
                        }
                        this.guiManager.openSettingsMenu(player);
                        return;
                    }
                    case "ui_actionbar_ticks": {
                        int val = this.plugin.getConfigManager().getActionBarUpdateTicks();
                        if (event.isLeftClick()) {
                            val += 5;
                        }
                        if (event.isRightClick()) {
                            val -= 5;
                        }
                        val = Math.max(1, Math.min(200, val));
                        this.plugin.getConfig().set("ui.update_ticks.actionbar", (Object)val);
                        this.plugin.saveConfig();
                        break;
                    }
                    case "ui_title_ticks": {
                        int val = this.plugin.getConfigManager().getTitleUpdateTicks();
                        if (event.isLeftClick()) {
                            val += event.isShiftClick() ? 5 : 1;
                        }
                        if (event.isRightClick()) {
                            val -= event.isShiftClick() ? 5 : 1;
                        }
                        val = Math.max(1, Math.min(200, val));
                        this.plugin.getConfig().set("ui.update_ticks.title", (Object)val);
                        this.plugin.saveConfig();
                        break;
                    }
                    case "set_limbo_here": {
                        Location loc = player.getLocation();
                        this.plugin.getConfig().set("limbo.world", (Object)loc.getWorld().getName());
                        this.plugin.getConfig().set("limbo.x", (Object)loc.getX());
                        this.plugin.getConfig().set("limbo.y", (Object)loc.getY());
                        this.plugin.getConfig().set("limbo.z", (Object)loc.getZ());
                        this.plugin.saveConfig();
                        player.sendMessage("\u00a7aLimbo location updated.");
                        break;
                    }
                    case "set_spawn_here": {
                        Location loc = player.getLocation();
                        this.plugin.getConfig().set("spawn.world", (Object)loc.getWorld().getName());
                        this.plugin.getConfig().set("spawn.x", (Object)loc.getX());
                        this.plugin.getConfig().set("spawn.y", (Object)loc.getY());
                        this.plugin.getConfig().set("spawn.z", (Object)loc.getZ());
                        this.plugin.saveConfig();
                        player.sendMessage("\u00a7aSpawn location updated.");
                        break;
                    }
                    case "beta_intervals_toggle": {
                        boolean enabled = this.plugin.getConfigManager().isBetaIntervalEnabled();
                        this.plugin.getConfigManager().setBetaIntervalEnabled(!enabled);
                        break;
                    }
                    case "apply_mode_default_toggle": {
                        boolean enabled = this.plugin.getConfigManager().getApplyDefaultOnModeSwitch();
                        this.plugin.getConfigManager().setApplyDefaultOnModeSwitch(!enabled);
                        break;
                    }
                    case "swap_interval_reset": {
                        this.plugin.getConfigManager().applyModeDefaultInterval(this.plugin.getCurrentMode());
                        break;
                    }
                    case "swap_interval_save_default": {
                        int curr = this.plugin.getConfigManager().getSwapInterval();
                        this.plugin.getConfigManager().setModeDefaultInterval(this.plugin.getCurrentMode(), curr);
                        break;
                    }
                }
                break block146;
            }
            String name = GuiCompat.getDisplayName(clicked.getItemMeta());
            if (name.equals("\u00a7e\u00a7lActive Runner Timer")) {
                this.cycleRunnerTimer(player);
            } else if (name.equals("\u00a7e\u00a7lWaiting Runner Timer")) {
                this.cycleWaitingTimer(player);
            } else if ("-5s".equals(name) || "+5s".equals(name)) {
                int current = this.plugin.getConfigManager().getSwapInterval();
                boolean beta = this.plugin.getConfigManager().isBetaIntervalEnabled();
                int min = beta ? 10 : this.plugin.getConfigManager().getMinSwapInterval();
                int max = this.plugin.getConfigManager().getSwapIntervalMax();
                int delta = "+5s".equals(name) ? 5 : -5;
                int val = current + delta;
                val = beta ? Math.max(min, val) : Math.max(min, Math.min(max, val));
                this.plugin.getConfigManager().setSwapInterval(val);
            }
        }
        this.guiManager.openSettingsMenu(player);
        this.plugin.getGameManager().refreshSwapSchedule();
        this.plugin.getGameManager().refreshActionBar();
    }

    private void cycleRunnerTimer(Player player) {
        String current = this.plugin.getConfigManager().getRunnerTimerVisibility();
        String next = this.guiManager.getNextVisibility(current);
        this.plugin.getConfigManager().setRunnerTimerVisibility(next);
    }

    private void cycleWaitingTimer(Player player) {
        String current = this.plugin.getConfigManager().getWaitingTimerVisibility();
        String next = this.guiManager.getNextVisibility(current);
        this.plugin.getConfigManager().setWaitingTimerVisibility(next);
    }

    private String getButtonId(ItemStack item) {
        NamespacedKey sswKey;
        if (item == null || !item.hasItemMeta()) {
            return null;
        }
        PersistentDataContainer container = item.getItemMeta().getPersistentDataContainer();
        if (container.has(sswKey = new NamespacedKey((Plugin)this.plugin, "ssw_button_id"), PersistentDataType.STRING)) {
            return (String)container.get(sswKey, PersistentDataType.STRING);
        }
        NamespacedKey legacyKey = new NamespacedKey((Plugin)this.plugin, "button_id");
        if (container.has(legacyKey, PersistentDataType.STRING)) {
            return (String)container.get(legacyKey, PersistentDataType.STRING);
        }
        return null;
    }

    private boolean isBackButton(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return false;
        }
        String text = GuiCompat.getDisplayName(item.getItemMeta());
        if (text == null) {
            return false;
        }
        boolean looksLikeBack = text != null && text.toLowerCase().contains("back");
        return looksLikeBack && (item.getType() == Material.BARRIER || item.getType() == Material.ARROW);
    }

    private void toggleRandomSwaps(Player player) {
        boolean current = this.plugin.getConfigManager().isSwapRandomized();
        this.plugin.getConfigManager().setSwapRandomized(!current);
    }

    private void toggleSafeSwaps(Player player) {
        boolean current = this.plugin.getConfigManager().isSafeSwapEnabled();
        this.plugin.getConfigManager().setSafeSwapEnabled(!current);
    }

    private void handleTeamSelectorClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null || !clicked.hasItemMeta()) {
            return;
        }
        String id = this.getButtonId(clicked);
        if ("clear_teams".equals(id)) {
            this.plugin.getGameManager().setRunners(new ArrayList<Player>());
            this.plugin.getGameManager().setHunters(new ArrayList<Player>());
            player.sendMessage("\u00a7aCleared all teams.");
            this.guiManager.openTeamSelector(player);
            return;
        }
        String name = GuiCompat.getDisplayName(clicked.getItemMeta());
        SpeedrunnerSwap.SwapMode currentMode = this.plugin.getCurrentMode();
        if (name != null) {
            if (name.contains("\u00a7b\u00a7lRunners")) {
                this.guiManager.setPlayerTeam(player, Team.RUNNER);
                return;
            }
            if (name.contains("\u00a7c\u00a7lHunters")) {
                if (currentMode != SpeedrunnerSwap.SwapMode.TASK) {
                    this.guiManager.setPlayerTeam(player, Team.HUNTER);
                } else {
                    player.sendMessage("\u00a7cHunters are not available in Task Manager mode!");
                }
                return;
            }
        }
        if (clicked.getType() == Material.PLAYER_HEAD && clicked.getItemMeta() != null) {
            Player target;
            String targetName = GuiCompat.getDisplayName(clicked.getItemMeta());
            try {
                targetName = ChatColor.stripColor((String)targetName);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (targetName != null) {
                targetName = targetName.trim();
            }
            if ((target = Bukkit.getPlayerExact((String)targetName)) == null) {
                player.sendMessage("\u00a7cPlayer not found or offline: " + targetName);
                return;
            }
            Team selected = this.guiManager.getSelectedTeam(player);
            if (selected == Team.NONE) {
                if (currentMode == SpeedrunnerSwap.SwapMode.TASK) {
                    try {
                        this.plugin.getGameManager().getPlayerState(player).setSelectedTeam(Team.RUNNER);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    selected = Team.RUNNER;
                } else {
                    player.sendMessage("\u00a7eSelect a team (Runners/Hunters) first.");
                    return;
                }
            }
            ArrayList<Player> newRunners = new ArrayList<Player>(this.plugin.getGameManager().getRunners());
            ArrayList<Player> newHunters = new ArrayList<Player>(this.plugin.getGameManager().getHunters());
            newRunners.remove(target);
            newHunters.remove(target);
            if (selected == Team.RUNNER) {
                newRunners.add(target);
            } else if (selected == Team.HUNTER) {
                newHunters.add(target);
            }
            this.plugin.getGameManager().setRunners(newRunners);
            this.plugin.getGameManager().setHunters(newHunters);
            this.guiManager.openTeamSelector(player);
        }
    }

    private void handlePowerUpsMenuClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null || !clicked.hasItemMeta()) {
            return;
        }
        String name = GuiCompat.getDisplayName(clicked.getItemMeta());
        if ("\u00a7e\u00a7lToggle Power-ups".equals(name)) {
            boolean current = this.plugin.getConfigManager().isPowerUpsEnabled();
            this.plugin.getConfigManager().setPowerUpsEnabled(!current);
            this.guiManager.openPowerUpsMenu(player);
            return;
        }
        if (name != null && name.contains("Positive Effects")) {
            this.guiManager.openPositiveEffectsMenu(player);
            return;
        }
        if (name != null && name.contains("Negative Effects")) {
            this.guiManager.openNegativeEffectsMenu(player);
            return;
        }
        if (name != null && name.contains("Effect Durations")) {
            this.guiManager.openPowerUpDurationsMenu(player);
            return;
        }
    }

    private boolean maybeHandlePowerUpDurationsMenu(InventoryClickEvent event, String title) {
        if (!title.contains("Power-up Durations")) {
            return false;
        }
        this.handlePowerUpDurationsClick(event);
        return true;
    }

    private boolean maybeHandleDangerousBlocksMenu(InventoryClickEvent event, String title) {
        if (!title.contains("Dangerous Blocks")) {
            return false;
        }
        this.handleDangerousBlocksClick(event);
        return true;
    }

    private void handlePowerUpDurationsClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null || !clicked.hasItemMeta()) {
            return;
        }
        String name = GuiCompat.getDisplayName(clicked.getItemMeta());
        boolean changed = false;
        switch (name) {
            case "\u00a7e\u00a7lMin Duration (s)": {
                int val = this.plugin.getConfigManager().getPowerUpsMinSeconds();
                if (event.isLeftClick()) {
                    val += 5;
                }
                if (event.isRightClick()) {
                    val -= 5;
                }
                val = Math.max(1, Math.min(600, val));
                this.plugin.getConfigManager().setPowerUpsMinSeconds(val);
                changed = true;
                break;
            }
            case "\u00a7e\u00a7lMax Duration (s)": {
                int val = this.plugin.getConfigManager().getPowerUpsMaxSeconds();
                if (event.isLeftClick()) {
                    val += 5;
                }
                if (event.isRightClick()) {
                    val -= 5;
                }
                val = Math.max(1, Math.min(1800, val));
                this.plugin.getConfigManager().setPowerUpsMaxSeconds(val);
                changed = true;
                break;
            }
            case "\u00a7e\u00a7lMin Level": {
                int val = this.plugin.getConfigManager().getPowerUpsMinLevel();
                if (event.isLeftClick()) {
                    ++val;
                }
                if (event.isRightClick()) {
                    --val;
                }
                val = Math.max(1, Math.min(5, val));
                this.plugin.getConfigManager().setPowerUpsMinLevel(val);
                changed = true;
                break;
            }
            case "\u00a7e\u00a7lMax Level": {
                int val = this.plugin.getConfigManager().getPowerUpsMaxLevel();
                if (event.isLeftClick()) {
                    ++val;
                }
                if (event.isRightClick()) {
                    --val;
                }
                val = Math.max(1, Math.min(5, val));
                this.plugin.getConfigManager().setPowerUpsMaxLevel(val);
                changed = true;
                break;
            }
        }
        if (this.isBackButton(clicked)) {
            this.guiManager.openPowerUpsMenu(player);
        } else if (changed) {
            this.guiManager.openPowerUpDurationsMenu(player);
        }
    }

    private void handleDangerousBlocksClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null || !clicked.hasItemMeta()) {
            return;
        }
        String name = GuiCompat.getDisplayName(clicked.getItemMeta());
        if (this.isBackButton(clicked)) {
            this.guiManager.openSettingsMenu(player);
            return;
        }
        try {
            Material mat = Material.matchMaterial((String)name.replace("\u00a7e", "").trim());
            if (mat != null) {
                Set<Material> set = this.plugin.getConfigManager().getDangerousBlocks();
                if (set.contains(mat)) {
                    set.remove(mat);
                    ArrayList<String> list = new ArrayList<String>();
                    for (Material m : set) {
                        list.add(m.name());
                    }
                    this.plugin.getConfig().set("safe_swap.dangerous_blocks", list);
                    this.plugin.saveConfig();
                }
                this.guiManager.openDangerousBlocksMenu(player);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void handleWorldBorderClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null || !clicked.hasItemMeta()) {
            return;
        }
        String name = GuiCompat.getDisplayName(clicked.getItemMeta());
        boolean changed = false;
        switch (name) {
            case "\u00a7e\u00a7lToggle World Border": {
                boolean enabled = this.plugin.getConfig().getBoolean("world_border.enabled", true);
                this.plugin.getConfig().set("world_border.enabled", (Object)(!enabled ? 1 : 0));
                this.plugin.saveConfig();
                if (!enabled) {
                    this.plugin.getWorldBorderManager().startBorderShrinking();
                } else {
                    this.plugin.getWorldBorderManager().stopBorderShrinking();
                }
                changed = true;
                break;
            }
            case "\u00a7a\u00a7lInitial Border Size": {
                int val = this.plugin.getConfig().getInt("world_border.initial_size", 2000);
                if (event.isLeftClick()) {
                    val += event.isShiftClick() ? 500 : 100;
                }
                if (event.isRightClick()) {
                    val -= event.isShiftClick() ? 500 : 100;
                }
                val = Math.max(100, Math.min(29999984, val));
                this.plugin.getConfig().set("world_border.initial_size", (Object)val);
                this.plugin.saveConfig();
                changed = true;
                break;
            }
            case "\u00a7c\u00a7lFinal Border Size": {
                int val = this.plugin.getConfig().getInt("world_border.final_size", 100);
                if (event.isLeftClick()) {
                    val += event.isShiftClick() ? 100 : 50;
                }
                if (event.isRightClick()) {
                    val -= event.isShiftClick() ? 100 : 50;
                }
                val = Math.max(50, Math.min(1000, val));
                this.plugin.getConfig().set("world_border.final_size", (Object)val);
                this.plugin.saveConfig();
                changed = true;
                break;
            }
            case "\u00a76\u00a7lShrink Duration": {
                int val = this.plugin.getConfig().getInt("world_border.shrink_duration", 1800);
                if (event.isLeftClick()) {
                    val += event.isShiftClick() ? 900 : 300;
                }
                if (event.isRightClick()) {
                    val -= event.isShiftClick() ? 900 : 300;
                }
                val = Math.max(300, Math.min(7200, val));
                this.plugin.getConfig().set("world_border.shrink_duration", (Object)val);
                this.plugin.saveConfig();
                changed = true;
                break;
            }
            case "\u00a7e\u00a7lWarning Settings": {
                int dist = this.plugin.getConfig().getInt("world_border.warning_distance", 50);
                int interval = this.plugin.getConfig().getInt("world_border.warning_interval", 300);
                if (event.isLeftClick()) {
                    dist += event.isShiftClick() ? 50 : 10;
                }
                if (event.isRightClick()) {
                    dist -= event.isShiftClick() ? 50 : 10;
                }
                if (event.isShiftClick()) {
                    if (event.isLeftClick()) {
                        interval += 30;
                    }
                    if (event.isRightClick()) {
                        interval -= 30;
                    }
                }
                dist = Math.max(5, Math.min(1000, dist));
                interval = Math.max(30, Math.min(3600, interval));
                this.plugin.getConfig().set("world_border.warning_distance", (Object)dist);
                this.plugin.getConfig().set("world_border.warning_interval", (Object)interval);
                this.plugin.saveConfig();
                changed = true;
                break;
            }
        }
        if (changed) {
            this.guiManager.openWorldBorderMenu(player);
        }
    }

    private void handleKitsMenuClick(InventoryClickEvent event) {
        String name;
        Player player = (Player)event.getWhoClicked();
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null || !clicked.hasItemMeta()) {
            return;
        }
        String id = this.getButtonId(clicked);
        if (id != null) {
            switch (id) {
                case "edit_runner_kit": {
                    this.guiManager.openKitEditor(player, "runner");
                    return;
                }
                case "edit_hunter_kit": {
                    this.guiManager.openKitEditor(player, "hunter");
                    return;
                }
                case "back_settings": {
                    this.guiManager.openSettingsMenu(player);
                    return;
                }
            }
        }
        if ((name = GuiCompat.getDisplayName(clicked.getItemMeta())) == null) {
            return;
        }
        switch (name) {
            case "\u00a7e\u00a7lKits: \u00a7aEnabled": 
            case "\u00a7e\u00a7lKits: \u00a7cDisabled": {
                boolean enabled = this.plugin.getConfigManager().isKitsEnabled();
                this.plugin.getConfigManager().setKitsEnabled(!enabled);
                this.guiManager.openKitsMenu(player);
                break;
            }
            case "\u00a7b\u00a7lGive Runner Kit": {
                this.plugin.getKitManager().applyRunnerKit(player);
                break;
            }
            case "\u00a7c\u00a7lGive Hunter Kit": {
                this.plugin.getKitManager().applyHunterKit(player);
                break;
            }
            case "\u00a7b\u00a7lEdit Runner Kit": {
                this.guiManager.openKitEditor(player, "runner");
                break;
            }
            case "\u00a7c\u00a7lEdit Hunter Kit": {
                this.guiManager.openKitEditor(player, "hunter");
                break;
            }
        }
    }

    private void handleBountyMenuClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null || !clicked.hasItemMeta()) {
            return;
        }
        String id = this.getButtonId(clicked);
        String name = GuiCompat.getDisplayName(clicked.getItemMeta());
        if (id != null) {
            switch (id) {
                case "toggle_bounty": {
                    boolean enabled = this.plugin.getConfig().getBoolean("bounty.enabled", false);
                    this.plugin.getConfig().set("bounty.enabled", (Object)(!enabled ? 1 : 0));
                    this.plugin.saveConfig();
                    break;
                }
                case "bounty_base": {
                    int delta;
                    int val = this.plugin.getConfig().getInt("bounty.base_amount", 10);
                    int n = delta = event.isShiftClick() ? 10 : 5;
                    if (event.isLeftClick()) {
                        val += delta;
                    }
                    if (event.isRightClick()) {
                        val -= delta;
                    }
                    val = Math.max(0, Math.min(10000, val));
                    this.plugin.getConfig().set("bounty.base_amount", (Object)val);
                    this.plugin.saveConfig();
                    break;
                }
                case "bounty_multiplier": {
                    int delta;
                    int val = this.plugin.getConfig().getInt("bounty.kill_multiplier", 2);
                    int n = delta = event.isShiftClick() ? 2 : 1;
                    if (event.isLeftClick()) {
                        val += delta;
                    }
                    if (event.isRightClick()) {
                        val -= delta;
                    }
                    val = Math.max(1, Math.min(10, val));
                    this.plugin.getConfig().set("bounty.kill_multiplier", (Object)val);
                    this.plugin.saveConfig();
                    break;
                }
                case "bounty_max": {
                    int delta;
                    int val = this.plugin.getConfig().getInt("bounty.max_amount", 100);
                    int n = delta = event.isShiftClick() ? 20 : 10;
                    if (event.isLeftClick()) {
                        val += delta;
                    }
                    if (event.isRightClick()) {
                        val -= delta;
                    }
                    val = Math.max(1, Math.min(100000, val));
                    this.plugin.getConfig().set("bounty.max_amount", (Object)val);
                    this.plugin.saveConfig();
                    break;
                }
            }
            this.guiManager.openBountyMenu(player);
            return;
        }
        if (name != null && name.startsWith("\u00a7e\u00a7lAssign New Bounty")) {
            this.plugin.getBountyManager().assignNewBounty();
            this.guiManager.openBountyMenu(player);
        } else if (name != null && name.startsWith("\u00a7c\u00a7lClear Bounty")) {
            this.plugin.getBountyManager().clearBounty();
            this.guiManager.openBountyMenu(player);
        }
    }

    private void handleLastStandClick(InventoryClickEvent event) {
        String name;
        Player player = (Player)event.getWhoClicked();
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null || !clicked.hasItemMeta()) {
            return;
        }
        String buttonId = this.getButtonId(clicked);
        if (buttonId != null) {
            switch (buttonId) {
                case "toggle_last_stand": {
                    boolean enabled = this.plugin.getConfigManager().isLastStandEnabled();
                    this.plugin.getConfig().set("last_stand.enabled", (Object)(!enabled ? 1 : 0));
                    this.plugin.saveConfig();
                    break;
                }
                case "last_stand_threshold": {
                    int threshold = this.plugin.getConfig().getInt("last_stand.health_threshold", 4);
                    if (event.isLeftClick()) {
                        ++threshold;
                    }
                    if (event.isRightClick()) {
                        --threshold;
                    }
                    threshold = Math.max(1, Math.min(20, threshold));
                    this.plugin.getConfig().set("last_stand.health_threshold", (Object)threshold);
                    this.plugin.saveConfig();
                    break;
                }
                case "last_stand_duration": {
                    int duration = this.plugin.getConfig().getInt("last_stand.duration", 30);
                    if (event.isLeftClick()) {
                        duration += 5;
                    }
                    if (event.isRightClick()) {
                        duration -= 5;
                    }
                    duration = Math.max(5, Math.min(300, duration));
                    this.plugin.getConfig().set("last_stand.duration", (Object)duration);
                    this.plugin.saveConfig();
                    break;
                }
                case "last_stand_strength": {
                    int amp = this.plugin.getConfigManager().getLastStandStrengthAmplifier();
                    if (event.isLeftClick()) {
                        ++amp;
                    }
                    if (event.isRightClick()) {
                        --amp;
                    }
                    amp = Math.max(0, Math.min(5, amp));
                    this.plugin.getConfig().set("last_stand.strength_amplifier", (Object)amp);
                    this.plugin.saveConfig();
                    break;
                }
                case "last_stand_speed": {
                    int amp = this.plugin.getConfigManager().getLastStandSpeedAmplifier();
                    if (event.isLeftClick()) {
                        ++amp;
                    }
                    if (event.isRightClick()) {
                        --amp;
                    }
                    amp = Math.max(0, Math.min(5, amp));
                    this.plugin.getConfig().set("last_stand.speed_amplifier", (Object)amp);
                    this.plugin.saveConfig();
                }
            }
            this.guiManager.openLastStandMenu(player);
            return;
        }
        switch (name = GuiCompat.getDisplayName(clicked.getItemMeta())) {
            case "\u00a7e\u00a7lLast Stand: \u00a7aEnabled": 
            case "\u00a7e\u00a7lLast Stand: \u00a7cDisabled": {
                boolean enabled = this.plugin.getConfigManager().isLastStandEnabled();
                this.plugin.getConfig().set("last_stand.enabled", (Object)(!enabled ? 1 : 0));
                this.plugin.saveConfig();
                this.guiManager.openLastStandMenu(player);
                break;
            }
            case "\u00a76\u00a7lLast Stand Duration": {
                int duration = this.plugin.getConfigManager().getLastStandDuration();
                if (event.isLeftClick()) {
                    duration += 100;
                }
                if (event.isRightClick()) {
                    duration -= 100;
                }
                duration = Math.max(100, duration);
                this.plugin.getConfig().set("last_stand.duration_ticks", (Object)duration);
                this.plugin.saveConfig();
                this.guiManager.openLastStandMenu(player);
                break;
            }
            case "\u00a7e\u00a7lStrength Amplifier": {
                int amp = this.plugin.getConfigManager().getLastStandStrengthAmplifier();
                if (event.isLeftClick()) {
                    ++amp;
                }
                if (event.isRightClick()) {
                    --amp;
                }
                amp = Math.max(0, Math.min(5, amp));
                this.plugin.getConfig().set("last_stand.strength_amplifier", (Object)amp);
                this.plugin.saveConfig();
                this.guiManager.openLastStandMenu(player);
                break;
            }
            case "\u00a7b\u00a7lSpeed Amplifier": {
                int amp = this.plugin.getConfigManager().getLastStandSpeedAmplifier();
                if (event.isLeftClick()) {
                    ++amp;
                }
                if (event.isRightClick()) {
                    --amp;
                }
                amp = Math.max(0, Math.min(5, amp));
                this.plugin.getConfig().set("last_stand.speed_amplifier", (Object)amp);
                this.plugin.saveConfig();
                this.guiManager.openLastStandMenu(player);
                break;
            }
        }
    }

    private void handleCompassSettingsClick(InventoryClickEvent event) {
        String name;
        Player player = (Player)event.getWhoClicked();
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null || !clicked.hasItemMeta()) {
            return;
        }
        String id = this.getButtonId(clicked);
        if (id != null) {
            switch (id) {
                case "back_settings": {
                    this.guiManager.openSettingsMenu(player);
                    return;
                }
                case "toggle_compass": {
                    boolean enabled = this.plugin.getConfig().getBoolean("compass.enabled", true);
                    this.plugin.getConfig().set("compass.enabled", (Object)(!enabled ? 1 : 0));
                    this.plugin.saveConfig();
                    break;
                }
                case "compass_update": {
                    int delta;
                    int val = this.plugin.getConfig().getInt("compass.update_interval", 20);
                    int n = delta = event.isShiftClick() ? 10 : 5;
                    if (event.isLeftClick()) {
                        val += delta;
                    }
                    if (event.isRightClick()) {
                        val -= delta;
                    }
                    val = Math.max(1, Math.min(200, val));
                    this.plugin.getConfig().set("compass.update_interval", (Object)val);
                    this.plugin.saveConfig();
                    break;
                }
                case "compass_range": {
                    int delta;
                    int val = this.plugin.getConfig().getInt("compass.tracking_range", 100);
                    int n = delta = event.isShiftClick() ? 50 : 10;
                    if (event.isLeftClick()) {
                        val += delta;
                    }
                    if (event.isRightClick()) {
                        val -= delta;
                    }
                    val = Math.max(10, Math.min(100000, val));
                    this.plugin.getConfig().set("compass.tracking_range", (Object)val);
                    this.plugin.saveConfig();
                    break;
                }
                case "compass_distance": {
                    boolean show = this.plugin.getConfig().getBoolean("compass.show_distance", true);
                    this.plugin.getConfig().set("compass.show_distance", (Object)(!show ? 1 : 0));
                    this.plugin.saveConfig();
                    break;
                }
            }
            this.guiManager.openCompassSettingsMenu(player);
            return;
        }
        switch (name = GuiCompat.getDisplayName(clicked.getItemMeta())) {
            case "\u00a7e\u00a7lCompass Jamming: \u00a7aEnabled": 
            case "\u00a7e\u00a7lCompass Jamming: \u00a7cDisabled": {
                boolean enabled = this.plugin.getConfigManager().isCompassJammingEnabled();
                this.plugin.getConfig().set("tracker.compass_jamming.enabled", (Object)(!enabled ? 1 : 0));
                this.plugin.getConfig().set("sudden_death.compass_jamming.enabled", (Object)(!enabled ? 1 : 0));
                this.plugin.saveConfig();
                this.guiManager.openCompassSettingsMenu(player);
                break;
            }
            case "\u00a76\u00a7lJam Duration (ticks)": {
                int duration = this.plugin.getConfigManager().getCompassJamDuration();
                if (event.isLeftClick()) {
                    duration += 20;
                }
                if (event.isRightClick()) {
                    duration -= 20;
                }
                duration = Math.max(20, duration);
                this.plugin.getConfig().set("tracker.compass_jamming.duration_ticks", (Object)duration);
                this.plugin.getConfig().set("sudden_death.compass_jamming.duration_ticks", (Object)duration);
                this.plugin.saveConfig();
                this.guiManager.openCompassSettingsMenu(player);
                break;
            }
            case "\u00a7e\u00a7lSet End Portal Hint (this world)": {
                this.plugin.getConfigManager().setEndPortalHint(player.getWorld(), player.getLocation());
                player.sendMessage("\u00a7aSet End Portal hint for world \u00a7f" + player.getWorld().getName());
                this.guiManager.openCompassSettingsMenu(player);
                break;
            }
            case "\u00a7c\u00a7lClear End Portal Hint (this world)": {
                this.plugin.getConfigManager().clearEndPortalHint(player.getWorld());
                player.sendMessage("\u00a7eCleared End Portal hint for world \u00a7f" + player.getWorld().getName());
                this.guiManager.openCompassSettingsMenu(player);
                break;
            }
            case "\u00a76\u00a7lJam Max Distance (blocks)": {
                int dist = this.plugin.getConfigManager().getCompassJamMaxDistance();
                if (event.isLeftClick()) {
                    dist += 25;
                }
                if (event.isRightClick()) {
                    dist -= 25;
                }
                dist = Math.max(0, Math.min(100000, dist));
                this.plugin.getConfigManager().setCompassJamMaxDistance(dist);
                this.guiManager.openCompassSettingsMenu(player);
                break;
            }
        }
    }

    private void handleSuddenDeathClick(InventoryClickEvent event) {
        String name;
        Player player = (Player)event.getWhoClicked();
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null || !clicked.hasItemMeta()) {
            return;
        }
        String buttonId = this.getButtonId(clicked);
        if (buttonId != null) {
            switch (buttonId) {
                case "toggle_sudden_death": {
                    boolean enabled = this.plugin.getConfig().getBoolean("sudden_death.enabled", false);
                    this.plugin.getConfig().set("sudden_death.enabled", (Object)(!enabled ? 1 : 0));
                    this.plugin.saveConfig();
                    break;
                }
                case "sudden_death_time": {
                    int time = this.plugin.getConfig().getInt("sudden_death.trigger_time", 1800);
                    int delta = 300;
                    if (event.isLeftClick()) {
                        time += delta;
                    }
                    if (event.isRightClick()) {
                        time -= delta;
                    }
                    time = Math.max(300, Math.min(21600, time));
                    this.plugin.getConfig().set("sudden_death.trigger_time", (Object)time);
                    this.plugin.saveConfig();
                    break;
                }
                case "sudden_death_no_regen": {
                    boolean noRegen = this.plugin.getConfig().getBoolean("sudden_death.no_regen", true);
                    this.plugin.getConfig().set("sudden_death.no_regen", (Object)(!noRegen ? 1 : 0));
                    this.plugin.saveConfig();
                    break;
                }
                case "sudden_death_one_hit": {
                    boolean oneHit = this.plugin.getConfig().getBoolean("sudden_death.one_hit_kill", false);
                    this.plugin.getConfig().set("sudden_death.one_hit_kill", (Object)(!oneHit ? 1 : 0));
                    this.plugin.saveConfig();
                    break;
                }
                case "activate_sudden_death_now": {
                    this.plugin.getSuddenDeathManager().activateSuddenDeath();
                    player.sendMessage("\u00a74Sudden Death activated!");
                    break;
                }
                case "cancel_sudden_death": {
                    this.plugin.getSuddenDeathManager().cancelSchedule();
                    player.sendMessage("\u00a7eScheduled Sudden Death cancelled.");
                    break;
                }
                case "schedule_sudden_death": {
                    this.plugin.getSuddenDeathManager().scheduleSuddenDeath();
                    player.sendMessage("\u00a7eSudden Death scheduled.");
                }
            }
            this.guiManager.openSuddenDeathMenu(player);
            return;
        }
        switch (name = GuiCompat.getDisplayName(clicked.getItemMeta())) {
            case "\u00a74\u00a7lSudden Death: \u00a7aActive": {
                this.plugin.getSuddenDeathManager().deactivate();
                break;
            }
            case "\u00a74\u00a7lSudden Death: \u00a7cInactive": {
                break;
            }
            case "\u00a7e\u00a7lCancel Scheduled Sudden Death": {
                this.plugin.getSuddenDeathManager().cancelSchedule();
                break;
            }
            case "\u00a7e\u00a7lSchedule Sudden Death": {
                this.plugin.getSuddenDeathManager().scheduleSuddenDeath();
                break;
            }
            case "\u00a7c\u00a7lActivate Now": {
                this.plugin.getSuddenDeathManager().activateSuddenDeath();
                break;
            }
            case "\u00a76\u00a7lActivation Delay (minutes)": {
                long seconds = this.plugin.getConfig().getLong("sudden_death.activation_delay", 1200L);
                long delta = 300L;
                if (event.isLeftClick()) {
                    seconds += delta;
                }
                if (event.isRightClick()) {
                    seconds -= delta;
                }
                long min = 300L;
                long max = 21600L;
                seconds = Math.max(min, Math.min(max, seconds));
                this.plugin.getConfig().set("sudden_death.activation_delay", (Object)seconds);
                this.plugin.saveConfig();
                break;
            }
        }
        this.guiManager.openSuddenDeathMenu(player);
    }

    private void handleKitEditorClick(InventoryClickEvent event, String title) {
        ItemStack boots;
        Player player = (Player)event.getWhoClicked();
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null || !clicked.hasItemMeta()) {
            return;
        }
        String kitType = null;
        String id = this.getButtonId(clicked);
        if (id != null && id.startsWith("save_") && id.endsWith("_kit")) {
            kitType = id.substring("save_".length(), id.length() - "_kit".length());
        } else {
            String name = GuiCompat.getDisplayName(clicked.getItemMeta());
            if (!"\u00a7a\u00a7lSave Kit".equals(name)) {
                return;
            }
            String plainTitle = this.getPlainTitle(event.getView());
            kitType = "runner";
            int idxEdit = plainTitle.indexOf("Edit ");
            int idxKit = plainTitle.indexOf(" Kit");
            if (idxEdit >= 0 && idxKit > idxEdit + 5) {
                kitType = plainTitle.substring(idxEdit + 5, idxKit).trim().toLowerCase();
            }
        }
        Inventory top = event.getView().getTopInventory();
        ItemStack[] contents = new ItemStack[45];
        for (int i = 0; i < 45; ++i) {
            contents[i] = top.getItem(i);
        }
        ItemStack[] armor = new ItemStack[4];
        ItemStack helmet = top.getItem(45);
        ItemStack chest = top.getItem(46);
        ItemStack legs = top.getItem(47);
        armor[0] = boots = top.getItem(48);
        armor[1] = legs;
        armor[2] = chest;
        armor[3] = helmet;
        this.plugin.getKitConfigManager().saveKit(kitType, contents, armor);
        player.sendMessage("\u00a7aSaved " + kitType + " kit.");
        this.guiManager.openKitsMenu(player);
    }

    private void handleCustomTasksClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null || !clicked.hasItemMeta()) {
            return;
        }
        String name = GuiCompat.getDisplayName(clicked.getItemMeta());
        if (name.equals("\u00a77\u00a7lBack")) {
            this.guiManager.openSettingsMenu(player);
        } else if (name.startsWith("\u00a7e\u00a7lInclude Default Tasks:")) {
            boolean current = this.plugin.getConfig().getBoolean("task_manager.include_default_tasks", true);
            this.plugin.getConfig().set("task_manager.include_default_tasks", (Object)(!current ? 1 : 0));
            this.plugin.saveConfig();
            TaskManagerMode taskMode = this.plugin.getTaskManagerMode();
            if (taskMode != null) {
                taskMode.reloadTasks();
            }
            this.guiManager.openCustomTasksMenu(player);
        } else if (name.equals("\u00a7a\u00a7lAdd New Task")) {
            this.guiManager.promptTaskInput(player, "id");
        } else if (name.equals("\u00a76\u00a7lReload Tasks")) {
            TaskManagerMode taskMode = this.plugin.getTaskManagerMode();
            if (taskMode != null) {
                taskMode.reloadTasks();
                player.sendMessage("\u00a7a[Task Manager] Tasks reloaded from config!");
            }
            this.guiManager.openCustomTasksMenu(player);
        } else if (name.startsWith("\u00a7e")) {
            String taskId = name.substring(2);
            TaskManagerMode taskMode = this.plugin.getTaskManagerMode();
            if (taskMode != null && taskMode.removeCustomTask(taskId)) {
                player.sendMessage("\u00a7e[Task Manager] Removed task: " + taskId);
            }
            this.guiManager.openCustomTasksMenu(player);
        }
    }

    private void handleAdvancedConfigClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null || !clicked.hasItemMeta()) {
            return;
        }
        String id = this.getButtonId(clicked);
        if (id == null) {
            return;
        }
        try {
            if ("back_settings".equals(id)) {
                this.guiManager.openSettingsMenu(player);
                return;
            }
            if ("advanced_config_root".equals(id)) {
                this.guiManager.openAdvancedConfigMenu(player, "", 0);
                return;
            }
            if (id.startsWith("cfg:nav:")) {
                String path = id.substring("cfg:nav:".length());
                this.guiManager.openAdvancedConfigMenu(player, path, 0);
                return;
            }
            if (id.startsWith("cfg:page:")) {
                String rest = id.substring("cfg:page:".length());
                int idx = rest.lastIndexOf(58);
                String path = idx >= 0 ? rest.substring(0, idx) : "";
                int page = idx >= 0 ? Integer.parseInt(rest.substring(idx + 1)) : 0;
                this.guiManager.openAdvancedConfigMenu(player, path, page);
                return;
            }
            if (id.startsWith("cfg:bool:")) {
                String path = id.substring("cfg:bool:".length());
                boolean cur = this.plugin.getConfig().getBoolean(path, false);
                this.plugin.getConfig().set(path, (Object)(!cur ? 1 : 0));
                this.plugin.saveConfig();
                this.guiManager.openAdvancedConfigMenu(player, this.getParentPath(path), 0);
                return;
            }
            if (id.startsWith("cfg:num:")) {
                double delta;
                String path = id.substring("cfg:num:".length());
                Object val = this.plugin.getConfig().get(path);
                double num = 0.0;
                if (val instanceof Number) {
                    Number n = (Number)val;
                    num = n.doubleValue();
                }
                double d = delta = event.isShiftClick() ? 10.0 : 1.0;
                if (event.isLeftClick()) {
                    num += delta;
                }
                if (event.isRightClick()) {
                    num -= delta;
                }
                if (val instanceof Integer || Math.rint(num) == num) {
                    this.plugin.getConfig().set(path, (Object)((int)Math.round(num)));
                } else {
                    this.plugin.getConfig().set(path, (Object)num);
                }
                this.plugin.saveConfig();
                this.guiManager.openAdvancedConfigMenu(player, this.getParentPath(path), 0);
                return;
            }
            if (id.startsWith("cfg:str:")) {
                String path = id.substring("cfg:str:".length());
                this.plugin.getChatInputHandler().expectConfigString(player, path);
                player.closeInventory();
                player.sendMessage("\u00a7e[Config] Enter new value for \u00a7f" + path + " \u00a77(type 'cancel' to abort)");
                return;
            }
            if (id.startsWith("cfg:list:")) {
                String path = id.substring("cfg:list:".length());
                this.guiManager.openConfigListEditor(player, path, 0);
                return;
            }
        }
        catch (Exception ex) {
            player.sendMessage("\u00a7c[Config] Error: " + ex.getMessage());
        }
    }

    private void handleConfigListClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null || !clicked.hasItemMeta()) {
            return;
        }
        String id = this.getButtonId(clicked);
        if (id == null) {
            return;
        }
        try {
            if (id.startsWith("cfg:nav:")) {
                String parent = id.substring("cfg:nav:".length());
                this.guiManager.openAdvancedConfigMenu(player, parent == null ? "" : parent, 0);
                return;
            }
            if (id.startsWith("cfg:list_add:")) {
                String path = id.substring("cfg:list_add:".length());
                this.plugin.getChatInputHandler().expectConfigListAdd(player, path);
                player.closeInventory();
                player.sendMessage("\u00a7e[Config] Enter list item to add to \u00a7f" + path + " \u00a77(type 'cancel' to abort)");
                return;
            }
            if (id.startsWith("cfg:list_del:")) {
                String rest = id.substring("cfg:list_del:".length());
                int idx = rest.lastIndexOf(58);
                String path = rest.substring(0, idx);
                int index = Integer.parseInt(rest.substring(idx + 1));
                List list = this.plugin.getConfig().getStringList(path);
                if (index >= 0 && index < list.size()) {
                    list.remove(index);
                    this.plugin.getConfig().set(path, (Object)list);
                    this.plugin.saveConfig();
                }
                this.guiManager.openConfigListEditor(player, path, 0);
                return;
            }
            if (id.startsWith("cfg:list_page:")) {
                String rest = id.substring("cfg:list_page:".length());
                int idx = rest.lastIndexOf(58);
                String path = rest.substring(0, idx);
                int page = Integer.parseInt(rest.substring(idx + 1));
                this.guiManager.openConfigListEditor(player, path, page);
                return;
            }
        }
        catch (Exception ex) {
            player.sendMessage("\u00a7c[Config] Error: " + ex.getMessage());
        }
    }

    private String getParentPath(String path) {
        if (path == null || path.isEmpty()) {
            return "";
        }
        int idx = path.lastIndexOf(46);
        return idx < 0 ? "" : path.substring(0, idx);
    }

    private void handleTaskSettingsClick(InventoryClickEvent event) {
        String name;
        Player player = (Player)event.getWhoClicked();
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null || !clicked.hasItemMeta()) {
            return;
        }
        String buttonId = this.getButtonId(clicked);
        if (buttonId != null) {
            switch (buttonId) {
                case "reroll_tasks": {
                    if (this.plugin.getGameManager().isGameRunning()) {
                        player.sendMessage("\u00a7cYou can only reroll before the game starts.");
                        return;
                    }
                    if (this.plugin.getCurrentMode() != SpeedrunnerSwap.SwapMode.TASK) {
                        player.sendMessage("\u00a7cSwitch to Task Manager mode first: /swap mode task");
                        return;
                    }
                    TaskManagerMode tmm = this.plugin.getTaskManagerMode();
                    if (tmm == null) {
                        player.sendMessage("\u00a7cTask Manager not initialized.");
                        return;
                    }
                    ArrayList<Player> selectedRunners = new ArrayList<Player>();
                    for (Player p : Bukkit.getOnlinePlayers()) {
                        PlayerState st = this.plugin.getGameManager().getPlayerState(p);
                        if (st == null || st.getSelectedTeam() != Team.RUNNER) continue;
                        selectedRunners.add(p);
                    }
                    if (selectedRunners.isEmpty()) {
                        player.sendMessage("\u00a7cNo selected runners found. Use the Team Selector first.");
                        return;
                    }
                    tmm.assignAndAnnounceTasks(selectedRunners);
                    player.sendMessage("\u00a7aRerolled tasks for \u00a7f" + selectedRunners.size() + "\u00a7a selected runners.");
                    this.guiManager.openTaskSettingsMenu(player);
                    return;
                }
                case "show_assignments": {
                    TaskManagerMode tmm = this.plugin.getTaskManagerMode();
                    if (tmm == null) {
                        player.sendMessage("\u00a7cTask Manager not initialized.");
                        return;
                    }
                    Map<UUID, String> map = tmm.getAssignments();
                    if (map.isEmpty()) {
                        player.sendMessage("\u00a77No task assignments.");
                        return;
                    }
                    player.sendMessage("\u00a76Task Assignments:");
                    for (Map.Entry<UUID, String> e : map.entrySet()) {
                        TaskDefinition def;
                        UUID uuid = e.getKey();
                        String taskId = e.getValue();
                        String pname = this.plugin.getServer().getOfflinePlayer(uuid).getName();
                        if (pname == null) {
                            pname = uuid.toString().substring(0, 8);
                        }
                        String desc = (def = tmm.getTask(taskId)) != null ? def.description() : taskId;
                        player.sendMessage("\u00a7e" + pname + "\u00a77: \u00a7f" + desc + " (\u00a78" + taskId + "\u00a77)");
                    }
                    return;
                }
            }
        }
        switch (name = GuiCompat.getDisplayName(clicked.getItemMeta())) {
            case "\u00a77\u00a7lBack": {
                this.guiManager.openTaskManagerMenu(player);
                break;
            }
            case "\u00a7e\u00a7lPause On Disconnect: \u00a7aEnabled": 
            case "\u00a7e\u00a7lPause On Disconnect: \u00a7cDisabled": {
                boolean cur = this.plugin.getConfig().getBoolean("task_manager.pause_on_disconnect", true);
                this.plugin.getConfig().set("task_manager.pause_on_disconnect", (Object)(!cur ? 1 : 0));
                this.plugin.saveConfig();
                break;
            }
            case "\u00a7e\u00a7lRemove On Timeout: \u00a7aYes": 
            case "\u00a7e\u00a7lRemove On Timeout: \u00a7cNo": {
                boolean cur = this.plugin.getConfig().getBoolean("task_manager.remove_on_timeout", true);
                this.plugin.getConfig().set("task_manager.remove_on_timeout", (Object)(!cur ? 1 : 0));
                this.plugin.saveConfig();
                break;
            }
            case "\u00a7e\u00a7lAllow Late Joiners: \u00a7aYes": 
            case "\u00a7e\u00a7lAllow Late Joiners: \u00a7cNo": {
                boolean cur = this.plugin.getConfig().getBoolean("task_manager.allow_late_joiners", false);
                this.plugin.getConfig().set("task_manager.allow_late_joiners", (Object)(!cur ? 1 : 0));
                this.plugin.saveConfig();
                break;
            }
            case "\u00a7e\u00a7lEnd When One Left: \u00a7aYes": 
            case "\u00a7e\u00a7lEnd When One Left: \u00a7cNo": {
                boolean cur = this.plugin.getConfig().getBoolean("task_manager.end_when_one_left", false);
                this.plugin.getConfig().set("task_manager.end_when_one_left", (Object)(!cur ? 1 : 0));
                this.plugin.saveConfig();
                break;
            }
            case "\u00a76\u00a7lRejoin Grace (s)": {
                int delta;
                int val = this.plugin.getConfig().getInt("task_manager.rejoin_grace_seconds", 180);
                int n = delta = event.isShiftClick() ? 30 : 10;
                if (event.isLeftClick()) {
                    val += delta;
                }
                if (event.isRightClick()) {
                    val -= delta;
                }
                val = Math.max(10, Math.min(3600, val));
                this.plugin.getConfig().set("task_manager.rejoin_grace_seconds", (Object)val);
                this.plugin.saveConfig();
                break;
            }
            case "\u00a76\u00a7lReload Tasks": {
                TaskManagerMode tmm = this.plugin.getTaskManagerMode();
                if (tmm != null) {
                    tmm.reloadTasks();
                }
                player.sendMessage("[Task Manager] Reloaded tasks.");
                break;
            }
        }
        this.guiManager.openTaskSettingsMenu(player);
    }

    private void handleDreamSettingsClick(InventoryClickEvent event) {
        String name;
        Player player = (Player)event.getWhoClicked();
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null || !clicked.hasItemMeta()) {
            return;
        }
        String id = this.getButtonId(clicked);
        if (id != null) {
            switch (id) {
                case "back_settings": {
                    this.guiManager.openDreamMenu(player);
                    return;
                }
                case "dream_tracker_toggle": {
                    boolean enabled = this.plugin.getConfigManager().isTrackerEnabled();
                    this.plugin.getConfigManager().setTrackerEnabled(!enabled);
                    if (!enabled) {
                        this.plugin.getTrackerManager().startTracking();
                        for (Player hunter : this.plugin.getGameManager().getHunters()) {
                            if (!hunter.isOnline()) continue;
                            this.plugin.getTrackerManager().giveTrackingCompass(hunter);
                        }
                        break;
                    }
                    this.plugin.getTrackerManager().stopTracking();
                    break;
                }
                case "dream_single_sleep_toggle": {
                    boolean enabled = this.plugin.getConfigManager().isSinglePlayerSleepEnabled();
                    this.plugin.getConfigManager().setSinglePlayerSleepEnabled(!enabled);
                    break;
                }
            }
            this.guiManager.openDreamSettingsMenu(player);
            return;
        }
        switch (name = GuiCompat.getDisplayName(clicked.getItemMeta())) {
            case "\u00a77\u00a7lBack": {
                this.guiManager.openDreamMenu(player);
                break;
            }
            case "\u00a7e\u00a7lTracker: \u00a7aEnabled": 
            case "\u00a7e\u00a7lTracker: \u00a7cDisabled": {
                boolean en = this.plugin.getConfigManager().isTrackerEnabled();
                this.plugin.getConfigManager().setTrackerEnabled(!en);
                break;
            }
            case "\u00a7e\u00a7lSingle Player Sleep: \u00a7aEnabled": 
            case "\u00a7e\u00a7lSingle Player Sleep: \u00a7cDisabled": {
                boolean en = this.plugin.getConfigManager().isSinglePlayerSleepEnabled();
                this.plugin.getConfigManager().setSinglePlayerSleepEnabled(!en);
                break;
            }
        }
        this.guiManager.openDreamSettingsMenu(player);
    }

    private void handleStatisticsClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null || !clicked.hasItemMeta()) {
            return;
        }
        String id = this.getButtonId(clicked);
        if (id != null) {
            switch (id) {
                case "toggle_stats": {
                    boolean statsEnabled = this.plugin.getConfig().getBoolean("stats.enabled", true);
                    this.plugin.getConfig().set("stats.enabled", (Object)(!statsEnabled ? 1 : 0));
                    this.plugin.saveConfig();
                    break;
                }
                case "toggle_distance_tracking": {
                    boolean distanceTracking = this.plugin.getConfig().getBoolean("stats.distance_tracking", true);
                    this.plugin.getConfig().set("stats.distance_tracking", (Object)(!distanceTracking ? 1 : 0));
                    this.plugin.saveConfig();
                    break;
                }
                case "stats_update_rate": {
                    int delta;
                    int ticks = this.plugin.getConfig().getInt("stats.distance_update_ticks", 20);
                    int n = delta = event.isShiftClick() ? 20 : 5;
                    if (event.isLeftClick()) {
                        ticks += delta;
                    }
                    if (event.isRightClick()) {
                        ticks -= delta;
                    }
                    ticks = Math.max(1, Math.min(200, ticks));
                    this.plugin.getConfig().set("stats.distance_update_ticks", (Object)ticks);
                    this.plugin.saveConfig();
                    break;
                }
            }
            this.guiManager.openStatisticsMenu(player);
        }
    }

    private void handleEffectsMenuClick(InventoryClickEvent event, String title) {
        Player player = (Player)event.getWhoClicked();
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null || !clicked.hasItemMeta()) {
            return;
        }
        List<String> lore = GuiCompat.getLore(clicked.getItemMeta());
        if (lore == null) {
            return;
        }
        String effectId = null;
        for (String text : lore) {
            int idx = text.indexOf("Effect ID:");
            if (idx < 0) continue;
            int split = text.indexOf(58);
            if (split < 0 || split + 1 >= text.length()) break;
            effectId = text.substring(split + 1).trim();
            effectId = effectId.replaceAll("\u00a7[0-9A-FK-ORa-fk-or]", "");
            break;
        }
        if (effectId == null || effectId.isEmpty()) {
            return;
        }
        boolean positive = title.contains("Positive Effects");
        ArrayList<String> list = new ArrayList<String>(positive ? this.plugin.getConfig().getStringList("power_ups.good_effects") : this.plugin.getConfig().getStringList("power_ups.bad_effects"));
        if (list.contains(effectId)) {
            list.remove(effectId);
        } else {
            list.add(effectId);
        }
        if (positive) {
            this.plugin.getConfig().set("power_ups.good_effects", list);
        } else {
            this.plugin.getConfig().set("power_ups.bad_effects", list);
        }
        this.plugin.saveConfig();
        if (positive) {
            this.guiManager.openPositiveEffectsMenu(player);
        } else {
            this.guiManager.openNegativeEffectsMenu(player);
        }
    }

    private void handleBroadcastSettingsClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null || !clicked.hasItemMeta()) {
            return;
        }
        String id = this.getButtonId(clicked);
        if (id != null) {
            switch (id) {
                case "back_settings": {
                    this.guiManager.openSettingsMenu(player);
                    return;
                }
                case "toggle_broadcasts": {
                    boolean current = this.plugin.getConfig().getBoolean("broadcasts.enabled", true);
                    this.plugin.getConfig().set("broadcasts.enabled", (Object)(!current ? 1 : 0));
                    this.plugin.saveConfig();
                    break;
                }
                case "toggle_game_events": {
                    boolean current = this.plugin.getConfig().getBoolean("broadcasts.game_events", true);
                    this.plugin.getConfig().set("broadcasts.game_events", (Object)(!current ? 1 : 0));
                    this.plugin.saveConfig();
                    break;
                }
                case "toggle_team_changes": {
                    boolean current = this.plugin.getConfig().getBoolean("broadcasts.team_changes", true);
                    this.plugin.getConfig().set("broadcasts.team_changes", (Object)(!current ? 1 : 0));
                    this.plugin.saveConfig();
                }
            }
        }
        this.guiManager.openBroadcastSettingsMenu(player);
    }

    private void handleLimboSettingsClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null || !clicked.hasItemMeta()) {
            return;
        }
        String id = this.getButtonId(clicked);
        if (id != null) {
            switch (id) {
                case "back_settings": {
                    this.guiManager.openSettingsMenu(player);
                    return;
                }
                case "limbo_world": {
                    this.plugin.getChatInputHandler().expectConfigString(player, "limbo.world");
                    player.closeInventory();
                    player.sendMessage("\u00a7e[Config] Enter world name for limbo \u00a77(type 'cancel' to abort)");
                    return;
                }
                case "limbo_coords": {
                    this.plugin.getChatInputHandler().expectConfigString(player, "limbo.coords");
                    player.closeInventory();
                    player.sendMessage("\u00a7e[Config] Enter coordinates as 'x,y,z' \u00a77(type 'cancel' to abort)");
                    return;
                }
                case "limbo_set_current": {
                    this.plugin.getConfig().set("limbo.world", (Object)player.getWorld().getName());
                    this.plugin.getConfig().set("limbo.x", (Object)player.getLocation().getX());
                    this.plugin.getConfig().set("limbo.y", (Object)player.getLocation().getY());
                    this.plugin.getConfig().set("limbo.z", (Object)player.getLocation().getZ());
                    this.plugin.saveConfig();
                    player.sendMessage("\u00a7aLimbo location set to your current position!");
                }
            }
        }
        this.guiManager.openLimboSettingsMenu(player);
    }

    private void handleUIPerformanceClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null || !clicked.hasItemMeta()) {
            return;
        }
        String id = this.getButtonId(clicked);
        if (id != null) {
            switch (id) {
                case "back_settings": {
                    this.guiManager.openSettingsMenu(player);
                    return;
                }
                case "actionbar_rate": {
                    int current = this.plugin.getConfig().getInt("ui.update_ticks.actionbar", 20);
                    if (event.isLeftClick()) {
                        current += 5;
                    }
                    if (event.isRightClick()) {
                        current -= 5;
                    }
                    current = Math.max(1, Math.min(200, current));
                    this.plugin.getConfig().set("ui.update_ticks.actionbar", (Object)current);
                    this.plugin.saveConfig();
                    break;
                }
                case "title_rate": {
                    int current = this.plugin.getConfig().getInt("ui.update_ticks.title", 10);
                    if (event.isLeftClick()) {
                        current += 5;
                    }
                    if (event.isRightClick()) {
                        current -= 5;
                    }
                    current = Math.max(1, Math.min(200, current));
                    this.plugin.getConfig().set("ui.update_ticks.title", (Object)current);
                    this.plugin.saveConfig();
                    break;
                }
                case "tracker_rate": {
                    int current = this.plugin.getConfig().getInt("tracker.update_ticks", 20);
                    if (event.isLeftClick()) {
                        current += 5;
                    }
                    if (event.isRightClick()) {
                        current -= 5;
                    }
                    current = Math.max(1, Math.min(200, current));
                    this.plugin.getConfig().set("tracker.update_ticks", (Object)current);
                    this.plugin.saveConfig();
                    break;
                }
                case "performance_info": {
                    player.sendMessage("\u00a76=== UI Performance Tips ===");
                    player.sendMessage("\u00a77Lower tick values = more responsive UI but higher CPU usage");
                    player.sendMessage("\u00a77Higher tick values = less responsive UI but better performance");
                    player.sendMessage("\u00a77Recommended range: 10-20 ticks (0.5-1 second)");
                    return;
                }
            }
        }
        this.guiManager.openUIPerformanceMenu(player);
    }
}

