/*
 * Decompiled with CFR 0.152.
 */
package com.example.speedrunnerswap.gui;

import com.example.speedrunnerswap.SpeedrunnerSwap;
import com.example.speedrunnerswap.gui.ControlGui;
import com.example.speedrunnerswap.models.Team;
import com.example.speedrunnerswap.task.TaskDefinition;
import com.example.speedrunnerswap.task.TaskManagerMode;
import com.example.speedrunnerswap.utils.GuiCompat;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class GuiManager {
    private final SpeedrunnerSwap plugin;
    private final String BACK_BUTTON_TITLE = "\u00a7c\u00a7lBack to Main Menu";
    private final Set<UUID> pendingOpens = Collections.synchronizedSet(new HashSet());
    private static final String BUTTON_ID_KEY = "ssw_button_id";

    public GuiManager(SpeedrunnerSwap plugin) {
        this.plugin = plugin;
    }

    private void openInventorySoon(Player player, Inventory inv) {
        if (player == null || inv == null) {
            return;
        }
        UUID uuid = player.getUniqueId();
        if (this.pendingOpens.contains(uuid)) {
            return;
        }
        this.pendingOpens.add(uuid);
        this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
            try {
                if (player.isOnline()) {
                    this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                        if (player.isOnline()) {
                            player.openInventory(inv);
                        }
                        this.pendingOpens.remove(uuid);
                    }, 1L);
                } else {
                    this.pendingOpens.remove(uuid);
                }
            }
            catch (Exception e) {
                this.pendingOpens.remove(uuid);
                this.plugin.getLogger().warning("Failed to open inventory for " + player.getName() + ": " + e.getMessage());
            }
        });
    }

    public void openDirectGamemodeSelector(Player player) {
        int rows = 3;
        Inventory inv = GuiCompat.createInventory(null, rows * 9, "\u00a76\u00a7lSpeedrunner Swap - Choose Gamemode");
        ItemStack filler = this.createItem(Material.BLACK_STAINED_GLASS_PANE, " ", new String[0]);
        this.fillBorder(inv, filler);
        String currentMode = this.plugin.getCurrentMode().name();
        ArrayList<String> dreamLore = new ArrayList<String>();
        dreamLore.add("\u00a7e\u00a7lSpeedrunners \u00a77+ \u00a7c\u00a7lHunters");
        dreamLore.add("\u00a77Classic manhunt with tracking & PvP");
        dreamLore.add("");
        dreamLore.add("\u00a7b\u2022 \u00a77Hunters track runners with compasses");
        dreamLore.add("\u00a7b\u2022 \u00a77Power-ups, world border, bounties");
        dreamLore.add("\u00a7b\u2022 \u00a77Team vs team competition");
        dreamLore.add("");
        dreamLore.add("\u00a7a\u00a7lClick to open Dream menu directly!");
        if (currentMode.equals("DREAM")) {
            dreamLore.add("\u00a7e\u25cf Currently Selected Mode");
        }
        ItemStack dream = this.createGuiButton(Material.DIAMOND_SWORD, "\u00a7a\u00a7lDream: Speedrunners vs Hunters", dreamLore, "direct_dream_menu");
        if (currentMode.equals("DREAM")) {
            dream = this.createGlowingItem(dream);
        }
        inv.setItem(11, dream);
        ArrayList<String> sapLore = new ArrayList<String>();
        sapLore.add("\u00a7b\u00a7lMulti-Runner Cooperation");
        sapLore.add("\u00a77Pure teamwork - no hunters!");
        sapLore.add("");
        sapLore.add("\u00a7b\u2022 \u00a77Share one character between runners");
        sapLore.add("\u00a7b\u2022 \u00a77Cooperative dragon defeat");
        sapLore.add("\u00a7b\u2022 \u00a77Queue-based rotation system");
        sapLore.add("");
        sapLore.add("\u00a7a\u00a7lClick to open Sapnap menu directly!");
        if (currentMode.equals("SAPNAP")) {
            sapLore.add("\u00a7e\u25cf Currently Selected Mode");
        }
        ItemStack sapnap = this.createGuiButton(Material.DIAMOND_BOOTS, "\u00a7b\u00a7lSapnap: Multi-Runner Swap", sapLore, "direct_sapnap_menu");
        if (currentMode.equals("SAPNAP")) {
            sapnap = this.createGlowingItem(sapnap);
        }
        inv.setItem(13, sapnap);
        ArrayList<String> taskLore = new ArrayList<String>();
        taskLore.add("\u00a7d\u00a7lSecret Task Competition");
        taskLore.add("\u00a77Each runner gets hidden objectives");
        taskLore.add("");
        taskLore.add("\u00a7b\u2022 \u00a77Individual secret tasks");
        taskLore.add("\u00a7b\u2022 \u00a77First to complete wins");
        taskLore.add("\u00a7b\u2022 \u00a77Customizable task pool");
        taskLore.add("");
        taskLore.add("\u00a7a\u00a7lClick to open Task Manager menu directly!");
        if (currentMode.equals("TASK")) {
            taskLore.add("\u00a7e\u25cf Currently Selected Mode");
        }
        ItemStack taskMode = this.createGuiButton(Material.TARGET, "\u00a76\u00a7lTask Manager Swap", taskLore, "direct_task_menu");
        if (currentMode.equals("TASK")) {
            taskMode = this.createGlowingItem(taskMode);
        }
        inv.setItem(15, taskMode);
        this.openInventorySoon(player, inv);
    }

    public void openResetConfirmMenu(Player player) {
        Inventory inv = GuiCompat.createInventory(null, 9, "\u00a74\u00a7lConfirm Reset All Settings");
        ItemStack filler = this.createItem(Material.BLACK_STAINED_GLASS_PANE, " ", new String[0]);
        for (int i = 0; i < inv.getSize(); ++i) {
            inv.setItem(i, filler);
        }
        inv.setItem(0, this.createGuiButton(Material.ARROW, "\u00a77\u00a7lBack", List.of("\u00a77Return"), "reset_confirm_no"));
        inv.setItem(3, this.createGuiButton(Material.EMERALD_BLOCK, "\u00a7a\u00a7lCancel", List.of("\u00a77Do nothing"), "reset_confirm_no"));
        inv.setItem(5, this.createGuiButton(Material.REDSTONE_BLOCK, "\u00a7c\u00a7lConfirm Reset", List.of("\u00a77Restore defaults from jar", "\u00a7cThis cannot be undone!"), "reset_confirm_yes"));
        this.openInventorySoon(player, inv);
    }

    public void openModeSelector(Player player) {
        int rows = 3;
        Inventory inv = GuiCompat.createInventory(null, rows * 9, "\u00a76\u00a7lSpeedrunner Swap - Mode Selection");
        ItemStack filler = this.createItem(Material.BLACK_STAINED_GLASS_PANE, " ", new String[0]);
        this.fillBorder(inv, filler);
        boolean gameRunning = this.plugin.getGameManager().isGameRunning();
        String currentMode = this.plugin.getCurrentMode().name();
        ArrayList<String> dreamLore = new ArrayList<String>();
        dreamLore.add("\u00a7e\u00a7lSpeedrunners \u00a77+ \u00a7c\u00a7lHunters");
        dreamLore.add("\u00a77Classic manhunt with tracking & PvP");
        dreamLore.add("");
        dreamLore.add("\u00a7b\u2022 \u00a77Hunters track runners with compasses");
        dreamLore.add("\u00a7b\u2022 \u00a77Power-ups, world border, bounties");
        dreamLore.add("\u00a7b\u2022 \u00a77Team vs team competition");
        if (currentMode.equals("DREAM")) {
            dreamLore.add("");
            dreamLore.add(gameRunning ? "\u00a7a\u25b6 Currently Active" : "\u00a7e\u25cf Currently Selected");
        }
        ItemStack dream = this.createGuiButton(Material.DIAMOND_SWORD, "\u00a7a\u00a7lDream: Speedrunners vs Hunters", dreamLore, "mode_dream");
        if (currentMode.equals("DREAM")) {
            dream = this.createGlowingItem(dream);
        }
        inv.setItem(11, dream);
        ArrayList<String> sapLore = new ArrayList<String>();
        sapLore.add("\u00a7b\u00a7lMulti-Runner Cooperation");
        sapLore.add("\u00a77Pure teamwork - no hunters!");
        sapLore.add("");
        sapLore.add("\u00a7b\u2022 \u00a77Share one character between runners");
        sapLore.add("\u00a7b\u2022 \u00a77Cooperative dragon defeat");
        sapLore.add("\u00a7b\u2022 \u00a77Queue-based rotation system");
        if (currentMode.equals("SAPNAP")) {
            sapLore.add("");
            sapLore.add(gameRunning ? "\u00a7a\u25b6 Currently Active" : "\u00a7e\u25cf Currently Selected");
        }
        ItemStack sapnap = this.createGuiButton(Material.DIAMOND_BOOTS, "\u00a7b\u00a7lSapnap: Multi-Runner Swap", sapLore, "mode_sapnap");
        if (currentMode.equals("SAPNAP")) {
            sapnap = this.createGlowingItem(sapnap);
        }
        inv.setItem(13, sapnap);
        ArrayList<String> taskLore = new ArrayList<String>();
        taskLore.add("\u00a7d\u00a7lSecret Task Competition");
        taskLore.add("\u00a77Each runner gets hidden objectives");
        taskLore.add("");
        taskLore.add("\u00a7b\u2022 \u00a77Individual secret tasks");
        taskLore.add("\u00a7b\u2022 \u00a77First to complete wins");
        taskLore.add("\u00a7b\u2022 \u00a77Customizable task pool");
        if (currentMode.equals("TASK")) {
            taskLore.add("");
            taskLore.add(gameRunning ? "\u00a7a\u25b6 Currently Active" : "\u00a7e\u25cf Currently Selected");
        }
        ItemStack taskMode = this.createGuiButton(Material.TARGET, "\u00a76\u00a7lTask Manager Swap", taskLore, "mode_task");
        if (currentMode.equals("TASK")) {
            taskMode = this.createGlowingItem(taskMode);
        }
        inv.setItem(15, taskMode);
        if (gameRunning && player.hasPermission("speedrunnerswap.admin")) {
            List<String> forceLore = List.of("\u00a7cStop current game and switch modes", "\u00a77Admin-only quick mode switching");
            inv.setItem(22, this.createGuiButton(Material.BARRIER, "\u00a7c\u00a7lForce Stop & Switch", forceLore, "admin_force_stop"));
        } else if (gameRunning) {
            List<String> infoLore = List.of("\u00a77A game is currently running", "\u00a77Stop it before switching modes");
            inv.setItem(22, this.createItem(Material.PAPER, "\u00a7e\u00a7lGame In Progress", infoLore));
        }
        this.openInventorySoon(player, inv);
    }

    public void openForceConfirm(Player player, SpeedrunnerSwap.SwapMode target) {
        String name = target == SpeedrunnerSwap.SwapMode.SAPNAP ? "Sapnap" : "Dream";
        Inventory inv = GuiCompat.createInventory(null, 9, "\u00a74\u00a7lConfirm Mode Switch");
        ItemStack filler = this.createItem(Material.BLACK_STAINED_GLASS_PANE, " ", new String[0]);
        for (int i = 0; i < inv.getSize(); ++i) {
            inv.setItem(i, filler);
        }
        inv.setItem(0, this.createGuiButton(Material.ARROW, "\u00a77\u00a7lBack", List.of("\u00a77Return"), "back_mode"));
        String id = target == SpeedrunnerSwap.SwapMode.SAPNAP ? "force_yes_sapnap" : "force_yes_dream";
        ItemStack yes = this.createGuiButton(Material.REDSTONE_BLOCK, "\u00a7c\u00a7lConfirm", List.of("\u00a77End current game", "\u00a77Switch to \u00a7f" + name), id);
        ItemStack no = this.createGuiButton(Material.EMERALD_BLOCK, "\u00a7a\u00a7lCancel", List.of("\u00a77Do nothing"), "force_no");
        inv.setItem(3, no);
        inv.setItem(5, yes);
        this.openInventorySoon(player, inv);
    }

    public String formatTime(int seconds) {
        int minutes = seconds / 60;
        int hours = minutes / 60;
        minutes %= 60;
        seconds %= 60;
        if (hours > 0) {
            return String.format("%dh %dm %ds", hours, minutes, seconds);
        }
        if (minutes > 0) {
            return String.format("%dm %ds", minutes, seconds);
        }
        return String.format("%ds", seconds);
    }

    public void openDangerousBlocksMenu(Player player) {
        Inventory inv = GuiCompat.createInventory(null, 54, "\u00a76\u00a7lDangerous Blocks");
        ItemStack filler = this.createItem(Material.BLACK_STAINED_GLASS_PANE, " ", new String[0]);
        this.fillBorder(inv, filler);
        inv.setItem(0, this.createItem(Material.ARROW, "\u00a77\u00a7lBack", List.of("\u00a77Return to settings")));
        Set<Material> set = this.plugin.getConfigManager().getDangerousBlocks();
        int slot = 10;
        for (Material mat : Material.values()) {
            if (slot >= 44) break;
            if (!set.contains(mat)) continue;
            ItemStack it = this.createItem(mat, "\u00a7e" + mat.name(), List.of("\u00a77Click to remove from list"));
            inv.setItem(slot++, it);
        }
        inv.setItem(49, this.createItem(Material.PAPER, "\u00a77Note", List.of("\u00a77To add new blocks, use config.yml", "\u00a77GUI supports removal quickly")));
        this.openInventorySoon(player, inv);
    }

    public void openPositiveEffectsMenu(Player player) {
        Inventory inventory = GuiCompat.createInventory(null, 36, "\u00a7a\u00a7lPositive Effects");
        ItemStack filler = this.createItem(Material.BLACK_STAINED_GLASS_PANE, " ", new String[0]);
        this.fillBorder(inventory, filler);
        ArrayList<ItemStack> effectItems = new ArrayList<ItemStack>();
        effectItems.add(this.createEffectItem(Material.POTION, "Speed", "SPEED"));
        effectItems.add(this.createEffectItem(Material.POTION, "Jump Boost", "JUMP"));
        effectItems.add(this.createEffectItem(Material.POTION, "Strength", "INCREASE_DAMAGE"));
        effectItems.add(this.createEffectItem(Material.POTION, "Regeneration", "REGENERATION"));
        effectItems.add(this.createEffectItem(Material.POTION, "Resistance", "DAMAGE_RESISTANCE"));
        effectItems.add(this.createEffectItem(Material.POTION, "Fire Resistance", "FIRE_RESISTANCE"));
        effectItems.add(this.createEffectItem(Material.POTION, "Water Breathing", "WATER_BREATHING"));
        effectItems.add(this.createEffectItem(Material.POTION, "Night Vision", "NIGHT_VISION"));
        for (int i = 0; i < effectItems.size(); ++i) {
            inventory.setItem(10 + i, (ItemStack)effectItems.get(i));
        }
        inventory.setItem(35, this.createItem(Material.BARRIER, "\u00a7c\u00a7lBack to Main Menu", new String[0]));
        this.openInventorySoon(player, inventory);
    }

    public void openNegativeEffectsMenu(Player player) {
        Inventory inventory = GuiCompat.createInventory(null, 36, "\u00a7c\u00a7lNegative Effects");
        ItemStack filler = this.createItem(Material.BLACK_STAINED_GLASS_PANE, " ", new String[0]);
        this.fillBorder(inventory, filler);
        ArrayList<ItemStack> effectItems = new ArrayList<ItemStack>();
        effectItems.add(this.createEffectItem(Material.POTION, "Slowness", "SLOW"));
        effectItems.add(this.createEffectItem(Material.POTION, "Weakness", "WEAKNESS"));
        effectItems.add(this.createEffectItem(Material.POTION, "Poison", "POISON"));
        effectItems.add(this.createEffectItem(Material.POTION, "Blindness", "BLINDNESS"));
        effectItems.add(this.createEffectItem(Material.POTION, "Hunger", "HUNGER"));
        effectItems.add(this.createEffectItem(Material.POTION, "Mining Fatigue", "SLOW_DIGGING"));
        effectItems.add(this.createEffectItem(Material.POTION, "Nausea", "CONFUSION"));
        effectItems.add(this.createEffectItem(Material.POTION, "Glowing", "GLOWING"));
        for (int i = 0; i < effectItems.size(); ++i) {
            inventory.setItem(10 + i, (ItemStack)effectItems.get(i));
        }
        inventory.setItem(35, this.createItem(Material.BARRIER, "\u00a7c\u00a7lBack to Main Menu", new String[0]));
        this.openInventorySoon(player, inventory);
    }

    public ItemStack createEffectItem(Material material, String displayName, String effectId) {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Effect ID: \u00a7f" + effectId);
        lore.add("\u00a77Click to toggle this effect");
        boolean isEnabled = this.plugin.getConfig().getStringList("power_ups.good_effects").contains(effectId) || this.plugin.getConfig().getStringList("power_ups.bad_effects").contains(effectId);
        lore.add(isEnabled ? "\u00a7aCurrently enabled" : "\u00a7cCurrently disabled");
        return this.createItem(material, "\u00a7e\u00a7l" + displayName, lore);
    }

    public void openPowerUpsMenu(Player player) {
        Inventory inventory = GuiCompat.createInventory(null, 36, "\u00a7e\u00a7lPower-ups Menu");
        ItemStack filler = this.createItem(Material.BLACK_STAINED_GLASS_PANE, " ", new String[0]);
        this.fillBorder(inventory, filler);
        ArrayList<String> powerUpToggleLore = new ArrayList<String>();
        boolean powerUpsEnabled = this.plugin.getConfigManager().isPowerUpsEnabled();
        powerUpToggleLore.add("\u00a77Current status: " + (powerUpsEnabled ? "\u00a7aEnabled" : "\u00a7cDisabled"));
        powerUpToggleLore.add("\u00a77Click to toggle");
        ItemStack toggleItem = this.createItem(powerUpsEnabled ? Material.LIME_DYE : Material.GRAY_DYE, "\u00a7e\u00a7lToggle Power-ups", powerUpToggleLore);
        inventory.setItem(4, toggleItem);
        ArrayList<String> positiveEffectsLore = new ArrayList<String>();
        positiveEffectsLore.add("\u00a77Current effects:");
        for (String effect : this.plugin.getConfig().getStringList("power_ups.good_effects")) {
            positiveEffectsLore.add("\u00a7a\u2022 " + effect.toLowerCase());
        }
        positiveEffectsLore.add("");
        positiveEffectsLore.add("\u00a77Click to modify");
        ItemStack goodEffectsItem = this.createItem(Material.SPLASH_POTION, "\u00a7a\u00a7lPositive Effects", positiveEffectsLore);
        inventory.setItem(11, goodEffectsItem);
        ArrayList<String> negativeEffectsLore = new ArrayList<String>();
        negativeEffectsLore.add("\u00a77Current effects:");
        for (String effect : this.plugin.getConfig().getStringList("power_ups.bad_effects")) {
            negativeEffectsLore.add("\u00a7c\u2022 " + effect.toLowerCase());
        }
        negativeEffectsLore.add("");
        negativeEffectsLore.add("\u00a77Click to modify");
        ItemStack badEffectsItem = this.createItem(Material.LINGERING_POTION, "\u00a7c\u00a7lNegative Effects", negativeEffectsLore);
        inventory.setItem(15, badEffectsItem);
        int minSec = this.plugin.getConfigManager().getPowerUpsMinSeconds();
        int maxSec = this.plugin.getConfigManager().getPowerUpsMaxSeconds();
        int minLvl = this.plugin.getConfigManager().getPowerUpsMinLevel();
        int maxLvl = this.plugin.getConfigManager().getPowerUpsMaxLevel();
        ArrayList<String> durationLore = new ArrayList<String>();
        durationLore.add("\u00a77Duration: \u00a7e" + minSec + "-" + maxSec + "s");
        durationLore.add("\u00a77Level: \u00a7e" + minLvl + "-" + maxLvl);
        durationLore.add("");
        durationLore.add("\u00a77Click to modify timings");
        ItemStack durationItem = this.createItem(Material.CLOCK, "\u00a76\u00a7lEffect Durations", durationLore);
        inventory.setItem(22, durationItem);
        inventory.setItem(31, this.createItem(Material.BARRIER, "\u00a7c\u00a7lBack to Main Menu", new String[0]));
        this.openInventorySoon(player, inventory);
    }

    public void openPowerUpDurationsMenu(Player player) {
        Inventory inv = GuiCompat.createInventory(null, 27, "\u00a76\u00a7lPower-up Durations");
        ItemStack filler = this.createItem(Material.GRAY_STAINED_GLASS_PANE, " ", new String[0]);
        this.fillBorder(inv, filler);
        ItemStack back = this.createItem(Material.ARROW, "\u00a77\u00a7lBack", List.of("\u00a77Return to power-ups"));
        inv.setItem(0, back);
        int minSec = this.plugin.getConfigManager().getPowerUpsMinSeconds();
        int maxSec = this.plugin.getConfigManager().getPowerUpsMaxSeconds();
        int minLvl = this.plugin.getConfigManager().getPowerUpsMinLevel();
        int maxLvl = this.plugin.getConfigManager().getPowerUpsMaxLevel();
        ItemStack minDur = this.createItem(Material.CLOCK, "\u00a7e\u00a7lMin Duration (s)", List.of("\u00a77Current: \u00a7f" + minSec, "\u00a77Left/Right: \u00b15"));
        ItemStack maxDur = this.createItem(Material.CLOCK, "\u00a7e\u00a7lMax Duration (s)", List.of("\u00a77Current: \u00a7f" + maxSec, "\u00a77Left/Right: \u00b15"));
        ItemStack minLvlItem = this.createItem(Material.EXPERIENCE_BOTTLE, "\u00a7e\u00a7lMin Level", List.of("\u00a77Current: \u00a7f" + minLvl, "\u00a77Left/Right: \u00b11"));
        ItemStack maxLvlItem = this.createItem(Material.EXPERIENCE_BOTTLE, "\u00a7e\u00a7lMax Level", List.of("\u00a77Current: \u00a7f" + maxLvl, "\u00a77Left/Right: \u00b11"));
        inv.setItem(10, minDur);
        inv.setItem(12, maxDur);
        inv.setItem(14, minLvlItem);
        inv.setItem(16, maxLvlItem);
        this.openInventorySoon(player, inv);
    }

    public void openWorldBorderMenu(Player player) {
        Inventory inventory = GuiCompat.createInventory(null, 27, "\u00a7c\u00a7lWorld Border Settings");
        ItemStack filler = this.createItem(Material.BLACK_STAINED_GLASS_PANE, " ", new String[0]);
        this.fillBorder(inventory, filler);
        boolean isEnabled = this.plugin.getConfig().getBoolean("world_border.enabled", true);
        ArrayList<String> toggleLore = new ArrayList<String>();
        toggleLore.add("\u00a77Current status: " + (isEnabled ? "\u00a7aEnabled" : "\u00a7cDisabled"));
        toggleLore.add("\u00a77Click to toggle");
        ItemStack toggleItem = this.createItem(isEnabled ? Material.LIME_DYE : Material.GRAY_DYE, "\u00a7e\u00a7lToggle World Border", toggleLore);
        inventory.setItem(4, toggleItem);
        int initialSize = this.plugin.getConfig().getInt("world_border.initial_size", 2000);
        ArrayList<String> initialSizeLore = new ArrayList<String>();
        initialSizeLore.add("\u00a77Current size: \u00a7e" + initialSize + " blocks");
        initialSizeLore.add("\u00a77Left-click: \u00a7a+100 blocks");
        initialSizeLore.add("\u00a77Right-click: \u00a7c-100 blocks");
        initialSizeLore.add("\u00a77Shift + Left-click: \u00a7a+500 blocks");
        initialSizeLore.add("\u00a77Shift + Right-click: \u00a7c-500 blocks");
        ItemStack initialSizeItem = this.createItem(Material.GRASS_BLOCK, "\u00a7a\u00a7lInitial Border Size", initialSizeLore);
        inventory.setItem(11, initialSizeItem);
        int finalSize = this.plugin.getConfig().getInt("world_border.final_size", 100);
        ArrayList<String> finalSizeLore = new ArrayList<String>();
        finalSizeLore.add("\u00a77Current size: \u00a7e" + finalSize + " blocks");
        finalSizeLore.add("\u00a77Left-click: \u00a7a+50 blocks");
        finalSizeLore.add("\u00a77Right-click: \u00a7c-50 blocks");
        finalSizeLore.add("\u00a77Shift + Left-click: \u00a7a+100 blocks");
        finalSizeLore.add("\u00a77Shift + Right-click: \u00a7c-100 blocks");
        ItemStack finalSizeItem = this.createItem(Material.BEDROCK, "\u00a7c\u00a7lFinal Border Size", finalSizeLore);
        inventory.setItem(13, finalSizeItem);
        int shrinkDuration = this.plugin.getConfig().getInt("world_border.shrink_duration", 1800);
        ArrayList<String> durationLore = new ArrayList<String>();
        durationLore.add("\u00a77Current duration: \u00a7e" + this.formatTime(shrinkDuration));
        durationLore.add("\u00a77Left-click: \u00a7a+5 minutes");
        durationLore.add("\u00a77Right-click: \u00a7c-5 minutes");
        durationLore.add("\u00a77Shift + Left-click: \u00a7a+15 minutes");
        durationLore.add("\u00a77Shift + Right-click: \u00a7c-15 minutes");
        ItemStack durationItem = this.createItem(Material.CLOCK, "\u00a76\u00a7lShrink Duration", durationLore);
        inventory.setItem(15, durationItem);
        int warningDistance = this.plugin.getConfig().getInt("world_border.warning_distance", 50);
        ArrayList<String> warningLore = new ArrayList<String>();
        warningLore.add("\u00a77Warning distance: \u00a7e" + warningDistance + " blocks");
        warningLore.add("\u00a77Warning interval: \u00a7e" + this.plugin.getConfig().getInt("world_border.warning_interval", 300) + " seconds");
        warningLore.add("\u00a77Click to modify warnings");
        ItemStack warningItem = this.createItem(Material.BELL, "\u00a7e\u00a7lWarning Settings", warningLore);
        inventory.setItem(22, warningItem);
        inventory.setItem(26, this.createItem(Material.BARRIER, "\u00a7c\u00a7lBack to Main Menu", new String[0]));
        this.openInventorySoon(player, inventory);
    }

    public void openMainMenu(Player player) {
        switch (this.plugin.getCurrentMode()) {
            case DREAM: {
                this.openDreamMenu(player);
                break;
            }
            case SAPNAP: {
                try {
                    new ControlGui(this.plugin).openMainMenu(player);
                }
                catch (Throwable t) {
                    player.sendMessage("\u00a7cFailed to open Sapnap menu: " + t.getMessage());
                    this.plugin.getLogger().warning("Sapnap GUI error: " + t.getMessage());
                }
                break;
            }
            case TASK: {
                this.openTaskManagerMenu(player);
            }
        }
    }

    public void openDreamMenu(Player player) {
        try {
            String title = "\u00a7a\u00a7lDream: Speedrunners vs Hunters";
            int rows = 6;
            Inventory inventory = GuiCompat.createInventory(null, rows * 9, title);
            ItemStack filler = this.createItem(Material.GREEN_STAINED_GLASS_PANE, " ", new String[0]);
            this.fillBorder(inventory, filler);
            boolean gameRunning = this.plugin.getGameManager().isGameRunning();
            boolean gamePaused = this.plugin.getGameManager().isGamePaused();
            int runnerCount = this.plugin.getGameManager().getRunners().size();
            int hunterCount = this.plugin.getGameManager().getHunters().size();
            inventory.setItem(0, this.createGuiButton(Material.ARROW, "\u00a77\u00a7lBack", List.of("\u00a77Return to mode selector"), "back_mode"));
            if (!gameRunning) {
                ArrayList<String> startLore = new ArrayList<String>();
                startLore.add("\u00a77Begin manhunt gameplay");
                if (runnerCount == 0 || hunterCount == 0) {
                    startLore.add("\u00a7cNeed both runners and hunters!");
                    startLore.add("\u00a7cRunners: " + runnerCount + ", Hunters: " + hunterCount);
                    inventory.setItem(10, this.createItem(Material.GRAY_CONCRETE, "\u00a7c\u00a7lCannot Start", startLore));
                } else {
                    startLore.add("\u00a77Ready: \u00a7b" + runnerCount + " runners\u00a77, \u00a7c" + hunterCount + " hunters");
                    startLore.add("\u00a77Swap interval: \u00a7e" + this.plugin.getConfigManager().getSwapInterval() + "s");
                    inventory.setItem(10, this.createGuiButton(Material.LIME_CONCRETE, "\u00a7a\u00a7lStart Hunt", startLore, "start_game"));
                }
            } else {
                ArrayList<String> stopLore = new ArrayList<String>();
                stopLore.add("\u00a77End current manhunt");
                stopLore.add("\u00a77Status: " + (gamePaused ? "\u00a7ePaused" : "\u00a7aRunning"));
                inventory.setItem(10, this.createGuiButton(Material.RED_CONCRETE, "\u00a7c\u00a7lStop Hunt", stopLore, "stop_game"));
            }
            if (gameRunning && !gamePaused) {
                inventory.setItem(11, this.createGuiButton(Material.YELLOW_CONCRETE, "\u00a7e\u00a7lPause Hunt", List.of("\u00a77Temporarily pause the game"), "pause_game"));
            } else if (gameRunning && gamePaused) {
                inventory.setItem(11, this.createGuiButton(Material.ORANGE_CONCRETE, "\u00a7a\u00a7lResume Hunt", List.of("\u00a77Resume the manhunt"), "resume_game"));
            } else {
                inventory.setItem(11, this.createItem(Material.GRAY_CONCRETE, "\u00a77Pause Hunt", List.of("\u00a77Game not running")));
            }
            ArrayList<String> statusLore = new ArrayList<String>();
            statusLore.add("\u00a77Current game information");
            statusLore.add("\u00a77Running: " + (gameRunning ? "\u00a7aYes" : "\u00a7cNo"));
            statusLore.add("\u00a77Runners: \u00a7b" + runnerCount);
            statusLore.add("\u00a77Hunters: \u00a7c" + hunterCount);
            if (gameRunning) {
                Player activeRunner = this.plugin.getGameManager().getActiveRunner();
                statusLore.add("\u00a77Active: \u00a7f" + (activeRunner != null ? activeRunner.getName() : "None"));
                statusLore.add("\u00a77Next Swap: \u00a7e" + this.plugin.getGameManager().getTimeUntilNextSwap() + "s");
            }
            inventory.setItem(13, this.createItem(Material.CLOCK, "\u00a76\u00a7lGame Status", statusLore));
            inventory.setItem(19, this.createGuiButton(Material.PLAYER_HEAD, "\u00a7e\u00a7lTeam Selector", List.of("\u00a77Assign players to Runner/Hunter teams", "\u00a77Current: \u00a7b" + runnerCount + " runners\u00a77, \u00a7c" + hunterCount + " hunters"), "team_selector"));
            inventory.setItem(21, this.createGuiButton(Material.COMPASS, "\u00a76\u00a7lHunter Tracking", List.of("\u00a77Configure compass tracking system", "\u00a77Current: " + (this.plugin.getConfigManager().isTrackerEnabled() ? "\u00a7aEnabled" : "\u00a7cDisabled"), "\u00a77\u00a7oHunters use compasses to find runners", "\u00a77\u00a7oAdjust update rate and jamming settings", "\u00a77\u00a7nClick to configure tracking"), "dream_tracking"));
            inventory.setItem(23, this.createGuiButton(Material.POTION, "\u00a7d\u00a7lPower-ups", List.of("\u00a77Random effects on swap", "\u00a77Current: " + (this.plugin.getConfigManager().isPowerUpsEnabled() ? "\u00a7aEnabled" : "\u00a7cDisabled"), "\u00a77\u00a7oBoth positive and negative effects", "\u00a77\u00a7oAdds unpredictability to gameplay", "\u00a77\u00a7nClick to configure effects"), "power_ups"));
            inventory.setItem(25, this.createGuiButton(Material.BARRIER, "\u00a7c\u00a7lWorld Border", List.of("\u00a77Shrinking world boundary", "\u00a77Forces final confrontation", "\u00a77\u00a7oGradually shrinks over time", "\u00a77\u00a7oCreates intense endgame scenarios", "\u00a77\u00a7nClick to configure border"), "world_border"));
            inventory.setItem(28, this.createGuiButton(Material.GOLD_INGOT, "\u00a76\u00a7lBounty System", List.of("\u00a77Special hunter rewards", "\u00a77Current: " + (this.plugin.getConfig().getBoolean("bounty.enabled", false) ? "\u00a7aEnabled" : "\u00a7cDisabled"), "\u00a77\u00a7oTarget specific runners for bonuses", "\u00a77\u00a7oGives glowing effect to targets", "\u00a77\u00a7nClick to configure bounties"), "bounty"));
            inventory.setItem(30, this.createGuiButton(Material.TOTEM_OF_UNDYING, "\u00a7e\u00a7lLast Stand", List.of("\u00a77Final runner power boost", "\u00a77Current: " + (this.plugin.getConfigManager().isLastStandEnabled() ? "\u00a7aEnabled" : "\u00a7cDisabled"), "\u00a77\u00a7oStrength and speed when low health", "\u00a77\u00a7oGives runners final fighting chance", "\u00a77\u00a7nClick to configure effects"), "last_stand"));
            inventory.setItem(32, this.createGuiButton(Material.DRAGON_HEAD, "\u00a74\u00a7lSudden Death", List.of("\u00a77End dimension final battle", "\u00a77Current: " + (this.plugin.getConfig().getBoolean("sudden_death.enabled", false) ? "\u00a7aEnabled" : "\u00a7cDisabled"), "\u00a77\u00a7oForces final showdown in The End", "\u00a77\u00a7oActivates after set time limit", "\u00a77\u00a7nClick to configure sudden death"), "sudden_death"));
            inventory.setItem(34, this.createGuiButton(Material.DIAMOND_CHESTPLATE, "\u00a7b\u00a7lCustom Kits", List.of("\u00a77Starting equipment setup", "\u00a77Current: " + (this.plugin.getConfigManager().isKitsEnabled() ? "\u00a7aEnabled" : "\u00a7cDisabled"), "\u00a77\u00a7oDifferent kits for each team", "\u00a77\u00a7oBalances early game advantages", "\u00a77\u00a7nClick to edit kits"), "kits"));
            inventory.setItem(40, this.createGuiButton(Material.REDSTONE, "\u00a76\u00a7lAdvanced Settings", List.of("\u00a77Access all configuration options", "\u00a77Swap intervals, timers, safety settings"), "advanced_settings"));
            inventory.setItem(42, this.createGuiButton(Material.BOOK, "\u00a7a\u00a7lStatistics", List.of("\u00a77View and manage game statistics", "\u00a77Track performance across games"), "statistics"));
            this.openInventorySoon(player, inventory);
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "Error opening Dream main menu", e);
            player.sendMessage("\u00a7cFailed to open Dream menu: " + e.getMessage());
        }
    }

    public void openTaskManagerMenu(Player player) {
        try {
            String title = "\u00a76\u00a7lTask Manager: Secret Missions";
            int rows = 6;
            Inventory inventory = GuiCompat.createInventory(null, rows * 9, title);
            ItemStack filler = this.createItem(Material.ORANGE_STAINED_GLASS_PANE, " ", new String[0]);
            this.fillBorder(inventory, filler);
            boolean gameRunning = this.plugin.getGameManager().isGameRunning();
            boolean gamePaused = this.plugin.getGameManager().isGamePaused();
            int runnerCount = this.plugin.getGameManager().getRunners().size();
            TaskManagerMode taskMode = this.plugin.getTaskManagerMode();
            int assignedTasks = taskMode != null ? taskMode.getAssignments().size() : 0;
            inventory.setItem(0, this.createGuiButton(Material.ARROW, "\u00a77\u00a7lBack", List.of("\u00a77Return to mode selector"), "back_mode"));
            if (!gameRunning) {
                ArrayList<String> startLore = new ArrayList<String>();
                startLore.add("\u00a77Begin secret task competition");
                if (runnerCount < 2) {
                    startLore.add("\u00a7cNeed at least 2 runners!");
                    startLore.add("\u00a7cCurrent runners: " + runnerCount);
                    inventory.setItem(10, this.createItem(Material.GRAY_CONCRETE, "\u00a7c\u00a7lCannot Start", startLore));
                } else {
                    startLore.add("\u00a77Ready: \u00a7b" + runnerCount + " runners");
                    startLore.add("\u00a77Each will get a secret task");
                    startLore.add("\u00a77First to complete wins!");
                    inventory.setItem(10, this.createGuiButton(Material.LIME_CONCRETE, "\u00a7a\u00a7lStart Competition", startLore, "start_game"));
                }
            } else {
                ArrayList<String> stopLore = new ArrayList<String>();
                stopLore.add("\u00a77End current task competition");
                stopLore.add("\u00a77Status: " + (gamePaused ? "\u00a7ePaused" : "\u00a7aRunning"));
                if (assignedTasks > 0) {
                    stopLore.add("\u00a77Tasks assigned: \u00a7e" + assignedTasks);
                }
                inventory.setItem(10, this.createGuiButton(Material.RED_CONCRETE, "\u00a7c\u00a7lEnd Competition", stopLore, "stop_game"));
            }
            if (gameRunning && !gamePaused) {
                inventory.setItem(11, this.createGuiButton(Material.YELLOW_CONCRETE, "\u00a7e\u00a7lPause Competition", List.of("\u00a77Temporarily pause all tasks"), "pause_game"));
            } else if (gameRunning && gamePaused) {
                inventory.setItem(11, this.createGuiButton(Material.ORANGE_CONCRETE, "\u00a7a\u00a7lResume Competition", List.of("\u00a77Resume task competition"), "resume_game"));
            } else {
                inventory.setItem(11, this.createItem(Material.GRAY_CONCRETE, "\u00a77Pause Competition", List.of("\u00a77Game not running")));
            }
            ArrayList<String> statusLore = new ArrayList<String>();
            statusLore.add("\u00a77Current competition status");
            statusLore.add("\u00a77Running: " + (gameRunning ? "\u00a7aYes" : "\u00a7cNo"));
            statusLore.add("\u00a77Runners: \u00a7b" + runnerCount);
            if (gameRunning) {
                Player activeRunner = this.plugin.getGameManager().getActiveRunner();
                statusLore.add("\u00a77Active: \u00a7f" + (activeRunner != null ? activeRunner.getName() : "None"));
                statusLore.add("\u00a77Tasks Assigned: \u00a7e" + assignedTasks);
                statusLore.add("\u00a77Next Swap: \u00a7e" + this.plugin.getGameManager().getTimeUntilNextSwap() + "s");
            }
            inventory.setItem(13, this.createItem(Material.CLOCK, "\u00a76\u00a7lCompetition Status", statusLore));
            ArrayList<String> runnerLore = new ArrayList<String>();
            runnerLore.add("\u00a77Manage competition participants");
            runnerLore.add("\u00a77Current: \u00a7b" + runnerCount + " runners");
            runnerLore.add("\u00a77Each runner gets a secret task");
            runnerLore.add("\u00a7cNote: No hunters in Task Manager mode");
            inventory.setItem(19, this.createGuiButton(Material.PLAYER_HEAD, "\u00a7b\u00a7lRunner Management", runnerLore, "team_selector"));
            inventory.setItem(21, this.createGuiButton(Material.TARGET, "\u00a7d\u00a7lTask Settings", List.of("\u00a77Configure task competition rules", "\u00a77Timeouts, late joiners, disconnects", "\u00a77\u00a7oPause on disconnect behavior", "\u00a77\u00a7oRejoin grace periods and timeouts", "\u00a77\u00a7oGame ending conditions", "\u00a77\u00a7nClick to configure rules"), "task_settings"));
            inventory.setItem(23, this.createGuiButton(Material.WRITABLE_BOOK, "\u00a76\u00a7lCustom Tasks", List.of("\u00a77Manage custom task pool", "\u00a77Add, remove, or modify tasks", "\u00a77Built-in tasks: " + (this.plugin.getConfig().getBoolean("task_manager.include_default_tasks", true) ? "\u00a7aIncluded" : "\u00a7cExcluded"), "\u00a77\u00a7oCreate your own challenge tasks", "\u00a77\u00a7oEdit descriptions and requirements", "\u00a77\u00a7nClick to manage tasks"), "custom_tasks_menu"));
            inventory.setItem(25, this.createGuiButton(Material.BOOK, "\u00a7b\u00a7lTask Assignments", List.of("\u00a77View current task assignments", "\u00a77Reroll tasks (when not running)", "\u00a77Currently assigned: \u00a7e" + assignedTasks, "\u00a77\u00a7oSee who has which secret task", "\u00a77\u00a7oReassign tasks before game starts", "\u00a77\u00a7nClick to view assignments"), "task_assignments"));
            inventory.setItem(28, this.createGuiButton(Material.EXPERIENCE_BOTTLE, "\u00a7a\u00a7lTask Statistics", List.of("\u00a77View competition statistics", "\u00a77Track completion rates and times", "\u00a77\u00a7oPlayer performance metrics", "\u00a77\u00a7oGame duration and success rates", "\u00a77\u00a7nClick to view statistics"), "statistics"));
            inventory.setItem(30, this.createGuiButton(Material.NETHER_STAR, "\u00a7e\u00a7lShuffle Tasks", List.of("\u00a77Reassign all runner tasks", gameRunning ? "\u00a7cCannot shuffle during game" : "\u00a77Generate new task assignments", "\u00a77\u00a7oGives everyone new secret tasks", "\u00a77\u00a7oOnly works before game starts", gameRunning ? "" : "\u00a77\u00a7nClick to reroll tasks"), gameRunning ? "" : "reroll_tasks"));
            inventory.setItem(40, this.createGuiButton(Material.REDSTONE, "\u00a76\u00a7lAdvanced Settings", List.of("\u00a77Access all configuration options", "\u00a77Swap intervals, timers, disconnection handling"), "advanced_settings"));
            ArrayList<String> infoLore = new ArrayList<String>();
            infoLore.add("\u00a76Task Manager Mode Information:");
            infoLore.add("\u00a7b\u2022 \u00a77Each runner gets a secret task");
            infoLore.add("\u00a7b\u2022 \u00a77First to complete their task wins");
            infoLore.add("\u00a7b\u2022 \u00a77No hunters - pure competition");
            infoLore.add("\u00a7b\u2022 \u00a77Tasks are hidden from other players");
            infoLore.add("\u00a7b\u2022 \u00a77Swap control to give everyone chances");
            inventory.setItem(49, this.createItem(Material.PAPER, "\u00a7e\u00a7lMode Information", infoLore));
            this.openInventorySoon(player, inventory);
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "Error opening Task Manager menu", e);
            player.sendMessage("\u00a7cFailed to open Task Manager menu: " + e.getMessage());
        }
    }

    public void openTaskSettingsMenu(Player player) {
        Inventory inv = GuiCompat.createInventory(null, 54, "\u00a76\u00a7lTask Settings");
        ItemStack filler = this.createItem(Material.BLACK_STAINED_GLASS_PANE, " ", new String[0]);
        this.fillBorder(inv, filler);
        this.addGameControlsHeader(inv);
        inv.setItem(0, this.createItem(Material.ARROW, "\u00a77\u00a7lBack", List.of("\u00a77Return to Task Manager")));
        boolean pause = this.plugin.getConfig().getBoolean("task_manager.pause_on_disconnect", true);
        ItemStack pauseToggle = this.createItem(pause ? Material.REDSTONE_TORCH : Material.LEVER, "\u00a7e\u00a7lPause On Disconnect: " + (pause ? "\u00a7aEnabled" : "\u00a7cDisabled"), List.of("\u00a77When a runner disconnects, pause the game"));
        inv.setItem(10, pauseToggle);
        int grace = this.plugin.getConfig().getInt("task_manager.rejoin_grace_seconds", 180);
        ItemStack graceItem = this.createItem(Material.CLOCK, "\u00a76\u00a7lRejoin Grace (s)", List.of("\u00a77Current: \u00a7f" + grace, "\u00a77Left/Right: \u00b110", "\u00a77Shift: \u00b130"));
        inv.setItem(12, graceItem);
        boolean remove = this.plugin.getConfig().getBoolean("task_manager.remove_on_timeout", true);
        ItemStack removeToggle = this.createItem(remove ? Material.BARRIER : Material.IRON_DOOR, "\u00a7e\u00a7lRemove On Timeout: " + (remove ? "\u00a7aYes" : "\u00a7cNo"), List.of("\u00a77If runner exceeds grace, remove from queue"));
        inv.setItem(14, removeToggle);
        boolean allowLate = this.plugin.getConfig().getBoolean("task_manager.allow_late_joiners", false);
        ItemStack allowToggle = this.createItem(allowLate ? Material.LIME_DYE : Material.GRAY_DYE, "\u00a7e\u00a7lAllow Late Joiners: " + (allowLate ? "\u00a7aYes" : "\u00a7cNo"), List.of("\u00a77Allow players to join mid-game and receive tasks"));
        inv.setItem(16, allowToggle);
        boolean endOne = this.plugin.getConfig().getBoolean("task_manager.end_when_one_left", false);
        ItemStack endOneToggle = this.createItem(endOne ? Material.REDSTONE_BLOCK : Material.GRAY_DYE, "\u00a7e\u00a7lEnd When One Left: " + (endOne ? "\u00a7aYes" : "\u00a7cNo"), List.of("\u00a77End the game automatically when only one runner remains"));
        inv.setItem(18, endOneToggle);
        boolean gameRunning = this.plugin.getGameManager().isGameRunning();
        ItemStack rerollTasks = this.createGuiButton(gameRunning ? Material.GRAY_DYE : Material.BOOK, "\u00a7d\u00a7lReroll Tasks" + (gameRunning ? " \u00a78(Game Running)" : ""), gameRunning ? List.of("\u00a77Reroll tasks for all selected runners", "\u00a7c\u00a7lDisabled while game is running") : List.of("\u00a77Reroll tasks for all selected runners", "\u00a77Must have runners selected via Team Selector"), "reroll_tasks");
        inv.setItem(20, rerollTasks);
        ItemStack showAssignments = this.createGuiButton(Material.WRITTEN_BOOK, "\u00a7b\u00a7lShow Task Assignments", List.of("\u00a77Display current task assignments", "\u00a77Shows assignments in chat"), "show_assignments");
        inv.setItem(22, showAssignments);
        TaskManagerMode tmm = this.plugin.getTaskManagerMode();
        if (tmm != null) {
            int slot = 28;
            for (Map.Entry<UUID, String> entry : tmm.getAssignments().entrySet()) {
                UUID uuid = entry.getKey();
                String taskId = entry.getValue();
                TaskDefinition def = tmm.getTask(taskId);
                String name = this.plugin.getServer().getOfflinePlayer(uuid).getName();
                if (name == null) {
                    name = uuid.toString().substring(0, 8);
                }
                ItemStack it = this.createItem(Material.PAPER, "\u00a7e" + name, List.of("\u00a77" + (def != null ? def.description() : taskId)));
                inv.setItem(slot++, it);
                if (slot < 44) continue;
                break;
            }
            if (tmm.getAssignments().isEmpty()) {
                inv.setItem(31, this.createItem(Material.BOOK, "\u00a77No assignments yet", List.of("\u00a77Start a Task game to assign")));
            }
        }
        inv.setItem(53, this.createItem(Material.BOOK, "\u00a76\u00a7lReload Tasks", List.of("\u00a77Reload tasks from config")));
        this.openInventorySoon(player, inv);
    }

    public void openDreamSettingsMenu(Player player) {
        Inventory inv = GuiCompat.createInventory(null, 27, "\u00a7a\u00a7lDream Settings");
        ItemStack filler = this.createItem(Material.BLACK_STAINED_GLASS_PANE, " ", new String[0]);
        this.fillBorder(inv, filler);
        inv.setItem(0, this.createItem(Material.ARROW, "\u00a77\u00a7lBack", List.of("\u00a77Return to Dream menu")));
        this.addGameControlsHeader(inv);
        boolean tracker = this.plugin.getConfigManager().isTrackerEnabled();
        ItemStack trackerToggle = this.createGuiButton(tracker ? Material.COMPASS : Material.GRAY_DYE, "\u00a7e\u00a7lTracker: " + (tracker ? "\u00a7aEnabled" : "\u00a7cDisabled"), List.of("\u00a77Toggle hunter tracking compass"), "dream_tracker_toggle");
        inv.setItem(11, trackerToggle);
        boolean singleSleep = this.plugin.getConfigManager().isSinglePlayerSleepEnabled();
        ItemStack sleepToggle = this.createGuiButton(singleSleep ? Material.RED_BED : Material.GRAY_BED, "\u00a7e\u00a7lSingle Player Sleep: " + (singleSleep ? "\u00a7aEnabled" : "\u00a7cDisabled"), List.of("\u00a77Only active runner can sleep"), "dream_single_sleep_toggle");
        inv.setItem(15, sleepToggle);
        this.openInventorySoon(player, inv);
    }

    public void openTeamSelector(Player player) {
        String title = this.plugin.getConfigManager().getGuiTeamSelectorTitle();
        int rows = this.plugin.getConfigManager().getGuiTeamSelectorRows();
        rows = Math.max(rows, 4);
        rows = this.clampRows(rows);
        Inventory inventory = GuiCompat.createInventory(null, rows * 9, title);
        ItemStack filler = this.createItem(Material.BLACK_STAINED_GLASS_PANE, " ", new String[0]);
        this.fillBorder(inventory, filler);
        ArrayList<String> backLore = new ArrayList<String>();
        backLore.add("\u00a77Return to main menu");
        backLore.add("\u00a77Current selections will be saved");
        ItemStack back = this.createItem(Material.ARROW, "\u00a77\u00a7lBack", backLore);
        inventory.setItem(0, back);
        ItemStack clearTeams = this.createGuiButton(Material.BARRIER, "\u00a7c\u00a7lClear All Teams", List.of("\u00a77Remove all existing team assignments"), "clear_teams");
        inventory.setItem(8, clearTeams);
        SpeedrunnerSwap.SwapMode currentMode = this.plugin.getCurrentMode();
        if (currentMode == SpeedrunnerSwap.SwapMode.TASK) {
            runnerLore = new ArrayList<String>();
            runnerLore.add("\u00a77Click to select players as runners");
            runnerLore.add("");
            runnerLore.add("\u00a77Current Runners: \u00a7b" + this.plugin.getGameManager().getRunners().size());
            runnerLore.add("\u00a77Role:");
            runnerLore.add("\u00a77\u2022 Complete secret tasks");
            runnerLore.add("\u00a77\u2022 Compete to finish first");
            runnerLore.add("\u00a77\u2022 Swap between players");
            runnerTeam = this.createItem(Material.DIAMOND_BOOTS, "\u00a7b\u00a7lRunners", runnerLore);
            inventory.setItem(4, this.plugin.getGameManager().getPlayerState(player).getSelectedTeam() == Team.RUNNER ? this.createGlowingItem(runnerTeam) : this.createNormalItem(runnerTeam));
            ArrayList<String> instructionsLore = new ArrayList<String>();
            instructionsLore.add("\u00a76\u00a7lTask Manager Mode:");
            instructionsLore.add("\u00a771. Select runners for competition");
            instructionsLore.add("\u00a772. Each gets a secret task");
            instructionsLore.add("\u00a773. First to complete wins");
            instructionsLore.add("\u00a7c\u00a7lNo hunters in Task Manager mode!");
            ItemStack instructions = this.createItem(Material.TARGET, "\u00a7e\u00a7lTask Competition", instructionsLore);
            inventory.setItem(2, instructions);
            inventory.setItem(6, instructions);
        } else {
            runnerLore = new ArrayList();
            runnerLore.add("\u00a77Click to select players as runners");
            runnerLore.add("");
            runnerLore.add("\u00a77Current Runners: \u00a7b" + this.plugin.getGameManager().getRunners().size());
            runnerLore.add("\u00a77Role:");
            runnerLore.add("\u00a77\u2022 Complete objectives");
            runnerLore.add("\u00a77\u2022 Avoid hunters");
            runnerLore.add("\u00a77\u2022 Swap between players");
            runnerTeam = this.createItem(Material.DIAMOND_BOOTS, "\u00a7b\u00a7lRunners", runnerLore);
            inventory.setItem(2, this.plugin.getGameManager().getPlayerState(player).getSelectedTeam() == Team.RUNNER ? this.createGlowingItem(runnerTeam) : this.createNormalItem(runnerTeam));
            ArrayList<String> hunterLore = new ArrayList<String>();
            hunterLore.add("\u00a77Click to select players as hunters");
            hunterLore.add("");
            hunterLore.add("\u00a77Current Hunters: \u00a7c" + this.plugin.getGameManager().getHunters().size());
            hunterLore.add("\u00a77Role:");
            hunterLore.add("\u00a77\u2022 Track runners");
            hunterLore.add("\u00a77\u2022 Eliminate runners");
            hunterLore.add("\u00a77\u2022 Prevent objectives");
            ItemStack hunterTeam = this.createItem(Material.IRON_SWORD, "\u00a7c\u00a7lHunters", hunterLore);
            inventory.setItem(6, this.plugin.getGameManager().getPlayerState(player).getSelectedTeam() == Team.HUNTER ? this.createGlowingItem(hunterTeam) : this.createNormalItem(hunterTeam));
            ArrayList<String> instructionsLore = new ArrayList<String>();
            instructionsLore.add("\u00a77How to assign teams:");
            instructionsLore.add("\u00a771. Select a team above");
            instructionsLore.add("\u00a772. Click player heads below");
            instructionsLore.add("\u00a773. Confirm your selections");
            ItemStack instructions = this.createItem(Material.BOOK, "\u00a7e\u00a7lInstructions", instructionsLore);
            inventory.setItem(4, instructions);
        }
        int slot = 18;
        for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
            if (slot >= inventory.getSize()) break;
            ItemStack playerHead = new ItemStack(Material.PLAYER_HEAD);
            SkullMeta meta = (SkullMeta)playerHead.getItemMeta();
            meta.setOwningPlayer((OfflinePlayer)onlinePlayer);
            Team currentTeam = this.plugin.getGameManager().getPlayerState(onlinePlayer).getSelectedTeam();
            String coloredName = switch (currentTeam) {
                case Team.RUNNER -> "\u00a7b" + onlinePlayer.getName();
                case Team.HUNTER -> "\u00a7c" + onlinePlayer.getName();
                default -> "\u00a7f" + onlinePlayer.getName();
            };
            GuiCompat.setDisplayName((ItemMeta)meta, coloredName);
            ArrayList<String> lore = new ArrayList<String>();
            if (this.plugin.getGameManager().isRunner(onlinePlayer)) {
                lore.add("\u00a7bCurrently a Runner");
                lore.add("\u00a77Click while Hunter team is selected");
                lore.add("\u00a77to change to Hunter");
            } else if (this.plugin.getGameManager().isHunter(onlinePlayer)) {
                lore.add("\u00a7cCurrently a Hunter");
                lore.add("\u00a77Click while Runner team is selected");
                lore.add("\u00a77to change to Runner");
            } else {
                lore.add("\u00a77No team assigned");
                lore.add("\u00a77Select a team above first");
                lore.add("\u00a77then click to assign");
            }
            lore.add("");
            lore.add(onlinePlayer.isOnline() ? "\u00a7a\u2714 Online" : "\u00a7c\u2718 Offline");
            GuiCompat.setLore((ItemMeta)meta, lore);
            playerHead.setItemMeta((ItemMeta)meta);
            if (currentTeam != Team.NONE) {
                playerHead = this.createGlowingItem(playerHead);
            }
            inventory.setItem(slot++, playerHead);
        }
        this.openInventorySoon(player, inventory);
    }

    public void openSettingsMenu(Player player) {
        boolean singleSleep;
        boolean safeSwap;
        String title = "\u00a76\u00a7lAdvanced Settings - All Options";
        int rows = 6;
        rows = this.clampRows(rows);
        Inventory inventory = GuiCompat.createInventory(null, rows * 9, title);
        ItemStack filler = this.createItem(Material.RED_STAINED_GLASS_PANE, " ", new String[0]);
        this.fillBorder(inventory, filler);
        inventory.setItem(0, this.createGuiButton(Material.ARROW, "\u00a77\u00a7lBack", List.of("\u00a77Return to main menu"), "back_main"));
        this.addGameControlsHeader(inventory);
        boolean isRandomized = this.plugin.getConfigManager().isSwapRandomized();
        inventory.setItem(10, this.createGuiButton(isRandomized ? Material.CLOCK : Material.REPEATER, "\u00a7e\u00a7lSwap Type: " + (isRandomized ? "\u00a7aRandom" : "\u00a7bFixed"), List.of("\u00a77Toggle between fixed and random intervals", isRandomized ? "\u00a77Random adds unpredictability" : "\u00a77Fixed provides consistent timing"), "random_swaps"));
        int currentInterval = this.plugin.getConfigManager().getSwapInterval();
        boolean isBeta = this.plugin.getConfigManager().isBetaIntervalEnabled();
        ArrayList<String> intervalLore = new ArrayList<String>();
        intervalLore.add("\u00a77Current: \u00a7e" + currentInterval + " seconds");
        intervalLore.add("\u00a77Use arrows to adjust (\u00b15s)");
        if (isBeta && currentInterval < 30) {
            intervalLore.add("\u00a7cBETA: Below 30s may be unstable");
        }
        inventory.setItem(11, this.createGuiButton(Material.PAPER, "\u00a7e\u00a7lSwap Interval", intervalLore, "swap_interval"));
        inventory.setItem(12, this.createGuiButton(Material.ARROW, "\u00a7c-5s", List.of("\u00a77Decrease interval"), "interval_minus"));
        inventory.setItem(14, this.createGuiButton(Material.ARROW, "\u00a7a+5s", List.of("\u00a77Increase interval"), "interval_plus"));
        inventory.setItem(15, this.createGuiButton(isBeta ? Material.REDSTONE_TORCH : Material.LEVER, "\u00a7e\u00a7lExperimental: " + (isBeta ? "\u00a7aON" : "\u00a7cOFF"), List.of("\u00a77Allow <30s and >max intervals", "\u00a77Shows warnings when used"), "beta_intervals"));
        if (isRandomized) {
            int minInterval = this.plugin.getConfigManager().getMinSwapInterval();
            int maxInterval = this.plugin.getConfigManager().getMaxSwapInterval();
            inventory.setItem(16, this.createGuiButton(Material.COMPASS, "\u00a76\u00a7lRandom Range", List.of("\u00a77Min: \u00a7e" + minInterval + "s", "\u00a77Max: \u00a7e" + maxInterval + "s", "\u00a77Left/Right: \u00b15s, Shift: \u00b115s"), "random_range"));
        }
        inventory.setItem(19, this.createGuiButton((safeSwap = this.plugin.getConfigManager().isSafeSwapEnabled()) ? Material.SLIME_BLOCK : Material.MAGMA_BLOCK, "\u00a7e\u00a7lSafe Swaps: " + (safeSwap ? "\u00a7aON" : "\u00a7cOFF"), List.of("\u00a77Prevent dangerous spawn locations", "\u00a77Radius: \u00a7e" + this.plugin.getConfigManager().getSafeSwapHorizontalRadius() + " blocks"), "safe_swaps"));
        int graceTicks = this.plugin.getConfigManager().getGracePeriodTicks();
        inventory.setItem(20, this.createGuiButton(Material.SHIELD, "\u00a76\u00a7lGrace Period", List.of("\u00a77Current: \u00a7e" + (double)graceTicks / 20.0 + "s", "\u00a77Protection after swaps", "\u00a77Left/Right: \u00b10.5s, Shift: \u00b12s"), "grace_period"));
        boolean pauseDisconnect = this.plugin.getConfigManager().isPauseOnDisconnect();
        inventory.setItem(21, this.createGuiButton(pauseDisconnect ? Material.REDSTONE_TORCH : Material.LEVER, "\u00a7e\u00a7lPause on Disconnect: " + (pauseDisconnect ? "\u00a7aON" : "\u00a7cOFF"), List.of("\u00a77Auto-pause if active runner leaves"), "pause_disconnect"));
        String freezeMode = this.plugin.getConfigManager().getFreezeMode();
        Material freezeIcon = switch (freezeMode.toUpperCase()) {
            case "SPECTATOR" -> Material.ENDER_EYE;
            case "LIMBO" -> Material.ENDER_PEARL;
            case "CAGE" -> Material.BEDROCK;
            default -> Material.POTION;
        };
        inventory.setItem(22, this.createGuiButton(freezeIcon, "\u00a76\u00a7lInactive State: \u00a7a" + freezeMode, List.of("\u00a77How inactive runners are handled", "\u00a77Click to cycle through options"), "freeze_mode"));
        String runnerVis = this.plugin.getConfigManager().getRunnerTimerVisibility();
        inventory.setItem(28, this.createGuiButton(Material.CLOCK, "\u00a7b\u00a7lActive Runner Timer", List.of("\u00a77Current: \u00a7e" + this.getVisibilityDisplay(runnerVis), "\u00a77Click to cycle visibility"), "runner_timer"));
        String waitingVis = this.plugin.getConfigManager().getWaitingTimerVisibility();
        inventory.setItem(29, this.createGuiButton(Material.CLOCK, "\u00a7d\u00a7lWaiting Runner Timer", List.of("\u00a77Current: \u00a7e" + this.getVisibilityDisplay(waitingVis), "\u00a77Click to cycle visibility"), "waiting_timer"));
        String hunterVis = this.plugin.getConfigManager().getHunterTimerVisibility();
        inventory.setItem(30, this.createGuiButton(Material.CLOCK, "\u00a7c\u00a7lHunter Timer", List.of("\u00a77Current: \u00a7e" + this.getVisibilityDisplay(hunterVis), "\u00a77Click to cycle visibility"), "hunter_timer"));
        if (this.plugin.getCurrentMode() == SpeedrunnerSwap.SwapMode.DREAM) {
            boolean trackerEnabled = this.plugin.getConfigManager().isTrackerEnabled();
            inventory.setItem(37, this.createGuiButton(trackerEnabled ? Material.COMPASS : Material.GRAY_DYE, "\u00a7e\u00a7lHunter Tracking: " + (trackerEnabled ? "\u00a7aON" : "\u00a7cOFF"), List.of("\u00a77Hunters get tracking compasses", "\u00a77Update rate: \u00a7e" + this.plugin.getConfigManager().getTrackerUpdateTicks() / 20 + "s"), "tracker_toggle"));
            boolean hunterSwap = this.plugin.getConfigManager().isHunterSwapEnabled();
            inventory.setItem(38, this.createGuiButton(hunterSwap ? Material.CROSSBOW : Material.GRAY_DYE, "\u00a7e\u00a7lHunter Swap: " + (hunterSwap ? "\u00a7aON" : "\u00a7cOFF"), List.of("\u00a77Periodically shuffle hunter focus", "\u00a77Interval: \u00a7e" + this.plugin.getConfigManager().getHunterSwapInterval() + "s"), "hunter_swap"));
            boolean hotPotato = this.plugin.getConfigManager().isHotPotatoModeEnabled();
            inventory.setItem(39, this.createGuiButton(hotPotato ? Material.BLAZE_POWDER : Material.GRAY_DYE, "\u00a7e\u00a7lHot Potato: " + (hotPotato ? "\u00a7aON" : "\u00a7cOFF"), List.of("\u00a77Swap when runner takes damage", "\u00a77Overrides normal timer"), "hot_potato"));
        }
        inventory.setItem(46, this.createGuiButton((singleSleep = this.plugin.getConfigManager().isSinglePlayerSleepEnabled()) ? Material.WHITE_BED : Material.RED_BED, "\u00a7e\u00a7lSingle Player Sleep: " + (singleSleep ? "\u00a7aON" : "\u00a7cOFF"), List.of("\u00a77Only active runner can skip night", "\u00a77Recommended for cage/spectator modes"), "single_sleep"));
        boolean voiceChat = this.plugin.getConfigManager().isVoiceChatIntegrationEnabled();
        inventory.setItem(47, this.createGuiButton(voiceChat ? Material.NOTE_BLOCK : Material.GRAY_DYE, "\u00a7e\u00a7lVoice Chat: " + (voiceChat ? "\u00a7aON" : "\u00a7cOFF"), List.of("\u00a77Integrate with Simple Voice Chat", "\u00a77Mute inactive runners: " + (this.plugin.getConfigManager().isMuteInactiveRunners() ? "\u00a7aYes" : "\u00a7cNo")), "voice_chat"));
        boolean statsEnabled = this.plugin.getConfig().getBoolean("stats.enabled", true);
        inventory.setItem(48, this.createGuiButton(statsEnabled ? Material.BOOK : Material.GRAY_DYE, "\u00a7e\u00a7lStatistics: " + (statsEnabled ? "\u00a7aON" : "\u00a7cOFF"), List.of("\u00a77Track game performance metrics", "\u00a77Distance, time, completion rates"), "stats_toggle"));
        switch (this.plugin.getCurrentMode()) {
            case DREAM: {
                inventory.setItem(43, this.createGuiButton(Material.POTION, "\u00a7d\u00a7lPower-ups Settings", List.of("\u00a77Configure random effects on swap"), "power_ups"));
                inventory.setItem(44, this.createGuiButton(Material.BARRIER, "\u00a7c\u00a7lWorld Border Settings", List.of("\u00a77Configure shrinking world boundary"), "world_border"));
                break;
            }
            case TASK: {
                inventory.setItem(43, this.createGuiButton(Material.TARGET, "\u00a76\u00a7lTask Settings", List.of("\u00a77Configure task competition rules"), "task_settings"));
                inventory.setItem(44, this.createGuiButton(Material.WRITABLE_BOOK, "\u00a76\u00a7lCustom Tasks", List.of("\u00a77Manage custom task pool"), "custom_tasks_menu"));
                break;
            }
            case SAPNAP: {
                inventory.setItem(43, this.createGuiButton(Material.BEDROCK, "\u00a7b\u00a7lCage Settings", List.of("\u00a77Configure cage behavior"), "cage_settings"));
            }
        }
        if (safeSwap) {
            inventory.setItem(49, this.createGuiButton(Material.MAGMA_BLOCK, "\u00a76\u00a7lDangerous Blocks", List.of("\u00a77Edit list of avoided blocks"), "dangerous_blocks"));
        }
        inventory.setItem(50, this.createGuiButton(Material.BELL, "\u00a7e\u00a7lBroadcast Settings", List.of("\u00a77Configure game event announcements", "\u00a77Swap events, team changes, etc."), "broadcast_settings"));
        if ("LIMBO".equalsIgnoreCase(freezeMode)) {
            inventory.setItem(51, this.createGuiButton(Material.ENDER_PEARL, "\u00a76\u00a7lLimbo Settings", List.of("\u00a77Configure limbo world and coordinates"), "limbo_settings"));
        }
        inventory.setItem(52, this.createGuiButton(Material.COMPARATOR, "\u00a7d\u00a7lUI Performance", List.of("\u00a77Update frequencies for timers", "\u00a77Actionbar and title refresh rates"), "ui_performance"));
        inventory.setItem(53, this.createGuiButton(Material.WRITABLE_BOOK, "\u00a7c\u00a7lAdvanced Config Browser", List.of("\u00a77Direct access to all config values", "\u00a77Edit any setting not in main GUI"), "advanced_config_root"));
        inventory.setItem(45, this.createGuiButton(Material.BARRIER, "\u00a7c\u00a7lReset All Settings", List.of("\u00a77Reset all settings to defaults", "\u00a7cThis cannot be undone!"), "reset_all_settings"));
        this.openInventorySoon(player, inventory);
    }

    public void openCustomTasksMenu(Player player) {
        Inventory inv = GuiCompat.createInventory(null, 54, "\u00a7d\u00a7lCustom Tasks Manager");
        ItemStack filler = this.createItem(Material.BLACK_STAINED_GLASS_PANE, " ", new String[0]);
        this.fillBorder(inv, filler);
        this.addGameControlsHeader(inv);
        ItemStack back = this.createItem(Material.ARROW, "\u00a77\u00a7lBack", List.of("\u00a77Return to Settings"));
        inv.setItem(0, back);
        boolean includeDefaults = this.plugin.getConfig().getBoolean("task_manager.include_default_tasks", true);
        ItemStack toggleDefaults = this.createItem(includeDefaults ? Material.LIME_DYE : Material.GRAY_DYE, "\u00a7e\u00a7lInclude Default Tasks: " + (includeDefaults ? "\u00a7aEnabled" : "\u00a7cDisabled"), List.of("\u00a77Toggle whether built-in tasks are included"));
        inv.setItem(4, toggleDefaults);
        ItemStack addTask = this.createItem(Material.EMERALD, "\u00a7a\u00a7lAdd New Task", List.of("\u00a77Click to add a custom task", "\u00a77You'll be prompted in chat"));
        inv.setItem(8, addTask);
        ItemStack reloadTasks = this.createItem(Material.BOOK, "\u00a76\u00a7lReload Tasks", List.of("\u00a77Reload all tasks from config"));
        inv.setItem(53, reloadTasks);
        TaskManagerMode taskMode = this.plugin.getTaskManagerMode();
        if (taskMode != null) {
            List<String> customIds = taskMode.getCustomTaskIds();
            int slot = 9;
            for (String taskId : customIds) {
                if (slot >= 45) break;
                TaskDefinition task = taskMode.getTask(taskId);
                if (task != null) {
                    ItemStack taskItem = this.createItem(Material.PAPER, "\u00a7e" + taskId, List.of("\u00a77" + task.description(), "", "\u00a7cClick to remove"));
                    inv.setItem(slot, taskItem);
                }
                ++slot;
            }
            if (customIds.isEmpty()) {
                ItemStack noTasks = this.createItem(Material.BARRIER, "\u00a7cNo Custom Tasks", List.of("\u00a77Click 'Add New Task' to create one"));
                inv.setItem(22, noTasks);
            }
        }
        this.openInventorySoon(player, inv);
    }

    public void promptTaskInput(Player player, String type) {
        player.closeInventory();
        if (type.equals("id")) {
            player.sendMessage("\u00a7e[Task Manager] Enter a unique task ID (e.g., 'build_nether_house'):");
            player.sendMessage("\u00a77Type 'cancel' to abort");
            this.plugin.getChatInputHandler().expectTaskId(player);
        } else if (type.equals("description")) {
            player.sendMessage("\u00a7e[Task Manager] Enter the task description:");
            player.sendMessage("\u00a77Type 'cancel' to abort");
            this.plugin.getChatInputHandler().expectTaskDescription(player);
        }
    }

    private int clampRows(int rows) {
        if (rows < 1) {
            return 1;
        }
        if (rows > 6) {
            return 6;
        }
        return rows;
    }

    public ItemStack createItem(Material material, String name, String ... lore) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        GuiCompat.setDisplayName(meta, name);
        if (lore.length > 0) {
            ArrayList<String> loreList = new ArrayList<String>();
            Collections.addAll(loreList, lore);
            GuiCompat.setLore(meta, loreList);
        }
        item.setItemMeta(meta);
        return item;
    }

    public ItemStack createGlowingItem(ItemStack item) {
        ItemStack glowingItem = item.clone();
        ItemMeta meta = glowingItem.getItemMeta();
        meta.addEnchant(Enchantment.UNBREAKING, 1, true);
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        glowingItem.setItemMeta(meta);
        return glowingItem;
    }

    public ItemStack createNormalItem(ItemStack item) {
        ItemStack normalItem = item.clone();
        ItemMeta meta = normalItem.getItemMeta();
        meta.removeEnchant(Enchantment.UNBREAKING);
        meta.removeItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        normalItem.setItemMeta(meta);
        return normalItem;
    }

    public ItemStack createItem(Material material, String name, List<String> lore) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        GuiCompat.setDisplayName(meta, name);
        if (lore != null && !lore.isEmpty()) {
            GuiCompat.setLore(meta, lore);
        }
        item.setItemMeta(meta);
        return item;
    }

    private void addGameControlsHeader(Inventory inventory) {
        boolean running = this.plugin.getGameManager().isGameRunning();
        boolean paused = this.plugin.getGameManager().isGamePaused();
        int runnerCount = this.plugin.getGameManager().getRunners().size();
        int hunterCount = 0;
        try {
            hunterCount = this.plugin.getGameManager().getHunters().size();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (!running) {
            ArrayList<String> startLore = new ArrayList<String>();
            if (this.plugin.getCurrentMode() == SpeedrunnerSwap.SwapMode.DREAM) {
                if (runnerCount == 0 || hunterCount == 0) {
                    startLore.add("\u00a7cNeed both runners and hunters!");
                    startLore.add("\u00a7cRunners: " + runnerCount + ", Hunters: " + hunterCount);
                    inventory.setItem(10, this.createItem(Material.GRAY_CONCRETE, "\u00a7c\u00a7lCannot Start", startLore));
                } else {
                    startLore.add("\u00a77Ready: \u00a7b" + runnerCount + " runners\u00a77, \u00a7c" + hunterCount + " hunters");
                    startLore.add("\u00a77Swap interval: \u00a7e" + this.plugin.getConfigManager().getSwapInterval() + "s");
                    inventory.setItem(10, this.createGuiButton(Material.LIME_CONCRETE, "\u00a7a\u00a7lStart Game", startLore, "start_game"));
                }
            } else if (runnerCount < 1) {
                startLore.add("\u00a7cNeed at least 1 runner!");
                inventory.setItem(10, this.createItem(Material.GRAY_CONCRETE, "\u00a7c\u00a7lCannot Start", startLore));
            } else {
                startLore.add("\u00a77Ready: \u00a7b" + runnerCount + " runners");
                startLore.add("\u00a77Swap interval: \u00a7e" + this.plugin.getConfigManager().getSwapInterval() + "s");
                inventory.setItem(10, this.createGuiButton(Material.LIME_CONCRETE, "\u00a7a\u00a7lStart Game", startLore, "start_game"));
            }
        } else {
            ArrayList<String> stopLore = new ArrayList<String>();
            stopLore.add("\u00a77End the current game");
            stopLore.add("\u00a77Status: " + (paused ? "\u00a7ePaused" : "\u00a7aRunning"));
            inventory.setItem(10, this.createGuiButton(Material.RED_CONCRETE, "\u00a7c\u00a7lStop Game", stopLore, "stop_game"));
        }
        if (running && !paused) {
            inventory.setItem(11, this.createGuiButton(Material.YELLOW_CONCRETE, "\u00a7e\u00a7lPause", List.of("\u00a77Temporarily pause the game"), "pause_game"));
        } else if (running) {
            inventory.setItem(11, this.createGuiButton(Material.ORANGE_CONCRETE, "\u00a7a\u00a7lResume", List.of("\u00a77Resume the game"), "resume_game"));
        } else {
            inventory.setItem(11, this.createItem(Material.GRAY_CONCRETE, "\u00a77Pause", List.of("\u00a77Game not running")));
        }
        ArrayList<String> status = new ArrayList<String>();
        status.add("\u00a77Running: " + (running ? "\u00a7aYes" : "\u00a7cNo"));
        status.add("\u00a77Runners: \u00a7b" + runnerCount);
        if (this.plugin.getCurrentMode() == SpeedrunnerSwap.SwapMode.DREAM) {
            status.add("\u00a77Hunters: \u00a7c" + hunterCount);
        }
        if (running) {
            try {
                Player active = this.plugin.getGameManager().getActiveRunner();
                status.add("\u00a77Active: \u00a7f" + (active != null ? active.getName() : "None"));
                status.add("\u00a77Next Swap: \u00a7e" + this.plugin.getGameManager().getTimeUntilNextSwap() + "s");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        inventory.setItem(13, this.createItem(Material.CLOCK, "\u00a76\u00a7lGame Status", status));
    }

    private void fillBorder(Inventory inv, ItemStack filler) {
        if (inv == null || filler == null) {
            return;
        }
        int size = inv.getSize();
        if (size < 9) {
            return;
        }
        int rows = size / 9;
        for (int c = 0; c < 9; ++c) {
            inv.setItem(c, filler);
            inv.setItem((rows - 1) * 9 + c, filler);
        }
        for (int r = 0; r < rows; ++r) {
            inv.setItem(r * 9, filler);
            inv.setItem(r * 9 + 8, filler);
        }
    }

    public void openAdvancedConfigMenu(Player player, String path, int page) {
        ConfigurationSection section;
        if (path == null) {
            path = "";
        }
        FileConfiguration cfg = this.plugin.getConfig();
        ConfigurationSection configurationSection = section = path.isEmpty() ? cfg.getConfigurationSection("") : cfg.getConfigurationSection(path);
        if (section == null) {
            String parent = this.getParentPath(path);
            section = parent == null ? cfg.getConfigurationSection("") : cfg.getConfigurationSection(parent);
            path = parent == null ? "" : parent;
        }
        Set keys = section == null ? Collections.emptySet() : section.getKeys(false);
        int rows = 6;
        String title = "\u00a76\u00a7lAdvanced Config" + (String)(path.isEmpty() ? "" : " \u00a77(" + path + ")");
        Inventory inv = GuiCompat.createInventory(null, rows * 9, title);
        ItemStack filler = this.createItem(Material.GRAY_STAINED_GLASS_PANE, " ", new String[0]);
        this.fillBorder(inv, filler);
        this.addGameControlsHeader(inv);
        if (path.isEmpty()) {
            inv.setItem(0, this.createGuiButton(Material.ARROW, "\u00a77\u00a7lBack", List.of("\u00a77Return to Settings"), "back_settings"));
        } else {
            String parent = this.getParentPath(path);
            Object id = parent == null ? "advanced_config_root" : "cfg:nav:" + parent;
            inv.setItem(0, this.createGuiButton(Material.ARROW, "\u00a77\u00a7lUp: \u00a7f" + (parent == null ? "root" : parent), List.of("\u00a77Go to parent section"), (String)id));
        }
        ArrayList sorted = new ArrayList(keys);
        Collections.sort(sorted);
        int start = page * 28;
        int end = Math.min(start + 28, sorted.size());
        int slot = 10;
        for (int i = start; i < end; ++i) {
            ItemStack it;
            String key = (String)sorted.get(i);
            Object full = path.isEmpty() ? key : path + "." + key;
            Object val = cfg.get((String)full);
            if (val instanceof ConfigurationSection) {
                it = this.createGuiButton(Material.CHEST, "\u00a7e\u00a7l" + key + "/", List.of("\u00a77Open section", "\u00a78" + (String)full), "cfg:nav:" + (String)full);
            } else if (val instanceof Boolean) {
                boolean b = (Boolean)val;
                it = this.createGuiButton(b ? Material.LIME_DYE : Material.GRAY_DYE, "\u00a7a\u00a7l" + key + " = " + (b ? "\u00a7atrue" : "\u00a7cfalse"), List.of("\u00a77Toggle", "\u00a78" + (String)full), "cfg:bool:" + (String)full);
            } else if (val instanceof Number) {
                String display = String.valueOf(val);
                it = this.createGuiButton(Material.REPEATER, "\u00a76\u00a7l" + key + " = \u00a7e" + display, List.of("\u00a77Left/Right: \u00b11", "\u00a77Shift: \u00b110", "\u00a78" + (String)full), "cfg:num:" + (String)full);
            } else {
                String s;
                it = val instanceof List ? this.createGuiButton(Material.PAPER, "\u00a7b\u00a7l" + key + "[]", List.of("\u00a77Edit list", "\u00a78" + (String)full), "cfg:list:" + (String)full) : this.createGuiButton(Material.NAME_TAG, "\u00a7d\u00a7l" + key + " = \u00a7f" + ((s = cfg.getString((String)full, String.valueOf(val))) == null ? "null" : this.truncate(s, 20)), List.of("\u00a77Click to edit string", "\u00a78" + (String)full), "cfg:str:" + (String)full);
            }
            inv.setItem(slot, it);
            if ((++slot + 1) % 9 != 0) continue;
            slot += 2;
        }
        if (page > 0) {
            inv.setItem(45, this.createGuiButton(Material.ARROW, "\u00a77\u00a7lPrev Page", List.of(), "cfg:page:" + path + ":" + (page - 1)));
        }
        if (end < sorted.size()) {
            inv.setItem(53, this.createGuiButton(Material.ARROW, "\u00a77\u00a7lNext Page", List.of(), "cfg:page:" + path + ":" + (page + 1)));
        }
        this.openInventorySoon(player, inv);
    }

    public void openConfigListEditor(Player player, String path, int page) {
        FileConfiguration cfg = this.plugin.getConfig();
        List list = cfg.getStringList(path);
        int rows = 6;
        String title = "\u00a76\u00a7lList Editor \u00a77(" + path + ")";
        Inventory inv = GuiCompat.createInventory(null, rows * 9, title);
        ItemStack filler = this.createItem(Material.GRAY_STAINED_GLASS_PANE, " ", new String[0]);
        this.fillBorder(inv, filler);
        this.addGameControlsHeader(inv);
        inv.setItem(0, this.createGuiButton(Material.ARROW, "\u00a77\u00a7lBack", List.of("\u00a77Return to Advanced Config"), "cfg:nav:" + this.getParentPath(path)));
        inv.setItem(8, this.createGuiButton(Material.EMERALD, "\u00a7a\u00a7lAdd Item", List.of("\u00a77Click to add via chat"), "cfg:list_add:" + path));
        int start = page * 28;
        int end = Math.min(start + 28, list.size());
        int slot = 10;
        for (int i = start; i < end; ++i) {
            String item = (String)list.get(i);
            String id = "cfg:list_del:" + path + ":" + i;
            inv.setItem(slot, this.createGuiButton(Material.PAPER, "\u00a7f" + this.truncate(item, 30), List.of("\u00a7cClick to remove", "\u00a78index:" + i), id));
            if ((++slot + 1) % 9 != 0) continue;
            slot += 2;
        }
        if (page > 0) {
            inv.setItem(45, this.createGuiButton(Material.ARROW, "\u00a77\u00a7lPrev Page", List.of(), "cfg:list_page:" + path + ":" + (page - 1)));
        }
        if (end < list.size()) {
            inv.setItem(53, this.createGuiButton(Material.ARROW, "\u00a77\u00a7lNext Page", List.of(), "cfg:list_page:" + path + ":" + (page + 1)));
        }
        this.openInventorySoon(player, inv);
    }

    private String getParentPath(String path) {
        if (path == null || path.isEmpty()) {
            return null;
        }
        int idx = path.lastIndexOf(46);
        if (idx < 0) {
            return null;
        }
        return path.substring(0, idx);
    }

    private String truncate(String s, int n) {
        if (s == null) {
            return "null";
        }
        if (s.length() <= n) {
            return s;
        }
        return s.substring(0, n - 1) + "\u2026";
    }

    private String getOpenInventoryPlainTitle(Inventory inventory) {
        try {
            InventoryView view;
            block14: {
                if (inventory == null || inventory.getViewers().isEmpty()) {
                    return "";
                }
                HumanEntity viewer = (HumanEntity)inventory.getViewers().get(0);
                view = viewer.getOpenInventory();
                if (view == null) {
                    return "";
                }
                try {
                    Method m = view.getClass().getMethod("title", new Class[0]);
                    Object comp = m.invoke((Object)view, new Object[0]);
                    if (comp == null) break block14;
                    try {
                        Class<?> serCls = Class.forName("net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer");
                        Method plainText = serCls.getMethod("plainText", new Class[0]);
                        Object serializer = plainText.invoke(null, new Object[0]);
                        Class<?> componentCls = Class.forName("net.kyori.adventure.text.Component");
                        Method serialize = serializer.getClass().getMethod("serialize", componentCls);
                        Object s = serialize.invoke(serializer, comp);
                        if (s != null) {
                            return String.valueOf(s);
                        }
                    }
                    catch (Throwable ignored) {
                        try {
                            Method content = comp.getClass().getMethod("content", new Class[0]);
                            Object s2 = content.invoke(comp, new Object[0]);
                            if (s2 != null) {
                                return String.valueOf(s2);
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        return String.valueOf(comp);
                    }
                }
                catch (Throwable m) {
                    // empty catch block
                }
            }
            try {
                Method m2 = view.getClass().getMethod("getTitle", new Class[0]);
                Object s3 = m2.invoke((Object)view, new Object[0]);
                return s3 != null ? String.valueOf(s3) : "";
            }
            catch (Throwable throwable) {
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "";
    }

    private boolean isItem(ItemStack item, Material material, String name) {
        if (item == null || item.getType() != material || !item.hasItemMeta()) {
            return false;
        }
        String displayName = GuiCompat.getDisplayName(item.getItemMeta());
        return name.equals(displayName);
    }

    public boolean isMainMenu(Inventory inventory) {
        if (inventory == null || inventory.getHolder() != null || inventory.getViewers().isEmpty()) {
            return false;
        }
        String title = this.getOpenInventoryPlainTitle(inventory);
        return this.plugin.getConfigManager().getGuiMainMenuTitle().equals(title);
    }

    public boolean isTeamSelector(Inventory inventory) {
        if (inventory == null || inventory.getHolder() != null || inventory.getViewers().isEmpty()) {
            return false;
        }
        String title = this.getOpenInventoryPlainTitle(inventory);
        return this.plugin.getConfigManager().getGuiTeamSelectorTitle().equals(title);
    }

    public boolean isSettingsMenu(Inventory inventory) {
        if (inventory == null || inventory.getHolder() != null || inventory.getViewers().isEmpty()) {
            return false;
        }
        String title = this.getOpenInventoryPlainTitle(inventory);
        return this.plugin.getConfigManager().getGuiSettingsTitle().equals(title);
    }

    public boolean isBackButton(ItemStack item) {
        return this.isItem(item, Material.ARROW, "\u00a77\u00a7lBack");
    }

    public boolean isStartButton(ItemStack item) {
        return this.isItem(item, Material.GREEN_CONCRETE, "\u00a7a\u00a7lStart Game");
    }

    public boolean isStopButton(ItemStack item) {
        return this.isItem(item, Material.RED_CONCRETE, "\u00a7c\u00a7lStop Game");
    }

    public boolean isPauseButton(ItemStack item) {
        return this.isItem(item, Material.YELLOW_CONCRETE, "\u00a7e\u00a7lPause Game");
    }

    public boolean isResumeButton(ItemStack item) {
        return this.isItem(item, Material.LIME_CONCRETE, "\u00a7a\u00a7lResume Game");
    }

    public boolean isTeamSelectorButton(ItemStack item) {
        return this.isItem(item, Material.PLAYER_HEAD, "\u00a7e\u00a7lTeam Selector");
    }

    public boolean isSettingsButton(ItemStack item) {
        return this.isItem(item, Material.COMPARATOR, "\u00a7a\u00a7lSettings");
    }

    public boolean isRunnerTeamButton(ItemStack item) {
        return this.isItem(item, Material.DIAMOND_BOOTS, "\u00a7b\u00a7lRunners");
    }

    public boolean isHunterTeamButton(ItemStack item) {
        return this.isItem(item, Material.IRON_SWORD, "\u00a7c\u00a7lHunters");
    }

    public ItemStack createGuiButton(Material material, String name, List<String> lore, String buttonId) {
        ItemStack item = this.createItem(material, name, lore);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.getPersistentDataContainer().set(new NamespacedKey((Plugin)this.plugin, BUTTON_ID_KEY), PersistentDataType.STRING, (Object)buttonId);
            item.setItemMeta(meta);
        }
        return item;
    }

    public String getButtonId(ItemStack item) {
        if (item != null && item.hasItemMeta()) {
            return (String)item.getItemMeta().getPersistentDataContainer().get(new NamespacedKey((Plugin)this.plugin, BUTTON_ID_KEY), PersistentDataType.STRING);
        }
        return null;
    }

    public boolean isSwapIntervalButton(ItemStack item) {
        String buttonId = this.getButtonId(item);
        return "swap_interval".equals(buttonId) && item != null && item.getType() == Material.CLOCK;
    }

    public boolean isRandomizeSwapButton(ItemStack item) {
        String buttonId = this.getButtonId(item);
        return "random_swaps".equals(buttonId) && item != null && (item.getType() == Material.CLOCK || item.getType() == Material.REPEATER);
    }

    public boolean isSafeSwapButton(ItemStack item) {
        String buttonId = this.getButtonId(item);
        return "safe_swaps".equals(buttonId) && item != null && (item.getType() == Material.TOTEM_OF_UNDYING || item.getType() == Material.BARRIER);
    }

    public boolean isActiveRunnerTimerButton(ItemStack item) {
        return this.isItem(item, Material.CLOCK, "\u00a7e\u00a7lActive Runner Timer");
    }

    public boolean isWaitingRunnerTimerButton(ItemStack item) {
        return this.isItem(item, Material.CLOCK, "\u00a7e\u00a7lWaiting Runner Timer");
    }

    public boolean isHunterTimerButton(ItemStack item) {
        return this.isItem(item, Material.CLOCK, "\u00a7e\u00a7lHunter Timer");
    }

    private String getVisibilityDisplay(String visibility) {
        switch (visibility) {
            case "always": {
                return "\u00a7aAlways Show";
            }
            case "last_10": {
                return "\u00a7eLast 10 Seconds";
            }
            case "never": {
                return "\u00a7cNever Show";
            }
        }
        return "\u00a77Unknown";
    }

    public String getNextVisibility(String current) {
        switch (current) {
            case "always": {
                return "last_10";
            }
            case "last_10": {
                return "never";
            }
            case "never": {
                return "always";
            }
        }
        return "last_10";
    }

    public void setPlayerTeam(Player player, Team team) {
        this.plugin.getGameManager().getPlayerState(player).setSelectedTeam(team);
        this.updateTeamSelectors();
    }

    public void updateTeamSelectors() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!this.isTeamSelector(player.getOpenInventory().getTopInventory())) continue;
            this.openTeamSelector(player);
        }
    }

    public void updateMainMenus() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!this.isMainMenu(player.getOpenInventory().getTopInventory())) continue;
            this.openMainMenu(player);
        }
    }

    public void updateSettingsMenus() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!this.isSettingsMenu(player.getOpenInventory().getTopInventory())) continue;
            this.openSettingsMenu(player);
        }
    }

    public Team getSelectedTeam(Player player) {
        return this.plugin.getGameManager().getPlayerState(player).getSelectedTeam();
    }

    public boolean isSwapRandomized() {
        return this.plugin.getConfigManager().isSwapRandomized();
    }

    public void openStatisticsMenu(Player player) {
        Inventory inventory = GuiCompat.createInventory(null, 54, "\u00a7b\u00a7lStatistics & Tracking");
        ItemStack filler = this.createItem(Material.BLACK_STAINED_GLASS_PANE, " ", new String[0]);
        this.fillBorder(inventory, filler);
        this.addGameControlsHeader(inventory);
        inventory.setItem(0, this.createGuiButton(Material.ARROW, "\u00a77\u00a7lBack", List.of("\u00a77Return to Settings"), "back_settings"));
        boolean statsEnabled = this.plugin.getConfig().getBoolean("stats.enabled", true);
        boolean distanceTracking = this.plugin.getConfig().getBoolean("stats.distance_tracking", true);
        int distanceUpdateTicks = this.plugin.getConfig().getInt("stats.distance_update_ticks", 20);
        ItemStack statsToggle = this.createGuiButton(statsEnabled ? Material.LIME_DYE : Material.GRAY_DYE, "\u00a7e\u00a7lStatistics: " + (statsEnabled ? "\u00a7aEnabled" : "\u00a7cDisabled"), List.of("\u00a77Toggle statistics collection", "\u00a77Currently: " + (statsEnabled ? "\u00a7aOn" : "\u00a7cOff")), "toggle_stats");
        inventory.setItem(11, statsToggle);
        ItemStack distanceToggle = this.createGuiButton(distanceTracking ? Material.COMPASS : Material.BARRIER, "\u00a76\u00a7lDistance Tracking: " + (distanceTracking ? "\u00a7aEnabled" : "\u00a7cDisabled"), List.of("\u00a77Track distance between players", "\u00a77Update Rate: \u00a7f" + distanceUpdateTicks + " ticks"), "toggle_distance_tracking");
        inventory.setItem(13, distanceToggle);
        ItemStack updateRate = this.createGuiButton(Material.REPEATER, "\u00a76\u00a7lUpdate Rate", List.of("\u00a77Current: \u00a7f" + distanceUpdateTicks + " ticks", "\u00a77Left/Right click: \u00b15 ticks"), "stats_update_rate");
        inventory.setItem(15, updateRate);
        this.openInventorySoon(player, inventory);
    }

    public void openKitsMenu(Player player) {
        Inventory inventory = GuiCompat.createInventory(null, 54, "\u00a76\u00a7lKit Management");
        ItemStack filler = this.createItem(Material.BLACK_STAINED_GLASS_PANE, " ", new String[0]);
        this.fillBorder(inventory, filler);
        this.addGameControlsHeader(inventory);
        inventory.setItem(0, this.createGuiButton(Material.ARROW, "\u00a77\u00a7lBack", List.of("\u00a77Return to Settings"), "back_settings"));
        boolean runnerKitEnabled = this.plugin.getConfig().getBoolean("kits.runner_kit.enabled", false);
        boolean hunterKitEnabled = this.plugin.getConfig().getBoolean("kits.hunter_kit.enabled", false);
        ItemStack runnerKit = this.createGuiButton(runnerKitEnabled ? Material.DIAMOND_SWORD : Material.WOODEN_SWORD, "\u00a7a\u00a7lRunner Kit: " + (runnerKitEnabled ? "\u00a7aEnabled" : "\u00a7cDisabled"), List.of("\u00a77Starting equipment for runners", "\u00a77Click to edit kit contents"), "edit_runner_kit");
        inventory.setItem(20, runnerKit);
        ItemStack hunterKit = this.createGuiButton(hunterKitEnabled ? Material.BOW : Material.STICK, "\u00a7c\u00a7lHunter Kit: " + (hunterKitEnabled ? "\u00a7aEnabled" : "\u00a7cDisabled"), List.of("\u00a77Starting equipment for hunters", "\u00a77Click to edit kit contents"), "edit_hunter_kit");
        inventory.setItem(24, hunterKit);
        this.openInventorySoon(player, inventory);
    }

    public void openKitEditor(Player player, String kitType) {
        String title = kitType.equals("runner") ? "\u00a7a\u00a7lRunner Kit Editor" : "\u00a7c\u00a7lHunter Kit Editor";
        Inventory inventory = GuiCompat.createInventory(null, 54, title);
        ItemStack instructions = this.createItem(Material.PAPER, "\u00a7e\u00a7lInstructions", List.of("\u00a77Place items you want in the kit", "\u00a77Empty slots will be ignored", "\u00a77Click 'Save Kit' when finished"));
        inventory.setItem(4, instructions);
        ItemStack save = this.createGuiButton(Material.EMERALD, "\u00a7a\u00a7lSave Kit", List.of("\u00a77Save current contents as kit"), "save_" + kitType + "_kit");
        inventory.setItem(49, save);
        inventory.setItem(45, this.createGuiButton(Material.ARROW, "\u00a77\u00a7lBack", List.of("\u00a77Return to Kit Menu"), "back_kits"));
        this.openInventorySoon(player, inventory);
    }

    public void openBountyMenu(Player player) {
        Inventory inventory = GuiCompat.createInventory(null, 54, "\u00a76\u00a7lBounty System");
        ItemStack filler = this.createItem(Material.BLACK_STAINED_GLASS_PANE, " ", new String[0]);
        this.fillBorder(inventory, filler);
        this.addGameControlsHeader(inventory);
        inventory.setItem(0, this.createGuiButton(Material.ARROW, "\u00a77\u00a7lBack", List.of("\u00a77Return to Settings"), "back_settings"));
        boolean bountyEnabled = this.plugin.getConfig().getBoolean("bounty.enabled", false);
        int baseBounty = this.plugin.getConfig().getInt("bounty.base_amount", 10);
        int killMultiplier = this.plugin.getConfig().getInt("bounty.kill_multiplier", 2);
        int maxBounty = this.plugin.getConfig().getInt("bounty.max_amount", 100);
        ItemStack enableToggle = this.createGuiButton(bountyEnabled ? Material.GOLD_INGOT : Material.BARRIER, "\u00a76\u00a7lBounty System: " + (bountyEnabled ? "\u00a7aEnabled" : "\u00a7cDisabled"), List.of("\u00a77Toggle bounty rewards for kills"), "toggle_bounty");
        inventory.setItem(11, enableToggle);
        ItemStack baseAmount = this.createGuiButton(Material.GOLD_NUGGET, "\u00a76\u00a7lBase Bounty", List.of("\u00a77Current: \u00a7f" + baseBounty + " gold", "\u00a77Left/Right click: \u00b15"), "bounty_base");
        inventory.setItem(13, baseAmount);
        ItemStack multiplier = this.createGuiButton(Material.EXPERIENCE_BOTTLE, "\u00a76\u00a7lKill Multiplier", List.of("\u00a77Current: \u00a7fx" + killMultiplier, "\u00a77Increases bounty per kill"), "bounty_multiplier");
        inventory.setItem(15, multiplier);
        ItemStack maxAmount = this.createGuiButton(Material.GOLD_BLOCK, "\u00a76\u00a7lMax Bounty", List.of("\u00a77Current: \u00a7f" + maxBounty + " gold", "\u00a77Left/Right click: \u00b110"), "bounty_max");
        inventory.setItem(17, maxAmount);
        this.openInventorySoon(player, inventory);
    }

    public void openLastStandMenu(Player player) {
        Inventory inventory = GuiCompat.createInventory(null, 54, "\u00a7c\u00a7lLast Stand Mode");
        ItemStack filler = this.createItem(Material.BLACK_STAINED_GLASS_PANE, " ", new String[0]);
        this.fillBorder(inventory, filler);
        this.addGameControlsHeader(inventory);
        inventory.setItem(0, this.createGuiButton(Material.ARROW, "\u00a77\u00a7lBack", List.of("\u00a77Return to Settings"), "back_settings"));
        boolean lastStandEnabled = this.plugin.getConfig().getBoolean("last_stand.enabled", false);
        int healthThreshold = this.plugin.getConfig().getInt("last_stand.health_threshold", 4);
        int duration = this.plugin.getConfig().getInt("last_stand.duration", 30);
        ItemStack enableToggle = this.createGuiButton(lastStandEnabled ? Material.TOTEM_OF_UNDYING : Material.BARRIER, "\u00a7c\u00a7lLast Stand: " + (lastStandEnabled ? "\u00a7aEnabled" : "\u00a7cDisabled"), List.of("\u00a77Special effects when low on health", "\u00a77Click to toggle on/off"), "toggle_last_stand");
        inventory.setItem(11, enableToggle);
        ItemStack threshold = this.createGuiButton(Material.RED_DYE, "\u00a7c\u00a7lHealth Threshold", List.of("\u00a77Current: \u00a7f" + healthThreshold + " hearts", "\u00a77Left click: +1 heart", "\u00a77Right click: -1 heart"), "last_stand_threshold");
        inventory.setItem(13, threshold);
        ItemStack durationItem = this.createGuiButton(Material.CLOCK, "\u00a7c\u00a7lDuration", List.of("\u00a77Current: \u00a7f" + duration + " seconds", "\u00a77Left click: +5 seconds", "\u00a77Right click: -5 seconds"), "last_stand_duration");
        inventory.setItem(15, durationItem);
        ItemStack strengthAmp = this.createGuiButton(Material.IRON_SWORD, "\u00a7e\u00a7lStrength Amplifier", List.of("\u00a77Current: \u00a7f" + this.plugin.getConfigManager().getLastStandStrengthAmplifier(), "\u00a77Left click: +1 level", "\u00a77Right click: -1 level"), "last_stand_strength");
        inventory.setItem(20, strengthAmp);
        ItemStack speedAmp = this.createGuiButton(Material.SUGAR, "\u00a7b\u00a7lSpeed Amplifier", List.of("\u00a77Current: \u00a7f" + this.plugin.getConfigManager().getLastStandSpeedAmplifier(), "\u00a77Left click: +1 level", "\u00a77Right click: -1 level"), "last_stand_speed");
        inventory.setItem(24, speedAmp);
        this.openInventorySoon(player, inventory);
    }

    public void openCompassSettingsMenu(Player player) {
        Inventory inventory = GuiCompat.createInventory(null, 54, "\u00a7b\u00a7lCompass Settings");
        ItemStack filler = this.createItem(Material.BLACK_STAINED_GLASS_PANE, " ", new String[0]);
        this.fillBorder(inventory, filler);
        this.addGameControlsHeader(inventory);
        inventory.setItem(0, this.createGuiButton(Material.ARROW, "\u00a77\u00a7lBack", List.of("\u00a77Return to Settings"), "back_settings"));
        boolean compassEnabled = this.plugin.getConfig().getBoolean("compass.enabled", true);
        int updateInterval = this.plugin.getConfig().getInt("compass.update_interval", 20);
        int trackingRange = this.plugin.getConfig().getInt("compass.tracking_range", 100);
        boolean showDistance = this.plugin.getConfig().getBoolean("compass.show_distance", true);
        ItemStack enableToggle = this.createGuiButton(compassEnabled ? Material.COMPASS : Material.BARRIER, "\u00a7b\u00a7lCompass Tracking: " + (compassEnabled ? "\u00a7aEnabled" : "\u00a7cDisabled"), List.of("\u00a77Toggle compass tracking system"), "toggle_compass");
        inventory.setItem(11, enableToggle);
        ItemStack updateRate = this.createGuiButton(Material.REPEATER, "\u00a7b\u00a7lUpdate Interval", List.of("\u00a77Current: \u00a7f" + updateInterval + " ticks", "\u00a77Left/Right click: \u00b15"), "compass_update");
        inventory.setItem(13, updateRate);
        ItemStack range = this.createGuiButton(Material.SPYGLASS, "\u00a7b\u00a7lTracking Range", List.of("\u00a77Current: \u00a7f" + trackingRange + " blocks", "\u00a77Left/Right click: \u00b110"), "compass_range");
        inventory.setItem(15, range);
        ItemStack distanceToggle = this.createGuiButton(showDistance ? Material.MAP : Material.PAPER, "\u00a7b\u00a7lShow Distance: " + (showDistance ? "\u00a7aEnabled" : "\u00a7cDisabled"), List.of("\u00a77Show distance to tracked player"), "compass_distance");
        inventory.setItem(17, distanceToggle);
        this.openInventorySoon(player, inventory);
    }

    public void openSuddenDeathMenu(Player player) {
        Inventory inventory = GuiCompat.createInventory(null, 54, "\u00a74\u00a7lSudden Death Mode");
        ItemStack filler = this.createItem(Material.BLACK_STAINED_GLASS_PANE, " ", new String[0]);
        this.fillBorder(inventory, filler);
        this.addGameControlsHeader(inventory);
        inventory.setItem(0, this.createGuiButton(Material.ARROW, "\u00a77\u00a7lBack", List.of("\u00a77Return to Settings"), "back_settings"));
        boolean suddenDeathEnabled = this.plugin.getConfig().getBoolean("sudden_death.enabled", false);
        int triggerTime = this.plugin.getConfig().getInt("sudden_death.trigger_time", 1800);
        boolean noRegen = this.plugin.getConfig().getBoolean("sudden_death.no_regen", true);
        boolean oneHit = this.plugin.getConfig().getBoolean("sudden_death.one_hit_kill", false);
        boolean gameRunning = this.plugin.getGameManager().isGameRunning();
        boolean suddenDeathActive = this.plugin.getSuddenDeathManager().isActive();
        ItemStack enableToggle = this.createGuiButton(suddenDeathEnabled ? Material.WITHER_SKELETON_SKULL : Material.BARRIER, "\u00a74\u00a7lSudden Death: " + (suddenDeathEnabled ? "\u00a7aEnabled" : "\u00a7cDisabled"), List.of("\u00a77Activate after long games", "\u00a77Click to toggle on/off"), "toggle_sudden_death");
        inventory.setItem(11, enableToggle);
        ItemStack triggerTimeItem = this.createGuiButton(Material.CLOCK, "\u00a74\u00a7lTrigger Time", List.of("\u00a77Current: \u00a7f" + triggerTime / 60 + " minutes", "\u00a77Left click: +5 minutes", "\u00a77Right click: -5 minutes"), "sudden_death_time");
        inventory.setItem(13, triggerTimeItem);
        ItemStack noRegenToggle = this.createGuiButton(noRegen ? Material.ROTTEN_FLESH : Material.GOLDEN_APPLE, "\u00a74\u00a7lNo Regeneration: " + (noRegen ? "\u00a7aEnabled" : "\u00a7cDisabled"), List.of("\u00a77Disable natural health regen", "\u00a77Click to toggle"), "sudden_death_no_regen");
        inventory.setItem(15, noRegenToggle);
        ItemStack oneHitToggle = this.createGuiButton(oneHit ? Material.NETHERITE_SWORD : Material.WOODEN_SWORD, "\u00a74\u00a7lOne Hit Kill: " + (oneHit ? "\u00a7aEnabled" : "\u00a7cDisabled"), List.of("\u00a77Any damage kills instantly", "\u00a77\u00a7cExtremely dangerous mode!", "\u00a77Click to toggle"), "sudden_death_one_hit");
        inventory.setItem(17, oneHitToggle);
        if (gameRunning && !suddenDeathActive) {
            ItemStack activateNow = this.createGuiButton(Material.TNT, "\u00a7c\u00a7lActivate Now", List.of("\u00a77Force immediate sudden death", "\u00a77\u00a7cWarning: Will teleport all players!"), "activate_sudden_death_now");
            inventory.setItem(29, activateNow);
        }
        if (this.plugin.getSuddenDeathManager().isScheduled()) {
            ItemStack cancel = this.createGuiButton(Material.BARRIER, "\u00a7e\u00a7lCancel Scheduled", List.of("\u00a77Cancel automatic sudden death"), "cancel_sudden_death");
            inventory.setItem(31, cancel);
        } else if (gameRunning) {
            ItemStack schedule = this.createGuiButton(Material.CLOCK, "\u00a7e\u00a7lSchedule Activation", List.of("\u00a77Auto-activate after delay time"), "schedule_sudden_death");
            inventory.setItem(31, schedule);
        }
        this.openInventorySoon(player, inventory);
    }

    public void openBroadcastSettingsMenu(Player player) {
        Inventory inventory = GuiCompat.createInventory(null, 27, "\u00a7e\u00a7lBroadcast Settings");
        ItemStack filler = this.createItem(Material.YELLOW_STAINED_GLASS_PANE, " ", new String[0]);
        this.fillBorder(inventory, filler);
        this.addGameControlsHeader(inventory);
        inventory.setItem(0, this.createGuiButton(Material.ARROW, "\u00a77\u00a7lBack", List.of("\u00a77Return to Advanced Settings"), "back_settings"));
        boolean broadcastEnabled = this.plugin.getConfig().getBoolean("broadcasts.enabled", true);
        inventory.setItem(10, this.createGuiButton(broadcastEnabled ? Material.BELL : Material.GRAY_DYE, "\u00a7e\u00a7lBroadcast Events: " + (broadcastEnabled ? "\u00a7aON" : "\u00a7cOFF"), List.of("\u00a77Toggle all broadcast messages"), "toggle_broadcasts"));
        boolean gameEvents = this.plugin.getConfig().getBoolean("broadcasts.game_events", true);
        inventory.setItem(12, this.createGuiButton(gameEvents ? Material.EMERALD : Material.GRAY_DYE, "\u00a7e\u00a7lGame Events: " + (gameEvents ? "\u00a7aON" : "\u00a7cOFF"), List.of("\u00a77Broadcast start/stop/pause events"), "toggle_game_events"));
        boolean teamChanges = this.plugin.getConfig().getBoolean("broadcasts.team_changes", true);
        inventory.setItem(14, this.createGuiButton(teamChanges ? Material.PLAYER_HEAD : Material.GRAY_DYE, "\u00a7e\u00a7lTeam Changes: " + (teamChanges ? "\u00a7aON" : "\u00a7cOFF"), List.of("\u00a77Broadcast team assignment changes"), "toggle_team_changes"));
        this.openInventorySoon(player, inventory);
    }

    public void openLimboSettingsMenu(Player player) {
        Inventory inventory = GuiCompat.createInventory(null, 27, "\u00a76\u00a7lLimbo Configuration");
        ItemStack filler = this.createItem(Material.PURPLE_STAINED_GLASS_PANE, " ", new String[0]);
        this.fillBorder(inventory, filler);
        this.addGameControlsHeader(inventory);
        inventory.setItem(0, this.createGuiButton(Material.ARROW, "\u00a77\u00a7lBack", List.of("\u00a77Return to Advanced Settings"), "back_settings"));
        String limboWorld = this.plugin.getConfig().getString("limbo.world", "world");
        double limboX = this.plugin.getConfig().getDouble("limbo.x", 0.5);
        double limboY = this.plugin.getConfig().getDouble("limbo.y", 200.0);
        double limboZ = this.plugin.getConfig().getDouble("limbo.z", 0.5);
        inventory.setItem(10, this.createGuiButton(Material.GRASS_BLOCK, "\u00a7e\u00a7lLimbo World", List.of("\u00a77Current: \u00a7f" + limboWorld, "\u00a77Click to change world"), "limbo_world"));
        inventory.setItem(12, this.createGuiButton(Material.COMPASS, "\u00a7e\u00a7lLimbo Coordinates", List.of("\u00a77X: \u00a7f" + limboX, "\u00a77Y: \u00a7f" + limboY, "\u00a77Z: \u00a7f" + limboZ, "\u00a77Click to edit coordinates"), "limbo_coords"));
        inventory.setItem(14, this.createGuiButton(Material.ENDER_PEARL, "\u00a7a\u00a7lSet to Current Location", List.of("\u00a77Set limbo to your current position"), "limbo_set_current"));
        this.openInventorySoon(player, inventory);
    }

    public void openUIPerformanceMenu(Player player) {
        Inventory inventory = GuiCompat.createInventory(null, 27, "\u00a7d\u00a7lUI Performance Settings");
        ItemStack filler = this.createItem(Material.MAGENTA_STAINED_GLASS_PANE, " ", new String[0]);
        this.fillBorder(inventory, filler);
        this.addGameControlsHeader(inventory);
        inventory.setItem(0, this.createGuiButton(Material.ARROW, "\u00a77\u00a7lBack", List.of("\u00a77Return to Advanced Settings"), "back_settings"));
        int actionbarTicks = this.plugin.getConfig().getInt("ui.update_ticks.actionbar", 20);
        int titleTicks = this.plugin.getConfig().getInt("ui.update_ticks.title", 10);
        int trackerTicks = this.plugin.getConfig().getInt("tracker.update_ticks", 20);
        inventory.setItem(10, this.createGuiButton(Material.CLOCK, "\u00a7e\u00a7lActionbar Update Rate", List.of("\u00a77Current: \u00a7f" + actionbarTicks + " ticks (" + (double)actionbarTicks / 20.0 + "s)", "\u00a77How often timer actionbars update", "\u00a77Left/Right: \u00b15 ticks"), "actionbar_rate"));
        inventory.setItem(12, this.createGuiButton(Material.EXPERIENCE_BOTTLE, "\u00a7e\u00a7lTitle Update Rate", List.of("\u00a77Current: \u00a7f" + titleTicks + " ticks (" + (double)titleTicks / 20.0 + "s)", "\u00a77How often waiting runner titles update", "\u00a77Left/Right: \u00b15 ticks"), "title_rate"));
        inventory.setItem(14, this.createGuiButton(Material.COMPASS, "\u00a7e\u00a7lTracker Update Rate", List.of("\u00a77Current: \u00a7f" + trackerTicks + " ticks (" + (double)trackerTicks / 20.0 + "s)", "\u00a77How often hunter compasses update", "\u00a77Left/Right: \u00b15 ticks"), "tracker_rate"));
        inventory.setItem(16, this.createGuiButton(Material.REDSTONE, "\u00a7c\u00a7lPerformance Tips", List.of("\u00a77Lower values = more responsive UI", "\u00a77Higher values = better server performance", "\u00a77Recommended: 10-20 ticks"), "performance_info"));
        this.openInventorySoon(player, inventory);
    }
}

