/*
 * Decompiled with CFR 0.152.
 */
package com.example.speedrunnerswap.listeners;

import com.example.speedrunnerswap.SpeedrunnerSwap;
import com.example.speedrunnerswap.models.Team;
import io.papermc.paper.event.player.AsyncChatEvent;
import java.lang.reflect.Method;
import java.util.Iterator;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerAdvancementDoneEvent;
import org.bukkit.event.player.PlayerBedEnterEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;

public class EventListeners
implements Listener {
    private final SpeedrunnerSwap plugin;
    private volatile long lastHotPotatoTriggerMs = 0L;

    public EventListeners(SpeedrunnerSwap plugin) {
        this.plugin = plugin;
    }

    private String getPlainTitle(InventoryView view) {
        Object s;
        block15: {
            if (view == null) {
                return "";
            }
            try {
                Method m = view.getClass().getMethod("title", new Class[0]);
                Object comp = m.invoke((Object)view, new Object[0]);
                if (comp == null) break block15;
                try {
                    Class<?> serCls = Class.forName("net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer");
                    Method plainText = serCls.getMethod("plainText", new Class[0]);
                    Object serializer = plainText.invoke(null, new Object[0]);
                    Class<?> componentCls = Class.forName("net.kyori.adventure.text.Component");
                    Method serialize = serializer.getClass().getMethod("serialize", componentCls);
                    Object s2 = serialize.invoke(serializer, comp);
                    if (s2 != null) {
                        return String.valueOf(s2);
                    }
                }
                catch (Throwable ignored) {
                    try {
                        Method content = comp.getClass().getMethod("content", new Class[0]);
                        Object s3 = content.invoke(comp, new Object[0]);
                        if (s3 != null) {
                            return String.valueOf(s3);
                        }
                    }
                    catch (Throwable alsoIgnored) {
                        return String.valueOf(comp);
                    }
                }
            }
            catch (Throwable m) {
                // empty catch block
            }
        }
        try {
            Method getTitle = view.getClass().getMethod("getTitle", new Class[0]);
            s = getTitle.invoke((Object)view, new Object[0]);
            if (s != null) {
                return String.valueOf(s);
            }
        }
        catch (Throwable getTitle) {
            // empty catch block
        }
        try {
            Method getOrig = view.getClass().getMethod("getOriginalTitle", new Class[0]);
            s = getOrig.invoke((Object)view, new Object[0]);
            if (s != null) {
                return String.valueOf(s);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "";
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (this.plugin.getGameManager() != null && this.plugin.getGameManager().isGameRunning()) {
            this.plugin.getGameManager().handlePlayerJoin(player);
            if (this.plugin.getConfig().getBoolean("stats.enabled", true)) {
                this.plugin.getStatsManager().initializePlayerStats(player);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onRunnerDamaged(EntityDamageEvent event) {
        if (!this.plugin.getGameManager().isGameRunning()) {
            return;
        }
        if (!this.plugin.getConfigManager().isHotPotatoModeEnabled()) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (!this.plugin.getGameManager().isRunner(player)) {
            return;
        }
        if (!player.equals((Object)this.plugin.getGameManager().getActiveRunner())) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now - this.lastHotPotatoTriggerMs < 1000L) {
            return;
        }
        this.lastHotPotatoTriggerMs = now;
        this.plugin.getGameManager().triggerImmediateSwap();
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerDeath(PlayerDeathEvent event) {
        Player player = event.getEntity();
        if (this.plugin.getGameManager().isGameRunning()) {
            try {
                Method m = event.getClass().getMethod("setDeathMessage", String.class);
                m.invoke((Object)event, new Object[]{null});
            }
            catch (Throwable t) {
                try {
                    Method m2 = event.getClass().getMethod("deathMessage", Class.forName("net.kyori.adventure.text.Component"));
                    m2.invoke((Object)event, new Object[]{null});
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        if (this.plugin.getGameManager().isGameRunning() && this.plugin.getGameManager().isHunter(player)) {
            event.getDrops().removeIf(item -> item != null && item.getType() == Material.COMPASS);
        }
        if (this.plugin.getGameManager().isGameRunning() && this.plugin.getGameManager().isRunner(player)) {
            SpeedrunnerSwap.SwapMode mode = this.plugin.getCurrentMode();
            if (mode == SpeedrunnerSwap.SwapMode.DREAM) {
                this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
                    if (this.plugin.getGameManager().isGameRunning()) {
                        this.plugin.getGameManager().endGame(Team.HUNTER);
                    }
                });
            } else {
                try {
                    player.sendMessage("\u00a7eYou died, but the game continues in this mode.");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    @EventHandler
    public void onPlayerDropItem(PlayerDropItemEvent event) {
        Player player = event.getPlayer();
        ItemStack droppedItem = event.getItemDrop().getItemStack();
        if (this.plugin.getGameManager().isGameRunning() && this.plugin.getGameManager().isHunter(player) && droppedItem.getType() == Material.COMPASS) {
            event.setCancelled(true);
            player.sendMessage("\u00a7cYou cannot drop your tracking compass!");
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onInventoryDrag(InventoryDragEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        if (!this.plugin.getGameManager().isGameRunning() || !this.plugin.getGameManager().isHunter(player)) {
            return;
        }
        ItemStack dragged = event.getOldCursor();
        if (dragged == null || dragged.getType() != Material.COMPASS) {
            return;
        }
        int topSize = event.getView().getTopInventory() != null ? event.getView().getTopInventory().getSize() : 0;
        Iterator iterator = event.getRawSlots().iterator();
        while (iterator.hasNext()) {
            int rawSlot = (Integer)iterator.next();
            if (rawSlot >= topSize) continue;
            event.setCancelled(true);
            player.sendMessage("\u00a7cYou cannot store your tracking compass in containers!");
            return;
        }
    }

    @EventHandler
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        Player player = event.getPlayer();
        if (this.plugin.getGameManager().isGameRunning() && this.plugin.getGameManager().isHunter(player)) {
            this.plugin.getTrackerManager().giveTrackingCompass(player);
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        this.plugin.getGameManager().handlePlayerQuit(player);
        this.plugin.getGameManager().updateTeams();
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onAnyDamage(EntityDamageEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player victim = (Player)entity;
        if (!this.plugin.getGameManager().isGameRunning()) {
            return;
        }
        if (this.plugin.getGameManager().isRunner(victim) && this.plugin.getGameManager().getActiveRunner() != victim && "CAGE".equalsIgnoreCase(this.plugin.getConfigManager().getFreezeMode())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerChangedWorld(PlayerChangedWorldEvent event) {
        Player active;
        Player player = event.getPlayer();
        if (!this.plugin.getGameManager().isGameRunning()) {
            return;
        }
        if (this.plugin.getGameManager().isHunter(player)) {
            this.plugin.getTrackerManager().giveTrackingCompass(player);
        }
        if ((active = this.plugin.getGameManager().getActiveRunner()) != null && active.equals((Object)player)) {
            this.plugin.getTrackerManager().updateAllHunterCompasses();
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onInventoryClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        Inventory inventory = event.getClickedInventory();
        ItemStack clickedItem = event.getCurrentItem();
        if (inventory == null || clickedItem == null || clickedItem.getType() == Material.AIR) {
            return;
        }
        String title = this.getPlainTitle(event.getView());
        if (this.isPluginGuiTitle(title)) {
            return;
        }
        if (this.plugin.getGameManager().isGameRunning() && this.plugin.getGameManager().isHunter(player)) {
            ItemStack hotbarItem;
            int hb;
            InventoryAction action;
            boolean clickedInPlayerInv = inventory.equals((Object)player.getInventory());
            ItemStack cursor = event.getCursor();
            if (cursor != null && cursor.getType() == Material.COMPASS && !clickedInPlayerInv) {
                event.setCancelled(true);
                player.sendMessage("\u00a7cYou cannot store your tracking compass in containers!");
                return;
            }
            if (clickedItem.getType() == Material.COMPASS) {
                if (event.isShiftClick()) {
                    event.setCancelled(true);
                    player.sendMessage("\u00a7cYou cannot quick-move your tracking compass!");
                    return;
                }
                if (!clickedInPlayerInv) {
                    event.setCancelled(true);
                    player.sendMessage("\u00a7cYou cannot store your tracking compass in containers!");
                    return;
                }
            }
            if ((action = event.getAction()) == InventoryAction.MOVE_TO_OTHER_INVENTORY && clickedItem.getType() == Material.COMPASS) {
                event.setCancelled(true);
                player.sendMessage("\u00a7cYou cannot quick-move your tracking compass!");
                return;
            }
            String actName = action.name();
            if ((action == InventoryAction.HOTBAR_SWAP || "HOTBAR_MOVE_AND_READD".equals(actName)) && (hb = event.getHotbarButton()) >= 0 && (hotbarItem = player.getInventory().getItem(hb)) != null && hotbarItem.getType() == Material.COMPASS && !clickedInPlayerInv) {
                event.setCancelled(true);
                player.sendMessage("\u00a7cYou cannot store your tracking compass in containers!");
                return;
            }
        }
        if (this.plugin.getGameManager().isGameRunning() && this.plugin.getGameManager().isRunner(player) && this.plugin.getGameManager().getActiveRunner() != player) {
            event.setCancelled(true);
            player.sendMessage("\u00a7cYou cannot interact with items while inactive!");
            return;
        }
    }

    private boolean isPluginGuiTitle(String title) {
        if (title == null || title.isEmpty()) {
            return false;
        }
        return title.contains("SpeedrunnerSwap") || title.contains("Main Menu") || title.contains("Team Selector") || title.contains("Settings") || title.contains("Kits") || title.contains("Effects") || title.contains("Power-ups") || title.contains("Power-up Durations") || title.contains("World Border") || title.contains("Bounty") || title.contains("Last Stand") || title.contains("Compass") || title.contains("Sudden Death") || title.contains("Statistics") || title.contains("Dangerous Blocks") || title.contains("Edit ") && title.contains(" Kit");
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerChat(AsyncChatEvent event) {
        Player player = event.getPlayer();
        if (this.plugin.getGameManager().isGameRunning() && this.plugin.getGameManager().isRunner(player) && this.plugin.getGameManager().getActiveRunner() != player) {
            player.sendMessage("\u00a7c[SpeedrunnerSwap] You cannot chat while inactive.");
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerChatLegacy(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        if (!this.plugin.getGameManager().isGameRunning()) {
            return;
        }
        if (!this.plugin.getGameManager().isRunner(player)) {
            return;
        }
        if (this.plugin.getGameManager().getActiveRunner() == player) {
            return;
        }
        player.sendMessage("\u00a7c[SpeedrunnerSwap] You cannot chat while inactive.");
        event.setCancelled(true);
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        if (this.plugin.getGameManager().isGameRunning() && this.plugin.getGameManager().isRunner(player) && this.plugin.getGameManager().getActiveRunner() != player && event.getTo() != null && (event.getFrom().getX() != event.getTo().getX() || event.getFrom().getY() != event.getTo().getY() || event.getFrom().getZ() != event.getTo().getZ())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerAdvancementDone(PlayerAdvancementDoneEvent event) {
        if (this.plugin.getGameManager().isGameRunning()) {
            event.message(null);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerBedEnter(PlayerBedEnterEvent event) {
        Player player = event.getPlayer();
        if (this.plugin.getGameManager().isGameRunning() && this.plugin.getConfigManager().isSinglePlayerSleepEnabled()) {
            if (this.plugin.getGameManager().isRunner(player) && !player.equals((Object)this.plugin.getGameManager().getActiveRunner())) {
                event.setCancelled(true);
                player.sendMessage("\u00a7cOnly the active runner can sleep!");
                return;
            }
            if (!this.plugin.getGameManager().isRunner(player) && !this.plugin.getGameManager().isHunter(player)) {
                event.setCancelled(true);
                return;
            }
            if (this.plugin.getGameManager().isRunner(player) && player.equals((Object)this.plugin.getGameManager().getActiveRunner())) {
                this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                    World world;
                    if (player.isOnline() && player.isSleeping() && (world = player.getWorld()).getTime() > 12000L && world.getTime() < 24000L) {
                        world.setTime(0L);
                        world.setStorm(false);
                        world.setThundering(false);
                        for (Player p : this.plugin.getServer().getOnlinePlayers()) {
                            p.sendMessage("\u00a7eThe night has been skipped by the active runner!");
                        }
                    }
                }, 20L);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        if (!this.plugin.getGameManager().isGameRunning()) {
            return;
        }
        if (!"CAGE".equalsIgnoreCase(this.plugin.getConfigManager().getFreezeMode())) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Projectile proj;
            ProjectileSource projectileSource;
            Player victim = (Player)entity;
            Entity damagerEntity = event.getDamager();
            Player attacker = null;
            if (damagerEntity instanceof Player) {
                Player p;
                attacker = p = (Player)damagerEntity;
            } else if (damagerEntity instanceof Projectile && (projectileSource = (proj = (Projectile)damagerEntity).getShooter()) instanceof Player) {
                Player p2;
                attacker = p2 = (Player)projectileSource;
            }
            if (attacker != null) {
                try {
                    if (this.plugin.getGameManager().areBothPlayersInSharedCage(attacker, victim)) {
                        event.setCancelled(true);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }
}

