/*
 * Decompiled with CFR 0.152.
 */
package com.example.speedrunnerswap.task;

import com.example.speedrunnerswap.SpeedrunnerSwap;
import java.util.EnumSet;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.IronGolem;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Sheep;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityBreedEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityTameEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerShearEntityEvent;
import org.bukkit.inventory.ItemStack;

public class TaskEventListener
implements Listener {
    private final SpeedrunnerSwap plugin;

    public TaskEventListener(SpeedrunnerSwap plugin) {
        this.plugin = plugin;
    }

    private boolean isTaskMode() {
        return this.plugin.getCurrentMode() == SpeedrunnerSwap.SwapMode.TASK && this.plugin.getGameManager().isGameRunning();
    }

    private String getTask(Player p) {
        return this.plugin.getTaskManagerMode().getAssignedTask(p);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBedInteract(PlayerInteractEvent event) {
        if (!this.isTaskMode()) {
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (event.getClickedBlock() == null) {
            return;
        }
        Material m = event.getClickedBlock().getType();
        if (!m.name().endsWith("_BED")) {
            return;
        }
        World.Environment env = event.getPlayer().getWorld().getEnvironment();
        if (env == World.Environment.NETHER || env == World.Environment.THE_END) {
            this.plugin.getTaskManagerMode().markBedExploder(event.getPlayer());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityDeath(EntityDeathEvent event) {
        String id;
        Player p;
        UUID attr;
        EntityDamageEvent cause;
        IronGolem golem;
        if (!this.isTaskMode()) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof IronGolem && (golem = (IronGolem)livingEntity).getWorld().getEnvironment() == World.Environment.NETHER && (cause = golem.getLastDamageCause()) != null && (cause.getCause() == EntityDamageEvent.DamageCause.BLOCK_EXPLOSION || cause.getCause() == EntityDamageEvent.DamageCause.ENTITY_EXPLOSION) && (attr = this.plugin.getTaskManagerMode().getRecentBedExploder(golem.getWorld().getName())) != null && (p = Bukkit.getPlayer((UUID)attr)) != null && p.isOnline() && "kill_golem_nether_bed".equals(id = this.getTask(p))) {
            this.plugin.getTaskManagerMode().complete(p);
        }
        if (event.getEntity().getKiller() != null) {
            ItemStack hand;
            Player killer = event.getEntity().getKiller();
            String id2 = this.getTask(killer);
            if (id2 != null && id2.startsWith("kill_") && !id2.equals("kill_golem_nether_bed") && !id2.equals("kill_all_sheep_iron_shovel")) {
                String target = id2.substring("kill_".length()).toUpperCase();
                if (event.getEntityType().name().equals(target)) {
                    this.plugin.getTaskManagerMode().complete(killer);
                }
            }
            if (event.getEntityType() == EntityType.SHEEP && id2 != null && id2.equals("kill_all_sheep_iron_shovel") && (hand = killer.getInventory().getItemInMainHand()) != null && hand.getType() == Material.IRON_SHOVEL) {
                Sheep sheep = (Sheep)event.getEntity();
                EnumSet set = this.plugin.getTaskManagerMode().sheepKilledWithIronShovel.computeIfAbsent(killer.getUniqueId(), u -> EnumSet.noneOf(DyeColor.class));
                set.add(sheep.getColor());
                if (set.size() >= DyeColor.values().length) {
                    this.plugin.getTaskManagerMode().complete(killer);
                } else {
                    killer.sendMessage("\u00a7eSheep colors killed (iron shovel): \u00a7a" + set.size() + "/" + DyeColor.values().length);
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerDeath(PlayerDeathEvent event) {
        if (!this.isTaskMode()) {
            return;
        }
        Player p = event.getEntity();
        String id = this.getTask(p);
        if (id == null) {
            return;
        }
        if (id.equals("die_on_bedrock_fall")) {
            Location loc;
            Location below;
            if (event.getDeathMessage() != null && event.getEntity().getLastDamageCause() != null && event.getEntity().getLastDamageCause().getCause() == EntityDamageEvent.DamageCause.FALL && (below = (loc = p.getLocation()).clone().subtract(0.0, 1.0, 0.0)).getBlock().getType() == Material.BEDROCK && p.getFallDistance() >= 20.0f) {
                this.plugin.getTaskManagerMode().complete(p);
            }
        } else if (id.startsWith("die_")) {
            String cause = id.substring("die_".length()).toUpperCase();
            EntityDamageEvent last = p.getLastDamageCause();
            if (last != null) {
                switch (cause) {
                    case "LAVA": {
                        if (last.getCause() != EntityDamageEvent.DamageCause.LAVA) break;
                        this.plugin.getTaskManagerMode().complete(p);
                        break;
                    }
                    case "FIRE": {
                        if (last.getCause() != EntityDamageEvent.DamageCause.FIRE && last.getCause() != EntityDamageEvent.DamageCause.FIRE_TICK) break;
                        this.plugin.getTaskManagerMode().complete(p);
                        break;
                    }
                    case "FALL": {
                        if (last.getCause() != EntityDamageEvent.DamageCause.FALL) break;
                        this.plugin.getTaskManagerMode().complete(p);
                        break;
                    }
                    case "VOID": {
                        if (last.getCause() != EntityDamageEvent.DamageCause.VOID) break;
                        this.plugin.getTaskManagerMode().complete(p);
                        break;
                    }
                    case "DROWNING": {
                        if (last.getCause() != EntityDamageEvent.DamageCause.DROWNING) break;
                        this.plugin.getTaskManagerMode().complete(p);
                        break;
                    }
                    case "EXPLOSION": {
                        if (last.getCause() != EntityDamageEvent.DamageCause.ENTITY_EXPLOSION && last.getCause() != EntityDamageEvent.DamageCause.BLOCK_EXPLOSION) break;
                        this.plugin.getTaskManagerMode().complete(p);
                    }
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onWorldChange(PlayerChangedWorldEvent event) {
        if (!this.isTaskMode()) {
            return;
        }
        Player p = event.getPlayer();
        String id = this.getTask(p);
        if (id == null) {
            return;
        }
        World.Environment env = p.getWorld().getEnvironment();
        if (id.equals("enter_nether") && env == World.Environment.NETHER) {
            this.plugin.getTaskManagerMode().complete(p);
        }
        if (id.equals("enter_end") && env == World.Environment.THE_END) {
            this.plugin.getTaskManagerMode().complete(p);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onCraft(CraftItemEvent event) {
        if (!this.isTaskMode()) {
            return;
        }
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player p = (Player)humanEntity;
        String id = this.getTask(p);
        if (id == null) {
            return;
        }
        if (!id.startsWith("craft_")) {
            return;
        }
        String matName = id.substring("craft_".length()).toUpperCase();
        Material expected = Material.matchMaterial((String)matName);
        if (expected == null) {
            return;
        }
        if (event.getRecipe() != null && event.getRecipe().getResult() != null && event.getRecipe().getResult().getType() == expected) {
            this.plugin.getTaskManagerMode().complete(p);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBreak(BlockBreakEvent event) {
        if (!this.isTaskMode()) {
            return;
        }
        Player p = event.getPlayer();
        String id = this.getTask(p);
        if (id == null) {
            return;
        }
        if (!id.startsWith("mine_")) {
            return;
        }
        String blockName = id.substring("mine_".length()).toUpperCase();
        if (event.getBlock().getType().name().equals(blockName)) {
            this.plugin.getTaskManagerMode().complete(p);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlace(BlockPlaceEvent event) {
        if (!this.isTaskMode()) {
            return;
        }
        Player p = event.getPlayer();
        String id = this.getTask(p);
        if (id == null) {
            return;
        }
        if (!id.startsWith("place_")) {
            return;
        }
        String blockName = id.substring("place_".length()).toUpperCase();
        if (event.getBlockPlaced().getType().name().equals(blockName)) {
            this.plugin.getTaskManagerMode().complete(p);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onShear(PlayerShearEntityEvent event) {
        if (!this.isTaskMode()) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof Sheep)) {
            return;
        }
        Sheep sheep = (Sheep)entity;
        Player p = event.getPlayer();
        String id = this.getTask(p);
        if (id == null) {
            return;
        }
        if (!id.startsWith("shear_")) {
            return;
        }
        String expectedColor = id.replace("shear_", "{}").replace("_sheep", "").replace("{}", "").toUpperCase();
        if (sheep.getColor().name().equals(expectedColor)) {
            this.plugin.getTaskManagerMode().complete(p);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onTame(EntityTameEvent event) {
        if (!this.isTaskMode()) {
            return;
        }
        AnimalTamer animalTamer = event.getOwner();
        if (!(animalTamer instanceof Player)) {
            return;
        }
        Player p = (Player)animalTamer;
        String id = this.getTask(p);
        if (id == null) {
            return;
        }
        if (!id.startsWith("tame_")) {
            return;
        }
        String type = id.substring("tame_".length()).toUpperCase();
        if (event.getEntityType().name().equals(type)) {
            this.plugin.getTaskManagerMode().complete(p);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBreed(EntityBreedEvent event) {
        if (!this.isTaskMode()) {
            return;
        }
        LivingEntity livingEntity = event.getBreeder();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player p = (Player)livingEntity;
        String id = this.getTask(p);
        if (id == null) {
            return;
        }
        if (!id.startsWith("breed_")) {
            return;
        }
        String type = id.substring("breed_".length()).toUpperCase();
        if (event.getEntityType().name().equals(type)) {
            this.plugin.getTaskManagerMode().complete(p);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onConsume(PlayerItemConsumeEvent event) {
        if (!this.isTaskMode()) {
            return;
        }
        Player p = event.getPlayer();
        String id = this.getTask(p);
        if (id == null) {
            return;
        }
        if (!id.startsWith("eat_")) {
            return;
        }
        String matName = id.substring("eat_".length()).toUpperCase();
        Material m = Material.matchMaterial((String)matName);
        if (m != null && event.getItem() != null && event.getItem().getType() == m) {
            this.plugin.getTaskManagerMode().complete(p);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onFish(PlayerFishEvent event) {
        if (!this.isTaskMode()) {
            return;
        }
        if (event.getState() != PlayerFishEvent.State.CAUGHT_FISH) {
            return;
        }
        Player p = event.getPlayer();
        String id = this.getTask(p);
        if ("fish_any".equals(id)) {
            this.plugin.getTaskManagerMode().complete(p);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onMove(PlayerMoveEvent event) {
        if (!this.isTaskMode()) {
            return;
        }
        Player p = event.getPlayer();
        String id = this.getTask(p);
        if (id == null) {
            return;
        }
        if (id.startsWith("reach_y_")) {
            try {
                int target = Integer.parseInt(id.substring("reach_y_".length()));
                if ((int)Math.round(p.getLocation().getY()) == target) {
                    this.plugin.getTaskManagerMode().complete(p);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

