/*
 * Decompiled with CFR 0.152.
 */
package com.example.speedrunnerswap.tracking;

import com.example.speedrunnerswap.SpeedrunnerSwap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.CompassMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class TrackerManager {
    private final SpeedrunnerSwap plugin;
    private volatile BukkitTask trackerTask;
    private volatile BukkitTask particleTask;
    private boolean isJammed = false;
    private final Object taskLock = new Object();
    private final Map<UUID, Integer> compassSlotCache = new HashMap<UUID, Integer>();
    private final Set<UUID> endHintNotifiedOnce = new HashSet<UUID>();

    public TrackerManager(SpeedrunnerSwap plugin) {
        this.plugin = plugin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startTracking() {
        Object object = this.taskLock;
        synchronized (object) {
            if (this.trackerTask != null) {
                this.trackerTask.cancel();
            }
            int updateTicks = Math.max(10, this.plugin.getConfigManager().getTrackerUpdateTicks());
            this.trackerTask = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
                Player activeRunner = this.plugin.getGameManager().getActiveRunner();
                if (activeRunner == null || !activeRunner.isOnline() || !this.plugin.getGameManager().isGameRunning()) {
                    return;
                }
                for (Player hunter : this.plugin.getGameManager().getHunters()) {
                    if (!hunter.isOnline()) continue;
                    this.updateHunterCompass(hunter, activeRunner);
                }
            }, 0L, (long)updateTicks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopTracking() {
        Object object = this.taskLock;
        synchronized (object) {
            if (this.trackerTask != null) {
                this.trackerTask.cancel();
                this.trackerTask = null;
            }
            if (this.particleTask != null) {
                this.particleTask.cancel();
                this.particleTask = null;
            }
        }
    }

    public void giveTrackingCompass(Player hunter) {
        if (hunter == null || !hunter.isOnline()) {
            return;
        }
        if (!hunter.getInventory().contains(Material.COMPASS)) {
            ItemStack compass = new ItemStack(Material.COMPASS);
            hunter.getInventory().addItem(new ItemStack[]{compass});
            this.compassSlotCache.remove(hunter.getUniqueId());
        }
        this.updateCompass(hunter);
    }

    public void updateCompass(Player hunter) {
        Player activeRunner = this.plugin.getGameManager().getActiveRunner();
        if (activeRunner != null && activeRunner.isOnline()) {
            this.updateHunterCompass(hunter, activeRunner);
        }
    }

    private void updateHunterCompass(Player hunter, Player activeRunner) {
        Location target;
        World rw;
        if (hunter == null || activeRunner == null) {
            return;
        }
        if (!hunter.isOnline()) {
            return;
        }
        World hw = hunter.getWorld();
        if (hw.equals((Object)(rw = activeRunner.getWorld()))) {
            target = activeRunner.getLocation();
        } else {
            World.Environment he = hw.getEnvironment();
            World.Environment re = rw.getEnvironment();
            Location rloc = activeRunner.getLocation();
            if (he == World.Environment.NETHER && re == World.Environment.NORMAL) {
                target = new Location(hw, rloc.getX() / 8.0, rloc.getY(), rloc.getZ() / 8.0);
            } else if (he == World.Environment.NORMAL && re == World.Environment.NETHER) {
                target = new Location(hw, rloc.getX() * 8.0, rloc.getY(), rloc.getZ() * 8.0);
            } else if (re == World.Environment.THE_END) {
                if (this.endHintNotifiedOnce.add(hunter.getUniqueId())) {
                    hunter.sendMessage("\u00a7eTracker: Runner is in \u00a75The End\u00a7e. Compass shows a fallback until you enter The End.");
                }
                target = hw.getSpawnLocation();
            } else {
                target = hw.getSpawnLocation();
            }
        }
        PlayerInventory inv = hunter.getInventory();
        ItemStack off = inv.getItemInOffHand();
        Consumer<ItemStack> updateCompass = item -> {
            if (item == null || item.getType() != Material.COMPASS) {
                return;
            }
            ItemMeta im = item.getItemMeta();
            if (!(im instanceof CompassMeta)) {
                return;
            }
            CompassMeta cm = (CompassMeta)im;
            cm.setLodestone(target);
            cm.setLodestoneTracked(false);
            item.setItemMeta((ItemMeta)cm);
        };
        updateCompass.accept(off);
        for (ItemStack it : inv.getContents()) {
            updateCompass.accept(it);
        }
    }

    public void updateAllHunterCompasses() {
        Player activeRunner = this.plugin.getGameManager().getActiveRunner();
        if (activeRunner != null && activeRunner.isOnline()) {
            for (Player hunter : this.plugin.getGameManager().getHunters()) {
                if (!hunter.isOnline()) continue;
                this.updateHunterCompass(hunter, activeRunner);
            }
        }
    }

    public void jamCompasses(long durationTicks) {
        this.isJammed = true;
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            this.isJammed = false;
        }, durationTicks);
    }
}

