/*
 * Decompiled with CFR 0.152.
 */
package com.example.speedrunnerswap.utils;

import com.example.speedrunnerswap.gui.PluginGuiHolder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.meta.ItemMeta;

public final class GuiCompat {
    private GuiCompat() {
    }

    public static Inventory createInventory(InventoryHolder holder, int size, String title) {
        InventoryHolder effective = holder != null ? holder : new PluginGuiHolder();
        try {
            return Bukkit.createInventory((InventoryHolder)effective, (int)size, (Component)Component.text((String)title));
        }
        catch (Throwable t) {
            return GuiCompat.createInventoryLegacy(effective, size, title);
        }
    }

    private static Inventory createInventoryLegacy(InventoryHolder holder, int size, String title) {
        InventoryHolder effective = holder != null ? holder : new PluginGuiHolder();
        return Bukkit.createInventory((InventoryHolder)effective, (int)size, (String)title);
    }

    public static void setDisplayName(ItemMeta meta, String name) {
        try {
            meta.displayName((Component)Component.text((String)name));
        }
        catch (Throwable t) {
            GuiCompat.setDisplayNameLegacy(meta, name);
        }
    }

    public static String getDisplayName(ItemMeta meta) {
        try {
            Component c = meta.displayName();
            if (c != null) {
                return PlainTextComponentSerializer.plainText().serialize(c);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return GuiCompat.getDisplayNameLegacy(meta);
    }

    public static void setLore(ItemMeta meta, List<String> legacyLore) {
        try {
            ArrayList<TextComponent> list = new ArrayList<TextComponent>();
            for (String s : legacyLore) {
                list.add(Component.text((String)s));
            }
            meta.lore(list);
        }
        catch (Throwable t) {
            GuiCompat.setLoreLegacy(meta, legacyLore);
        }
    }

    public static List<String> getLore(ItemMeta meta) {
        try {
            List comps = meta.lore();
            if (comps != null) {
                ArrayList<String> out = new ArrayList<String>(comps.size());
                PlainTextComponentSerializer serializer = PlainTextComponentSerializer.plainText();
                for (Component c : comps) {
                    out.add(serializer.serialize(c));
                }
                return out;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return GuiCompat.getLoreLegacy(meta);
    }

    private static void setDisplayNameLegacy(ItemMeta meta, String name) {
        meta.setDisplayName(name);
    }

    private static String getDisplayNameLegacy(ItemMeta meta) {
        return meta.hasDisplayName() ? meta.getDisplayName() : null;
    }

    private static void setLoreLegacy(ItemMeta meta, List<String> legacyLore) {
        meta.setLore(legacyLore);
    }

    private static List<String> getLoreLegacy(ItemMeta meta) {
        List<String> lore = meta.getLore();
        return lore != null ? lore : Collections.emptyList();
    }
}

