/*
 * Decompiled with CFR 0.152.
 */
package com.example.speedrunnerswap.game;

import com.example.speedrunnerswap.SpeedrunnerSwap;
import com.example.speedrunnerswap.models.PlayerState;
import com.example.speedrunnerswap.models.Team;
import com.example.speedrunnerswap.task.TaskDefinition;
import com.example.speedrunnerswap.task.TaskManagerMode;
import com.example.speedrunnerswap.utils.ActionBarUtil;
import com.example.speedrunnerswap.utils.BukkitCompat;
import com.example.speedrunnerswap.utils.Msg;
import com.example.speedrunnerswap.utils.PlayerStateUtil;
import com.example.speedrunnerswap.utils.SafeLocationFinder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Vector;

public class GameManager {
    private final SpeedrunnerSwap plugin;
    private boolean gameRunning;
    private boolean gamePaused;
    private Player activeRunner;
    private int activeRunnerIndex;
    private List<Player> runners;
    private List<Player> hunters;
    private BukkitTask swapTask;
    private BukkitTask hunterSwapTask;
    private BukkitTask actionBarTask;
    private BukkitTask titleTask;
    private BukkitTask freezeCheckTask;
    private BukkitTask cageTask;
    private BukkitTask runnerTimeoutTask;
    private long nextSwapTime;
    private final Map<UUID, PlayerState> playerStates;
    private final Map<UUID, Long> runnerDisconnectAt = new HashMap<UUID, Long>();
    private final Map<World, List<BlockState>> sharedCageBlocks = new HashMap<World, List<BlockState>>();
    private final Map<World, Location> sharedCageCenters = new HashMap<World, Location>();
    private final Set<UUID> cagedPlayers = new HashSet<UUID>();
    private final Map<UUID, Integer> portalSwapRetries = new HashMap<UUID, Integer>();
    private boolean swapInProgress = false;

    public GameManager(SpeedrunnerSwap plugin) {
        this.plugin = plugin;
        this.gameRunning = false;
        this.gamePaused = false;
        this.activeRunnerIndex = 0;
        this.runners = new ArrayList<Player>();
        this.hunters = new ArrayList<Player>();
        this.playerStates = new HashMap<UUID, PlayerState>();
    }

    public boolean startGame() {
        if (this.gameRunning) {
            return false;
        }
        if (!this.canStartGame()) {
            SpeedrunnerSwap.SwapMode mode = this.plugin.getCurrentMode();
            boolean hasRunner = !this.runners.isEmpty();
            boolean hasHunter = !this.hunters.isEmpty();
            String failureMessage = switch (mode) {
                case SpeedrunnerSwap.SwapMode.DREAM -> {
                    if (hasRunner) {
                        yield "\u00a7cGame cannot start: Assign at least one hunter for Dream mode.";
                    }
                    yield "\u00a7cGame cannot start: Assign at least one speed owner.";
                }
                case SpeedrunnerSwap.SwapMode.SAPNAP -> {
                    if (hasRunner) {
                        if (hasHunter) {
                            yield "\u00a7cGame cannot start: Sapnap mode does not allow hunters. Clear them and keep only speed owners.";
                        }
                        yield "\u00a7cGame cannot start: Assign at least one speed owner.";
                    }
                    yield "\u00a7cGame cannot start: Assign at least one speed owner.";
                }
                case SpeedrunnerSwap.SwapMode.TASK -> {
                    if (hasRunner) {
                        if (hasHunter) {
                            yield "\u00a7cGame cannot start: Task Master mode uses only speed owners. Remove any hunters before starting.";
                        }
                        yield "\u00a7cGame cannot start: Assign at least one speed owner.";
                    }
                    yield "\u00a7cGame cannot start: Assign at least one speed owner.";
                }
                default -> throw new IncompatibleClassChangeError();
            };
            Msg.broadcast(failureMessage);
            return false;
        }
        final SpeedrunnerSwap.SwapMode countdownMode = this.plugin.getCurrentMode();
        new BukkitRunnable(){
            int count = 3;

            public void run() {
                if (this.count > 0) {
                    String title = switch (countdownMode) {
                        case SpeedrunnerSwap.SwapMode.DREAM -> "\u00a7b\u00a7lDream Swap starting in " + this.count;
                        case SpeedrunnerSwap.SwapMode.SAPNAP -> "\u00a7d\u00a7lSapnap speed owner swap in " + this.count;
                        case SpeedrunnerSwap.SwapMode.TASK -> "\u00a76\u00a7lTaskmaster starting in " + this.count;
                        default -> throw new IncompatibleClassChangeError();
                    };
                    String subtitle = "\u00a77Made by muj3b";
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        BukkitCompat.showTitle(player, title, subtitle, 10, 70, 10);
                    }
                    --this.count;
                } else {
                    String goTitle = switch (countdownMode) {
                        case SpeedrunnerSwap.SwapMode.DREAM -> "\u00a7b\u00a7lDream Swap GO!";
                        case SpeedrunnerSwap.SwapMode.SAPNAP -> "\u00a7d\u00a7lSapnap swap GO!";
                        case SpeedrunnerSwap.SwapMode.TASK -> "\u00a76\u00a7lTaskmaster GO!";
                        default -> throw new IncompatibleClassChangeError();
                    };
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        BukkitCompat.showTitle(player, goTitle, "\u00a77Made by muj3b", 10, 60, 10);
                    }
                    this.cancel();
                    GameManager.this.gameRunning = true;
                    GameManager.this.gamePaused = false;
                    GameManager.this.activeRunnerIndex = 0;
                    GameManager.this.activeRunner = GameManager.this.runners.get(GameManager.this.activeRunnerIndex);
                    GameManager.this.saveAllPlayerStates();
                    GameManager.this.portalSwapRetries.clear();
                    GameManager.this.swapInProgress = false;
                    if (GameManager.this.plugin.getConfigManager().isKitsEnabled()) {
                        for (Player player : GameManager.this.runners) {
                            GameManager.this.plugin.getKitManager().giveKit(player, "runner");
                        }
                        for (Player hunter : GameManager.this.hunters) {
                            GameManager.this.plugin.getKitManager().giveKit(hunter, "hunter");
                        }
                    }
                    GameManager.this.applyInactiveEffects();
                    GameManager.this.scheduleNextSwap();
                    if (GameManager.this.plugin.getCurrentMode() == SpeedrunnerSwap.SwapMode.DREAM) {
                        GameManager.this.scheduleNextHunterSwap();
                    }
                    GameManager.this.startActionBarUpdates();
                    if (GameManager.this.plugin.getCurrentMode() == SpeedrunnerSwap.SwapMode.TASK) {
                        try {
                            GameManager.this.plugin.getTaskManagerMode().assignAndAnnounceTasks(GameManager.this.runners);
                        }
                        catch (Throwable t) {
                            GameManager.this.plugin.getLogger().warning("Task assignment failed: " + t.getMessage());
                        }
                    }
                    GameManager.this.startTitleUpdates();
                    GameManager.this.startCageEnforcement();
                    if (GameManager.this.plugin.getCurrentMode() == SpeedrunnerSwap.SwapMode.TASK) {
                        GameManager.this.startRunnerTimeoutWatcher();
                    }
                    if (GameManager.this.plugin.getCurrentMode() != SpeedrunnerSwap.SwapMode.SAPNAP && GameManager.this.plugin.getConfigManager().isTrackerEnabled()) {
                        GameManager.this.plugin.getTrackerManager().startTracking();
                        for (Player hunter : GameManager.this.hunters) {
                            if (!hunter.isOnline()) continue;
                            GameManager.this.plugin.getTrackerManager().giveTrackingCompass(hunter);
                        }
                    }
                    if (GameManager.this.plugin.getConfig().getBoolean("stats.enabled", true)) {
                        GameManager.this.plugin.getStatsManager().startTracking();
                    }
                    if (GameManager.this.plugin.getConfigManager().isFreezeMechanicEnabled()) {
                        GameManager.this.startFreezeChecking();
                    }
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 20L);
        return true;
    }

    public void endGame(final Team winner) {
        String titleStr;
        if (!this.gameRunning) {
            return;
        }
        String runnerSubtitle = "";
        String hunterSubtitle = "";
        if (winner == Team.RUNNER) {
            titleStr = "\u00a7a\u00a7lRUNNERS WIN!";
            runnerSubtitle = "\u00a7eBro y'all are locked in, good stuff";
            hunterSubtitle = "\u00a7eBro y'all are locked in, good stuff";
        } else if (winner == Team.HUNTER) {
            titleStr = "\u00a7c\u00a7lHUNTERS WIN!";
            runnerSubtitle = "\u00a7eYou ain't the main character, unc";
            hunterSubtitle = "\u00a7eBro those speedrunners are trash";
        } else {
            titleStr = "\u00a7c\u00a7lGAME OVER";
            runnerSubtitle = "\u00a7eNo winner declared.";
            hunterSubtitle = "\u00a7eNo winner declared.";
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            String sub = this.isRunner(player) ? runnerSubtitle : hunterSubtitle;
            BukkitCompat.showTitle(player, titleStr, sub, 10, 100, 10);
        }
        if (this.swapTask != null) {
            this.swapTask.cancel();
        }
        if (this.hunterSwapTask != null) {
            this.hunterSwapTask.cancel();
        }
        if (this.actionBarTask != null) {
            this.actionBarTask.cancel();
        }
        if (this.titleTask != null) {
            this.titleTask.cancel();
        }
        if (this.freezeCheckTask != null) {
            this.freezeCheckTask.cancel();
        }
        if (this.cageTask != null) {
            this.cageTask.cancel();
            this.cageTask = null;
        }
        if (this.runnerTimeoutTask != null) {
            this.runnerTimeoutTask.cancel();
            this.runnerTimeoutTask = null;
        }
        this.plugin.getTrackerManager().stopTracking();
        this.portalSwapRetries.clear();
        this.swapInProgress = false;
        try {
            this.plugin.getStatsManager().stopTracking();
        }
        catch (Exception exception) {
            // empty catch block
        }
        new BukkitRunnable(){

            public void run() {
                if (GameManager.this.plugin.getConfig().getBoolean("swap.preserve_runner_progress_on_end", false)) {
                    try {
                        if (GameManager.this.activeRunner != null && GameManager.this.activeRunner.isOnline() && !GameManager.this.runners.isEmpty()) {
                            PlayerState finalState = PlayerStateUtil.capturePlayerState(GameManager.this.activeRunner);
                            for (Player r : GameManager.this.runners) {
                                GameManager.this.playerStates.put(r.getUniqueId(), finalState);
                            }
                        }
                    }
                    catch (Exception ex) {
                        GameManager.this.plugin.getLogger().warning("Failed to capture/apply final runner state: " + ex.getMessage());
                    }
                }
                GameManager.this.cleanupAllCages();
                GameManager.this.restoreAllPlayerStates();
                GameManager.this.gameRunning = false;
                GameManager.this.gamePaused = false;
                GameManager.this.activeRunner = null;
                if (GameManager.this.plugin.getConfigManager().isBroadcastGameEvents()) {
                    String winnerMessage = winner != null ? winner.name() + " team won!" : "Game ended!";
                    Msg.broadcast("\u00a7a[SpeedrunnerSwap] Game ended! " + winnerMessage);
                }
                GameManager.this.broadcastDonationMessage();
            }
        }.runTaskLater((Plugin)this.plugin, 200L);
    }

    public void sendDonationMessage(Player recipient) {
        String donateUrl = this.plugin.getConfig().getString("donation.url", "https://donate.stripe.com/8x29AT0H58K03judnR0Ba01");
        if (recipient != null) {
            this.deliverDonationMessage(recipient, donateUrl);
            return;
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.deliverDonationMessage(player, donateUrl);
        }
    }

    private void deliverDonationMessage(Player player, String donateUrl) {
        if (player == null) {
            return;
        }
        player.sendMessage("");
        player.sendMessage("\u00a76\u00a7l=== Support the Creator ===");
        player.sendMessage("\u00a7eEnjoyed the game? Help keep updates coming!");
        player.sendMessage("\u00a7d\u2764 Donate to support development");
        player.sendMessage("\u00a7b" + donateUrl);
        player.sendMessage("");
    }

    private void broadcastDonationMessage() {
        this.sendDonationMessage(null);
    }

    public void stopGame() {
        this.endGame(null);
    }

    public boolean isHunter(Player player) {
        return this.hunters.contains(player);
    }

    public boolean isRunner(Player player) {
        return this.runners.contains(player);
    }

    public boolean isGameRunning() {
        return this.gameRunning;
    }

    public Player getActiveRunner() {
        return this.activeRunner;
    }

    public List<Player> getRunners() {
        return this.runners;
    }

    public List<Player> getHunters() {
        return this.hunters;
    }

    public void refreshSwapSchedule() {
        if (this.gameRunning && !this.gamePaused) {
            this.scheduleNextSwap();
        }
    }

    public void refreshActionBar() {
        if (this.gameRunning && !this.gamePaused) {
            this.updateActionBar();
        }
    }

    public PlayerState getPlayerState(Player player) {
        if (player == null) {
            return null;
        }
        return this.playerStates.computeIfAbsent(player.getUniqueId(), id -> PlayerStateUtil.capturePlayerState(player));
    }

    public boolean canStartGame() {
        boolean hasHunter;
        if (this.gameRunning) {
            return false;
        }
        this.loadTeams();
        SpeedrunnerSwap.SwapMode mode = this.plugin.getCurrentMode();
        boolean hasRunner = !this.runners.isEmpty();
        boolean bl = hasHunter = !this.hunters.isEmpty();
        if (!hasRunner) {
            return false;
        }
        if (this.huntersRequired(mode)) {
            return hasHunter;
        }
        return this.huntersAllowed(mode) || !hasHunter;
    }

    public void updateTeams() {
        boolean teamEmpty;
        ArrayList<Player> newRunners = new ArrayList<Player>();
        ArrayList<Player> newHunters = new ArrayList<Player>();
        for (Player runner : this.runners) {
            if (!runner.isOnline()) continue;
            newRunners.add(runner);
        }
        for (Player hunter : this.hunters) {
            if (!hunter.isOnline()) continue;
            newHunters.add(hunter);
        }
        this.runners = newRunners;
        this.hunters = newHunters;
        boolean huntersRequired = this.huntersRequired(this.plugin.getCurrentMode());
        boolean bl = teamEmpty = this.runners.isEmpty() || huntersRequired && this.hunters.isEmpty();
        if (this.gameRunning && teamEmpty) {
            if (this.plugin.getConfigManager().isPauseOnDisconnect()) {
                this.pauseGame();
                if (this.plugin.getConfigManager().isBroadcastGameEvents()) {
                    Msg.broadcast("\u00a7e[SpeedrunnerSwap] Game paused: waiting for players to return.");
                }
            } else {
                this.plugin.getLogger().warning("A team is empty; game continues (pause_on_disconnect=false)");
            }
        }
        if (this.gameRunning && this.plugin.getCurrentMode() == SpeedrunnerSwap.SwapMode.TASK && this.plugin.getConfig().getBoolean("task_manager.end_when_one_left", false)) {
            int online = 0;
            for (Player r : this.runners) {
                if (!r.isOnline()) continue;
                ++online;
            }
            if (online <= 1) {
                Msg.broadcast("\u00a7e[Task Manager] Ending: only one runner remains.");
                this.stopGame();
                return;
            }
        }
    }

    public void handlePlayerQuit(Player player) {
        boolean pauseOnDc;
        if (!this.gameRunning) {
            return;
        }
        if (this.isRunner(player)) {
            this.runnerDisconnectAt.put(player.getUniqueId(), System.currentTimeMillis());
            if (this.plugin.getCurrentMode() == SpeedrunnerSwap.SwapMode.TASK) {
                this.setRuntimeDisconnectTime(player.getUniqueId(), System.currentTimeMillis());
            }
        }
        boolean bl = pauseOnDc = this.plugin.getCurrentMode() == SpeedrunnerSwap.SwapMode.TASK ? this.plugin.getConfig().getBoolean("task_manager.pause_on_disconnect", this.plugin.getConfigManager().isPauseOnDisconnect()) : this.plugin.getConfigManager().isPauseOnDisconnect();
        if (player.equals(this.activeRunner)) {
            if (pauseOnDc) {
                this.pauseGame();
            } else {
                this.performSwap();
            }
        }
        this.savePlayerState(player);
        this.portalSwapRetries.remove(player.getUniqueId());
        this.ensureRunnerQueueCoherence();
    }

    public void handlePlayerJoin(Player player) {
        if (!this.gameRunning) {
            return;
        }
        if (this.plugin.getCurrentMode() == SpeedrunnerSwap.SwapMode.TASK) {
            TaskManagerMode tmm = this.plugin.getTaskManagerMode();
            if (tmm != null && tmm.getAssignedTask(player) != null) {
                TaskDefinition def;
                if (!this.isRunner(player)) {
                    this.runners.add(player);
                }
                if ((def = tmm.getTask(tmm.getAssignedTask(player))) != null) {
                    player.sendMessage("\u00a76[Task Manager] Your task:");
                    player.sendMessage("\u00a7e \u2192 " + def.description());
                }
            } else if (this.plugin.getConfig().getBoolean("task_manager.allow_late_joiners", false)) {
                if (!this.isRunner(player)) {
                    this.runners.add(player);
                }
                if (tmm != null && tmm.getAssignedTask(player) == null) {
                    tmm.assignAndAnnounceTasks(List.of(player));
                }
            }
            this.runnerDisconnectAt.remove(player.getUniqueId());
            this.clearRuntimeDisconnectTime(player.getUniqueId());
            if (this.isGamePaused()) {
                boolean anyOnline = false;
                for (Player r : this.runners) {
                    if (!r.isOnline()) continue;
                    anyOnline = true;
                    break;
                }
                if (anyOnline) {
                    this.resumeGame();
                }
            }
        }
        this.portalSwapRetries.remove(player.getUniqueId());
        this.ensureRunnerQueueCoherence();
        if (this.plugin.getConfigManager().isTrackerEnabled()) {
            this.plugin.getTrackerManager().startTracking();
        }
    }

    private void startRunnerTimeoutWatcher() {
        if (this.runnerTimeoutTask != null) {
            this.runnerTimeoutTask.cancel();
        }
        this.runnerTimeoutTask = new BukkitRunnable(){

            public void run() {
                if (!GameManager.this.gameRunning) {
                    return;
                }
                long now = System.currentTimeMillis();
                int graceSec = GameManager.this.plugin.getConfig().getInt("task_manager.rejoin_grace_seconds", 180);
                boolean remove = GameManager.this.plugin.getConfig().getBoolean("task_manager.remove_on_timeout", true);
                boolean pauseOnDc = GameManager.this.plugin.getConfig().getBoolean("task_manager.pause_on_disconnect", true);
                ArrayList<UUID> toRemove = new ArrayList<UUID>();
                for (Map.Entry<UUID, Long> e : GameManager.this.runnerDisconnectAt.entrySet()) {
                    long elapsed = now - e.getValue();
                    if (elapsed < (long)graceSec * 1000L) continue;
                    UUID uuid = e.getKey();
                    if (remove) {
                        GameManager.this.runners.removeIf(r -> r.getUniqueId().equals(uuid));
                        toRemove.add(uuid);
                    }
                    if (GameManager.this.activeRunner == null || !GameManager.this.activeRunner.getUniqueId().equals(uuid)) continue;
                    GameManager.this.performSwap();
                }
                for (UUID id : toRemove) {
                    GameManager.this.runnerDisconnectAt.remove(id);
                    GameManager.this.clearRuntimeDisconnectTime(id);
                }
                if (GameManager.this.gameRunning && GameManager.this.plugin.getConfig().getBoolean("task_manager.end_when_one_left", false) && GameManager.this.plugin.getCurrentMode() == SpeedrunnerSwap.SwapMode.TASK) {
                    int online = 0;
                    for (Player r2 : GameManager.this.runners) {
                        if (!r2.isOnline()) continue;
                        ++online;
                    }
                    if (online <= 1) {
                        Msg.broadcast("\u00a7e[Task Manager] Ending: only one runner remains.");
                        GameManager.this.stopGame();
                        return;
                    }
                }
                if (GameManager.this.gamePaused && pauseOnDc) {
                    boolean anyOnline = false;
                    for (Player r2 : GameManager.this.runners) {
                        if (!r2.isOnline()) continue;
                        anyOnline = true;
                        break;
                    }
                    if (anyOnline) {
                        GameManager.this.resumeGame();
                    }
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 20L, 100L);
    }

    private void setRuntimeDisconnectTime(UUID uuid, long when) {
        try {
            String path = "task_manager.runtime.disconnect_times." + String.valueOf(uuid);
            this.plugin.getConfig().set(path, (Object)when);
            this.plugin.saveConfig();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void clearRuntimeDisconnectTime(UUID uuid) {
        try {
            String path = "task_manager.runtime.disconnect_times." + String.valueOf(uuid);
            this.plugin.getConfig().set(path, null);
            this.plugin.saveConfig();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public int getTimeUntilNextSwap() {
        return (int)((this.nextSwapTime - System.currentTimeMillis()) / 1000L);
    }

    private void saveAllPlayerStates() {
        for (Player runner : this.runners) {
            this.savePlayerState(runner);
        }
    }

    private void savePlayerState(Player player) {
        if (player == null || !player.isOnline()) {
            return;
        }
        PlayerState state = PlayerStateUtil.capturePlayerState(player);
        this.playerStates.put(player.getUniqueId(), state);
    }

    private void restoreAllPlayerStates() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            PotionEffectType eff;
            if (this.playerStates.containsKey(player.getUniqueId())) {
                this.restorePlayerState(player);
            }
            if ((eff = BukkitCompat.resolvePotionEffect("blindness")) != null) {
                player.removePotionEffect(eff);
            }
            if ((eff = BukkitCompat.resolvePotionEffect("darkness")) != null) {
                player.removePotionEffect(eff);
            }
            if ((eff = BukkitCompat.resolvePotionEffect("weakness")) != null) {
                player.removePotionEffect(eff);
            }
            if ((eff = BukkitCompat.resolvePotionEffect("slow_falling")) != null) {
                player.removePotionEffect(eff);
            }
            if ((eff = BukkitCompat.resolvePotionEffect("slowness")) != null) {
                player.removePotionEffect(eff);
            }
            if ((eff = BukkitCompat.resolvePotionEffect("jump_boost")) != null) {
                player.removePotionEffect(eff);
            }
            if (player.getGameMode() == GameMode.SPECTATOR && this.runners.contains(player)) {
                player.setGameMode(GameMode.SURVIVAL);
            }
            for (Player viewer : Bukkit.getOnlinePlayers()) {
                try {
                    viewer.showPlayer((Plugin)this.plugin, player);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    private void restorePlayerState(Player player) {
        if (player == null || !player.isOnline()) {
            return;
        }
        PlayerState state = this.playerStates.get(player.getUniqueId());
        if (state != null) {
            try {
                Location saved;
                player.getInventory().clear();
                for (PotionEffect effect : player.getActivePotionEffects()) {
                    player.removePotionEffect(effect.getType());
                }
                player.setHealth(BukkitCompat.getMaxHealthValue((LivingEntity)player));
                player.setFoodLevel(20);
                player.setFireTicks(0);
                player.setFallDistance(0.0f);
                player.setInvulnerable(false);
                PlayerStateUtil.applyPlayerState(player, state);
                Location target = null;
                boolean forceGlobalSpawn = this.plugin.getConfigManager().isForceGlobalSpawn();
                if (!forceGlobalSpawn && (saved = state.getLocation()) != null && !saved.getBlock().getType().isSolid()) {
                    target = saved;
                }
                if (target == null) {
                    target = this.plugin.getConfigManager().getSpawnLocation();
                }
                player.teleport(target);
                if (target.equals((Object)this.plugin.getConfigManager().getSpawnLocation())) {
                    player.setGameMode(GameMode.SURVIVAL);
                    player.getInventory().clear();
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Failed to restore state for player " + player.getName() + ": " + e.getMessage());
                player.teleport(this.plugin.getConfigManager().getSpawnLocation());
                player.setGameMode(GameMode.SURVIVAL);
                player.getInventory().clear();
            }
        }
    }

    private void loadTeams() {
        Player player;
        this.runners.clear();
        this.hunters.clear();
        for (String name : this.plugin.getConfigManager().getRunnerNames()) {
            player = Bukkit.getPlayerExact((String)name);
            if (player == null || !player.isOnline()) continue;
            this.runners.add(player);
        }
        for (String name : this.plugin.getConfigManager().getHunterNames()) {
            player = Bukkit.getPlayerExact((String)name);
            if (player == null || !player.isOnline()) continue;
            this.hunters.add(player);
        }
    }

    private void scheduleNextSwap() {
        long intervalSeconds;
        if (this.swapTask != null) {
            this.swapTask.cancel();
        }
        if (this.plugin.getConfigManager().isSwapRandomized()) {
            double mean = this.plugin.getConfigManager().getSwapInterval();
            double stdDev = this.plugin.getConfigManager().getJitterStdDev();
            double jitteredInterval = ThreadLocalRandom.current().nextGaussian() * stdDev + mean;
            if (this.plugin.getConfigManager().isClampJitter()) {
                int min = this.plugin.getConfigManager().getMinSwapInterval();
                int max = this.plugin.getConfigManager().getMaxSwapInterval();
                jitteredInterval = Math.max((double)min, Math.min((double)max, jitteredInterval));
            }
            intervalSeconds = Math.round(jitteredInterval);
        } else {
            intervalSeconds = this.plugin.getConfigManager().getSwapInterval();
        }
        long intervalTicks = intervalSeconds * 20L;
        this.nextSwapTime = System.currentTimeMillis() + intervalSeconds * 1000L;
        this.swapTask = Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, this::performSwap, intervalTicks);
    }

    private void scheduleNextHunterSwap() {
        if (this.hunterSwapTask != null) {
            this.hunterSwapTask.cancel();
        }
        if (!this.plugin.getConfigManager().isHunterSwapEnabled()) {
            return;
        }
        long intervalTicks = (long)this.plugin.getConfigManager().getHunterSwapInterval() * 20L;
        this.hunterSwapTask = Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, this::performHunterSwap, intervalTicks);
    }

    private void startActionBarUpdates() {
        if (this.actionBarTask != null) {
            this.actionBarTask.cancel();
        }
        int period = Math.max(1, this.plugin.getConfigManager().getActionBarUpdateTicks());
        this.actionBarTask = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            if (!this.gameRunning) {
                return;
            }
            this.updateActionBar();
        }, 0L, (long)period);
    }

    private void startTitleUpdates() {
        if (this.titleTask != null) {
            this.titleTask.cancel();
        }
        int period = Math.max(1, this.plugin.getConfigManager().getTitleUpdateTicks());
        this.titleTask = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            if (!this.gameRunning || this.gamePaused) {
                return;
            }
            this.updateTitles();
        }, 0L, (long)period);
    }

    private void updateActionBar() {
        if (!this.gameRunning || this.gamePaused) {
            return;
        }
        int timeLeft = this.getTimeUntilNextSwap();
        for (Player player : Bukkit.getOnlinePlayers()) {
            boolean isRunner = this.runners.contains(player);
            boolean isHunter = this.hunters.contains(player);
            boolean isActive = player.equals(this.activeRunner);
            boolean isCaged = this.cagedPlayers.contains(player.getUniqueId());
            String vis = isRunner ? (isActive ? this.plugin.getConfigManager().getRunnerTimerVisibility() : this.plugin.getConfigManager().getWaitingTimerVisibility()) : (isHunter ? this.plugin.getConfigManager().getHunterTimerVisibility() : "never");
            if (switch (String.valueOf(vis).toLowerCase()) {
                case "always" -> true;
                case "last_10" -> timeLeft <= 10;
                default -> false;
            }) {
                if (isCaged && !isActive) {
                    int queuePosition = this.getQueuePosition(player);
                    String msg = String.format("\u00a76Queued (%d) - You're up next", queuePosition);
                    ActionBarUtil.sendActionBar(player, msg);
                    continue;
                }
                String msg = String.format("\u00a7eSwap in: \u00a7c%ds", Math.max(0, timeLeft));
                ActionBarUtil.sendActionBar(player, msg);
                continue;
            }
            ActionBarUtil.sendActionBar(player, "");
        }
    }

    private int getQueuePosition(Player player) {
        if (!this.runners.contains(player)) {
            return 0;
        }
        int position = 1;
        for (Player runner : this.runners) {
            if (runner.equals(player)) break;
            if (!runner.isOnline() || runner.equals(this.activeRunner)) continue;
            ++position;
        }
        return position;
    }

    private void updateHostileMobTargeting(Player previousRunner, Player newRunner) {
        if (previousRunner == null || newRunner == null || !previousRunner.isOnline() || !newRunner.isOnline()) {
            return;
        }
        for (World world : Bukkit.getWorlds()) {
            for (Entity entity : world.getEntities()) {
                Enderman enderman;
                Mob mob;
                if (entity instanceof Mob && (mob = (Mob)entity).getTarget() != null && mob.getTarget().equals(previousRunner)) {
                    mob.setTarget((LivingEntity)newRunner);
                }
                if (!(entity instanceof Enderman) || !((enderman = (Enderman)entity).getLocation().distance(previousRunner.getLocation()) < 16.0)) continue;
                enderman.setTarget((LivingEntity)newRunner);
            }
        }
    }

    private void applyInactiveEffects() {
        this.ensureRunnerQueueCoherence();
        String freezeMode = this.plugin.getConfigManager().getFreezeMode();
        for (Player runner : this.runners) {
            if (runner.equals(this.activeRunner)) {
                this.cagedPlayers.remove(runner.getUniqueId());
                PotionEffectType eff = BukkitCompat.resolvePotionEffect("blindness");
                if (eff != null) {
                    runner.removePotionEffect(eff);
                }
                if ((eff = BukkitCompat.resolvePotionEffect("darkness")) != null) {
                    runner.removePotionEffect(eff);
                }
                if ((eff = BukkitCompat.resolvePotionEffect("slowness")) != null) {
                    runner.removePotionEffect(eff);
                }
                if ((eff = BukkitCompat.resolvePotionEffect("slow_falling")) != null) {
                    runner.removePotionEffect(eff);
                }
                if ((eff = BukkitCompat.resolvePotionEffect("invisibility")) != null) {
                    runner.removePotionEffect(eff);
                }
                runner.setGameMode(GameMode.SURVIVAL);
                try {
                    runner.setAllowFlight(false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    runner.setFlying(false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                for (Player viewer : Bukkit.getOnlinePlayers()) {
                    viewer.showPlayer((Plugin)this.plugin, runner);
                }
                continue;
            }
            if (freezeMode.equalsIgnoreCase("EFFECTS")) {
                PotionEffectType slowFalling;
                PotionEffectType slowness;
                PotionEffectType darkness;
                blindness = BukkitCompat.resolvePotionEffect("blindness");
                if (blindness != null) {
                    runner.addPotionEffect(new PotionEffect(blindness, Integer.MAX_VALUE, 1, false, false));
                }
                if ((darkness = BukkitCompat.resolvePotionEffect("darkness")) != null) {
                    runner.addPotionEffect(new PotionEffect(darkness, Integer.MAX_VALUE, 1, false, false));
                }
                if ((slowness = BukkitCompat.resolvePotionEffect("slowness")) != null) {
                    runner.addPotionEffect(new PotionEffect(slowness, Integer.MAX_VALUE, 255, false, false));
                }
                if ((slowFalling = BukkitCompat.resolvePotionEffect("slow_falling")) != null) {
                    runner.addPotionEffect(new PotionEffect(slowFalling, Integer.MAX_VALUE, 128, false, false));
                }
            } else if (freezeMode.equalsIgnoreCase("SPECTATOR")) {
                runner.setGameMode(GameMode.SPECTATOR);
            } else if (freezeMode.equalsIgnoreCase("LIMBO")) {
                Location limboLocation = this.plugin.getConfigManager().getLimboLocation();
                Location safe = SafeLocationFinder.findSafeLocation(limboLocation, this.plugin.getConfigManager().getSafeSwapHorizontalRadius(), this.plugin.getConfigManager().getSafeSwapVerticalDistance(), this.plugin.getConfigManager().getDangerousBlocks());
                runner.teleport(safe != null ? safe : limboLocation);
                runner.setGameMode(GameMode.ADVENTURE);
                PotionEffectType blindness2 = BukkitCompat.resolvePotionEffect("blindness");
                if (blindness2 != null) {
                    runner.addPotionEffect(new PotionEffect(blindness2, Integer.MAX_VALUE, 1, false, false));
                }
            } else if (freezeMode.equalsIgnoreCase("CAGE")) {
                PotionEffectType invis;
                this.createOrEnsureSharedCage(runner.getWorld());
                this.teleportToSharedCage(runner);
                blindness = BukkitCompat.resolvePotionEffect("blindness");
                if (blindness != null) {
                    runner.addPotionEffect(new PotionEffect(blindness, Integer.MAX_VALUE, 1, false, false));
                }
                if ((invis = BukkitCompat.resolvePotionEffect("invisibility")) != null) {
                    runner.addPotionEffect(new PotionEffect(invis, Integer.MAX_VALUE, 1, false, false));
                }
                runner.setGameMode(GameMode.ADVENTURE);
                try {
                    runner.setAllowFlight(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    runner.setFlying(false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                runner.getInventory().clear();
                runner.getInventory().setArmorContents(new ItemStack[0]);
                runner.getInventory().setItemInOffHand(null);
                runner.updateInventory();
            }
            catch (Exception blindness) {
                // empty catch block
            }
            for (Player viewer : Bukkit.getOnlinePlayers()) {
                if (viewer.equals(runner)) continue;
                viewer.hidePlayer((Plugin)this.plugin, runner);
            }
        }
    }

    private void startFreezeChecking() {
        int interval = this.plugin.getConfigManager().getFreezeCheckIntervalTicks();
        this.freezeCheckTask = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            Player hunter;
            if (!this.gameRunning || this.gamePaused || this.activeRunner == null) {
                return;
            }
            int maxDistance = (int)this.plugin.getConfigManager().getFreezeMaxDistance();
            Entity target = BukkitCompat.getTargetEntity(this.activeRunner, maxDistance);
            if (target instanceof Player && this.isHunter(hunter = (Player)target)) {
                PotionEffectType jumpBoost;
                int duration = this.plugin.getConfigManager().getFreezeDurationTicks();
                PotionEffectType slowness2 = BukkitCompat.resolvePotionEffect("slowness");
                if (slowness2 != null) {
                    hunter.addPotionEffect(new PotionEffect(slowness2, duration, 255, false, false));
                }
                if ((jumpBoost = BukkitCompat.resolvePotionEffect("jump_boost")) != null) {
                    hunter.addPotionEffect(new PotionEffect(jumpBoost, duration, 128, false, false));
                }
                if (this.plugin.getConfigManager().isBroadcastGameEvents()) {
                    hunter.sendMessage("\u00a7cYou have been frozen by the runner!");
                }
            }
        }, 0L, (long)interval);
    }

    public void refreshFreezeMechanic() {
        if (this.freezeCheckTask != null) {
            this.freezeCheckTask.cancel();
            this.freezeCheckTask = null;
        }
        if (this.gameRunning && this.plugin.getConfigManager().isFreezeMechanicEnabled()) {
            this.startFreezeChecking();
        }
        if (this.gameRunning) {
            this.applyInactiveEffects();
            if (!"CAGE".equalsIgnoreCase(this.plugin.getConfigManager().getFreezeMode())) {
                this.cleanupAllCages();
            }
        }
    }

    public void reapplyStates() {
        this.refreshFreezeMechanic();
    }

    private void performSwap() {
        long duration;
        if (this.gameRunning && this.plugin.getCurrentMode() == SpeedrunnerSwap.SwapMode.TASK && this.plugin.getConfig().getBoolean("task_manager.end_when_one_left", false)) {
            int online = 0;
            for (Player r : this.runners) {
                if (!r.isOnline()) continue;
                ++online;
            }
            if (online <= 1) {
                Msg.broadcast("\u00a7e[Task Manager] Ending: only one runner remains.");
                this.stopGame();
                return;
            }
        }
        if (!this.gameRunning || this.gamePaused || this.runners.isEmpty()) {
            return;
        }
        if (this.activeRunner != null && this.deferSwapForPortal(this.activeRunner)) {
            return;
        }
        if (this.swapInProgress) {
            return;
        }
        this.swapInProgress = true;
        this.plugin.getDragonManager().onSwapStart();
        if (this.activeRunner != null && this.activeRunner.isOnline()) {
            this.savePlayerState(this.activeRunner);
        }
        int attempts = 0;
        do {
            this.activeRunnerIndex = (this.activeRunnerIndex + 1) % this.runners.size();
            if (++attempts < this.runners.size()) continue;
            this.plugin.getLogger().warning("No online runners found during swap - pausing game");
            this.pauseGame();
            return;
        } while (!this.runners.get(this.activeRunnerIndex).isOnline());
        Player nextRunner = this.runners.get(this.activeRunnerIndex);
        Player previousRunner = this.activeRunner;
        boolean sameRunner = previousRunner != null && previousRunner.equals(nextRunner);
        this.activeRunner = nextRunner;
        this.portalSwapRetries.remove(nextRunner.getUniqueId());
        this.ensureRunnerQueueCoherence();
        int gracePeriodTicks = this.plugin.getConfigManager().getGracePeriodTicks();
        if (gracePeriodTicks > 0) {
            nextRunner.setInvulnerable(true);
            Player finalNextRunner = nextRunner;
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                if (finalNextRunner.isOnline()) {
                    finalNextRunner.setInvulnerable(false);
                }
            }, (long)gracePeriodTicks);
        }
        if (!sameRunner && previousRunner != null && previousRunner.isOnline()) {
            Location swapLocation;
            Location safeLocation;
            PlayerState prevState = PlayerStateUtil.capturePlayerState(previousRunner);
            PlayerStateUtil.applyPlayerState(nextRunner, prevState);
            try {
                nextRunner.updateInventory();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (this.plugin.getConfigManager().isSafeSwapEnabled() && (safeLocation = SafeLocationFinder.findSafeLocation(swapLocation = previousRunner.getLocation(), this.plugin.getConfigManager().getSafeSwapHorizontalRadius(), this.plugin.getConfigManager().getSafeSwapVerticalDistance(), this.plugin.getConfigManager().getDangerousBlocks())) != null) {
                nextRunner.teleport(safeLocation);
            }
            for (PotionEffect effect : previousRunner.getActivePotionEffects()) {
                previousRunner.removePotionEffect(effect.getType());
            }
            previousRunner.getInventory().clear();
            previousRunner.getInventory().setArmorContents(new ItemStack[0]);
            previousRunner.getInventory().setItemInOffHand(null);
            previousRunner.updateInventory();
        } else if ((previousRunner == null || !previousRunner.isOnline()) && this.plugin.getConfigManager().isKitsEnabled()) {
            nextRunner.getInventory().clear();
            this.plugin.getKitManager().giveKit(nextRunner, "runner");
        }
        this.applyInactiveEffects();
        this.refreshActiveTrackerTargets();
        this.scheduleNextSwap();
        this.plugin.getDragonManager().onSwapComplete();
        this.updateHostileMobTargeting(previousRunner, nextRunner);
        if (this.plugin.getConfigManager().isPowerUpsEnabled()) {
            this.applyRandomPowerUp(nextRunner);
        }
        if (this.plugin.getConfigManager().isCompassJammingEnabled() && (duration = (long)this.plugin.getConfigManager().getCompassJamDuration()) > 0L) {
            this.plugin.getTrackerManager().jamCompasses(duration);
        }
        this.swapInProgress = false;
    }

    private void refreshActiveTrackerTargets() {
        if (!this.plugin.getConfigManager().isTrackerEnabled()) {
            return;
        }
        Player current = this.activeRunner;
        if (current == null || !current.isOnline()) {
            return;
        }
        try {
            this.plugin.getTrackerManager().updateAllHunterCompasses();
            Location loc = current.getLocation();
            if (loc != null && loc.getWorld() != null && loc.getWorld().getEnvironment() == World.Environment.NORMAL) {
                this.plugin.getTrackerManager().setLastRunnerOverworldLocation(loc);
            }
        }
        catch (Throwable t) {
            this.plugin.getLogger().warning("Failed to refresh tracker targets: " + t.getMessage());
        }
    }

    private boolean deferSwapForPortal(Player runner) {
        int maxAttempts;
        boolean inPortal;
        if (runner == null || !runner.isOnline()) {
            return false;
        }
        if (runner.getGameMode() == GameMode.SPECTATOR) {
            this.portalSwapRetries.remove(runner.getUniqueId());
            return false;
        }
        Location loc = runner.getLocation();
        if (loc == null) {
            return false;
        }
        Material type = loc.getBlock().getType();
        boolean bl = inPortal = type == Material.NETHER_PORTAL || type == Material.END_PORTAL || type == Material.END_GATEWAY;
        if (!inPortal) {
            this.portalSwapRetries.remove(runner.getUniqueId());
            return false;
        }
        int attempts = this.portalSwapRetries.getOrDefault(runner.getUniqueId(), 0);
        if (attempts >= (maxAttempts = this.plugin.getConfig().getInt("tracker.portal_retry_attempts", 5))) {
            this.portalSwapRetries.remove(runner.getUniqueId());
            return false;
        }
        this.portalSwapRetries.put(runner.getUniqueId(), attempts + 1);
        long delay = this.plugin.getConfig().getLong("tracker.portal_retry_delay_ticks", 20L);
        long normalizedDelay = Math.max(5L, delay);
        if (this.plugin.getConfigManager().isBroadcastGameEvents()) {
            Msg.broadcast("\u00a7e[SpeedrunnerSwap] Swap deferred: runner is mid-portal. Retrying in " + (double)normalizedDelay / 20.0 + "s (attempt " + (attempts + 1) + "/" + maxAttempts + ").");
        } else {
            this.plugin.getLogger().info("Deferred runner swap while player is in portal. Retry " + (attempts + 1) + "/" + maxAttempts + " in " + normalizedDelay + " ticks.");
        }
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, this::performSwap, normalizedDelay);
        return true;
    }

    private void ensureRunnerQueueCoherence() {
        ArrayList<Player> cleaned = new ArrayList<Player>();
        HashSet<UUID> seen = new HashSet<UUID>();
        for (Player candidate : this.runners) {
            if (candidate == null || !candidate.isOnline() || !seen.add(candidate.getUniqueId())) continue;
            cleaned.add(candidate);
        }
        this.runners = cleaned;
        if (this.runners.isEmpty()) {
            this.activeRunner = null;
            this.activeRunnerIndex = 0;
            return;
        }
        if (this.activeRunner != null && this.activeRunner.isOnline()) {
            int idx = this.runners.indexOf(this.activeRunner);
            if (idx >= 0) {
                this.activeRunnerIndex = idx;
            } else {
                this.runners.add(0, this.activeRunner);
                this.activeRunnerIndex = 0;
                seen.add(this.activeRunner.getUniqueId());
            }
        } else {
            this.activeRunner = this.runners.get(0);
            this.activeRunnerIndex = 0;
            seen.add(this.activeRunner.getUniqueId());
        }
        HashSet<UUID> allowed = new HashSet<UUID>(seen);
        if (this.activeRunner != null) {
            allowed.add(this.activeRunner.getUniqueId());
        }
        this.portalSwapRetries.keySet().retainAll(allowed);
        this.swapInProgress = false;
    }

    public void triggerImmediateSwap() {
        if (!this.gameRunning || this.gamePaused) {
            return;
        }
        Bukkit.getScheduler().runTask((Plugin)this.plugin, this::performSwap);
    }

    public void triggerImmediateHunterSwap() {
        if (!this.gameRunning || this.gamePaused) {
            return;
        }
        Bukkit.getScheduler().runTask((Plugin)this.plugin, this::performHunterSwap);
    }

    private void performHunterSwap() {
        if (!this.gameRunning || this.gamePaused || this.hunters.size() < 2) {
            return;
        }
        Collections.shuffle(this.hunters);
        this.plugin.getTrackerManager().updateAllHunterCompasses();
        if (this.plugin.getConfigManager().isBroadcastsEnabled()) {
            Msg.broadcast("\u00a7c[SpeedrunnerSwap] Hunters have been swapped!");
        }
    }

    private void applyRandomPowerUp(Player player) {
        boolean isGoodEffect;
        PotionEffectType t;
        PotionEffectType t2;
        String k;
        int n;
        String[] stringArray;
        String[] defaults;
        PotionEffectType t3;
        List<String> good = this.plugin.getConfigManager().getGoodPowerUps();
        List<String> bad = this.plugin.getConfigManager().getBadPowerUps();
        ArrayList<PotionEffectType> goodTypes = new ArrayList<PotionEffectType>();
        ArrayList<PotionEffectType> badTypes = new ArrayList<PotionEffectType>();
        for (String id : good) {
            t3 = this.resolveEffect(id);
            if (t3 == null) continue;
            goodTypes.add(t3);
        }
        for (String id : bad) {
            t3 = this.resolveEffect(id);
            if (t3 == null) continue;
            badTypes.add(t3);
        }
        if (goodTypes.isEmpty()) {
            stringArray = defaults = new String[]{"speed", "regeneration", "resistance", "night_vision", "dolphins_grace"};
            n = defaults.length;
            int t4 = 0;
            while (t4 < n) {
                k = stringArray[t4];
                t2 = BukkitCompat.resolvePotionEffect(k);
                if (t2 != null) {
                    goodTypes.add(t2);
                }
                ++t4;
            }
            if (goodTypes.isEmpty() && (t = BukkitCompat.resolvePotionEffect("speed")) != null) {
                goodTypes.add(t);
            }
        }
        if (badTypes.isEmpty()) {
            stringArray = defaults = new String[]{"slowness", "weakness", "hunger", "darkness", "glowing"};
            n = defaults.length;
            int t4 = 0;
            while (t4 < n) {
                k = stringArray[t4];
                t2 = BukkitCompat.resolvePotionEffect(k);
                if (t2 != null) {
                    badTypes.add(t2);
                }
                ++t4;
            }
            if (badTypes.isEmpty() && (t = BukkitCompat.resolvePotionEffect("slowness")) != null) {
                badTypes.add(t);
            }
        }
        ArrayList<PotionEffectType> effectPool = (isGoodEffect = ThreadLocalRandom.current().nextBoolean()) ? goodTypes : badTypes;
        PotionEffectType effectType = (PotionEffectType)effectPool.get(ThreadLocalRandom.current().nextInt(effectPool.size()));
        int duration = ThreadLocalRandom.current().nextInt(10, 21) * 20;
        int amplifier = ThreadLocalRandom.current().nextInt(2);
        player.addPotionEffect(new PotionEffect(effectType, duration, amplifier));
        String effectName = effectType.getKey().getKey().replace("_", " ").toLowerCase();
        String effectLevel = amplifier == 0 ? "I" : "II";
        player.sendMessage(String.format("\u00a7%sYou received a %s power-up: %s %s!", isGoodEffect ? "a" : "c", isGoodEffect ? "good" : "bad", effectName, effectLevel));
    }

    private PotionEffectType resolveEffect(String id) {
        return BukkitCompat.resolvePotionEffect(id);
    }

    public boolean pauseGame() {
        Player ar;
        if (!this.gameRunning || this.gamePaused) {
            return false;
        }
        this.gamePaused = true;
        if (this.swapTask != null) {
            this.swapTask.cancel();
        }
        if (this.hunterSwapTask != null) {
            this.hunterSwapTask.cancel();
        }
        if (this.actionBarTask != null) {
            this.actionBarTask.cancel();
        }
        if (this.titleTask != null) {
            this.titleTask.cancel();
        }
        if ((ar = this.getActiveRunner()) != null) {
            try {
                ar.addPotionEffect(new PotionEffect(PotionEffectType.SLOWNESS, 60, 10, false, false));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        Msg.broadcast("\u00a7e\u00a7lGame paused by admin.");
        return true;
    }

    public boolean resumeGame() {
        if (!this.gameRunning || !this.gamePaused) {
            return false;
        }
        this.gamePaused = false;
        this.scheduleNextSwap();
        this.scheduleNextHunterSwap();
        this.startActionBarUpdates();
        this.startTitleUpdates();
        this.startCageEnforcement();
        Msg.broadcast("\u00a7a\u00a7lGame resumed.");
        return true;
    }

    public boolean isGamePaused() {
        return this.gamePaused;
    }

    public boolean shuffleQueue() {
        if (this.runners == null || this.runners.size() < 2) {
            return false;
        }
        Player current = this.activeRunner;
        ArrayList<Player> rest = new ArrayList<Player>();
        for (Player p : this.runners) {
            if (p.equals(current)) continue;
            rest.add(p);
        }
        Collections.shuffle(rest, new Random());
        ArrayList<Player> newOrder = new ArrayList<Player>();
        newOrder.add(current);
        newOrder.addAll(rest);
        this.runners = newOrder;
        this.applyInactiveEffects();
        this.refreshActionBar();
        return true;
    }

    public void setRunners(List<Player> players) {
        LinkedHashSet<Player> unique = new LinkedHashSet<Player>(players);
        ArrayList<String> names = new ArrayList<String>();
        for (Player p : unique) {
            names.add(p.getName());
        }
        this.plugin.getConfigManager().setRunnerNames(names);
        List<String> currentHunters = this.plugin.getConfigManager().getHunterNames();
        currentHunters.removeAll(names);
        this.plugin.getConfigManager().setHunterNames(currentHunters);
        this.runners = new ArrayList<Player>(unique);
        this.refreshTeamSelections();
    }

    public void setHunters(List<Player> players) {
        LinkedHashSet<Player> unique = new LinkedHashSet<Player>(players);
        ArrayList<String> names = new ArrayList<String>();
        for (Player p : unique) {
            names.add(p.getName());
        }
        this.plugin.getConfigManager().setHunterNames(names);
        List<String> currentRunners = this.plugin.getConfigManager().getRunnerNames();
        currentRunners.removeAll(names);
        this.plugin.getConfigManager().setRunnerNames(currentRunners);
        this.hunters = new ArrayList<Player>(unique);
        this.refreshTeamSelections();
    }

    public void clearAllTeams() {
        this.runners = new ArrayList<Player>();
        this.hunters = new ArrayList<Player>();
        this.plugin.getConfigManager().setRunnerNames(Collections.emptyList());
        this.plugin.getConfigManager().setHunterNames(Collections.emptyList());
        this.refreshTeamSelections();
    }

    public boolean assignPlayerToTeam(Player target, Team team) {
        if (target == null) {
            return false;
        }
        ArrayList<Player> newRunners = new ArrayList<Player>(this.runners);
        ArrayList<Player> newHunters = new ArrayList<Player>(this.hunters);
        boolean changed = false;
        if (newRunners.remove(target)) {
            changed = true;
        }
        if (newHunters.remove(target)) {
            changed = true;
        }
        if (team == Team.RUNNER) {
            if (!newRunners.contains(target)) {
                newRunners.add(target);
                changed = true;
            }
        } else if (team == Team.HUNTER) {
            if (!this.huntersAllowed(this.plugin.getCurrentMode())) {
                return false;
            }
            if (!newHunters.contains(target)) {
                newHunters.add(target);
                changed = true;
            }
        }
        if (!changed) {
            return false;
        }
        this.setRunners(newRunners);
        this.setHunters(newHunters);
        return true;
    }

    private boolean huntersAllowed(SpeedrunnerSwap.SwapMode mode) {
        return mode == SpeedrunnerSwap.SwapMode.DREAM;
    }

    private boolean huntersRequired(SpeedrunnerSwap.SwapMode mode) {
        return mode == SpeedrunnerSwap.SwapMode.DREAM;
    }

    private void refreshTeamSelections() {
        for (Player online : Bukkit.getOnlinePlayers()) {
            try {
                PlayerState state = this.getPlayerState(online);
                if (state == null) continue;
                if (this.runners.contains(online)) {
                    state.setSelectedTeam(Team.RUNNER);
                    continue;
                }
                if (this.hunters.contains(online)) {
                    state.setSelectedTeam(Team.HUNTER);
                    continue;
                }
                state.setSelectedTeam(Team.NONE);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void updateTitles() {
        int timeLeft = this.getTimeUntilNextSwap();
        Player current = this.activeRunner;
        boolean isSneak = current != null && current.isSneaking();
        boolean isSprint = current != null && current.isSprinting();
        String waitingVis = this.plugin.getConfigManager().getWaitingTimerVisibility();
        boolean waitingAlways = "always".equalsIgnoreCase(waitingVis);
        boolean waitingLast10 = "last_10".equalsIgnoreCase(waitingVis);
        for (Player p : Bukkit.getOnlinePlayers()) {
            boolean shouldShow;
            if (!this.runners.contains(p)) continue;
            boolean isActive = p.equals(current);
            boolean isCaged = this.cagedPlayers.contains(p.getUniqueId());
            if (isCaged && !isActive) {
                String t = String.format("\u00a76\u00a7lSwap in: %ds", Math.max(0, timeLeft));
                String sub = String.format("\u00a7eSneaking: %s  \u00a77|  \u00a7eRunning: %s", isSneak ? "Yes" : "No", isSprint ? "Yes" : "No");
                BukkitCompat.showTitle(p, t, sub, 0, 20, 0);
                continue;
            }
            boolean bl = shouldShow = !isActive && !isCaged && (waitingAlways || waitingLast10 && timeLeft <= 10);
            if (!shouldShow) continue;
            String t = String.format("\u00a76\u00a7lSwap in: %ds", Math.max(0, timeLeft));
            String sub = String.format("\u00a7eSneaking: %s  \u00a77|  \u00a7eRunning: %s", isSneak ? "Yes" : "No", isSprint ? "Yes" : "No");
            BukkitCompat.showTitle(p, t, sub, 0, 12, 0);
        }
    }

    private void createOrEnsureSharedCage(World world) {
        if (world == null) {
            world = (World)Bukkit.getWorlds().get(0);
        }
        Location base = this.plugin.getConfigManager().getLimboLocation();
        int y = world.getMaxHeight() - 10;
        int cx = (int)Math.round(base.getX());
        int cz = (int)Math.round(base.getZ());
        Location center = new Location(world, (double)cx + 0.5, (double)y, (double)cz + 0.5);
        Location existing = this.sharedCageCenters.get(world);
        if (existing != null && Math.abs(existing.getX() - center.getX()) < 0.1 && Math.abs(existing.getY() - center.getY()) < 0.1 && Math.abs(existing.getZ() - center.getZ()) < 0.1) {
            return;
        }
        List<BlockState> old = this.sharedCageBlocks.remove(world);
        if (old != null) {
            for (BlockState s : old) {
                try {
                    s.update(true, false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        try {
            center.getChunk().load(true);
        }
        catch (Throwable s) {
            // empty catch block
        }
        ArrayList<BlockState> changed = new ArrayList<BlockState>();
        int dx = -2;
        while (dx <= 2) {
            int dy = -1;
            while (dy <= 2) {
                int dz = -2;
                while (dz <= 2) {
                    Block block = world.getBlockAt(cx + dx, y + dy, cz + dz);
                    boolean isShell = dx == -2 || dx == 2 || dz == -2 || dz == 2 || dy == -1 || dy == 2;
                    changed.add(block.getState());
                    block.setType(isShell ? Material.BEDROCK : Material.AIR, false);
                    ++dz;
                }
                ++dy;
            }
            ++dx;
        }
        dx = -3;
        while (dx <= 3) {
            int dz = -3;
            while (dz <= 3) {
                Block floor = world.getBlockAt(cx + dx, y - 1, cz + dz);
                changed.add(floor.getState());
                floor.setType(Material.BEDROCK, false);
                ++dz;
            }
            ++dx;
        }
        this.sharedCageBlocks.put(world, changed);
        this.sharedCageCenters.put(world, center.clone());
    }

    private void teleportToSharedCage(Player p) {
        if (p == null || !p.isOnline()) {
            return;
        }
        this.createOrEnsureSharedCage(p.getWorld());
        Location center = this.sharedCageCenters.get(p.getWorld());
        if (center != null) {
            p.teleport(center);
            this.cagedPlayers.add(p.getUniqueId());
            try {
                p.setAllowFlight(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                p.setFlying(false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void cleanupAllCages() {
        for (Map.Entry<World, List<BlockState>> e : this.sharedCageBlocks.entrySet()) {
            List<BlockState> list = e.getValue();
            if (list == null) continue;
            for (BlockState s : list) {
                try {
                    s.update(true, false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.sharedCageBlocks.clear();
        this.sharedCageCenters.clear();
        this.cagedPlayers.clear();
    }

    private void startCageEnforcement() {
        if (this.cageTask != null) {
            this.cageTask.cancel();
            this.cageTask = null;
        }
        this.cageTask = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            if (!this.gameRunning || this.gamePaused) {
                return;
            }
            if (!"CAGE".equalsIgnoreCase(this.plugin.getConfigManager().getFreezeMode())) {
                return;
            }
            for (Player r : this.runners) {
                boolean outside;
                if (r.equals(this.activeRunner) || !r.isOnline()) continue;
                this.createOrEnsureSharedCage(r.getWorld());
                this.teleportToSharedCage(r);
                Location center = this.sharedCageCenters.get(r.getWorld());
                if (center == null) continue;
                Location loc = r.getLocation();
                double dx = Math.abs(loc.getX() - center.getX());
                double dy = loc.getY() - center.getY();
                double dz = Math.abs(loc.getZ() - center.getZ());
                boolean bl = outside = dx > 1.2 || dz > 1.2 || dy < -0.2 || dy > 0.8;
                if (outside) {
                    r.teleport(center);
                    r.setVelocity(new Vector(0, 0, 0));
                    r.setFallDistance(0.0f);
                    r.setNoDamageTicks(Math.max(10, r.getNoDamageTicks()));
                    continue;
                }
                try {
                    r.setAllowFlight(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    r.setFlying(false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }, 0L, 5L);
    }

    public boolean areBothPlayersInSharedCage(Player a, Player b) {
        if (a == null || b == null) {
            return false;
        }
        if (!this.cagedPlayers.contains(a.getUniqueId()) || !this.cagedPlayers.contains(b.getUniqueId())) {
            return false;
        }
        return a.getWorld().equals(b.getWorld()) && this.sharedCageCenters.containsKey(a.getWorld());
    }
}

