/*
 * Decompiled with CFR 0.152.
 */
package com.example.speedrunnerswap.gui;

import com.example.speedrunnerswap.SpeedrunnerSwap;
import com.example.speedrunnerswap.config.ConfigManager;
import com.example.speedrunnerswap.game.GameManager;
import com.example.speedrunnerswap.models.Team;
import com.example.speedrunnerswap.task.TaskDefinition;
import com.example.speedrunnerswap.task.TaskDifficulty;
import com.example.speedrunnerswap.task.TaskManagerMode;
import com.example.speedrunnerswap.utils.GuiCompat;
import com.example.speedrunnerswap.utils.Msg;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffectType;

public final class GuiManager
implements Listener {
    private static final ItemStack FILLER_PRIMARY;
    private static final ItemStack FILLER_ACCENT;
    private static final ItemStack FILLER_BORDER;
    private static final NamespacedKey BUTTON_KEY;
    private static final List<String> PARTICLE_TYPES;
    private final SpeedrunnerSwap plugin;
    private final Map<MenuKey, MenuBuilder> builders = new EnumMap<MenuKey, MenuBuilder>(MenuKey.class);
    private final Map<UUID, MenuSession> sessions = new HashMap<UUID, MenuSession>();
    private final Map<UUID, Deque<MenuRequest>> history = new HashMap<UUID, Deque<MenuRequest>>();
    private final Map<UUID, Team> teamFocus = new HashMap<UUID, Team>();
    private final Map<UUID, StatsParent> statsParents = new HashMap<UUID, StatsParent>();

    static {
        PARTICLE_TYPES = List.of("DUST", "END_ROD", "FLAME", "CRIT", "HEART", "CLOUD", "SMOKE");
        FILLER_PRIMARY = GuiManager.pane(Material.LIGHT_BLUE_STAINED_GLASS_PANE);
        FILLER_ACCENT = GuiManager.pane(Material.WHITE_STAINED_GLASS_PANE);
        FILLER_BORDER = GuiManager.pane(Material.BLUE_STAINED_GLASS_PANE);
        BUTTON_KEY = new NamespacedKey((Plugin)SpeedrunnerSwap.getInstance(), "menu_button");
    }

    private static ItemStack pane(Material material) {
        ItemStack pane = new ItemStack(material);
        ItemMeta meta = pane.getItemMeta();
        GuiCompat.setDisplayName(meta, " ");
        meta.addItemFlags(ItemFlag.values());
        pane.setItemMeta(meta);
        return pane;
    }

    public GuiManager(SpeedrunnerSwap plugin) {
        this.plugin = plugin;
        this.registerBuilders();
    }

    public void openMainMenu(Player player) {
        this.open(player, MenuKey.MAIN, null, false);
    }

    public void openDirectGamemodeSelector(Player player) {
        if (player == null) {
            return;
        }
        this.resetNavigation(player);
        this.open(player, MenuKey.MODE_SELECT_DIRECT, null, false);
    }

    public void openModeSelector(Player player) {
        this.open(player, MenuKey.MODE_SELECT, null, false);
    }

    public void openTeamSelector(Player player) {
        this.open(player, MenuKey.TEAM_MANAGEMENT, null, false);
    }

    public void openSettingsMenu(Player player) {
        this.open(player, MenuKey.SETTINGS_HOME, null, false);
    }

    public void openPowerUpsMenu(Player player) {
        this.open(player, MenuKey.POWERUPS_ROOT, null, false);
    }

    public void openDangerousBlocksMenu(Player player) {
        this.open(player, MenuKey.DANGEROUS_BLOCKS, null, false);
    }

    public void openTaskManagerMenu(Player player) {
        this.open(player, MenuKey.TASK_HOME, null, false);
    }

    public void openStatisticsMenu(Player player, StatsParent parent) {
        this.statsParents.put(player.getUniqueId(), parent);
        this.open(player, MenuKey.STATS_ROOT, null, false);
    }

    public void openStatisticsMenu(Player player) {
        this.openStatisticsMenu(player, StatsParent.SETTINGS);
    }

    private void open(Player player, MenuKey key, Object data, boolean replaceHistory) {
        if (player == null) {
            return;
        }
        MenuBuilder builder = this.builders.get((Object)key);
        if (builder == null) {
            player.closeInventory();
            player.sendMessage("\u00a7cMenu not implemented: " + key.name());
            return;
        }
        MenuRequest request = new MenuRequest(key, data);
        MenuContext context = new MenuContext(this, player, request);
        MenuScreen screen = builder.build(context);
        Inventory inventory = GuiCompat.createInventory(null, screen.size(), screen.title());
        this.fill(inventory, screen, context);
        this.sessions.put(player.getUniqueId(), new MenuSession(request, screen, inventory));
        Deque stack = this.history.computeIfAbsent(player.getUniqueId(), id -> new ArrayDeque());
        if (replaceHistory && !stack.isEmpty()) {
            stack.pop();
        }
        if (stack.isEmpty() || !((MenuRequest)stack.peek()).equals(request)) {
            stack.push(request);
        }
        player.openInventory(inventory);
    }

    void reopen(Player player) {
        MenuSession session = this.sessions.get(player.getUniqueId());
        if (session == null) {
            return;
        }
        this.open(player, session.request.key(), session.request.data(), true);
    }

    void open(Player player, MenuKey key) {
        this.open(player, key, null, false);
    }

    void open(Player player, MenuKey key, Object data) {
        this.open(player, key, data, false);
    }

    void openPrevious(Player player) {
        Deque<MenuRequest> stack = this.history.get(player.getUniqueId());
        if (stack == null || stack.isEmpty()) {
            player.closeInventory();
            return;
        }
        stack.pop();
        if (stack.isEmpty()) {
            player.closeInventory();
            return;
        }
        MenuRequest previous = stack.peek();
        this.open(player, previous.key(), previous.data(), true);
    }

    private void fill(Inventory inventory, MenuScreen screen, MenuContext context) {
        int rows = inventory.getSize() / 9;
        int i = 0;
        while (i < inventory.getSize()) {
            ItemStack filler;
            int row = i / 9;
            int col = i % 9;
            if (row == 0 || row == rows - 1 || col == 0 || col == 8) {
                filler = FILLER_BORDER.clone();
            } else {
                boolean usePrimary = (row + col) % 2 == 0;
                filler = (usePrimary ? FILLER_PRIMARY : FILLER_ACCENT).clone();
            }
            inventory.setItem(i, filler);
            ++i;
        }
        for (MenuItem item : screen.items()) {
            if (item.slot() < 0 || item.slot() >= inventory.getSize()) continue;
            ItemStack icon = item.icon().apply(context);
            ItemMeta meta = icon.getItemMeta();
            meta.getPersistentDataContainer().set(BUTTON_KEY, PersistentDataType.STRING, (Object)item.id());
            icon.setItemMeta(meta);
            inventory.setItem(item.slot(), icon);
        }
    }

    /*
     * WARNING - void declaration
     */
    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        void player;
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player2 = (Player)humanEntity;
        MenuSession session = this.sessions.get(player.getUniqueId());
        if (session == null) {
            return;
        }
        if (!Objects.equals(event.getView().getTopInventory(), session.inventory())) {
            return;
        }
        event.setCancelled(true);
        ItemStack current = event.getCurrentItem();
        if (current == null || current.getType() == Material.AIR) {
            return;
        }
        ItemMeta meta = current.getItemMeta();
        if (meta == null) {
            return;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        String id = (String)container.get(BUTTON_KEY, PersistentDataType.STRING);
        if (id == null) {
            return;
        }
        MenuItem item = session.screen.button(id);
        if (item == null || item.action() == null) {
            return;
        }
        MenuClickContext ctx = new MenuClickContext(this, (Player)player, session.request, event.isShiftClick(), event.getClick());
        item.action().accept(ctx);
    }

    /*
     * WARNING - void declaration
     */
    @EventHandler
    public void onInventoryDrag(InventoryDragEvent event) {
        void player;
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player2 = (Player)humanEntity;
        MenuSession session = this.sessions.get(player.getUniqueId());
        if (session == null) {
            return;
        }
        if (Objects.equals(event.getView().getTopInventory(), session.inventory())) {
            event.setCancelled(true);
        }
    }

    /*
     * WARNING - void declaration
     */
    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        void player;
        HumanEntity humanEntity = event.getPlayer();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player2 = (Player)humanEntity;
        MenuSession session = this.sessions.get(player.getUniqueId());
        if (session != null && Objects.equals(session.inventory(), event.getInventory())) {
            this.sessions.remove(player.getUniqueId());
        }
    }

    private void registerBuilders() {
        this.builders.put(MenuKey.MAIN, ctx -> this.buildMainMenu(ctx));
        this.builders.put(MenuKey.MODE_SELECT, ctx -> this.buildModeSelect(ctx, false));
        this.builders.put(MenuKey.MODE_SELECT_DIRECT, ctx -> this.buildModeSelect(ctx, true));
        this.builders.put(MenuKey.TEAM_MANAGEMENT, this::buildTeamMenu);
        this.builders.put(MenuKey.SETTINGS_HOME, this::buildSettingsHome);
        this.builders.put(MenuKey.SETTINGS_SWAP, this::buildSwapSettings);
        this.builders.put(MenuKey.SETTINGS_SAFETY, this::buildSafetySettings);
        this.builders.put(MenuKey.SETTINGS_HUNTER, this::buildHunterSettings);
        this.builders.put(MenuKey.POWERUPS_ROOT, this::buildPowerUpsRoot);
        this.builders.put(MenuKey.POWERUPS_EFFECTS, this::buildPowerUpEffects);
        this.builders.put(MenuKey.POWERUPS_DURATION, this::buildPowerUpDurations);
        this.builders.put(MenuKey.DANGEROUS_BLOCKS, this::buildDangerousBlocks);
        this.builders.put(MenuKey.SETTINGS_WORLD_BORDER, this::buildWorldBorder);
        this.builders.put(MenuKey.SETTINGS_BOUNTY, this::buildBounty);
        this.builders.put(MenuKey.SETTINGS_LAST_STAND, this::buildLastStand);
        this.builders.put(MenuKey.SETTINGS_SUDDEN_DEATH, this::buildSuddenDeath);
        this.builders.put(MenuKey.STATS_ROOT, this::buildStatsRoot);
        this.builders.put(MenuKey.STATS_ADVANCED, this::buildStatsAdvanced);
        this.builders.put(MenuKey.SETTINGS_TASK, this::buildTaskSettings);
        this.builders.put(MenuKey.TASK_HOME, this::buildTaskHome);
        this.builders.put(MenuKey.TASK_CUSTOM, this::buildTaskCustom);
        this.builders.put(MenuKey.TASK_POOL, this::buildTaskPool);
        this.builders.put(MenuKey.TASK_ASSIGNMENTS, this::buildTaskAssignments);
        this.builders.put(MenuKey.SETTINGS_VOICE_CHAT, this::buildVoiceChat);
        this.builders.put(MenuKey.SETTINGS_BROADCAST, this::buildBroadcast);
        this.builders.put(MenuKey.SETTINGS_UI, this::buildUiSettings);
        this.builders.put(MenuKey.KIT_MANAGER, this::buildKitManager);
    }

    private void resetNavigation(Player player) {
        UUID id = player.getUniqueId();
        this.sessions.remove(id);
        this.history.remove(id);
    }

    private MenuScreen buildMainMenu(MenuContext ctx) {
        ArrayList<MenuItem> items = new ArrayList<MenuItem>();
        GameManager gm = this.plugin.getGameManager();
        ConfigManager cfg = this.plugin.getConfigManager();
        boolean running = gm.isGameRunning();
        boolean paused = gm.isGamePaused();
        SpeedrunnerSwap.SwapMode mode = this.plugin.getCurrentMode();
        items.add(this.backButton(0, "\u00a77\u00a7lBack", null, null, null));
        ArrayList<Object> statusLore = new ArrayList<Object>();
        statusLore.add("\u00a77Mode: \u00a7f" + mode.name());
        statusLore.add("\u00a77Running: " + (running ? "\u00a7aYes" : "\u00a7cNo"));
        statusLore.add("\u00a77Paused: " + (paused ? "\u00a7eYes" : "\u00a7cNo"));
        statusLore.add("\u00a77Speed Owners: \u00a7b" + gm.getRunners().size());
        if (mode == SpeedrunnerSwap.SwapMode.DREAM) {
            statusLore.add("\u00a77Hunters: \u00a7c" + gm.getHunters().size());
        } else {
            statusLore.add("\u00a77Hunters: \u00a78Not used in this mode");
        }
        items.add(this.simpleItem(4, () -> this.icon(Material.CLOCK, "\u00a76\u00a7lGame Status", statusLore)));
        if (!running) {
            items.add(this.clickItem(10, () -> this.icon(Material.LIME_CONCRETE, "\u00a7a\u00a7lStart Game", List.of("\u00a77Swap interval: \u00a7f" + cfg.getSwapInterval() + "s")), ctxClick -> {
                if (gm.startGame()) {
                    Msg.send(ctxClick.player(), "\u00a7aGame started!");
                } else {
                    Msg.send(ctxClick.player(), "\u00a7cCannot start. Check team assignments.");
                }
                ctxClick.reopen();
            }));
        } else {
            items.add(this.clickItem(10, () -> this.icon(Material.RED_CONCRETE, "\u00a7c\u00a7lStop Game", List.of("\u00a77End the current game")), ctxClick -> {
                gm.stopGame();
                Msg.send(ctxClick.player(), "\u00a7cGame stopped.");
                ctxClick.reopen();
            }));
            if (paused) {
                items.add(this.clickItem(12, () -> this.icon(Material.ORANGE_CONCRETE, "\u00a7a\u00a7lResume", List.of("\u00a77Resume swaps")), ctxClick -> {
                    gm.resumeGame();
                    ctxClick.reopen();
                }));
            } else {
                items.add(this.clickItem(12, () -> this.icon(Material.YELLOW_CONCRETE, "\u00a7e\u00a7lPause", List.of("\u00a77Pause swaps")), ctxClick -> {
                    gm.pauseGame();
                    ctxClick.reopen();
                }));
            }
            items.add(this.clickItem(14, () -> this.icon(Material.NETHER_STAR, "\u00a7e\u00a7lForce Swap", List.of("\u00a77Trigger immediate swap")), ctxClick -> {
                gm.triggerImmediateSwap();
                Msg.send(ctxClick.player(), "\u00a7eSwap triggered.");
            }));
        }
        items.add(this.clickItem(18, () -> this.icon(Material.NETHER_STAR, "\u00a7d\u00a7lAbout muj3b", List.of("\u00a77Click to show support info", "\u00a77and share the donation link.")), ctxClick -> {
            this.plugin.getGameManager().sendDonationMessage(ctxClick.player());
            Msg.send(ctxClick.player(), "\u00a7dThanks for supporting muj3b!");
        }));
        items.add(this.clickItem(20, () -> this.icon(Material.PLAYER_HEAD, "\u00a7b\u00a7lTeam Management", List.of("\u00a77Assign runners & hunters")), ctxClick -> this.open(ctxClick.player(), MenuKey.TEAM_MANAGEMENT, null, false)));
        items.add(this.clickItem(21, () -> this.icon(Material.ENDER_EYE, "\u00a7d\u00a7lChoose Mode", List.of("\u00a77Switch Dream/Sapnap/Task")), ctxClick -> this.open(ctxClick.player(), MenuKey.MODE_SELECT, null, false)));
        items.add(this.clickItem(22, () -> this.icon(Material.COMPARATOR, "\u00a76\u00a7lSettings", List.of("\u00a77Configure every mechanic")), ctxClick -> this.open(ctxClick.player(), MenuKey.SETTINGS_HOME, null, false)));
        items.add(this.clickItem(23, () -> this.icon(Material.BOOK, "\u00a7b\u00a7lStatistics", List.of("\u00a77Adjust stat tracking")), ctxClick -> this.openStatisticsMenu(ctxClick.player(), StatsParent.MAIN)));
        items.add(this.clickItem(24, () -> this.icon(Material.TARGET, "\u00a76\u00a7lTask Manager", List.of("\u00a77Manage secret tasks")), ctxClick -> this.open(ctxClick.player(), MenuKey.TASK_HOME, null, false)));
        items.add(this.clickItem(30, () -> this.icon(Material.POTION, "\u00a7d\u00a7lPower-ups", List.of("\u00a77Configure swap effects")), ctxClick -> this.open(ctxClick.player(), MenuKey.POWERUPS_ROOT, null, false)));
        items.add(this.clickItem(31, () -> this.icon(Material.BARRIER, "\u00a7c\u00a7lDangerous Blocks", List.of("\u00a77Safe swap blacklist")), ctxClick -> this.open(ctxClick.player(), MenuKey.DANGEROUS_BLOCKS, null, false)));
        items.add(this.clickItem(32, () -> this.icon(Material.GOLD_INGOT, "\u00a76\u00a7lBounty System", List.of("\u00a77Hunter rewards")), ctxClick -> this.open(ctxClick.player(), MenuKey.SETTINGS_BOUNTY, null, false)));
        items.add(this.clickItem(33, () -> this.icon(Material.DRAGON_HEAD, "\u00a74\u00a7lSudden Death", List.of("\u00a77Endgame showdown")), ctxClick -> this.open(ctxClick.player(), MenuKey.SETTINGS_SUDDEN_DEATH, null, false)));
        if (mode == SpeedrunnerSwap.SwapMode.SAPNAP) {
            items.add(this.clickItem(40, () -> this.icon(Material.CLOCK, "\u00a7b\u00a7lQueue Shuffle", List.of("\u00a77Randomize runner order")), ctxClick -> {
                if (this.plugin.getGameManager().shuffleQueue()) {
                    Msg.send(ctxClick.player(), "\u00a7aRunner queue shuffled.");
                } else {
                    Msg.send(ctxClick.player(), "\u00a7cNot enough runners to shuffle.");
                }
            }));
        }
        return new MenuScreen(this.plugin.getConfigManager().getGuiMainMenuTitle(), 54, items);
    }

    private MenuScreen buildModeSelect(MenuContext ctx, boolean direct) {
        ArrayList<MenuItem> items = new ArrayList<MenuItem>();
        SpeedrunnerSwap.SwapMode current = this.plugin.getCurrentMode();
        if (direct) {
            items.add(this.simpleItem(4, () -> this.icon(Material.NETHER_STAR, "\u00a7e\u00a7lWelcome to Speedrunner Swap", List.of("\u00a77Pick the challenge you want to run", "\u00a77and jump straight into setup."))));
            items.add(this.modeItem(10, SpeedrunnerSwap.SwapMode.DREAM, true, current));
            items.add(this.modeItem(13, SpeedrunnerSwap.SwapMode.SAPNAP, true, current));
            items.add(this.modeItem(16, SpeedrunnerSwap.SwapMode.TASK, true, current));
            items.add(this.simpleItem(22, () -> this.icon(Material.MAP, "\u00a7b\u00a7lCurrent Mode", List.of("\u00a77Active: \u00a7f" + current.name(), "", "\u00a77Select another icon to switch."))));
            items.add(this.clickItem(29, () -> this.icon(Material.PLAYER_HEAD, "\u00a7a\u00a7lTeam Manager", List.of("\u00a77Assign runners & hunters")), context -> this.open(context.player(), MenuKey.TEAM_MANAGEMENT, null, false)));
            items.add(this.clickItem(31, () -> this.icon(Material.EMERALD, "\u00a7a\u00a7lOpen Control Hub", List.of("\u00a77Go straight to the main dashboard")), context -> this.open(context.player(), MenuKey.MAIN, null, false)));
            items.add(this.clickItem(33, () -> this.icon(Material.COMPARATOR, "\u00a76\u00a7lQuick Settings", List.of("\u00a77Tweak core mechanics instantly")), context -> this.open(context.player(), MenuKey.SETTINGS_HOME, null, false)));
            items.add(this.backButton(35, "\u00a77\u00a7lBack", null, null, null));
        } else {
            items.add(this.modeItem(11, SpeedrunnerSwap.SwapMode.DREAM, false, current));
            items.add(this.modeItem(13, SpeedrunnerSwap.SwapMode.SAPNAP, false, current));
            items.add(this.modeItem(15, SpeedrunnerSwap.SwapMode.TASK, false, current));
            items.add(this.backButton(22, "\u00a77\u00a7lBack", MenuKey.MAIN, null, player -> this.openPrevious((Player)player)));
        }
        int size = direct ? 36 : 27;
        String title = direct ? "\u00a79\u00a7lSpeedrunner Swap Hub" : "\u00a76\u00a7lMode Selector";
        return new MenuScreen(title, size, items);
    }

    private MenuItem modeItem(int slot, SpeedrunnerSwap.SwapMode mode, boolean direct, SpeedrunnerSwap.SwapMode current) {
        boolean selected = mode == current;
        Material mat = switch (mode) {
            case SpeedrunnerSwap.SwapMode.DREAM -> Material.DIAMOND_SWORD;
            case SpeedrunnerSwap.SwapMode.SAPNAP -> Material.DIAMOND_BOOTS;
            case SpeedrunnerSwap.SwapMode.TASK -> Material.TARGET;
            default -> throw new IncompatibleClassChangeError();
        };
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a78\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500");
        switch (mode) {
            case DREAM: {
                lore.addAll(List.of("\u00a7e\u00a7lSpeedrunners vs Hunters", "\u00a77Classic chase experience"));
                break;
            }
            case SAPNAP: {
                lore.addAll(List.of("\u00a7b\u00a7lMulti-runner Control", "\u00a77Share one body cooperatively"));
                break;
            }
            case TASK: {
                lore.addAll(List.of("\u00a76\u00a7lTask Master", "\u00a77Secret objectives and deception"));
            }
        }
        if (direct) {
            lore.add("");
            switch (mode) {
                case DREAM: {
                    lore.addAll(List.of("\u00a77Recommended: \u00a7f3+ players", "\u00a77(1 runner, 2+ hunters)"));
                    break;
                }
                case SAPNAP: {
                    lore.addAll(List.of("\u00a77Recommended: \u00a7f2-4 players", "\u00a77Perfect for co-op runs"));
                    break;
                }
                case TASK: {
                    lore.addAll(List.of("\u00a77Recommended: \u00a7f3+ players", "\u00a77For strategic chaos"));
                }
            }
        }
        lore.add("");
        lore.add(selected ? "\u00a7aCurrently active" : "\u00a7eClick to switch");
        return this.clickItem(slot, () -> {
            String string = selected ? "\u00a7a\u00a7l" : "\u00a7e\u00a7l";
            ItemStack icon = this.icon(mat, string + (switch (mode) {
                case SpeedrunnerSwap.SwapMode.DREAM -> "Dream";
                case SpeedrunnerSwap.SwapMode.SAPNAP -> "Sapnap";
                case SpeedrunnerSwap.SwapMode.TASK -> "Task Master";
                default -> throw new IncompatibleClassChangeError();
            }), lore);
            if (selected) {
                ItemMeta meta = icon.getItemMeta();
                meta.addEnchant(Enchantment.UNBREAKING, 1, true);
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                icon.setItemMeta(meta);
            }
            return icon;
        }, ctx -> {
            if (selected) {
                Msg.send(ctx.player(), "\u00a7eAlready using that mode.");
                return;
            }
            if (this.plugin.getGameManager().isGameRunning()) {
                Msg.send(ctx.player(), "\u00a7cStop the current game before switching modes.");
                return;
            }
            this.plugin.setCurrentMode(mode);
            Msg.send(ctx.player(), "\u00a7aSwitched to \u00a7f" + mode.name() + "\u00a7a mode.");
            if (direct) {
                this.open(ctx.player(), MenuKey.MAIN, null, false);
            } else {
                ctx.reopen();
            }
        });
    }

    private MenuScreen buildTeamMenu(MenuContext ctx) {
        boolean huntersAvailable;
        Player viewer = ctx.player();
        GameManager gm = this.plugin.getGameManager();
        Team initialFocus = this.teamFocus.computeIfAbsent(viewer.getUniqueId(), uuid -> Team.RUNNER);
        boolean bl = huntersAvailable = this.plugin.getCurrentMode() == SpeedrunnerSwap.SwapMode.DREAM;
        if (!huntersAvailable && initialFocus == Team.HUNTER) {
            initialFocus = Team.RUNNER;
            this.teamFocus.put(viewer.getUniqueId(), Team.RUNNER);
        }
        Team focus = initialFocus;
        ArrayList<MenuItem> items = new ArrayList<MenuItem>();
        items.add(this.backButton(0, "\u00a77\u00a7lBack", MenuKey.MAIN, null, this::openMainMenu));
        items.add(this.clickItem(2, () -> this.icon(Material.DIAMOND_BOOTS, focus == Team.RUNNER ? "\u00a7a\u00a7lAssigning Runners" : "\u00a7b\u00a7lAssign Runners", List.of("\u00a77Click to set focus")), ctxClick -> {
            this.teamFocus.put(ctxClick.player().getUniqueId(), Team.RUNNER);
            ctxClick.reopen();
        }));
        ArrayList<String> instructionLore = new ArrayList<String>();
        instructionLore.add("\u00a771. Select runner/hunter focus");
        instructionLore.add("\u00a772. Click player head to assign");
        instructionLore.add("\u00a773. Shift-click to remove");
        if (this.plugin.getCurrentMode() != SpeedrunnerSwap.SwapMode.DREAM) {
            instructionLore.add("\u00a7cThis mode uses speed owners only.");
            instructionLore.add("\u00a77Assigning hunters is disabled.");
        }
        items.add(this.simpleItem(4, () -> this.icon(Material.BOOK, "\u00a7e\u00a7lInstructions", instructionLore)));
        items.add(this.clickItem(6, () -> this.icon(Material.IRON_SWORD, huntersAvailable ? (focus == Team.HUNTER ? "\u00a7a\u00a7lAssigning Hunters" : "\u00a7c\u00a7lAssign Hunters") : "\u00a77\u00a7lHunters Disabled", huntersAvailable ? List.of("\u00a77Click to set focus") : List.of("\u00a77Dream mode only")), ctxClick -> {
            if (!huntersAvailable) {
                Msg.send(ctxClick.player(), "\u00a7eHunters are only available in Dream mode.");
                return;
            }
            this.teamFocus.put(ctxClick.player().getUniqueId(), Team.HUNTER);
            ctxClick.reopen();
        }));
        items.add(this.clickItem(8, () -> this.icon(Material.BARRIER, "\u00a7c\u00a7lClear All", List.of("\u00a77Remove all assignments")), ctxClick -> {
            HashSet<Player> affected = new HashSet<Player>();
            affected.addAll(gm.getRunners());
            affected.addAll(gm.getHunters());
            gm.clearAllTeams();
            Msg.send(ctxClick.player(), "\u00a7cCleared all teams.");
            for (Player p : affected) {
                if (p == null || !p.isOnline() || p == ctxClick.player()) continue;
                Msg.send(p, "\u00a7eYour team assignment was cleared by \u00a7f" + ctxClick.player().getName());
            }
            ctxClick.reopen();
        }));
        int slot = 9;
        for (Player online : Bukkit.getOnlinePlayers()) {
            if (slot >= 54) break;
            Team assigned = gm.isRunner(online) ? Team.RUNNER : (gm.isHunter(online) ? Team.HUNTER : Team.NONE);
            ItemStack head = new ItemStack(Material.PLAYER_HEAD);
            SkullMeta meta = (SkullMeta)head.getItemMeta();
            meta.setOwningPlayer((OfflinePlayer)online);
            String prefix = switch (assigned) {
                case Team.RUNNER -> "\u00a7b";
                case Team.HUNTER -> "\u00a7c";
                case Team.NONE -> "\u00a77";
                default -> throw new IncompatibleClassChangeError();
            };
            GuiCompat.setDisplayName((ItemMeta)meta, prefix + online.getName());
            Team currentFocus = huntersAvailable ? focus : Team.RUNNER;
            ArrayList<String> lore = new ArrayList<String>();
            lore.add("\u00a77Team: " + (switch (assigned) {
                case Team.RUNNER -> "\u00a7bRunner";
                case Team.HUNTER -> "\u00a7cHunter";
                case Team.NONE -> "\u00a77Unassigned";
                default -> throw new IncompatibleClassChangeError();
            }));
            lore.add("\u00a77Focus: " + (currentFocus == Team.RUNNER ? "\u00a7bSpeed Owners" : "\u00a7cHunters"));
            lore.add("\u00a77Click to assign, shift-click to clear");
            GuiCompat.setLore((ItemMeta)meta, lore);
            head.setItemMeta((ItemMeta)meta);
            items.add(this.clickItem(slot, () -> head, ctxClick -> {
                Team targetTeam;
                Team team = targetTeam = ctxClick.shift() ? Team.NONE : this.teamFocus.getOrDefault(ctxClick.player().getUniqueId(), Team.RUNNER);
                if (!huntersAvailable && targetTeam == Team.HUNTER) {
                    this.teamFocus.put(ctxClick.player().getUniqueId(), Team.RUNNER);
                    Msg.send(ctxClick.player(), "\u00a7eAssign hunters only when Dream mode is active.");
                    ctxClick.reopen();
                    return;
                }
                if (targetTeam == Team.HUNTER && !huntersAvailable) {
                    Msg.send(ctxClick.player(), "\u00a7eAssign hunters only when Dream mode is active.");
                    return;
                }
                boolean changed = gm.assignPlayerToTeam(online, targetTeam);
                if (!changed) {
                    Msg.send(ctxClick.player(), "\u00a7eNo change for \u00a7f" + online.getName());
                } else if (targetTeam == Team.NONE) {
                    Msg.send(ctxClick.player(), "\u00a7eRemoved \u00a7f" + online.getName() + "\u00a7e from teams.");
                    if (online != ctxClick.player()) {
                        Msg.send(online, "\u00a7eYou were removed from all teams by \u00a7f" + ctxClick.player().getName());
                    }
                } else {
                    String label = targetTeam == Team.RUNNER ? "\u00a7bSpeed Owners" : "\u00a7cHunters";
                    Msg.send(ctxClick.player(), "\u00a7aAdded \u00a7f" + online.getName() + "\u00a7a to " + label + "\u00a7a.");
                    if (online != ctxClick.player()) {
                        Msg.send(online, "\u00a7eYou were assigned to " + label + " \u00a7eby \u00a7f" + ctxClick.player().getName());
                    }
                }
                ctxClick.reopen();
            }));
            if ((++slot + 1) % 9 != 0) continue;
            slot += 2;
        }
        return new MenuScreen(this.plugin.getConfigManager().getGuiTeamSelectorTitle(), 54, items);
    }

    private MenuScreen buildSettingsHome(MenuContext ctx) {
        ArrayList<MenuItem> items = new ArrayList<MenuItem>();
        items.add(this.backButton(0, "\u00a77\u00a7lBack", MenuKey.MAIN, null, this::openMainMenu));
        items.add(this.navigateItem(10, Material.CLOCK, "\u00a7e\u00a7lSwap & Timing", MenuKey.SETTINGS_SWAP, "\u00a77Intervals, randomness, hunter swap"));
        items.add(this.navigateItem(11, Material.SHIELD, "\u00a7c\u00a7lSafety & Freeze", MenuKey.SETTINGS_SAFETY, "\u00a77Safe swap, freeze modes, sleep"));
        items.add(this.navigateItem(12, Material.COMPASS, "\u00a7c\u00a7lHunter Tools", MenuKey.SETTINGS_HUNTER, "\u00a77Tracker, compass jamming"));
        items.add(this.navigateItem(13, Material.POTION, "\u00a7d\u00a7lPower-ups", MenuKey.POWERUPS_ROOT, "\u00a77Manage effects"));
        items.add(this.navigateItem(14, Material.BARRIER, "\u00a74\u00a7lWorld Border", MenuKey.SETTINGS_WORLD_BORDER, "\u00a77Shrink timing"));
        items.add(this.navigateItem(15, Material.GOLD_INGOT, "\u00a76\u00a7lBounty", MenuKey.SETTINGS_BOUNTY, "\u00a77Hunter reward system"));
        items.add(this.navigateItem(16, Material.TOTEM_OF_UNDYING, "\u00a76\u00a7lLast Stand", MenuKey.SETTINGS_LAST_STAND, "\u00a77Final runner boost"));
        items.add(this.navigateItem(19, Material.DRAGON_HEAD, "\u00a74\u00a7lSudden Death", MenuKey.SETTINGS_SUDDEN_DEATH, "\u00a77Endgame showdown"));
        items.add(this.navigateItem(20, Material.BOOK, "\u00a7b\u00a7lStatistics", MenuKey.STATS_ROOT, "\u00a77Tracking toggles"));
        items.add(this.navigateItem(21, Material.TARGET, "\u00a76\u00a7lTask Master", MenuKey.SETTINGS_TASK, "\u00a77Competition rules"));
        items.add(this.navigateItem(22, Material.NOTE_BLOCK, "\u00a7d\u00a7lVoice Chat", MenuKey.SETTINGS_VOICE_CHAT, "\u00a77Simple Voice Chat integration"));
        items.add(this.navigateItem(23, Material.BELL, "\u00a7e\u00a7lBroadcasts", MenuKey.SETTINGS_BROADCAST, "\u00a77Announcement settings"));
        items.add(this.navigateItem(24, Material.COMPARATOR, "\u00a7b\u00a7lUI & Timers", MenuKey.SETTINGS_UI, "\u00a77Actionbars, titles, visibility"));
        items.add(this.navigateItem(28, Material.CHEST, "\u00a7a\u00a7lKits", MenuKey.KIT_MANAGER, "\u00a77Toggle kits and quick actions"));
        items.add(this.navigateItem(29, Material.MAGMA_BLOCK, "\u00a7c\u00a7lDangerous Blocks", MenuKey.DANGEROUS_BLOCKS, "\u00a77Edit safe-swap blacklist"));
        return new MenuScreen(this.plugin.getConfigManager().getGuiSettingsTitle(), 54, items);
    }

    private MenuScreen buildSwapSettings(MenuContext ctx) {
        ConfigManager cfg = this.plugin.getConfigManager();
        ArrayList<MenuItem> items = new ArrayList<MenuItem>();
        items.add(this.backButton(0, "\u00a77\u00a7lBack", MenuKey.SETTINGS_HOME, null, this::openSettingsMenu));
        items.add(this.toggleItem(10, Material.REPEATER, "\u00a7e\u00a7lRandomized Swaps", cfg::isSwapRandomized, value -> cfg.setSwapRandomized((boolean)value), "\u00a77Gaussian distribution around interval"));
        items.add(this.adjustItem(11, Material.CLOCK, "\u00a7e\u00a7lBase Interval", cfg::getSwapInterval, value -> cfg.setSwapInterval((int)value), 5, 15, 5, 600, "\u00a77Swap every X seconds"));
        items.add(this.toggleItem(12, Material.REDSTONE_TORCH, "\u00a7e\u00a7lExperimental Intervals", cfg::isBetaIntervalEnabled, value -> cfg.setBetaIntervalEnabled((boolean)value), "\u00a77Allow intervals <30s or above max"));
        items.add(this.adjustItem(13, Material.COMPASS, "\u00a76\u00a7lMin Interval", cfg::getMinSwapInterval, value -> this.plugin.getConfig().set("swap.min_interval", value), 5, 15, 5, 600, "\u00a77Minimum random interval"));
        items.add(this.adjustItem(14, Material.COMPASS, "\u00a76\u00a7lMax Interval", cfg::getSwapIntervalMax, value -> this.plugin.getConfig().set("swap.max_interval", value), 5, 15, 5, 1800, "\u00a77Maximum random interval"));
        items.add(this.adjustItem(15, Material.SPYGLASS, "\u00a76\u00a7lJitter Std Dev", () -> (int)Math.round(cfg.getJitterStdDev()), value -> this.plugin.getConfig().set("swap.jitter.stddev", value), 1, 5, 0, 600, "\u00a77Standard deviation for random interval"));
        items.add(this.toggleItem(16, Material.LEVER, "\u00a7e\u00a7lClamp Jitter", cfg::isClampJitter, value -> this.plugin.getConfig().set("swap.jitter.clamp", value), "\u00a77Restrict random interval within min/max"));
        items.add(this.toggleItem(19, Material.PISTON, "\u00a7e\u00a7lHunter Swap", cfg::isHunterSwapEnabled, value -> this.plugin.getConfig().set("swap.hunter_swap.enabled", value), "\u00a77Rotate which hunter chases"));
        items.add(this.adjustItem(20, Material.ARROW, "\u00a76\u00a7lHunter Swap Interval", cfg::getHunterSwapInterval, value -> this.plugin.getConfig().set("swap.hunter_swap.interval", value), 10, 30, 10, 600, "\u00a77Seconds between hunter rotations"));
        items.add(this.toggleItem(21, Material.BLAZE_POWDER, "\u00a7e\u00a7lHot Potato Mode", cfg::isHotPotatoModeEnabled, value -> this.plugin.getConfig().set("swap.hot_potato_mode.enabled", value), "\u00a77Swap to damaged runner immediately"));
        items.add(this.toggleItem(22, Material.REDSTONE_TORCH, "\u00a7e\u00a7lPause on Disconnect", cfg::isPauseOnDisconnect, value -> this.plugin.getConfig().set("swap.pause_on_disconnect", value), "\u00a77Auto-pause when active runner leaves"));
        items.add(this.toggleItem(23, Material.BOOK, "\u00a7e\u00a7lApply Mode Defaults", cfg::getApplyDefaultOnModeSwitch, value -> this.plugin.getConfig().set("swap.apply_default_on_mode_switch", value), "\u00a77Reset interval when switching mode"));
        items.add(this.adjustItem(24, Material.DIAMOND_SWORD, "\u00a76\u00a7lDream Default", () -> cfg.getModeDefaultInterval(SpeedrunnerSwap.SwapMode.DREAM), value -> cfg.setModeDefaultInterval(SpeedrunnerSwap.SwapMode.DREAM, (int)value), 5, 15, 5, 600, "\u00a77Default interval for Dream mode"));
        items.add(this.adjustItem(25, Material.DIAMOND_BOOTS, "\u00a76\u00a7lSapnap Default", () -> cfg.getModeDefaultInterval(SpeedrunnerSwap.SwapMode.SAPNAP), value -> cfg.setModeDefaultInterval(SpeedrunnerSwap.SwapMode.SAPNAP, (int)value), 5, 15, 5, 600, "\u00a77Default interval for Sapnap mode"));
        items.add(this.adjustItem(26, Material.TARGET, "\u00a76\u00a7lTask Default", () -> cfg.getModeDefaultInterval(SpeedrunnerSwap.SwapMode.TASK), value -> cfg.setModeDefaultInterval(SpeedrunnerSwap.SwapMode.TASK, (int)value), 5, 15, 5, 600, "\u00a77Default interval for Task mode"));
        items.add(this.adjustItem(28, Material.SHIELD, "\u00a76\u00a7lGrace Period (s)", () -> (int)Math.round((double)this.plugin.getConfig().getInt("swap.grace_period_ticks", 40) / 20.0), value -> this.plugin.getConfig().set("swap.grace_period_ticks", (Object)(Math.max(0, value) * 20)), 1, 5, 0, 600, "\u00a77Seconds of invulnerability after swapping"));
        items.add(this.toggleConfigItem(30, Material.PLAYER_HEAD, "\u00a7e\u00a7lPreserve Runner Progress", "swap.preserve_runner_progress_on_end", false, "\u00a77Copy final runner inventory to everyone"));
        items.add(this.backButton(44, "\u00a77\u00a7lBack", MenuKey.SETTINGS_HOME, null, this::openSettingsMenu));
        return new MenuScreen("\u00a7e\u00a7lSwap & Timing", 54, items);
    }

    private MenuScreen buildSafetySettings(MenuContext ctx) {
        ConfigManager cfg = this.plugin.getConfigManager();
        ArrayList<MenuItem> items = new ArrayList<MenuItem>();
        items.add(this.backButton(0, "\u00a77\u00a7lBack", MenuKey.SETTINGS_HOME, null, this::openSettingsMenu));
        items.add(this.toggleItem(10, Material.SLIME_BLOCK, "\u00a7e\u00a7lSafe Swaps", cfg::isSafeSwapEnabled, value -> cfg.setSafeSwapEnabled((boolean)value), "\u00a77Scan area before swapping"));
        items.add(this.adjustItem(11, Material.MAP, "\u00a76\u00a7lHorizontal Radius", cfg::getSafeSwapHorizontalRadius, value -> this.plugin.getConfig().set("safe_swap.horizontal_radius", value), 1, 5, 1, 32, "\u00a77Scan radius in blocks"));
        items.add(this.adjustItem(12, Material.LADDER, "\u00a76\u00a7lVertical Distance", cfg::getSafeSwapVerticalDistance, value -> this.plugin.getConfig().set("safe_swap.vertical_distance", value), 1, 5, 1, 32, "\u00a77Vertical search range"));
        items.add(this.clickItem(13, () -> this.icon(Material.MAGMA_BLOCK, "\u00a7c\u00a7lDangerous Blocks", List.of("\u00a77Edit blacklist")), ctxClick -> this.open(ctxClick.player(), MenuKey.DANGEROUS_BLOCKS, null, false)));
        items.add(this.cycleItem(19, Material.ICE, "\u00a76\u00a7lFreeze Mode", cfg::getFreezeMode, value -> {
            String next = switch (value.toUpperCase(Locale.ROOT)) {
                case "EFFECTS" -> "SPECTATOR";
                case "SPECTATOR" -> "LIMBO";
                case "LIMBO" -> "CAGE";
                default -> "EFFECTS";
            };
            this.plugin.getConfigManager().setFreezeMode(next);
            this.plugin.getGameManager().refreshFreezeMechanic();
            return next;
        }, List.of("\u00a77How inactive runners are handled", "\u00a7bEFFECTS \u00a77- heavy slowness", "\u00a7bSPECTATOR \u00a77- spectator mode", "\u00a7bLIMBO \u00a77- teleport to limbo", "\u00a7bCAGE \u00a77- trap in cage")));
        items.add(this.toggleItem(20, Material.REDSTONE_TORCH, "\u00a7e\u00a7lFreeze Mechanic", cfg::isFreezeMechanicEnabled, value -> {
            this.plugin.getConfig().set("freeze_mechanic.enabled", value);
            this.plugin.getGameManager().refreshFreezeMechanic();
        }, "\u00a77Force inactive runners near active one"));
        items.add(this.adjustItem(21, Material.CLOCK, "\u00a76\u00a7lFreeze Duration", cfg::getFreezeDurationTicks, value -> {
            this.plugin.getConfig().set("freeze_mechanic.duration_ticks", value);
            this.plugin.getGameManager().refreshFreezeMechanic();
        }, 20, 100, 20, 6000, "\u00a77Ticks freeze persists"));
        items.add(this.adjustItem(22, Material.REPEATER, "\u00a76\u00a7lCheck Interval", cfg::getFreezeCheckIntervalTicks, value -> {
            this.plugin.getConfig().set("freeze_mechanic.check_interval_ticks", value);
            this.plugin.getGameManager().refreshFreezeMechanic();
        }, 5, 20, 5, 200, "\u00a77Ticks between freeze checks"));
        items.add(this.adjustItem(23, Material.COMPASS, "\u00a76\u00a7lMax Distance", () -> (int)Math.round(cfg.getFreezeMaxDistance()), value -> {
            this.plugin.getConfig().set("freeze_mechanic.max_distance", value);
            this.plugin.getGameManager().refreshFreezeMechanic();
        }, 5, 20, 5, 256, "\u00a77Maximum distance before freeze"));
        items.add(this.toggleItem(30, Material.BARRIER, "\u00a7e\u00a7lCancel Movement", cfg::isCancelMovement, value -> this.plugin.getConfig().set("cancel.movement", value), "\u00a77Block inactive runner movement"));
        items.add(this.toggleItem(31, Material.STICK, "\u00a7e\u00a7lCancel Interactions", cfg::isCancelInteractions, value -> this.plugin.getConfig().set("cancel.interactions", value), "\u00a77Block inactive runner interactions"));
        items.add(this.toggleItem(32, Material.WHITE_BED, "\u00a7e\u00a7lSingle Player Sleep", cfg::isSinglePlayerSleepEnabled, value -> cfg.setSinglePlayerSleepEnabled((boolean)value), "\u00a77Only active runner must sleep"));
        items.add(this.toggleConfigItem(33, Material.RESPAWN_ANCHOR, "\u00a7e\u00a7lForce Global Spawn", "spawn.force_global", true, "\u00a77Override personal beds"));
        items.add(this.clickItem(34, () -> {
            Location spawn = this.plugin.getConfigManager().getSpawnLocation();
            String worldName = spawn.getWorld() != null ? spawn.getWorld().getName() : "unknown";
            return this.icon(Material.COMPASS, "\u00a7b\u00a7lSet Spawn", List.of("\u00a77World: \u00a7f" + worldName, String.format(Locale.ROOT, "\u00a77Coords: \u00a7f%.1f / %.1f / %.1f", spawn.getX(), spawn.getY(), spawn.getZ()), "", "\u00a7eClick to use your position"));
        }, ctxClick -> {
            this.plugin.getConfigManager().setGlobalSpawn(ctxClick.player().getLocation(), true);
            Msg.send(ctxClick.player(), "\u00a7aGlobal spawn updated to your current position.");
            ctxClick.reopen();
        }));
        items.add(this.clickItem(35, () -> {
            Location limbo = cfg.getLimboLocation();
            String world = limbo.getWorld() != null ? limbo.getWorld().getName() : "unknown";
            String coords = String.format(Locale.ROOT, "\u00a7f%.1f \u00a77/ \u00a7f%.1f \u00a77/ \u00a7f%.1f", limbo.getX(), limbo.getY(), limbo.getZ());
            return this.icon(Material.ENDER_PEARL, "\u00a7b\u00a7lSet Limbo Location", List.of("\u00a77World: \u00a7f" + world, "\u00a77Coords: " + coords, "", "\u00a7eClick to use your position"));
        }, ctxClick -> {
            Location loc = ctxClick.player().getLocation();
            this.plugin.getConfig().set("limbo.world", (Object)(loc.getWorld() != null ? loc.getWorld().getName() : "world"));
            this.plugin.getConfig().set("limbo.x", (Object)loc.getX());
            this.plugin.getConfig().set("limbo.y", (Object)loc.getY());
            this.plugin.getConfig().set("limbo.z", (Object)loc.getZ());
            this.plugin.saveConfig();
            Msg.send(ctxClick.player(), "\u00a7aLimbo location updated to your current position.");
            ctxClick.reopen();
        }));
        items.add(this.backButton(44, "\u00a77\u00a7lBack", MenuKey.SETTINGS_HOME, null, this::openSettingsMenu));
        return new MenuScreen("\u00a7c\u00a7lSafety & Freeze", 54, items);
    }

    private MenuScreen buildHunterSettings(MenuContext ctx) {
        ConfigManager cfg = this.plugin.getConfigManager();
        ArrayList<MenuItem> items = new ArrayList<MenuItem>();
        items.add(this.backButton(0, "\u00a77\u00a7lBack", MenuKey.SETTINGS_HOME, null, this::openSettingsMenu));
        items.add(this.toggleItem(10, Material.COMPASS, "\u00a7e\u00a7lTracker", cfg::isTrackerEnabled, value -> {
            cfg.setTrackerEnabled((boolean)value);
            if (this.plugin.getGameManager().isGameRunning()) {
                if (value.booleanValue()) {
                    this.plugin.getTrackerManager().startTracking();
                    this.plugin.getTrackerManager().updateAllHunterCompasses();
                } else {
                    this.plugin.getTrackerManager().stopTracking();
                }
            }
        }, "\u00a77Give hunters tracking compasses"));
        items.add(this.adjustItem(11, Material.REPEATER, "\u00a76\u00a7lUpdate Ticks", cfg::getTrackerUpdateTicks, value -> {
            this.plugin.getConfig().set("tracker.update_ticks", value);
            if (this.plugin.getGameManager().isGameRunning() && cfg.isTrackerEnabled()) {
                this.plugin.getTrackerManager().startTracking();
            }
        }, 5, 20, 1, 200, "\u00a77Compass update frequency"));
        items.add(this.toggleItem(12, Material.BLAZE_ROD, "\u00a7e\u00a7lCompass Jamming", cfg::isCompassJammingEnabled, value -> this.plugin.getConfig().set("tracker.compass_jamming.enabled", value), "\u00a77Scramble compass after swap"));
        items.add(this.adjustItem(13, Material.CLOCK, "\u00a76\u00a7lJam Duration", cfg::getCompassJamDuration, value -> this.plugin.getConfig().set("tracker.compass_jamming.duration_ticks", value), 20, 100, 20, 1200, "\u00a77Ticks compasses stay jammed"));
        items.add(this.adjustItem(14, Material.SPYGLASS, "\u00a76\u00a7lJam Distance", cfg::getCompassJamMaxDistance, value -> cfg.setCompassJamMaxDistance((int)value), 10, 50, 0, 5000, "\u00a77Maximum random offset"));
        items.add(this.clickItem(44, () -> this.icon(Material.BARRIER, "\u00a77\u00a7lBack", Collections.emptyList()), ctxClick -> this.open(ctxClick.player(), MenuKey.SETTINGS_HOME, null, false)));
        return new MenuScreen("\u00a7c\u00a7lHunter Tools", 27, items);
    }

    private MenuScreen buildPowerUpsRoot(MenuContext ctx) {
        ConfigManager cfg = this.plugin.getConfigManager();
        ArrayList<MenuItem> items = new ArrayList<MenuItem>();
        items.add(this.backButton(0, "\u00a77\u00a7lBack", MenuKey.SETTINGS_HOME, null, this::openSettingsMenu));
        items.add(this.toggleItem(11, Material.LIME_DYE, "\u00a7e\u00a7lPower-ups", cfg::isPowerUpsEnabled, value -> cfg.setPowerUpsEnabled((boolean)value), "\u00a77Enable random swap effects"));
        items.add(this.navigateItem(13, Material.SPLASH_POTION, "\u00a7a\u00a7lPositive Effects", MenuKey.POWERUPS_EFFECTS, "\u00a77Configure buffs", "positive"));
        items.add(this.navigateItem(15, Material.POISONOUS_POTATO, "\u00a7c\u00a7lNegative Effects", MenuKey.POWERUPS_EFFECTS, "\u00a77Configure debuffs", "negative"));
        items.add(this.navigateItem(22, Material.CLOCK, "\u00a76\u00a7lDurations & Levels", MenuKey.POWERUPS_DURATION, "\u00a77Modify duration range"));
        items.add(this.clickItem(44, () -> this.icon(Material.BARRIER, "\u00a77\u00a7lBack", Collections.emptyList()), ctxClick -> this.open(ctxClick.player(), MenuKey.SETTINGS_HOME, null, false)));
        return new MenuScreen("\u00a7d\u00a7lPower-ups", 27, items);
    }

    private MenuScreen buildPowerUpEffects(MenuContext ctx) {
        PotionEffectType[] effectTypes;
        boolean positive = "positive".equalsIgnoreCase(String.valueOf(ctx.request().data()));
        List<String> list = positive ? this.plugin.getConfigManager().getGoodPowerUps() : this.plugin.getConfigManager().getBadPowerUps();
        HashSet<String> enabled = new HashSet<String>();
        for (String id : list) {
            enabled.add(id.toUpperCase(Locale.ROOT));
        }
        ArrayList<MenuItem> items = new ArrayList<MenuItem>();
        items.add(this.backButton(0, "\u00a77\u00a7lBack", MenuKey.POWERUPS_ROOT, null, this::openPowerUpsMenu));
        int slot = 9;
        PotionEffectType[] potionEffectTypeArray = effectTypes = PotionEffectType.values();
        int n = effectTypes.length;
        int n2 = 0;
        while (n2 < n) {
            PotionEffectType type = potionEffectTypeArray[n2];
            if (type != null && type.getKey() != null) {
                String id = type.getKey().getKey().toUpperCase(Locale.ROOT);
                String prefix = positive ? "\u00a7a" : "\u00a7c";
                Material material = positive ? Material.HONEY_BOTTLE : Material.SPIDER_EYE;
                items.add(this.toggleItem(slot, material, prefix + id, () -> enabled.contains(id), value -> {
                    List editable;
                    List list = editable = positive ? this.plugin.getConfig().getStringList("power_ups.good_effects") : this.plugin.getConfig().getStringList("power_ups.bad_effects");
                    if (value.booleanValue() && !editable.contains(id)) {
                        editable.add(id);
                    }
                    if (!value.booleanValue()) {
                        editable.remove(id);
                    }
                    if (positive) {
                        this.plugin.getConfig().set("power_ups.good_effects", (Object)editable);
                    } else {
                        this.plugin.getConfig().set("power_ups.bad_effects", (Object)editable);
                    }
                    this.plugin.saveConfig();
                    Msg.send(ctx.player(), "\u00a7e" + id + ": " + (value != false ? "\u00a7aEnabled" : "\u00a7cDisabled"));
                }, "\u00a77Click to toggle"));
                if ((++slot + 1) % 9 == 0) {
                    slot += 2;
                }
                if (slot >= 54) break;
            }
            ++n2;
        }
        return new MenuScreen(positive ? "\u00a7a\u00a7lPositive Effects" : "\u00a7c\u00a7lNegative Effects", 54, items);
    }

    private MenuScreen buildPowerUpDurations(MenuContext ctx) {
        ConfigManager cfg = this.plugin.getConfigManager();
        ArrayList<MenuItem> items = new ArrayList<MenuItem>();
        items.add(this.backButton(0, "\u00a77\u00a7lBack", MenuKey.POWERUPS_ROOT, null, this::openPowerUpsMenu));
        items.add(this.adjustItem(12, Material.CLOCK, "\u00a76\u00a7lMin Duration", cfg::getPowerUpsMinSeconds, value -> cfg.setPowerUpsMinSeconds((int)value), 5, 20, 1, 1800, "\u00a77Seconds minimum"));
        items.add(this.adjustItem(14, Material.CLOCK, "\u00a76\u00a7lMax Duration", cfg::getPowerUpsMaxSeconds, value -> cfg.setPowerUpsMaxSeconds((int)value), 5, 20, 1, 3600, "\u00a77Seconds maximum"));
        items.add(this.adjustItem(21, Material.EXPERIENCE_BOTTLE, "\u00a76\u00a7lMin Level", cfg::getPowerUpsMinLevel, value -> cfg.setPowerUpsMinLevel((int)value), 1, 1, 1, 5, "\u00a77Potion amplifier minimum"));
        items.add(this.adjustItem(23, Material.EXPERIENCE_BOTTLE, "\u00a76\u00a7lMax Level", cfg::getPowerUpsMaxLevel, value -> cfg.setPowerUpsMaxLevel((int)value), 1, 1, 1, 5, "\u00a77Potion amplifier maximum"));
        return new MenuScreen("\u00a76\u00a7lDuration & Level", 45, items);
    }

    private MenuScreen buildDangerousBlocks(MenuContext ctx) {
        ArrayList<MenuItem> items = new ArrayList<MenuItem>();
        items.add(this.backButton(0, "\u00a77\u00a7lBack", MenuKey.SETTINGS_HOME, null, this::openSettingsMenu));
        HashSet<Material> blocks = new HashSet<Material>(this.plugin.getConfigManager().getDangerousBlocks());
        ArrayList<Material> sorted = new ArrayList<Material>(blocks);
        sorted.sort(Comparator.comparing(Enum::name));
        int slot = 9;
        for (Material material : sorted) {
            items.add(this.clickItem(slot, () -> this.icon(material, "\u00a7e" + material.name(), List.of("\u00a7cClick to remove")), ctxClick -> {
                Set<Material> set = this.plugin.getConfigManager().getDangerousBlocks();
                set.remove(material);
                ArrayList<String> updated = new ArrayList<String>();
                for (Material m : set) {
                    updated.add(m.name());
                }
                this.plugin.getConfig().set("safe_swap.dangerous_blocks", updated);
                this.plugin.saveConfig();
                Msg.send(ctxClick.player(), "\u00a7eRemoved \u00a7f" + material.name());
                ctxClick.reopen();
            }));
            if ((++slot + 1) % 9 != 0) continue;
            slot += 2;
        }
        items.add(this.clickItem(44, () -> this.icon(Material.EMERALD_BLOCK, "\u00a7a\u00a7lAdd Block", List.of("\u00a77Type block ID in chat")), ctxClick -> {
            this.plugin.getChatInputHandler().expectConfigListAdd(ctxClick.player(), "safe_swap.dangerous_blocks");
            ctxClick.player().closeInventory();
            Msg.send(ctxClick.player(), "\u00a7eType a block ID (or 'cancel').");
        }));
        return new MenuScreen("\u00a7c\u00a7lDangerous Blocks", 54, items);
    }

    private MenuScreen buildWorldBorder(MenuContext ctx) {
        ArrayList<MenuItem> items = new ArrayList<MenuItem>();
        items.add(this.backButton(0, "\u00a77\u00a7lBack", MenuKey.SETTINGS_HOME, null, this::openSettingsMenu));
        items.add(this.toggleConfigItem(10, Material.BARRIER, "\u00a7e\u00a7lWorld Border", "world_border.enabled", false, "\u00a77Enable shrinking border"));
        items.add(this.adjustConfigItem(12, Material.GRASS_BLOCK, "\u00a76\u00a7lInitial Size", "world_border.initial_size", 2000, 50, 100, 50, 100000, "\u00a77Blocks at start"));
        items.add(this.adjustConfigItem(14, Material.BEDROCK, "\u00a76\u00a7lFinal Size", "world_border.final_size", 100, 25, 100, 25, 5000, "\u00a77Blocks at end"));
        items.add(this.adjustConfigItem(16, Material.CLOCK, "\u00a76\u00a7lShrink Duration", "world_border.shrink_duration", 1800, 60, 300, 60, 21600, "\u00a77Seconds to shrink"));
        items.add(this.adjustConfigItem(20, Material.SPYGLASS, "\u00a76\u00a7lWarning Distance", "world_border.warning_distance", 50, 5, 25, 0, 5000, "\u00a77Blocks before warning"));
        items.add(this.adjustConfigItem(22, Material.BELL, "\u00a76\u00a7lWarning Interval (s)", "world_border.warning_interval", 300, 30, 60, 30, 3600, "\u00a77Seconds between alerts"));
        return new MenuScreen("\u00a74\u00a7lWorld Border", 45, items);
    }

    private MenuScreen buildBounty(MenuContext ctx) {
        ArrayList<MenuItem> items = new ArrayList<MenuItem>();
        items.add(this.backButton(0, "\u00a77\u00a7lBack", MenuKey.SETTINGS_HOME, null, this::openSettingsMenu));
        items.add(this.toggleItem(10, Material.GOLD_INGOT, "\u00a76\u00a7lBounty Enabled", () -> this.plugin.getConfig().getBoolean("bounty.enabled", false), value -> {
            this.plugin.getConfig().set("bounty.enabled", value);
            this.plugin.saveConfig();
            if (!value.booleanValue()) {
                this.plugin.getBountyManager().clearBounty();
            }
        }, "\u00a77Enable hunter bounty challenges"));
        items.add(this.adjustItem(12, Material.CLOCK, "\u00a76\u00a7lCooldown (s)", () -> this.plugin.getConfig().getInt("bounty.cooldown", 300), value -> this.plugin.getConfig().set("bounty.cooldown", (Object)Math.max(0, value)), 30, 60, 0, 3600, "\u00a77Minimum seconds between bounties"));
        items.add(this.adjustItem(14, Material.GLOWSTONE_DUST, "\u00a76\u00a7lGlow Duration (s)", () -> this.plugin.getConfig().getInt("bounty.glow_duration", 300), value -> this.plugin.getConfig().set("bounty.glow_duration", (Object)Math.max(10, value)), 30, 60, 10, 3600, "\u00a77Seconds the target glows"));
        items.add(this.adjustItem(21, Material.SUGAR, "\u00a76\u00a7lSpeed Reward (s)", () -> this.plugin.getConfig().getInt("bounty.rewards.speed_duration", 300), value -> this.plugin.getConfig().set("bounty.rewards.speed_duration", (Object)Math.max(10, value)), 30, 60, 10, 6000, "\u00a77Speed effect duration for killer"));
        items.add(this.adjustItem(23, Material.BLAZE_POWDER, "\u00a76\u00a7lStrength Reward (s)", () -> this.plugin.getConfig().getInt("bounty.rewards.strength_duration", 300), value -> this.plugin.getConfig().set("bounty.rewards.strength_duration", (Object)Math.max(10, value)), 30, 60, 10, 6000, "\u00a77Strength effect duration for killer"));
        items.add(this.clickItem(30, () -> this.icon(Material.TARGET, "\u00a7a\u00a7lAssign New Bounty", List.of("\u00a77Pick a new target")), ctxClick -> {
            this.plugin.getBountyManager().assignNewBounty();
            Msg.send(ctxClick.player(), "\u00a7aNew bounty assigned.");
        }));
        items.add(this.clickItem(32, () -> this.icon(Material.BARRIER, "\u00a7c\u00a7lClear Bounty", List.of("\u00a77Remove current target")), ctxClick -> {
            this.plugin.getBountyManager().clearBounty();
            Msg.send(ctxClick.player(), "\u00a7cBounty cleared.");
        }));
        return new MenuScreen("\u00a76\u00a7lBounty System", 45, items);
    }

    private MenuScreen buildLastStand(MenuContext ctx) {
        ConfigManager cfg = this.plugin.getConfigManager();
        ArrayList<MenuItem> items = new ArrayList<MenuItem>();
        items.add(this.backButton(0, "\u00a77\u00a7lBack", MenuKey.SETTINGS_HOME, null, this::openSettingsMenu));
        items.add(this.toggleItem(10, Material.TOTEM_OF_UNDYING, "\u00a76\u00a7lLast Stand", cfg::isLastStandEnabled, value -> this.plugin.getConfig().set("last_stand.enabled", value), "\u00a77Boost final runner"));
        items.add(this.adjustItem(12, Material.CLOCK, "\u00a76\u00a7lDuration", cfg::getLastStandDuration, value -> this.plugin.getConfig().set("last_stand.duration_ticks", value), 20, 100, 20, 6000, "\u00a77Ticks boost lasts"));
        items.add(this.adjustItem(14, Material.IRON_SWORD, "\u00a76\u00a7lStrength Level", cfg::getLastStandStrengthAmplifier, value -> this.plugin.getConfig().set("last_stand.strength_amplifier", value), 1, 1, 0, 5, "\u00a77Amplifier (level-1)"));
        items.add(this.adjustItem(16, Material.SUGAR, "\u00a76\u00a7lSpeed Level", cfg::getLastStandSpeedAmplifier, value -> this.plugin.getConfig().set("last_stand.speed_amplifier", value), 1, 1, 0, 5, "\u00a77Amplifier (level-1)"));
        return new MenuScreen("\u00a76\u00a7lLast Stand", 45, items);
    }

    private MenuScreen buildSuddenDeath(MenuContext ctx) {
        ArrayList<MenuItem> items = new ArrayList<MenuItem>();
        items.add(this.backButton(0, "\u00a77\u00a7lBack", MenuKey.SETTINGS_HOME, null, this::openSettingsMenu));
        items.add(this.toggleConfigItem(10, Material.DRAGON_HEAD, "\u00a74\u00a7lSudden Death", "sudden_death.enabled", false, "\u00a77Enable end dimension showdown"));
        items.add(this.adjustItem(12, Material.CLOCK, "\u00a76\u00a7lActivation Delay (s)", () -> this.plugin.getConfig().getInt("sudden_death.activation_delay", 1200), value -> this.plugin.getConfig().set("sudden_death.activation_delay", (Object)Math.max(30, value)), 60, 300, 30, 36000, "\u00a77Seconds before sudden death begins"));
        items.add(this.adjustItem(14, Material.SHIELD, "\u00a76\u00a7lResistance (s)", () -> (int)Math.round((double)this.plugin.getConfig().getInt("sudden_death.effects.resistance_duration", 200) / 20.0), value -> this.plugin.getConfig().set("sudden_death.effects.resistance_duration", (Object)(Math.max(1, value) * 20)), 5, 20, 1, 600, "\u00a77Duration of Resistance IV"));
        items.add(this.adjustItem(16, Material.GOLDEN_APPLE, "\u00a76\u00a7lRegeneration (s)", () -> (int)Math.round((double)this.plugin.getConfig().getInt("sudden_death.effects.regeneration_duration", 200) / 20.0), value -> this.plugin.getConfig().set("sudden_death.effects.regeneration_duration", (Object)(Math.max(1, value) * 20)), 5, 20, 1, 600, "\u00a77Duration of Regeneration III"));
        items.add(this.adjustItem(20, Material.SPYGLASS, "\u00a76\u00a7lMax Jam Distance", () -> this.plugin.getConfig().getInt("sudden_death.arena.max_jam_distance", 100), value -> this.plugin.getConfig().set("sudden_death.arena.max_jam_distance", (Object)Math.max(0, value)), 10, 50, 0, 10000, "\u00a77Blocks for random compass offsets"));
        items.add(this.clickItem(22, () -> {
            double x = this.plugin.getConfig().getDouble("sudden_death.arena.x", 100.0);
            double y = this.plugin.getConfig().getDouble("sudden_death.arena.y", 50.0);
            double z = this.plugin.getConfig().getDouble("sudden_death.arena.z", 0.0);
            String worldName = this.plugin.getConfig().getString("sudden_death.arena.world", "world_the_end");
            return this.icon(Material.ENDER_EYE, "\u00a7b\u00a7lSet Arena Location", List.of("\u00a77Current: \u00a7f" + x + ", " + y + ", " + z, "\u00a77World: \u00a7f" + worldName, "", "\u00a7eClick to use your position"));
        }, ctxClick -> {
            Location loc = ctxClick.player().getLocation();
            this.plugin.getConfig().set("sudden_death.arena.x", (Object)loc.getX());
            this.plugin.getConfig().set("sudden_death.arena.y", (Object)loc.getY());
            this.plugin.getConfig().set("sudden_death.arena.z", (Object)loc.getZ());
            this.plugin.getConfig().set("sudden_death.arena.world", (Object)(loc.getWorld() != null ? loc.getWorld().getName() : "world_the_end"));
            this.plugin.saveConfig();
            Msg.send(ctxClick.player(), "\u00a7aArena position updated.");
            ctxClick.reopen();
        }));
        items.add(this.clickItem(30, () -> this.icon(Material.CLOCK, "\u00a7e\u00a7lSchedule", List.of("\u00a77Start countdown")), ctxClick -> {
            this.plugin.getSuddenDeathManager().scheduleSuddenDeath();
            Msg.send(ctxClick.player(), "\u00a7eSudden death scheduled.");
        }));
        items.add(this.clickItem(32, () -> this.icon(Material.BARRIER, "\u00a7c\u00a7lCancel Schedule", Collections.emptyList()), ctxClick -> {
            this.plugin.getSuddenDeathManager().cancelSchedule();
            Msg.send(ctxClick.player(), "\u00a7cSchedule cancelled.");
        }));
        items.add(this.clickItem(34, () -> this.icon(Material.TNT, "\u00a74\u00a7lActivate Now", Collections.emptyList()), ctxClick -> {
            this.plugin.getSuddenDeathManager().activateSuddenDeath();
            Msg.send(ctxClick.player(), "\u00a74Sudden death activated!");
        }));
        return new MenuScreen("\u00a74\u00a7lSudden Death", 45, items);
    }

    private MenuScreen buildStatsRoot(MenuContext ctx) {
        StatsParent parent = this.statsParents.getOrDefault(ctx.player().getUniqueId(), StatsParent.SETTINGS);
        ArrayList<MenuItem> items = new ArrayList<MenuItem>();
        items.add(this.backButton(0, "\u00a77\u00a7lBack", parent == StatsParent.MAIN ? MenuKey.MAIN : MenuKey.SETTINGS_HOME, null, player -> {
            if (parent == StatsParent.MAIN) {
                this.open((Player)player, MenuKey.MAIN, null, false);
            } else {
                this.openSettingsMenu((Player)player);
            }
        }));
        items.add(this.toggleItem(11, Material.LIME_DYE, "\u00a7e\u00a7lStatistics", () -> this.plugin.getConfig().getBoolean("stats.enabled", true), value -> {
            this.plugin.getConfig().set("stats.enabled", value);
            this.plugin.saveConfig();
            if (!value.booleanValue()) {
                this.plugin.getStatsManager().stopTracking();
            } else if (this.plugin.getGameManager().isGameRunning()) {
                this.plugin.getStatsManager().startTracking();
            }
        }, "\u00a77Toggle server-side tracking"));
        items.add(this.toggleItem(13, Material.COMPASS, "\u00a76\u00a7lDistance Tracking", () -> this.plugin.getConfig().getBoolean("stats.distance_tracking", true), value -> {
            this.plugin.getConfig().set("stats.distance_tracking", value);
            this.plugin.saveConfig();
        }, "\u00a77Enable runner-hunter distance metric"));
        items.add(this.adjustItem(15, Material.REPEATER, "\u00a76\u00a7lDistance Update", () -> this.plugin.getConfig().getInt("stats.distance_update_ticks", 20), value -> {
            this.plugin.getConfig().set("stats.distance_update_ticks", value);
            this.plugin.saveConfig();
        }, 5, 20, 1, 200, "\u00a77Ticks between distance updates"));
        items.add(this.toggleConfigItem(17, Material.CLOCK, "\u00a7e\u00a7lPeriodic Display", "stats.periodic_display", false, "\u00a77Announce stats automatically"));
        items.add(this.adjustConfigItem(26, Material.CLOCK, "\u00a76\u00a7lDisplay Interval (s)", "stats.periodic_display_interval", 300, 30, 60, 30, 3600, "\u00a77Seconds between stat announcements"));
        items.add(this.clickItem(22, () -> this.icon(Material.PAPER, "\u00a7b\u00a7lBroadcast Snapshot", List.of("\u00a77Send stats to chat")), ctxClick -> this.plugin.getStatsManager().displayStats()));
        items.add(this.navigateItem(24, Material.SPYGLASS, "\u00a76\u00a7lAdvanced", MenuKey.STATS_ADVANCED, "\u00a77Additional settings"));
        return new MenuScreen("\u00a7b\u00a7lStatistics", 45, items);
    }

    private MenuScreen buildStatsAdvanced(MenuContext ctx) {
        ConfigManager cfg = this.plugin.getConfigManager();
        ArrayList<MenuItem> items = new ArrayList<MenuItem>();
        items.add(this.backButton(0, "\u00a77\u00a7lBack", MenuKey.STATS_ROOT, null, player -> this.open((Player)player, MenuKey.STATS_ROOT, null, false)));
        items.add(this.adjustItem(11, Material.CLOCK, "\u00a76\u00a7lActionbar Update", cfg::getActionBarUpdateTicks, value -> this.plugin.getConfig().set("ui.update_ticks.actionbar", value), 5, 20, 1, 200, "\u00a77Ticks between actionbar refresh"));
        items.add(this.adjustItem(13, Material.EXPERIENCE_BOTTLE, "\u00a76\u00a7lTitle Update", cfg::getTitleUpdateTicks, value -> this.plugin.getConfig().set("ui.update_ticks.title", value), 1, 5, 1, 200, "\u00a77Ticks between title refresh"));
        items.add(this.adjustItem(15, Material.COMPASS, "\u00a76\u00a7lTracker Update", cfg::getTrackerUpdateTicks, value -> this.plugin.getConfig().set("tracker.update_ticks", value), 5, 20, 1, 200, "\u00a77Compass refresh interval"));
        items.add(this.cycleItem(20, Material.CLOCK, "\u00a76\u00a7lRunner Timer", cfg::getRunnerTimerVisibility, current -> {
            String next = this.nextVisibility((String)current);
            cfg.setRunnerTimerVisibility(next);
            return next;
        }, this.timerLore("Active runner")));
        items.add(this.cycleItem(22, Material.CLOCK, "\u00a76\u00a7lWaiting Timer", cfg::getWaitingTimerVisibility, current -> {
            String next = this.nextVisibility((String)current);
            cfg.setWaitingTimerVisibility(next);
            return next;
        }, this.timerLore("Waiting runners")));
        items.add(this.cycleItem(24, Material.CLOCK, "\u00a76\u00a7lHunter Timer", cfg::getHunterTimerVisibility, current -> {
            String next = this.nextVisibility((String)current);
            cfg.setHunterTimerVisibility(next);
            return next;
        }, this.timerLore("Hunters")));
        return new MenuScreen("\u00a7b\u00a7lStats - Advanced", 45, items);
    }

    private MenuScreen buildTaskHome(MenuContext ctx) {
        TaskManagerMode mode = this.plugin.getTaskManagerMode();
        int assignments = mode != null ? mode.getAssignments().size() : 0;
        ArrayList<MenuItem> items = new ArrayList<MenuItem>();
        items.add(this.backButton(0, "\u00a77\u00a7lBack", MenuKey.MAIN, null, this::openMainMenu));
        items.add(this.navigateItem(10, Material.WRITABLE_BOOK, "\u00a76\u00a7lCompetition Rules", MenuKey.SETTINGS_TASK, "\u00a77Pause behaviour, grace timers"));
        items.add(this.navigateItem(12, Material.EMERALD, "\u00a7a\u00a7lCustom Tasks", MenuKey.TASK_CUSTOM, "\u00a77Manage custom entries"));
        items.add(this.clickItem(14, () -> this.icon(Material.FEATHER, "\u00a7b\u00a7lReroll Tasks", List.of("\u00a77Assign new secret tasks")), ctxClick -> {
            if (this.plugin.getGameManager().isGameRunning()) {
                Msg.send(ctxClick.player(), "\u00a7cStop the game before rerolling tasks.");
                return;
            }
            if (mode != null) {
                mode.assignAndAnnounceTasks(this.plugin.getGameManager().getRunners());
                Msg.send(ctxClick.player(), "\u00a7aTasks rerolled for current runners.");
            }
        }));
        items.add(this.navigateItem(16, Material.PAPER, "\u00a7e\u00a7lCurrent Assignments", MenuKey.TASK_ASSIGNMENTS, "\u00a77Active runner tasks", assignments));
        items.add(this.navigateItem(18, Material.BOOKSHELF, "\u00a76\u00a7lTask Pool", MenuKey.TASK_POOL, "\u00a77Enable/disable individual tasks", 0));
        return new MenuScreen("\u00a76\u00a7lTask Master", 36, items);
    }

    private MenuScreen buildTaskSettings(MenuContext ctx) {
        ArrayList<MenuItem> items = new ArrayList<MenuItem>();
        items.add(this.backButton(0, "\u00a77\u00a7lBack", MenuKey.TASK_HOME, null, this::openTaskManagerMenu));
        items.add(this.toggleConfigItem(10, Material.REDSTONE_TORCH, "\u00a7e\u00a7lPause on Disconnect", "task_manager.pause_on_disconnect", true, "\u00a77Pause when active runner disconnects"));
        items.add(this.toggleConfigItem(11, Material.BARRIER, "\u00a7e\u00a7lRemove On Timeout", "task_manager.remove_on_timeout", true, "\u00a77Drop players who exceed rejoin grace"));
        items.add(this.toggleConfigItem(12, Material.HOPPER, "\u00a7e\u00a7lAllow Late Joiners", "task_manager.allow_late_joiners", false, "\u00a77Permit players to join mid-game"));
        items.add(this.toggleConfigItem(13, Material.BOOK, "\u00a7e\u00a7lInclude Default Tasks", "task_manager.include_default_tasks", true, "\u00a77Keep built-in objectives in the pool"));
        items.add(this.adjustConfigItem(14, Material.CLOCK, "\u00a76\u00a7lRejoin Grace (s)", "task_manager.rejoin_grace_seconds", 180, 10, 30, 10, 3600, "\u00a77Seconds allowed to reconnect"));
        items.add(this.adjustConfigItem(15, Material.CLOCK, "\u00a76\u00a7lMax Game Length (min)", "task_manager.max_game_duration", 0, 5, 15, 0, 360, "\u00a770 = unlimited duration"));
        items.add(this.toggleConfigItem(16, Material.NAME_TAG, "\u00a7e\u00a7lEnd When One Left", "task_manager.end_when_one_left", false, "\u00a77Automatically finish when one runner remains"));
        return new MenuScreen("\u00a76\u00a7lTask Settings", 36, items);
    }

    private MenuScreen buildTaskCustom(MenuContext ctx) {
        TaskManagerMode mode = this.plugin.getTaskManagerMode();
        ArrayList<MenuItem> items = new ArrayList<MenuItem>();
        items.add(this.backButton(0, "\u00a77\u00a7lBack", MenuKey.TASK_HOME, null, this::openTaskManagerMenu));
        items.add(this.simpleItem(2, () -> this.icon(Material.BOOK, "\u00a77Default Pool", List.of("\u00a77Included: " + (this.plugin.getConfig().getBoolean("task_manager.include_default_tasks", true) ? "\u00a7aYes" : "\u00a7cNo"), "\u00a77Toggle in Task Settings"))));
        items.add(this.clickItem(8, () -> this.icon(Material.EMERALD_BLOCK, "\u00a7a\u00a7lAdd Custom Task", List.of("\u00a77Enter ID via chat")), ctxClick -> {
            this.plugin.getChatInputHandler().expectTaskId(ctxClick.player());
            ctxClick.player().closeInventory();
            Msg.send(ctxClick.player(), "\u00a7eEnter a unique task ID in chat.");
        }));
        if (mode != null) {
            List<String> ids = mode.getCustomTaskIds();
            int slot = 9;
            for (String id : ids) {
                TaskDefinition def = mode.getTask(id);
                String description = def != null ? def.description() : "";
                items.add(this.clickItem(slot, () -> this.icon(Material.PAPER, "\u00a7e" + id, List.of("\u00a77" + description, "", "\u00a7cClick to remove")), ctxClick -> {
                    if (mode.removeCustomTask(id)) {
                        Msg.send(ctxClick.player(), "\u00a7cRemoved custom task \u00a7f" + id);
                    }
                    ctxClick.reopen();
                }));
                if ((++slot + 1) % 9 == 0) {
                    slot += 2;
                }
                if (slot >= 54) break;
            }
        }
        return new MenuScreen("\u00a76\u00a7lCustom Tasks", 54, items);
    }

    private MenuScreen buildTaskPool(MenuContext ctx) {
        ArrayList<MenuItem> items = new ArrayList<MenuItem>();
        items.add(this.backButton(0, "\u00a77\u00a7lBack", MenuKey.TASK_HOME, null, this::openTaskManagerMenu));
        TaskManagerMode mode = this.plugin.getTaskManagerMode();
        if (mode == null) {
            items.add(this.simpleItem(22, () -> this.icon(Material.BARRIER, "\u00a7cTask Manager unavailable", List.of("\u00a77Task mode not initialised."))));
            return new MenuScreen("\u00a76\u00a7lTask Pool", 54, items);
        }
        TaskDefinition[] defs = (TaskDefinition[])mode.getAllDefinitions().values().toArray(TaskDefinition[]::new);
        Arrays.sort(defs, Comparator.comparing(TaskDefinition::id, String.CASE_INSENSITIVE_ORDER));
        int perPage = 36;
        int totalPages = Math.max(1, (int)Math.ceil((double)defs.length / (double)perPage));
        int pageIndex = 0;
        Object object = ctx.request().data();
        if (object instanceof Integer) {
            Integer p = (Integer)object;
            pageIndex = Math.max(0, Math.min(p, totalPages - 1));
        }
        int page = pageIndex;
        items.add(this.cycleItem(2, Material.NETHERITE_SWORD, "\u00a76\u00a7lDifficulty", () -> mode.getDifficultyFilter().name(), current -> {
            TaskDifficulty cur = mode.getDifficultyFilter();
            TaskDifficulty next = switch (cur) {
                case TaskDifficulty.EASY -> TaskDifficulty.MEDIUM;
                case TaskDifficulty.MEDIUM -> TaskDifficulty.HARD;
                case TaskDifficulty.HARD -> TaskDifficulty.EASY;
                default -> throw new IncompatibleClassChangeError();
            };
            mode.setDifficultyFilter(next);
            return next.name();
        }, List.of("\u00a77Filter used when assigning", "\u00a77Cycles EASY \u2192 MEDIUM \u2192 HARD")));
        items.add(this.simpleItem(4, () -> this.icon(Material.PAPER, "\u00a77Eligible Tasks", List.of("\u00a7a" + mode.getCandidateCount() + " \u00a77available for selection"))));
        items.add(this.clickItem(6, () -> this.icon(Material.ENDER_CHEST, "\u00a7e\u00a7lReload tasks.yml", List.of("\u00a77Re-read task definitions")), ctxClick -> {
            mode.reloadTasksFromFile();
            Msg.send(ctxClick.player(), "\u00a7aReloaded tasks.yml.");
            this.open(ctxClick.player(), MenuKey.TASK_POOL, page, true);
        }));
        int start = page * perPage;
        int end = Math.min(defs.length, start + perPage);
        int i = start;
        while (i < end) {
            TaskDefinition def = defs[i];
            int displayIndex = i - start;
            int row = displayIndex / 9;
            int col = displayIndex % 9;
            int slot = 9 + row * 9 + col;
            String id = def.id();
            TaskDefinition current2 = mode.getTask(id);
            boolean enabled = current2 == null || current2.enabled();
            Material mat = enabled ? Material.WRITABLE_BOOK : Material.GRAY_DYE;
            ArrayList<Object> lore = new ArrayList<Object>();
            lore.add("\u00a77" + Optional.ofNullable(def.description()).orElse("No description"));
            lore.add("\u00a77Difficulty: \u00a7f" + (def.difficulty() != null ? def.difficulty().name() : "MEDIUM"));
            if (def.categories() != null && !def.categories().isEmpty()) {
                lore.add("\u00a77Tags: \u00a7f" + String.join((CharSequence)", ", def.categories()));
            }
            lore.add("");
            lore.add(enabled ? "\u00a7aEnabled" : "\u00a7cDisabled");
            lore.add("\u00a77Click to toggle");
            items.add(this.clickItem(slot, () -> this.icon(mat, (enabled ? "\u00a7a" : "\u00a7c") + id, lore), ctxClick -> {
                TaskDefinition cur = mode.getTask(id);
                boolean next = cur == null || !cur.enabled();
                mode.setTaskEnabled(id, next);
                Msg.send(ctxClick.player(), "\u00a7eTask \u00a7f" + id + "\u00a7e is now " + (next ? "\u00a7aenabled" : "\u00a7cdisabled"));
                this.open(ctxClick.player(), MenuKey.TASK_POOL, page, true);
            }));
            ++i;
        }
        if (page > 0) {
            items.add(this.clickItem(45, () -> this.icon(Material.ARROW, "\u00a77\u00a7lPrevious Page", List.of("\u00a77Page " + page + " of " + totalPages)), ctxClick -> this.open(ctxClick.player(), MenuKey.TASK_POOL, page - 1, false)));
        }
        if (page < totalPages - 1) {
            items.add(this.clickItem(53, () -> this.icon(Material.ARROW, "\u00a77\u00a7lNext Page", List.of("\u00a77Page " + (page + 2) + " of " + totalPages)), ctxClick -> this.open(ctxClick.player(), MenuKey.TASK_POOL, page + 1, false)));
        }
        items.add(this.simpleItem(49, () -> this.icon(Material.NAME_TAG, "\u00a77Page Info", List.of("\u00a77Page \u00a7f" + (page + 1) + "\u00a77 of \u00a7f" + totalPages, "\u00a77Tasks total: \u00a7f" + defs.length))));
        return new MenuScreen("\u00a76\u00a7lTask Pool", 54, items);
    }

    private MenuItem buildParticleTypeCycler(int slot) {
        return this.cycleItem(slot, Material.FIREWORK_STAR, "\u00a76\u00a7lParticle Type", this.plugin.getConfigManager()::getParticleTrailType, current -> {
            int idx = PARTICLE_TYPES.indexOf(current == null ? "" : current.toUpperCase(Locale.ROOT));
            int nextIndex = (idx + 1) % PARTICLE_TYPES.size();
            String type = PARTICLE_TYPES.get(nextIndex);
            this.plugin.getConfig().set("particle_trail.type", (Object)type);
            return type;
        }, List.of("\u00a77Cycle between allowed particle IDs"));
    }

    private MenuScreen buildTaskAssignments(MenuContext ctx) {
        TaskManagerMode mode = this.plugin.getTaskManagerMode();
        ArrayList<MenuItem> items = new ArrayList<MenuItem>();
        items.add(this.backButton(0, "\u00a77\u00a7lBack", MenuKey.TASK_HOME, null, this::openTaskManagerMenu));
        if (mode != null) {
            int slot = 9;
            for (Map.Entry<UUID, String> entry : mode.getAssignments().entrySet()) {
                UUID uuid = entry.getKey();
                String taskId = entry.getValue();
                String name = Optional.ofNullable(Bukkit.getOfflinePlayer((UUID)uuid).getName()).orElse(uuid.toString().substring(0, 8));
                TaskDefinition def = mode.getTask(taskId);
                String desc = def != null ? def.description() : "Unknown task";
                items.add(this.simpleItem(slot, () -> this.icon(Material.PAPER, "\u00a7e" + name, List.of("\u00a77Task: \u00a7f" + taskId, "\u00a77" + desc))));
                if ((++slot + 1) % 9 == 0) {
                    slot += 2;
                }
                if (slot >= 54) break;
            }
        }
        return new MenuScreen("\u00a76\u00a7lTask Assignments", 54, items);
    }

    private MenuScreen buildVoiceChat(MenuContext ctx) {
        ArrayList<MenuItem> items = new ArrayList<MenuItem>();
        items.add(this.backButton(0, "\u00a77\u00a7lBack", MenuKey.SETTINGS_HOME, null, this::openSettingsMenu));
        items.add(this.toggleConfigItem(11, Material.NOTE_BLOCK, "\u00a7e\u00a7lVoice Chat Integration", "voice_chat.enabled", false, "\u00a77Integrate with Simple Voice Chat"));
        items.add(this.toggleConfigItem(13, Material.LEVER, "\u00a7e\u00a7lMute Inactive Runners", "voice_chat.mute_inactive_runners", true, "\u00a77Automatically mute inactive players"));
        return new MenuScreen("\u00a7d\u00a7lVoice Chat", 27, items);
    }

    private MenuScreen buildBroadcast(MenuContext ctx) {
        ArrayList<MenuItem> items = new ArrayList<MenuItem>();
        items.add(this.backButton(0, "\u00a77\u00a7lBack", MenuKey.SETTINGS_HOME, null, this::openSettingsMenu));
        items.add(this.toggleConfigItem(11, Material.BELL, "\u00a7e\u00a7lBroadcasts", "broadcasts.enabled", true, "\u00a77Enable general announcements"));
        items.add(this.toggleConfigItem(13, Material.MAP, "\u00a7e\u00a7lGame Events", "broadcasts.game_events", true, "\u00a77Announce start/stop"));
        items.add(this.toggleConfigItem(15, Material.PAPER, "\u00a7e\u00a7lTeam Changes", "broadcasts.team_changes", true, "\u00a77Announce team assignment changes"));
        return new MenuScreen("\u00a7e\u00a7lBroadcast Settings", 27, items);
    }

    private MenuScreen buildUiSettings(MenuContext ctx) {
        ConfigManager cfg = this.plugin.getConfigManager();
        ArrayList<MenuItem> items = new ArrayList<MenuItem>();
        items.add(this.backButton(0, "\u00a77\u00a7lBack", MenuKey.SETTINGS_HOME, null, this::openSettingsMenu));
        items.add(this.adjustItem(11, Material.CLOCK, "\u00a76\u00a7lActionbar Update", cfg::getActionBarUpdateTicks, value -> this.plugin.getConfig().set("ui.update_ticks.actionbar", value), 5, 20, 1, 200, "\u00a77Ticks between actionbar updates"));
        items.add(this.adjustItem(13, Material.EXPERIENCE_BOTTLE, "\u00a76\u00a7lTitle Update", cfg::getTitleUpdateTicks, value -> this.plugin.getConfig().set("ui.update_ticks.title", value), 1, 5, 1, 200, "\u00a77Ticks between title updates"));
        items.add(this.cycleItem(20, Material.CLOCK, "\u00a76\u00a7lRunner Timer", cfg::getRunnerTimerVisibility, current -> {
            String next = this.nextVisibility((String)current);
            cfg.setRunnerTimerVisibility(next);
            return next;
        }, this.timerLore("Active runner visibility")));
        items.add(this.cycleItem(22, Material.CLOCK, "\u00a76\u00a7lWaiting Timer", cfg::getWaitingTimerVisibility, current -> {
            String next = this.nextVisibility((String)current);
            cfg.setWaitingTimerVisibility(next);
            return next;
        }, this.timerLore("Waiting runner visibility")));
        items.add(this.cycleItem(24, Material.CLOCK, "\u00a76\u00a7lHunter Timer", cfg::getHunterTimerVisibility, current -> {
            String next = this.nextVisibility((String)current);
            cfg.setHunterTimerVisibility(next);
            return next;
        }, this.timerLore("Hunter visibility")));
        items.add(this.toggleItem(29, Material.BLAZE_POWDER, "\u00a7e\u00a7lParticle Trail", this.plugin.getConfigManager()::isParticleTrailEnabled, value -> this.plugin.getConfig().set("particle_trail.enabled", value), "\u00a77Toggle runner particle trail"));
        items.add(this.adjustItem(31, Material.REDSTONE, "\u00a76\u00a7lSpawn Interval", this.plugin.getConfigManager()::getParticleSpawnInterval, value -> this.plugin.getConfig().set("particle_trail.spawn_interval", (Object)Math.max(1, value)), 1, 5, 1, 200, "\u00a77Ticks between trail spawns"));
        items.add(this.buildParticleTypeCycler(33));
        items.add(this.adjustItem(39, Material.RED_DYE, "\u00a7cRed Channel", () -> this.plugin.getConfigManager().getParticleTrailColor()[0], value -> this.updateParticleColorChannel(0, (int)value), 5, 20, 0, 255, "\u00a77Adjust red intensity"));
        items.add(this.adjustItem(40, Material.GREEN_DYE, "\u00a7aGreen Channel", () -> this.plugin.getConfigManager().getParticleTrailColor()[1], value -> this.updateParticleColorChannel(1, (int)value), 5, 20, 0, 255, "\u00a77Adjust green intensity"));
        items.add(this.adjustItem(41, Material.LAPIS_LAZULI, "\u00a79Blue Channel", () -> this.plugin.getConfigManager().getParticleTrailColor()[2], value -> this.updateParticleColorChannel(2, (int)value), 5, 20, 0, 255, "\u00a77Adjust blue intensity"));
        return new MenuScreen("\u00a7b\u00a7lUI & Timers", 45, items);
    }

    private MenuScreen buildKitManager(MenuContext ctx) {
        ArrayList<MenuItem> items = new ArrayList<MenuItem>();
        items.add(this.backButton(0, "\u00a77\u00a7lBack", MenuKey.SETTINGS_HOME, null, this::openSettingsMenu));
        items.add(this.toggleItem(11, Material.CHEST, "\u00a7e\u00a7lKits Enabled", this.plugin.getConfigManager()::isKitsEnabled, value -> this.plugin.getConfigManager().setKitsEnabled((boolean)value), "\u00a77Toggle kit distribution on start"));
        items.add(this.clickItem(13, () -> this.icon(Material.DIAMOND_SWORD, "\u00a7a\u00a7lGive Runner Kit", List.of("\u00a77Equip configured runner kit")), ctxClick -> this.plugin.getKitManager().applyRunnerKit(ctxClick.player())));
        items.add(this.clickItem(15, () -> this.icon(Material.IRON_SWORD, "\u00a7c\u00a7lGive Hunter Kit", List.of("\u00a77Equip configured hunter kit")), ctxClick -> this.plugin.getKitManager().applyHunterKit(ctxClick.player())));
        items.add(this.simpleItem(31, () -> this.icon(Material.PAPER, "\u00a77Editing Kits", List.of("\u00a77Edit contents in kits.yml", "\u00a77or use /swap kits commands"))));
        return new MenuScreen("\u00a7a\u00a7lKit Manager", 36, items);
    }

    private MenuItem simpleItem(int slot, Supplier<ItemStack> icon) {
        return new MenuItem("static-" + slot, slot, ctx -> (ItemStack)icon.get(), null);
    }

    private MenuItem clickItem(int slot, Supplier<ItemStack> icon, Consumer<MenuClickContext> action) {
        return new MenuItem("click-" + slot + "-" + String.valueOf(UUID.randomUUID()), slot, ctx -> (ItemStack)icon.get(), action);
    }

    private MenuItem backButton(int slot, String label, MenuKey target, Object data, Consumer<Player> handler) {
        return this.clickItem(slot, () -> this.icon(Material.ARROW, label, List.of("\u00a77Go back")), ctx -> {
            if (handler != null) {
                handler.accept(ctx.player());
            } else {
                this.openPrevious(ctx.player());
            }
        });
    }

    private MenuItem navigateItem(int slot, Material material, String name, MenuKey target, String description) {
        return this.navigateItem(slot, material, name, target, description, null);
    }

    private MenuItem navigateItem(int slot, Material material, String name, MenuKey target, String description, Object data) {
        return this.clickItem(slot, () -> this.icon(material, name, List.of("\u00a77" + description)), ctx -> this.open(ctx.player(), target, data, false));
    }

    private MenuItem toggleItem(int slot, Material material, String label, BooleanSupplier getter, Consumer<Boolean> setter, String description) {
        return this.clickItem(slot, () -> {
            boolean enabled = getter.getAsBoolean();
            String status = enabled ? "\u00a7aEnabled" : "\u00a7cDisabled";
            return this.icon(material, label + ": " + status, description == null ? List.of("\u00a77Click to toggle") : List.of("\u00a77" + description, "\u00a77Click to toggle"));
        }, ctx -> {
            boolean next = !getter.getAsBoolean();
            setter.accept(next);
            this.plugin.saveConfig();
            Msg.send(ctx.player(), "\u00a7e" + label.replace("\u00a7", "") + ": " + (next ? "\u00a7aEnabled" : "\u00a7cDisabled"));
            ctx.reopen();
        });
    }

    private MenuItem toggleConfigItem(int slot, Material material, String label, String path, boolean def, String description) {
        return this.toggleItem(slot, material, label, () -> this.plugin.getConfig().getBoolean(path, def), value -> this.plugin.getConfig().set(path, value), description);
    }

    private MenuItem adjustItem(int slot, Material material, String label, IntSupplier getter, Consumer<Integer> setter, int step, int shiftStep, int min, int max, String description) {
        return this.clickItem(slot, () -> this.icon(material, label + " \u00a7f" + getter.getAsInt(), List.of("\u00a77" + description, "\u00a77Left/right: \u00b1" + step, "\u00a77Shift: \u00b1" + shiftStep)), ctx -> {
            int delta;
            int value = getter.getAsInt();
            int n5 = delta = ctx.shift() ? shiftStep : step;
            if (ctx.click() == ClickType.LEFT) {
                value += delta;
            } else if (ctx.click() == ClickType.RIGHT) {
                value -= delta;
            }
            value = Math.max(min, Math.min(max, value));
            setter.accept(value);
            this.plugin.saveConfig();
            Msg.send(ctx.player(), "\u00a7e" + label.replace("\u00a7", "") + ": \u00a7f" + value);
            ctx.reopen();
        });
    }

    private MenuItem adjustConfigItem(int slot, Material material, String label, String path, int def, int step, int shiftStep, int min, int max, String description) {
        return this.adjustItem(slot, material, label, () -> this.plugin.getConfig().getInt(path, def), value -> this.plugin.getConfig().set(path, value), step, shiftStep, min, max, description);
    }

    private void updateParticleColorChannel(int channel, int value) {
        int clamped;
        int[] rgb = this.plugin.getConfigManager().getParticleTrailColor();
        if (channel < 0 || channel >= rgb.length) {
            return;
        }
        rgb[channel] = clamped = Math.max(0, Math.min(255, value));
        this.plugin.getConfig().set("particle_trail.color", Arrays.asList(rgb[0], rgb[1], rgb[2]));
    }

    private MenuItem cycleItem(int slot, Material material, String label, Supplier<String> getter, Function<String, String> cycler, List<String> description) {
        return this.clickItem(slot, () -> this.icon(material, label + ": \u00a7f" + (String)getter.get(), description), ctx -> {
            String next = (String)cycler.apply((String)getter.get());
            this.plugin.saveConfig();
            Msg.send(ctx.player(), "\u00a7e" + label.replace("\u00a7", "") + ": \u00a7f" + next);
            ctx.reopen();
        });
    }

    private String nextVisibility(String current) {
        if (current == null) {
            return "always";
        }
        return switch (current.toLowerCase(Locale.ROOT)) {
            case "always" -> "last_10";
            case "last_10" -> "never";
            default -> "always";
        };
    }

    private List<String> timerLore(String title) {
        return List.of("\u00a77Visibility: always, last_10, never", "\u00a77Currently adjusting: \u00a7f" + title);
    }

    private ItemStack icon(Material material, String name, List<String> lore) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        GuiCompat.setDisplayName(meta, name);
        if (lore != null && !lore.isEmpty()) {
            GuiCompat.setLore(meta, lore);
        }
        item.setItemMeta(meta);
        return item;
    }

    private static interface MenuBuilder {
        public MenuScreen build(MenuContext var1);
    }

    private static final class MenuClickContext
    extends MenuContext {
        private final boolean shift;
        private final ClickType click;

        MenuClickContext(GuiManager manager, Player player, MenuRequest request, boolean shift, ClickType click) {
            super(manager, player, request);
            this.shift = shift;
            this.click = click;
        }

        public boolean shift() {
            return this.shift;
        }

        public ClickType click() {
            return this.click;
        }

        public void reopen() {
            this.manager().reopen(this.player());
        }
    }

    private static class MenuContext {
        private final GuiManager manager;
        private final Player player;
        private final MenuRequest request;

        MenuContext(GuiManager manager, Player player, MenuRequest request) {
            this.manager = manager;
            this.player = player;
            this.request = request;
        }

        public GuiManager manager() {
            return this.manager;
        }

        public Player player() {
            return this.player;
        }

        public MenuRequest request() {
            return this.request;
        }
    }

    private record MenuItem(String id, int slot, Function<MenuContext, ItemStack> icon, Consumer<MenuClickContext> action) {
    }

    private static enum MenuKey {
        MAIN,
        MODE_SELECT,
        MODE_SELECT_DIRECT,
        TEAM_MANAGEMENT,
        SETTINGS_HOME,
        SETTINGS_SWAP,
        SETTINGS_SAFETY,
        SETTINGS_HUNTER,
        POWERUPS_ROOT,
        POWERUPS_EFFECTS,
        POWERUPS_DURATION,
        DANGEROUS_BLOCKS,
        SETTINGS_WORLD_BORDER,
        SETTINGS_BOUNTY,
        SETTINGS_LAST_STAND,
        SETTINGS_SUDDEN_DEATH,
        SETTINGS_TASK,
        TASK_HOME,
        TASK_CUSTOM,
        TASK_POOL,
        TASK_ASSIGNMENTS,
        STATS_ROOT,
        STATS_ADVANCED,
        SETTINGS_VOICE_CHAT,
        SETTINGS_BROADCAST,
        SETTINGS_UI,
        KIT_MANAGER;

    }

    private record MenuRequest(MenuKey key, Object data) {
    }

    private record MenuScreen(String title, int size, List<MenuItem> items) {
        MenuItem button(String id) {
            for (MenuItem item : this.items) {
                if (!item.id().equals(id)) continue;
                return item;
            }
            return null;
        }
    }

    private record MenuSession(MenuRequest request, MenuScreen screen, Inventory inventory) {
    }

    public static enum StatsParent {
        MAIN,
        SETTINGS;

    }
}

