/*
 * Decompiled with CFR 0.152.
 */
package com.example.speedrunnerswap.utils;

import java.time.Duration;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.title.Title;
import org.bukkit.entity.Player;

public final class ChatTitleCompat {
    private ChatTitleCompat() {
    }

    public static void showTitle(Player player, String title, String subtitle, long fadeInMs, long stayMs, long fadeOutMs) {
        try {
            Title t = Title.title((Component)((TextComponent)Component.text((String)title).color((TextColor)NamedTextColor.GOLD)).decorate(TextDecoration.BOLD), (Component)Component.text((String)subtitle).color((TextColor)NamedTextColor.YELLOW), (Title.Times)Title.Times.times((Duration)Duration.ofMillis(fadeInMs), (Duration)Duration.ofMillis(stayMs), (Duration)Duration.ofMillis(fadeOutMs)));
            player.showTitle(t);
        }
        catch (Throwable ignored) {
            ChatTitleCompat.sendDeprecatedTitle(player, title, subtitle, fadeInMs, stayMs, fadeOutMs);
        }
    }

    private static void sendDeprecatedTitle(Player player, String title, String subtitle, long fadeInMs, long stayMs, long fadeOutMs) {
        player.sendTitle(title, subtitle, (int)(fadeInMs / 50L), (int)(stayMs / 50L), (int)(fadeOutMs / 50L));
    }

    public static void sendMessage(Player player, String message) {
        try {
            player.sendMessage((Component)Component.text((String)message));
        }
        catch (Throwable ignored) {
            player.sendMessage(message);
        }
    }

    public static void sendClickableUrl(Player player, String prefix, String url) {
        try {
            Component msg = Component.text((String)prefix).append(((TextComponent)Component.text((String)url, (TextColor)NamedTextColor.LIGHT_PURPLE, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Open donation page", (TextColor)NamedTextColor.GOLD)))).clickEvent(ClickEvent.openUrl((String)url)));
            player.sendMessage(msg);
        }
        catch (Throwable ignored) {
            player.sendMessage(prefix + url);
        }
    }
}

