/*
 * Decompiled with CFR 0.152.
 */
package com.example.speedrunnerswap.gui;

import com.example.speedrunnerswap.SpeedrunnerSwap;
import com.example.speedrunnerswap.gui.ControlGui;
import com.example.speedrunnerswap.gui.ControlGuiHolder;
import com.example.speedrunnerswap.utils.GuiCompat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class ControlGuiListener
implements Listener {
    private final SpeedrunnerSwap plugin;
    private final Map<UUID, Set<String>> pendingRunnerSelections = new HashMap<UUID, Set<String>>();

    public ControlGuiListener(SpeedrunnerSwap plugin) {
        this.plugin = plugin;
    }

    private boolean isMain(Inventory inv) {
        ControlGuiHolder holder;
        InventoryHolder inventoryHolder;
        return inv != null && (inventoryHolder = inv.getHolder()) instanceof ControlGuiHolder && (holder = (ControlGuiHolder)inventoryHolder).getType() == ControlGuiHolder.Type.MAIN;
    }

    private boolean isRunnerSelector(Inventory inv) {
        ControlGuiHolder holder;
        InventoryHolder inventoryHolder;
        return inv != null && (inventoryHolder = inv.getHolder()) instanceof ControlGuiHolder && (holder = (ControlGuiHolder)inventoryHolder).getType() == ControlGuiHolder.Type.RUNNER_SELECTOR;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onInventoryClick(InventoryClickEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        Inventory top = event.getView().getTopInventory();
        if (top == null) {
            return;
        }
        if (!this.isMain(top) && !this.isRunnerSelector(top)) {
            return;
        }
        event.setCancelled(true);
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null || clicked.getType() == Material.AIR) {
            return;
        }
        if (this.isMain(top)) {
            this.handleMainClick(player, clicked);
        } else if (this.isRunnerSelector(top)) {
            this.handleRunnerSelectorClick(player, clicked, event.getRawSlot(), top.getSize());
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onInventoryDrag(InventoryDragEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Inventory top = event.getView().getTopInventory();
        if (top == null) {
            return;
        }
        if (!this.isMain(top) && !this.isRunnerSelector(top)) {
            return;
        }
        Iterator iterator = event.getRawSlots().iterator();
        while (iterator.hasNext()) {
            int rawSlot = (Integer)iterator.next();
            if (rawSlot >= top.getSize()) continue;
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        HumanEntity humanEntity = event.getPlayer();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        Inventory top = event.getView().getTopInventory();
        if (top == null) {
            return;
        }
        if (this.isRunnerSelector(top)) {
            this.pendingRunnerSelections.remove(player.getUniqueId());
        }
    }

    private void handleMainClick(Player player, ItemStack clicked) {
        String name;
        Material type = clicked.getType();
        boolean running = this.plugin.getGameManager().isGameRunning();
        if (type == Material.ARROW) {
            this.plugin.getGuiManager().openModeSelector(player);
            return;
        }
        if (type == Material.LIME_WOOL) {
            if (!running) {
                this.plugin.setCurrentMode(SpeedrunnerSwap.SwapMode.SAPNAP);
                if (this.plugin.getConfigManager().getRunnerNames().isEmpty()) {
                    List<String> names = Bukkit.getOnlinePlayers().stream().map(Player::getName).collect(Collectors.toList());
                    this.plugin.getConfigManager().setRunnerNames(names);
                    this.plugin.getGameManager().setRunners(new ArrayList<Player>(Bukkit.getOnlinePlayers()));
                }
                this.plugin.getGameManager().startGame();
            }
            new ControlGui(this.plugin).openMainMenu(player);
            return;
        }
        if (type == Material.RED_WOOL) {
            if (running) {
                this.plugin.getGameManager().stopGame();
            }
            new ControlGui(this.plugin).openMainMenu(player);
            return;
        }
        if (type == Material.YELLOW_WOOL) {
            if (running && !this.plugin.getGameManager().isGamePaused()) {
                this.plugin.getGameManager().pauseGame();
            }
            new ControlGui(this.plugin).openMainMenu(player);
            return;
        }
        if (type == Material.ORANGE_WOOL) {
            if (running && this.plugin.getGameManager().isGamePaused()) {
                this.plugin.getGameManager().resumeGame();
            }
            new ControlGui(this.plugin).openMainMenu(player);
            return;
        }
        if (type == Material.NETHER_STAR) {
            this.plugin.getGameManager().shuffleQueue();
            player.sendMessage("\u00a7aShuffled runner queue.");
            return;
        }
        if (type == Material.BOOK) {
            HashSet<String> initial = new HashSet<String>(this.plugin.getConfigManager().getRunnerNames());
            this.pendingRunnerSelections.put(player.getUniqueId(), initial);
            new ControlGui(this.plugin).openRunnerSelector(player);
            return;
        }
        if (type == Material.CLOCK) {
            name = GuiCompat.getDisplayName(clicked.getItemMeta());
            if (name.startsWith("Runner Timer:")) {
                String current = this.plugin.getConfigManager().getRunnerTimerVisibility();
                String next = switch (current.toLowerCase()) {
                    case "always" -> "last_10";
                    case "last_10" -> "never";
                    default -> "always";
                };
                this.plugin.getConfigManager().setRunnerTimerVisibility(next);
                player.sendMessage("\u00a7eRunner timer visibility: \u00a7a" + next);
                this.plugin.getGameManager().refreshActionBar();
                new ControlGui(this.plugin).openMainMenu(player);
                return;
            }
            if (name.startsWith("Waiting Timer:")) {
                String current = this.plugin.getConfigManager().getWaitingTimerVisibility();
                String next = switch (current.toLowerCase()) {
                    case "always" -> "last_10";
                    case "last_10" -> "never";
                    default -> "always";
                };
                this.plugin.getConfigManager().setWaitingTimerVisibility(next);
                player.sendMessage("\u00a7eWaiting timer visibility: \u00a7a" + next);
                new ControlGui(this.plugin).openMainMenu(player);
                return;
            }
        }
        if (type == Material.ARMOR_STAND) {
            String mode = this.plugin.getConfigManager().getFreezeMode();
            String next = switch (mode.toUpperCase()) {
                case "EFFECTS" -> "SPECTATOR";
                case "SPECTATOR" -> "LIMBO";
                case "LIMBO" -> "CAGE";
                default -> "EFFECTS";
            };
            this.plugin.getConfigManager().setFreezeMode(next);
            player.sendMessage("\u00a7eInactive runner state: \u00a7a" + next);
            this.plugin.getGameManager().reapplyStates();
            new ControlGui(this.plugin).openMainMenu(player);
            return;
        }
        if (type == Material.SLIME_BLOCK || type == Material.MAGMA_BLOCK) {
            boolean enabled = this.plugin.getConfigManager().isSafeSwapEnabled();
            this.plugin.getConfigManager().setSafeSwapEnabled(!enabled);
            player.sendMessage("\u00a7eSafe Swap: \u00a7a" + !enabled);
            new ControlGui(this.plugin).openMainMenu(player);
            return;
        }
        if (type == Material.ARROW) {
            name = GuiCompat.getDisplayName(clicked.getItemMeta());
            if ("\u00a77\u00a7lBack".equals(name)) {
                this.plugin.getGuiManager().openModeSelector(player);
            } else {
                int interval = this.plugin.getConfigManager().getSwapInterval();
                if (name.contains("-5")) {
                    interval -= 5;
                } else if (name.contains("+5")) {
                    interval += 5;
                }
                this.plugin.getConfigManager().setSwapInterval(interval);
                player.sendMessage("\u00a7eInterval set to: \u00a7a" + this.plugin.getConfigManager().getSwapInterval() + "s");
                this.plugin.getGameManager().refreshSwapSchedule();
                new ControlGui(this.plugin).openMainMenu(player);
            }
            return;
        }
        if (type == Material.COMPARATOR) {
            boolean randomize = this.plugin.getConfigManager().isSwapRandomized();
            this.plugin.getConfigManager().setSwapRandomized(!randomize);
            player.sendMessage("\u00a7eRandomize swaps: \u00a7a" + !randomize);
            new ControlGui(this.plugin).openMainMenu(player);
            return;
        }
        if (type == Material.PAPER) {
            player.sendMessage("\u00a76=== Runner-Only Status ===");
            player.sendMessage("\u00a7eGame Running: \u00a7f" + this.plugin.getGameManager().isGameRunning());
            player.sendMessage("\u00a7eGame Paused: \u00a7f" + this.plugin.getGameManager().isGamePaused());
            if (this.plugin.getGameManager().isGameRunning()) {
                Player active = this.plugin.getGameManager().getActiveRunner();
                player.sendMessage("\u00a7eActive Runner: \u00a7f" + (active != null ? active.getName() : "None"));
                player.sendMessage("\u00a7eTime Until Next Swap: \u00a7f" + this.plugin.getGameManager().getTimeUntilNextSwap() + "s");
                String runners = this.plugin.getGameManager().getRunners().stream().map(Player::getName).collect(Collectors.joining(", "));
                player.sendMessage("\u00a7eRunners: \u00a7f" + runners);
            }
        }
    }

    private void handleRunnerSelectorClick(Player player, ItemStack clicked, int rawSlot, int size) {
        Material type = clicked.getType();
        if (rawSlot >= size - 9) {
            if (type == Material.BARRIER) {
                this.pendingRunnerSelections.remove(player.getUniqueId());
                new ControlGui(this.plugin).openMainMenu(player);
                return;
            }
            if (type == Material.ARROW) {
                new ControlGui(this.plugin).openMainMenu(player);
                return;
            }
            if (type == Material.EMERALD_BLOCK) {
                Set<String> sel = this.pendingRunnerSelections.remove(player.getUniqueId());
                if (sel == null) {
                    sel = new HashSet<String>();
                }
                this.plugin.getConfigManager().setRunnerNames(new ArrayList<String>(sel));
                ArrayList<Player> players = new ArrayList<Player>();
                for (String name : sel) {
                    Player p = Bukkit.getPlayerExact((String)name);
                    if (p == null || !p.isOnline()) continue;
                    players.add(p);
                }
                this.plugin.getGameManager().setRunners(players);
                player.sendMessage("\u00a7aRunners set: \u00a7f" + String.join((CharSequence)", ", sel));
                new ControlGui(this.plugin).openMainMenu(player);
                return;
            }
        }
        if (type == Material.PLAYER_HEAD) {
            String name = GuiCompat.getDisplayName(clicked.getItemMeta());
            if (name == null || name.isBlank()) {
                return;
            }
            Set sel = this.pendingRunnerSelections.computeIfAbsent(player.getUniqueId(), k -> new HashSet<String>(this.plugin.getConfigManager().getRunnerNames()));
            if (sel.contains(name)) {
                sel.remove(name);
            } else {
                sel.add(name);
            }
            new ControlGui(this.plugin).openRunnerSelector(player);
        }
    }
}

