/*
 * Decompiled with CFR 0.152.
 */
package com.example.speedrunnerswap.commands;

import com.example.speedrunnerswap.SpeedrunnerSwap;
import com.example.speedrunnerswap.gui.ControlGui;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class SwapCommand
implements CommandExecutor,
TabCompleter {
    private final SpeedrunnerSwap plugin;

    public SwapCommand(SpeedrunnerSwap plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        try {
            String subCommand;
            if (args.length == 0) {
                return this.handleMainCommand(sender);
            }
            switch (subCommand = args[0].toLowerCase()) {
                case "start": {
                    return this.handleStart(sender);
                }
                case "stop": {
                    return this.handleStop(sender);
                }
                case "pause": {
                    return this.handlePause(sender);
                }
                case "resume": {
                    return this.handleResume(sender);
                }
                case "status": {
                    return this.handleStatus(sender);
                }
                case "creator": {
                    return this.handleCreator(sender);
                }
                case "setrunners": 
                case "setrunner": {
                    return this.handleSetRunners(sender, Arrays.copyOfRange(args, 1, args.length));
                }
                case "sethunters": 
                case "sethunter": {
                    return this.handleSetHunters(sender, Arrays.copyOfRange(args, 1, args.length));
                }
                case "reload": {
                    return this.handleReload(sender);
                }
                case "gui": {
                    return this.handleMainCommand(sender);
                }
                case "mode": {
                    return this.handleMode(sender, Arrays.copyOfRange(args, 1, args.length));
                }
                case "clearteams": {
                    return this.handleClearTeams(sender);
                }
            }
            sender.sendMessage("\u00a7cUnknown subcommand. Use /swap for help.");
            return false;
        }
        catch (Exception e) {
            sender.sendMessage("\u00a7cAn internal error occurred while executing that command. Check server logs for details.");
            this.plugin.getLogger().log(Level.SEVERE, "Unhandled exception while executing /swap by " + (sender == null ? "UNKNOWN" : sender.getName()), e);
            return false;
        }
    }

    private boolean handleMode(CommandSender sender, String[] rest) {
        boolean force;
        if (!sender.hasPermission("speedrunnerswap.admin")) {
            sender.sendMessage("\u00a7cYou don't have permission to change mode.");
            return false;
        }
        if (rest.length == 0) {
            sender.sendMessage("\u00a7eCurrent mode: \u00a7f" + this.plugin.getCurrentMode().name().toLowerCase());
            sender.sendMessage("\u00a77Usage: /swap mode <dream|sapnap> [--force]");
            sender.sendMessage("\u00a77       /swap mode default <dream|sapnap>");
            return true;
        }
        String mode = rest[0].toLowerCase();
        if ("default".equals(mode)) {
            if (rest.length < 2) {
                sender.sendMessage("\u00a7eDefault mode: \u00a7f" + this.plugin.getConfigManager().getDefaultMode().name().toLowerCase());
                sender.sendMessage("\u00a77Usage: /swap mode default <dream|sapnap>");
                return true;
            }
            String val = rest[1].toLowerCase();
            if (!val.equals("dream") && !val.equals("sapnap")) {
                sender.sendMessage("\u00a7cUnknown mode: " + val);
                return false;
            }
            SpeedrunnerSwap.SwapMode m = val.equals("sapnap") ? SpeedrunnerSwap.SwapMode.SAPNAP : SpeedrunnerSwap.SwapMode.DREAM;
            this.plugin.getConfigManager().setDefaultMode(m);
            sender.sendMessage("\u00a7aDefault mode set to \u00a7f" + val + "\u00a7a.");
            return true;
        }
        boolean bl = force = rest.length > 1 && ("--force".equalsIgnoreCase(rest[1]) || "-f".equalsIgnoreCase(rest[1]) || "force".equalsIgnoreCase(rest[1]));
        if (this.plugin.getGameManager().isGameRunning() && !force) {
            sender.sendMessage("\u00a7cStop the current game before switching modes. Add --force to end it and switch now.");
            return false;
        }
        if (force && this.plugin.getGameManager().isGameRunning()) {
            this.plugin.getGameManager().stopGame();
        }
        switch (mode) {
            case "dream": {
                this.plugin.setCurrentMode(SpeedrunnerSwap.SwapMode.DREAM);
                sender.sendMessage("\u00a7aMode set to \u00a7fDream\u00a7a (runners + hunters)");
                if (sender instanceof Player) {
                    Player p = (Player)sender;
                    this.plugin.getGuiManager().openMainMenu(p);
                }
                return true;
            }
            case "runner": 
            case "sapnap": 
            case "runners": 
            case "sapnaps": {
                this.plugin.setCurrentMode(SpeedrunnerSwap.SwapMode.SAPNAP);
                sender.sendMessage("\u00a7aMode set to \u00a7fSapnap\u00a7a (runners only)");
                if (sender instanceof Player) {
                    Player p = (Player)sender;
                    try {
                        new ControlGui(this.plugin).openMainMenu(p);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                return true;
            }
        }
        sender.sendMessage("\u00a7cUnknown mode: " + mode + ". Use dream|sapnap");
        return false;
    }

    private boolean handleCreator(CommandSender sender) {
        String donateUrl = this.plugin.getConfig().getString("donation.url", "https://donate.stripe.com/8x29AT0H58K03judnR0Ba01");
        Component header = ((TextComponent)Component.text((String)"Speedrunner Swap").color((TextColor)NamedTextColor.GOLD)).decorate(TextDecoration.BOLD);
        Component author = Component.text((String)"Created by muj3b").color((TextColor)NamedTextColor.YELLOW);
        Component donate = ((TextComponent)((TextComponent)((TextComponent)Component.text((String)"\u2764 Donate to support development").color((TextColor)NamedTextColor.LIGHT_PURPLE)).decorate(TextDecoration.BOLD)).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Open donation page", (TextColor)NamedTextColor.GOLD)))).clickEvent(ClickEvent.openUrl((String)donateUrl));
        if (sender instanceof Player) {
            Player p = (Player)sender;
            p.sendMessage(header);
            p.sendMessage(author);
            p.sendMessage(donate);
        } else {
            sender.sendMessage("Speedrunner Swap \u2014 Created by muj3b");
            sender.sendMessage("Donate: " + donateUrl);
        }
        return true;
    }

    private boolean handleMainCommand(CommandSender sender) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a7cThis command can only be used by players.");
            return false;
        }
        if (!sender.hasPermission("speedrunnerswap.command")) {
            sender.sendMessage("\u00a7cYou don't have permission to use this command.");
            return false;
        }
        if (this.plugin.getGuiManager() == null) {
            sender.sendMessage("\u00a7cError: GUI Manager not initialized properly. Please report this to the plugin developer.");
            this.plugin.getLogger().log(Level.SEVERE, "GUI Manager is null when trying to open main menu");
            return false;
        }
        try {
            this.plugin.getGuiManager().openModeSelector((Player)sender);
            return true;
        }
        catch (Exception e) {
            sender.sendMessage("\u00a7cError opening GUI: " + e.getMessage());
            this.plugin.getLogger().log(Level.SEVERE, "Error opening GUI for player " + sender.getName(), e);
            return false;
        }
    }

    private boolean handleStart(CommandSender sender) {
        if (!sender.hasPermission("speedrunnerswap.command")) {
            sender.sendMessage("\u00a7cYou don't have permission to use this command.");
            return false;
        }
        if (this.plugin.getGameManager().isGameRunning()) {
            sender.sendMessage("\u00a7cThe game is already running.");
            return false;
        }
        boolean success = this.plugin.getGameManager().startGame();
        if (success) {
            sender.sendMessage("\u00a7aGame started successfully.");
        } else {
            sender.sendMessage("\u00a7cFailed to start the game. Make sure there are runners set.");
        }
        return success;
    }

    private boolean handleStop(CommandSender sender) {
        if (!sender.hasPermission("speedrunnerswap.command")) {
            sender.sendMessage("\u00a7cYou don't have permission to use this command.");
            return false;
        }
        if (!this.plugin.getGameManager().isGameRunning()) {
            sender.sendMessage("\u00a7cThe game is not running.");
            return false;
        }
        this.plugin.getGameManager().stopGame();
        sender.sendMessage("\u00a7aGame stopped.");
        return true;
    }

    private boolean handlePause(CommandSender sender) {
        if (!sender.hasPermission("speedrunnerswap.command")) {
            sender.sendMessage("\u00a7cYou don't have permission to use this command.");
            return false;
        }
        if (!this.plugin.getGameManager().isGameRunning()) {
            sender.sendMessage("\u00a7cThe game is not running.");
            return false;
        }
        if (this.plugin.getGameManager().isGamePaused()) {
            sender.sendMessage("\u00a7cThe game is already paused.");
            return false;
        }
        boolean success = this.plugin.getGameManager().pauseGame();
        if (success) {
            sender.sendMessage("\u00a7aGame paused.");
        } else {
            sender.sendMessage("\u00a7cFailed to pause the game.");
        }
        return success;
    }

    private boolean handleResume(CommandSender sender) {
        if (!sender.hasPermission("speedrunnerswap.command")) {
            sender.sendMessage("\u00a7cYou don't have permission to use this command.");
            return false;
        }
        if (!this.plugin.getGameManager().isGameRunning()) {
            sender.sendMessage("\u00a7cThe game is not running.");
            return false;
        }
        if (!this.plugin.getGameManager().isGamePaused()) {
            sender.sendMessage("\u00a7cThe game is not paused.");
            return false;
        }
        boolean success = this.plugin.getGameManager().resumeGame();
        if (success) {
            sender.sendMessage("\u00a7aGame resumed.");
        } else {
            sender.sendMessage("\u00a7cFailed to resume the game.");
        }
        return success;
    }

    private boolean handleStatus(CommandSender sender) {
        if (!sender.hasPermission("speedrunnerswap.command")) {
            sender.sendMessage("\u00a7cYou don't have permission to use this command.");
            return false;
        }
        sender.sendMessage("\u00a76=== SpeedrunnerSwap Status ===");
        sender.sendMessage("\u00a7eGame Running: \u00a7f" + this.plugin.getGameManager().isGameRunning());
        sender.sendMessage("\u00a7eGame Paused: \u00a7f" + this.plugin.getGameManager().isGamePaused());
        if (this.plugin.getGameManager().isGameRunning()) {
            Player activeRunner = this.plugin.getGameManager().getActiveRunner();
            sender.sendMessage("\u00a7eActive Runner: \u00a7f" + (activeRunner != null ? activeRunner.getName() : "None"));
            sender.sendMessage("\u00a7eTime Until Next Swap: \u00a7f" + this.plugin.getGameManager().getTimeUntilNextSwap() + "s");
            List<Player> runners = this.plugin.getGameManager().getRunners();
            List<Player> hunters = this.plugin.getGameManager().getHunters();
            sender.sendMessage("\u00a7eRunners: \u00a7f" + runners.stream().map(Player::getName).collect(Collectors.joining(", ")));
            sender.sendMessage("\u00a7eHunters: \u00a7f" + hunters.stream().map(Player::getName).collect(Collectors.joining(", ")));
        }
        return true;
    }

    private boolean handleSetRunners(CommandSender sender, String[] playerNames) {
        if (!sender.hasPermission("speedrunnerswap.command")) {
            sender.sendMessage("\u00a7cYou don't have permission to use this command.");
            return false;
        }
        if (playerNames.length == 0) {
            sender.sendMessage("\u00a7cUsage: /swap setrunners <player1> [player2] [player3] ...");
            return false;
        }
        ArrayList<Player> players = new ArrayList<Player>();
        String[] stringArray = playerNames;
        int n = playerNames.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            Player player = Bukkit.getPlayerExact((String)name);
            if (player != null) {
                players.add(player);
            } else {
                sender.sendMessage("\u00a7cPlayer not found: " + name);
            }
            ++n2;
        }
        if (players.isEmpty()) {
            sender.sendMessage("\u00a7cNo valid players specified.");
            return false;
        }
        this.plugin.getGameManager().setRunners(players);
        sender.sendMessage("\u00a7aRunners set: " + players.stream().map(Player::getName).collect(Collectors.joining(", ")));
        return true;
    }

    private boolean handleSetHunters(CommandSender sender, String[] playerNames) {
        if (!sender.hasPermission("speedrunnerswap.command")) {
            sender.sendMessage("\u00a7cYou don't have permission to use this command.");
            return false;
        }
        if (playerNames.length == 0) {
            sender.sendMessage("\u00a7cUsage: /swap sethunters <player1> [player2] [player3] ...");
            return false;
        }
        ArrayList<Player> players = new ArrayList<Player>();
        String[] stringArray = playerNames;
        int n = playerNames.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            Player player = Bukkit.getPlayerExact((String)name);
            if (player != null) {
                players.add(player);
            } else {
                sender.sendMessage("\u00a7cPlayer not found: " + name);
            }
            ++n2;
        }
        if (players.isEmpty()) {
            sender.sendMessage("\u00a7cNo valid players specified.");
            return false;
        }
        this.plugin.getGameManager().setHunters(players);
        sender.sendMessage("\u00a7aHunters set: " + players.stream().map(Player::getName).collect(Collectors.joining(", ")));
        return true;
    }

    private boolean handleReload(CommandSender sender) {
        if (!sender.hasPermission("speedrunnerswap.admin")) {
            sender.sendMessage("\u00a7cYou don't have permission to use this command.");
            return false;
        }
        if (this.plugin.getGameManager().isGameRunning()) {
            this.plugin.getGameManager().stopGame();
        }
        this.plugin.getConfigManager().loadConfig();
        sender.sendMessage("\u00a7aConfiguration reloaded.");
        return true;
    }

    private boolean handleClearTeams(CommandSender sender) {
        if (!sender.hasPermission("speedrunnerswap.admin")) {
            sender.sendMessage("\u00a7cYou don't have permission to use this command.");
            return false;
        }
        if (this.plugin.getGameManager().isGameRunning()) {
            this.plugin.getGameManager().stopGame();
        }
        this.plugin.getGameManager().setRunners(new ArrayList<Player>());
        this.plugin.getGameManager().setHunters(new ArrayList<Player>());
        sender.sendMessage("\u00a7aCleared all teams (runners and hunters).");
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions;
        block7: {
            block9: {
                block8: {
                    block6: {
                        completions = new ArrayList<String>();
                        if (args.length != 1) break block6;
                        List<String> subCommands = Arrays.asList("start", "stop", "pause", "resume", "status", "creator", "setrunners", "setrunner", "sethunters", "sethunter", "reload", "gui", "mode", "clearteams");
                        for (String subCommand : subCommands) {
                            if (!subCommand.startsWith(args[0].toLowerCase())) continue;
                            completions.add(subCommand);
                        }
                        break block7;
                    }
                    if (args.length <= 1) break block7;
                    if (!args[0].equalsIgnoreCase("setrunners") && !args[0].equalsIgnoreCase("setrunner") && !args[0].equalsIgnoreCase("sethunters") && !args[0].equalsIgnoreCase("sethunter")) break block8;
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        String name = player.getName();
                        if (!name.toLowerCase().startsWith(args[args.length - 1].toLowerCase())) continue;
                        completions.add(name);
                    }
                    break block7;
                }
                if (!args[0].equalsIgnoreCase("mode") || args.length != 2) break block9;
                String[] stringArray = new String[]{"dream", "sapnap", "default"};
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String opt = stringArray[n2];
                    if (opt.startsWith(args[1].toLowerCase())) {
                        completions.add(opt);
                    }
                    ++n2;
                }
                break block7;
            }
            if (!args[0].equalsIgnoreCase("mode") || args.length != 3 || !"default".startsWith(args[1].toLowerCase())) break block7;
            String[] stringArray = new String[]{"dream", "sapnap"};
            int n = stringArray.length;
            int n3 = 0;
            while (n3 < n) {
                String opt = stringArray[n3];
                if (opt.startsWith(args[2].toLowerCase())) {
                    completions.add(opt);
                }
                ++n3;
            }
        }
        return completions;
    }
}

