/*
 * Decompiled with CFR 0.152.
 */
package com.example.speedrunnerswap.gui;

import com.example.speedrunnerswap.SpeedrunnerSwap;
import com.example.speedrunnerswap.gui.ControlGuiHolder;
import com.example.speedrunnerswap.utils.GuiCompat;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class ControlGui {
    private final SpeedrunnerSwap plugin;

    public ControlGui(SpeedrunnerSwap plugin) {
        this.plugin = plugin;
    }

    public void openMainMenu(Player player) {
        boolean randomize;
        int rows = Math.max(1, this.plugin.getConfigManager().getGuiMainMenuRows());
        int size = rows * 9;
        String title = this.plugin.getConfigManager().getGuiMainMenuTitle();
        Inventory inv = GuiCompat.createInventory(new ControlGuiHolder(ControlGuiHolder.Type.MAIN), size, title);
        ItemStack filler = new ItemStack(Material.GRAY_STAINED_GLASS_PANE);
        ItemMeta fm = filler.getItemMeta();
        GuiCompat.setDisplayName(fm, " ");
        filler.setItemMeta(fm);
        int i = 0;
        while (i < inv.getSize()) {
            inv.setItem(i, filler);
            ++i;
        }
        boolean running = this.plugin.getGameManager().isGameRunning();
        boolean paused = this.plugin.getGameManager().isGamePaused();
        inv.setItem(0, this.named(Material.ARROW, "\u00a77\u00a7lBack", List.of("\u00a77Return to mode selector")));
        if (!running) {
            inv.setItem(10, this.named(Material.LIME_WOOL, "Start Game", List.of("Begin swapping every " + this.plugin.getConfigManager().getSwapInterval() + "s")));
        } else {
            inv.setItem(10, this.named(Material.RED_WOOL, "Stop Game", List.of("End current game")));
        }
        if (running && !paused) {
            inv.setItem(12, this.named(Material.YELLOW_WOOL, "Pause", List.of("Temporarily pause swapping")));
        } else if (running && paused) {
            inv.setItem(12, this.named(Material.ORANGE_WOOL, "Resume", List.of("Resume swapping")));
        } else {
            inv.setItem(12, this.named(Material.GRAY_WOOL, "Pause", List.of("Game not running")));
        }
        inv.setItem(14, this.named(Material.NETHER_STAR, "Shuffle Queue", List.of("Keep active runner, shuffle the rest")));
        if (this.plugin.getCurrentMode() != SpeedrunnerSwap.SwapMode.SAPNAP) {
            inv.setItem(16, this.named(Material.BOOK, "Set Runners", List.of("Open the runner selector")));
        }
        inv.setItem(22, this.named(Material.COMPARATOR, (randomize = this.plugin.getConfigManager().isSwapRandomized()) ? "Randomize: ON" : "Randomize: OFF", List.of("Toggle randomized intervals")));
        String runnerVis = this.plugin.getConfigManager().getRunnerTimerVisibility();
        String runnerLabel = switch (runnerVis.toLowerCase()) {
            case "always" -> "FULL";
            case "never" -> "HIDDEN";
            default -> "LAST 10s";
        };
        inv.setItem(20, this.named(Material.CLOCK, "Runner Timer: " + runnerLabel, List.of("Cycle active runner timer visibility", "FULL / LAST 10s / HIDDEN")));
        String waitingVis = this.plugin.getConfigManager().getWaitingTimerVisibility();
        String waitingLabel = switch (waitingVis.toLowerCase()) {
            case "last_10" -> "LAST 10s";
            case "never" -> "HIDDEN";
            default -> "FULL";
        };
        inv.setItem(21, this.named(Material.CLOCK, "Waiting Timer: " + waitingLabel, List.of("Cycle waiting runner timer visibility", "FULL / LAST 10s / HIDDEN")));
        int interval = this.plugin.getConfigManager().getSwapInterval();
        ArrayList<String> intervalLore = new ArrayList<String>();
        intervalLore.add("Base swap interval");
        int recommendedMin = 30;
        int recommendedMax = 300;
        if (interval < recommendedMin) {
            intervalLore.add("\u00a7cWarning: <30s may be unstable on some servers");
        } else if (interval > recommendedMax) {
            intervalLore.add("\u00a7cWarning: >300s may feel sluggish / desync-y");
        }
        inv.setItem(23, this.named(Material.PAPER, "Interval: " + interval + "s", intervalLore));
        inv.setItem(18, this.named(Material.ARROW, "-5s", List.of("Decrease interval")));
        inv.setItem(26, this.named(Material.ARROW, "+5s", List.of("Increase interval")));
        String freeze = this.plugin.getConfigManager().getFreezeMode();
        inv.setItem(4, this.named(Material.ARMOR_STAND, "Inactive Runner State: " + freeze, List.of("EFFECTS: Blind/Dark/Slow", "SPECTATOR: Spectator mode", "LIMBO: Teleport to limbo", "CAGE: Bedrock cage (one shared cage)")));
        boolean safeSwap = this.plugin.getConfigManager().isSafeSwapEnabled();
        inv.setItem(6, this.named(safeSwap ? Material.SLIME_BLOCK : Material.MAGMA_BLOCK, safeSwap ? "Safe Swap: ON" : "Safe Swap: OFF", List.of("Avoid lava/cactus/fire on teleports")));
        boolean singlePlayerSleep = this.plugin.getConfigManager().isSinglePlayerSleepEnabled();
        inv.setItem(8, this.named(singlePlayerSleep ? Material.WHITE_BED : Material.RED_BED, singlePlayerSleep ? "Single Player Sleep: ON" : "Single Player Sleep: OFF", List.of("Allow only active runner to skip night", "Useful when other players are caged")));
        inv.setItem(24, this.named(Material.PAPER, "Status", List.of("Show current status in chat")));
        player.openInventory(inv);
    }

    public void openRunnerSelector(Player player) {
        int rows = Math.max(2, this.plugin.getConfigManager().getGuiTeamSelectorRows());
        int size = rows * 9;
        String title = this.plugin.getConfigManager().getGuiTeamSelectorTitle();
        Inventory inv = GuiCompat.createInventory(new ControlGuiHolder(ControlGuiHolder.Type.RUNNER_SELECTOR), size, title);
        ItemStack filler = new ItemStack(Material.BLACK_STAINED_GLASS_PANE);
        ItemMeta fm = filler.getItemMeta();
        GuiCompat.setDisplayName(fm, " ");
        filler.setItemMeta(fm);
        int i = 0;
        while (i < inv.getSize()) {
            inv.setItem(i, filler);
            ++i;
        }
        List<String> selected = this.plugin.getConfigManager().getRunnerNames();
        int idx = 0;
        for (Player p : Bukkit.getOnlinePlayers()) {
            ItemStack icon = new ItemStack(Material.PLAYER_HEAD);
            try {
                SkullMeta sm = (SkullMeta)icon.getItemMeta();
                sm.setOwningPlayer((OfflinePlayer)p);
                GuiCompat.setDisplayName((ItemMeta)sm, p.getName());
                boolean isSel = selected.contains(p.getName());
                ArrayList<String> legacy = new ArrayList<String>();
                legacy.add(isSel ? "Selected: Yes" : "Selected: No");
                GuiCompat.setLore((ItemMeta)sm, legacy);
                icon.setItemMeta((ItemMeta)sm);
            }
            catch (Throwable t) {
                ItemMeta im = icon.getItemMeta();
                GuiCompat.setDisplayName(im, p.getName());
                icon.setItemMeta(im);
            }
            if (idx < size - 9) {
                inv.setItem(idx, icon);
            }
            ++idx;
        }
        inv.setItem(size - 8, this.named(Material.ARROW, "\u00a77\u00a7lBack", List.of("\u00a77Return to control menu")));
        inv.setItem(size - 6, this.named(Material.EMERALD_BLOCK, "Save", List.of("Apply selected runners")));
        inv.setItem(size - 4, this.named(Material.BARRIER, "Cancel", List.of("Discard changes")));
        player.openInventory(inv);
    }

    private ItemStack named(Material mat, String name, List<String> loreText) {
        ItemStack it = new ItemStack(mat);
        ItemMeta im = it.getItemMeta();
        GuiCompat.setDisplayName(im, name);
        if (loreText != null && !loreText.isEmpty()) {
            GuiCompat.setLore(im, loreText);
        }
        it.setItemMeta(im);
        return it;
    }
}

