/*
 * Decompiled with CFR 0.152.
 */
package com.example.speedrunnerswap.utils;

import java.util.Set;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;

public class SafeLocationFinder {
    public static Location findSafeLocation(Location location, int horizontalRadius, int verticalDistance, Set<Material> dangerousBlocks) {
        World world = location.getWorld();
        int startX = location.getBlockX();
        int startY = location.getBlockY();
        int startZ = location.getBlockZ();
        if (SafeLocationFinder.isSafeLocation(location, dangerousBlocks)) {
            return location;
        }
        int r = 1;
        while (r <= horizontalRadius) {
            int x = -r;
            while (x <= r) {
                int z = -r;
                while (z <= r) {
                    if (Math.abs(x) == r || Math.abs(z) == r) {
                        int y = 0;
                        while (y <= verticalDistance) {
                            Location checkLoc = new Location(world, (double)(startX + x), (double)(startY - y), (double)(startZ + z));
                            if (SafeLocationFinder.isSafeLocation(checkLoc, dangerousBlocks)) {
                                return checkLoc;
                            }
                            checkLoc = new Location(world, (double)(startX + x), (double)(startY + y), (double)(startZ + z));
                            if (SafeLocationFinder.isSafeLocation(checkLoc, dangerousBlocks)) {
                                return checkLoc;
                            }
                            ++y;
                        }
                    }
                    ++z;
                }
                ++x;
            }
            ++r;
        }
        return null;
    }

    private static boolean isSafeLocation(Location location, Set<Material> dangerousBlocks) {
        World world = location.getWorld();
        int x = location.getBlockX();
        int y = location.getBlockY();
        int z = location.getBlockZ();
        if (y < world.getMinHeight() || y >= world.getMaxHeight()) {
            return false;
        }
        Block feet = world.getBlockAt(x, y, z);
        Block head = world.getBlockAt(x, y + 1, z);
        Block ground = world.getBlockAt(x, y - 1, z);
        if (feet.getType().isSolid() || head.getType().isSolid()) {
            return false;
        }
        if (!ground.getType().isSolid()) {
            return false;
        }
        if (dangerousBlocks.contains(ground.getType())) {
            return false;
        }
        int dx = -1;
        while (dx <= 1) {
            int dz = -1;
            while (dz <= 1) {
                Block surroundingBlock = world.getBlockAt(x + dx, y, z + dz);
                if (dangerousBlocks.contains(surroundingBlock.getType())) {
                    return false;
                }
                ++dz;
            }
            ++dx;
        }
        return true;
    }
}

