/*
 * Decompiled with CFR 0.152.
 */
package net.sideways_sky.multimine;

import java.util.function.Consumer;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.sideways_sky.multimine.MultiMine;
import net.sideways_sky.multimine.Scheduler;
import org.jetbrains.annotations.Nullable;

public class DamagedBlock {
    private final int entityId = MultiMine.getNewID();
    private final Consumer<DamagedBlock> removeSelf;
    public final class_3218 world;
    public final class_2338 pos;
    public int progress;
    @Nullable
    private Scheduler.Task fading;

    public DamagedBlock(Consumer<DamagedBlock> removeSelf, class_3218 world, class_2338 pos, int currentProgress) {
        this.removeSelf = removeSelf;
        this.world = world;
        this.pos = pos;
        this.progress = currentProgress;
    }

    public void stopFade() {
        if (this.fading != null) {
            MultiMine.LOGGER.debug("Canceled Fade at: {}", (Object)this.pos);
            this.fading.cancel();
            this.fading = null;
        }
    }

    public void startFade() {
        if (this.fading != null) {
            return;
        }
        MultiMine.LOGGER.debug("Started Fade at: {}", (Object)this.pos);
        this.fading = Scheduler.repeat(40L, 20L, task -> {
            --this.progress;
            if (this.progress < 1) {
                MultiMine.LOGGER.debug("Fade completed at: {}", (Object)this.pos);
                this.world.method_8517(this.entityId, this.pos, -1);
                this.delete();
                return;
            }
            this.sendUpdate();
        });
    }

    public void delete() {
        this.stopFade();
        this.progress = -1;
        this.sendUpdate();
        this.removeSelf.accept(this);
    }

    public void sendUpdate() {
        this.world.method_8517(this.entityId, this.pos, this.progress);
    }
}

