/*
 * Decompiled with CFR 0.152.
 */
package net.sideways_sky.multimine;

import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.sideways_sky.multimine.Events;
import net.sideways_sky.multimine.MultiMine;
import org.bukkit.Particle;
import org.bukkit.SoundCategory;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

public class DamagedBlock {
    public static int FadeStartDelay = 40;
    public static int FadeIntervalDelay = 20;
    public static float FadeDamageReduction = 0.1f;
    private final int entityId;
    public Map<Entity, Float> entityDamageMap = new HashMap<Entity, Float>();
    private final Block block;
    public float damage = 0.0f;
    @Nullable
    private ScheduledTask fadeTask = null;

    public DamagedBlock(Block block) {
        this.block = block;
        this.entityId = net.minecraft.world.entity.Entity.nextEntityId();
        this.debugMessage("Created");
    }

    public void debugMessage(String message) {
        MultiMine.debugMessage("Block[ " + this.entityId + " ]: " + message);
    }

    public void brake(Entity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            MultiMine.debugMessage("Brake - player");
            if (player.breakBlock(this.block)) {
                this.block.getWorld().playSound(this.block.getLocation(), this.block.getBlockSoundGroup().getBreakSound(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                this.block.getWorld().spawnParticle(Particle.BLOCK, this.block.getLocation().add(0.5, 0.5, 0.5), 20, 0.3, 0.3, 0.3, (Object)this.block.getBlockData());
            }
        } else {
            MultiMine.debugMessage("Brake - non player");
            this.block.breakNaturally(true);
        }
    }

    public void startFade() {
        this.debugMessage("Fade Start");
        this.fadeTask = MultiMine.instance.getServer().getRegionScheduler().runAtFixedRate((Plugin)MultiMine.instance, this.block.getLocation(), e -> this.fade(), (long)FadeStartDelay, (long)FadeIntervalDelay);
    }

    public void stopFade() {
        if (this.fadeTask != null) {
            this.debugMessage("Fade Stop");
            this.fadeTask.cancel();
            this.fadeTask = null;
        }
    }

    public void delete() {
        this.stopFade();
        this.sendPacket(-1);
        Events.damagedBlockMap.remove(this.block);
        this.debugMessage("Deleted");
    }

    public void fade() {
        float preFadeDamageReduction = this.damage;
        this.damage -= FadeDamageReduction;
        Consumer<String> message = messageSuffix -> this.debugMessage("Fade: " + this.damage + " -= " + FadeDamageReduction + messageSuffix);
        if (this.damage < 0.0f) {
            message.accept(" -deleting");
            this.delete();
        } else if (Math.round(this.damage * 10.0f) != Math.round(preFadeDamageReduction * 10.0f)) {
            message.accept(" -updating");
            this.sendPacket();
        } else {
            message.accept("");
        }
    }

    public void sendPacket() {
        this.sendPacket(Math.round(this.damage * 10.0f));
    }

    private void sendPacket(int progress) {
        ((CraftWorld)this.block.getWorld()).getHandle().destroyBlockProgress(this.entityId, ((CraftBlock)this.block).getPosition(), progress);
    }
}

