/*
 * Decompiled with CFR 0.152.
 */
package net.sideways_sky.multimine;

import io.papermc.paper.event.block.BlockBreakProgressUpdateEvent;
import java.util.HashMap;
import java.util.Map;
import net.sideways_sky.multimine.DamagedBlock;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDamageAbortEvent;
import org.bukkit.event.block.BlockDamageEvent;

public class Events
implements Listener {
    public static Map<Block, DamagedBlock> damagedBlockMap = new HashMap<Block, DamagedBlock>();

    @EventHandler
    public static void onBlockDamage(BlockDamageEvent e) {
        if (e.getInstaBreak()) {
            return;
        }
        DamagedBlock damagedBlock = damagedBlockMap.get(e.getBlock());
        if (damagedBlock == null) {
            damagedBlock = new DamagedBlock(e.getBlock());
            damagedBlockMap.put(e.getBlock(), damagedBlock);
        }
        damagedBlock.debugMessage("DamageEvent");
        damagedBlock.entityDamageMap.putIfAbsent((Entity)e.getPlayer(), Float.valueOf(0.0f));
        damagedBlock.stopFade();
    }

    @EventHandler
    public static void onBlockBreakProgressUpdate(BlockBreakProgressUpdateEvent e) {
        float increment;
        if (e.getProgress() <= 0.0f) {
            return;
        }
        DamagedBlock damagedBlock = damagedBlockMap.get(e.getBlock());
        if (damagedBlock == null) {
            damagedBlock = new DamagedBlock(e.getBlock());
            damagedBlockMap.put(e.getBlock(), damagedBlock);
        }
        if ((increment = e.getProgress() - damagedBlock.entityDamageMap.getOrDefault(e.getEntity(), Float.valueOf(0.0f)).floatValue()) <= 0.0f) {
            return;
        }
        damagedBlock.debugMessage("BreakProgressUpdateEvent: " + damagedBlock.damage + " += " + increment + " (" + e.getProgress() + " - " + String.valueOf(damagedBlock.entityDamageMap.get(e.getEntity())) + ") | " + String.valueOf(e.getEntity()));
        damagedBlock.damage += increment;
        if (damagedBlock.damage >= 1.0f) {
            damagedBlock.brake(e.getEntity());
        } else {
            damagedBlock.sendPacket();
        }
        damagedBlock.entityDamageMap.put(e.getEntity(), Float.valueOf(e.getProgress()));
    }

    @EventHandler
    public static void onBlockBreak(BlockBreakEvent e) {
        DamagedBlock damagedBlock = damagedBlockMap.get(e.getBlock());
        if (damagedBlock != null) {
            damagedBlock.debugMessage("BreakEvent");
            damagedBlock.delete();
        }
    }

    @EventHandler
    public static void onBlockDamageAbort(BlockDamageAbortEvent e) {
        DamagedBlock damagedBlock = damagedBlockMap.get(e.getBlock());
        if (damagedBlock == null) {
            return;
        }
        damagedBlock.debugMessage("DamageAbortEvent");
        damagedBlock.entityDamageMap.remove(e.getPlayer());
        damagedBlock.sendPacket();
        if (damagedBlock.entityDamageMap.isEmpty()) {
            damagedBlock.startFade();
        }
    }
}

