/*
 * Decompiled with CFR 0.152.
 */
package mastergeneral.ctdmint.item;

import com.themastergeneral.ctdcore.helpers.ModUtils;
import com.themastergeneral.ctdcore.helpers.ServerHelper;
import com.themastergeneral.ctdcore.item.CTDItem;
import java.util.List;
import javax.annotation.Nullable;
import mastergeneral.ctdmint.MintHelper;
import mastergeneral.ctdmint.item.ItemCurrency;
import mastergeneral.ctdmint.item.ModItems;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemStorageCard
extends CTDItem {
    public float stored;

    public ItemStorageCard(float stored) {
        super(new Item.Properties().m_41487_(1).m_41486_());
        this.stored = stored;
    }

    public void m_7836_(ItemStack stack, Level worldIn, Player playerIn) {
        if (!stack.m_41782_()) {
            CompoundTag compoundnbt = new CompoundTag();
            compoundnbt.m_128350_("currentStored", 0.0f);
            compoundnbt.m_128350_("maxStored", this.stored);
            stack.m_41751_(compoundnbt);
        }
    }

    public void withdrawMoney(Player player, ItemStack stack, float remove) {
        MintHelper.givePlayerMoneyItem(player, remove);
        this.removeMoney(stack, remove);
    }

    public void depositMoney(Player player, ItemStack stack, float add) {
        this.addMoney(stack, add);
    }

    protected void removeMoney(ItemStack stackIn, float remove) {
        float current = this.getCurrentMoney(stackIn);
        float max = this.getMaxMoney(stackIn);
        if (current - remove >= 0.0f) {
            CompoundTag compoundnbt = new CompoundTag();
            float toset = current - remove;
            compoundnbt.m_128350_("currentStored", toset);
            compoundnbt.m_128350_("maxStored", max);
            stackIn.m_41751_(compoundnbt);
        }
    }

    protected void addMoney(ItemStack stackIn, float add) {
        float max;
        float current = this.getCurrentMoney(stackIn);
        if (current + add <= (max = this.getMaxMoney(stackIn))) {
            CompoundTag compoundnbt = new CompoundTag();
            float toset = current + add;
            compoundnbt.m_128350_("currentStored", toset);
            compoundnbt.m_128350_("maxStored", max);
            stackIn.m_41751_(compoundnbt);
        }
    }

    protected ItemCurrency getBiggestBill(ItemStack stack) {
        if (stack.m_41720_() instanceof ItemStorageCard) {
            ItemStorageCard item = (ItemStorageCard)stack.m_41720_();
            float max = item.getCurrentMoney(stack);
            if (max >= 1000000.0f) {
                return ModItems.bill_1000000;
            }
            if (max >= 500000.0f && max < 1000000.0f) {
                return ModItems.bill_500000;
            }
            if (max >= 100000.0f && max < 500000.0f) {
                return ModItems.bill_100000;
            }
            if (max >= 50000.0f && max < 100000.0f) {
                return ModItems.bill_50000;
            }
            if (max >= 10000.0f && max < 50000.0f) {
                return ModItems.bill_10000;
            }
            if (max >= 5000.0f && max < 10000.0f) {
                return ModItems.bill_5000;
            }
            if (max >= 1000.0f && max < 5000.0f) {
                return ModItems.bill_1000;
            }
            if (max >= 500.0f && max < 1000.0f) {
                return ModItems.bill_500;
            }
            if (max >= 100.0f && max < 500.0f) {
                return ModItems.bill_100;
            }
            if (max >= 50.0f && max < 100.0f) {
                return ModItems.bill_50;
            }
            if (max >= 20.0f && max < 50.0f) {
                return ModItems.bill_20;
            }
            if (max >= 10.0f && max < 20.0f) {
                return ModItems.bill_10;
            }
            if (max >= 5.0f && max < 10.0f) {
                return ModItems.bill_5;
            }
            if (max >= 2.0f && max < 10.0f) {
                return ModItems.bill_2;
            }
            if (max >= 1.0f && max < 2.0f) {
                return ModItems.bill_1;
            }
            if (max >= 0.5f && max < 1.0f) {
                return ModItems.coin_50;
            }
            if (max >= 0.25f && max < 0.5f) {
                return ModItems.coin_25;
            }
            if (max >= 0.1f && max < 0.25f) {
                return ModItems.coin_10;
            }
            if (max >= 0.05f && max < 0.1f) {
                return ModItems.coin_5;
            }
            if (max >= 0.01f && max < 0.05f) {
                return ModItems.coin_1;
            }
            return null;
        }
        return null;
    }

    protected float getCurrentMoney(ItemStack stackIn) {
        if (stackIn.m_41782_()) {
            return stackIn.m_41783_().m_128457_("currentStored") >= 0.01f ? stackIn.m_41783_().m_128457_("currentStored") : 0.0f;
        }
        return 0.0f;
    }

    protected float getMaxMoney(ItemStack stackIn) {
        if (stackIn.m_41782_()) {
            return stackIn.m_41783_().m_128457_("maxStored");
        }
        return 0.0f;
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!stack.m_41782_()) {
            CompoundTag compoundnbt = new CompoundTag();
            compoundnbt.m_128350_("currentStored", 0.0f);
            compoundnbt.m_128350_("maxStored", this.stored);
            stack.m_41751_(compoundnbt);
        }
    }

    public boolean m_142522_(ItemStack stack) {
        return true;
    }

    public int m_142158_(ItemStack stack) {
        return Math.round(13.0f - (this.getMaxMoney(stack) - this.getCurrentMoney(stack)) * 13.0f / this.getMaxMoney(stack));
    }

    public int m_142159_(ItemStack stack) {
        float stackMaxDamage = this.getMaxMoney(stack);
        float f = Math.max(0.0f, (stackMaxDamage - (stackMaxDamage - this.getCurrentMoney(stack))) / stackMaxDamage);
        return Mth.m_14169_((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.m_21205_();
        ItemStack offhand = playerIn.m_21206_();
        if (ServerHelper.isServerLevel((Level)worldIn) && handIn == InteractionHand.MAIN_HAND) {
            if (offhand.m_41619_() && playerIn.m_6047_()) {
                ItemStorageCard card = (ItemStorageCard)stack.m_41720_();
                if (card.getCurrentMoney(stack) > 0.0f) {
                    ItemCurrency giftedBill = this.getBiggestBill(stack);
                    this.withdrawMoney(playerIn, stack, giftedBill.returnValue());
                    playerIn.m_36335_().m_41524_((Item)this, 2);
                    return InteractionResultHolder.m_19090_((Object)stack);
                }
                return InteractionResultHolder.m_19100_((Object)stack);
            }
            if (playerIn.m_21206_().m_41720_() instanceof ItemCurrency) {
                ItemCurrency currency = (ItemCurrency)offhand.m_41720_();
                if (currency.returnValue() > 0.0f && currency.returnValue() != Float.NaN) {
                    if (currency.returnValue() + this.getCurrentMoney(stack) <= this.getMaxMoney(stack)) {
                        this.addMoney(stack, currency.returnValue());
                        playerIn.m_21206_().m_41774_(1);
                        playerIn.m_36335_().m_41524_((Item)this, 2);
                        return InteractionResultHolder.m_19090_((Object)stack);
                    }
                    return InteractionResultHolder.m_19100_((Object)stack);
                }
                return InteractionResultHolder.m_19100_((Object)stack);
            }
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (!Screen.m_96638_()) {
            tooltip.add((Component)ModUtils.displayString((String)("Stored: $" + ModUtils.returnShortenedNumber((Number)Float.valueOf(this.getCurrentMoney(stack))) + " / $" + ModUtils.returnShortenedNumber((Number)Float.valueOf(this.getMaxMoney(stack))))));
        } else {
            float multi = this.getCurrentMoney(stack) * 100.0f;
            long rounded = Math.round(multi);
            float display = (float)rounded / 100.0f;
            tooltip.add((Component)ModUtils.displayString((String)("Stored: $" + display + " / $" + this.getMaxMoney(stack))));
        }
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }
}

