/*
 * Decompiled with CFR 0.152.
 */
package mastergeneral.ctdmint.block.entity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import mastergeneral.ctdmint.item.ModItems;
import mastergeneral.ctdmint.recipe.SellingRecipe;
import mastergeneral.ctdmint.registry.BlockEntityRegistry;
import mastergeneral.ctdmint.registry.RecipeRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class SellingBlockEntity
extends BlockEntity {
    public final ItemStackHandler items = new ItemStackHandler(1);
    private final LazyOptional<IItemHandler> handler = LazyOptional.of(() -> this.items);
    private int progress = 0;
    private static final int PROCESS_TIME = 30;

    public SellingBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityRegistry.selling_block.get(), pos, state);
    }

    public void tick() {
        if (this.f_58857_ == null || this.f_58857_.m_5776_()) {
            return;
        }
        ItemStack input = this.items.getStackInSlot(0);
        if (input.m_41619_()) {
            this.progress = 0;
            return;
        }
        Optional<SellingRecipe> recipeOpt = this.findRecipe(input);
        if (recipeOpt.isEmpty()) {
            this.progress = 0;
            return;
        }
        SellingRecipe recipe = recipeOpt.get();
        List<ItemStack> outputs = this.calculateCurrencyOutput(recipe.getValue());
        if (!this.canOutputToTopContainer(outputs)) {
            this.progress = 0;
            return;
        }
        ++this.progress;
        if (this.progress >= 30) {
            this.items.extractItem(0, 1, false);
            this.outputToTopContainer(outputs);
            this.progress = 0;
        }
    }

    private Optional<SellingRecipe> findRecipe(ItemStack input) {
        return this.f_58857_.m_7465_().m_44015_((RecipeType)RecipeRegistry.SELLING_TYPE.get(), (Container)new SimpleContainer(new ItemStack[]{this.items.getStackInSlot(0)}), this.f_58857_);
    }

    private boolean canOutputToTopContainer(List<ItemStack> outputs) {
        BlockEntity above = this.f_58857_.m_7702_(this.f_58858_.m_7494_());
        if (above == null) {
            return false;
        }
        LazyOptional cap = above.getCapability(ForgeCapabilities.ITEM_HANDLER, Direction.DOWN);
        if (!cap.isPresent()) {
            return false;
        }
        IItemHandler handler = (IItemHandler)cap.orElse(null);
        for (ItemStack out : outputs) {
            ItemStack remaining = this.tryInsertStack(handler, out.m_41777_(), true);
            if (remaining.m_41619_()) continue;
            return false;
        }
        return true;
    }

    private void outputToTopContainer(List<ItemStack> outputs) {
        BlockEntity above = this.f_58857_.m_7702_(this.f_58858_.m_7494_());
        if (above == null) {
            return;
        }
        LazyOptional cap = above.getCapability(ForgeCapabilities.ITEM_HANDLER, Direction.DOWN);
        if (!cap.isPresent()) {
            return;
        }
        IItemHandler handler = (IItemHandler)cap.orElse(null);
        for (ItemStack out : outputs) {
            this.tryInsertStack(handler, out.m_41777_(), false);
        }
    }

    private ItemStack tryInsertStack(IItemHandler handler, ItemStack stack, boolean simulate) {
        for (int i = 0; i < handler.getSlots() && !(stack = handler.insertItem(i, stack, simulate)).m_41619_(); ++i) {
        }
        return stack;
    }

    private List<ItemStack> calculateCurrencyOutput(float value) {
        ArrayList<ItemStack> output = new ArrayList<ItemStack>();
        HashMap<Float, Item> denominations = new HashMap<Float, Item>();
        denominations.put(Float.valueOf(0.01f), ModItems.coin_1.m_5456_());
        denominations.put(Float.valueOf(0.05f), ModItems.coin_5.m_5456_());
        denominations.put(Float.valueOf(0.1f), ModItems.coin_10.m_5456_());
        denominations.put(Float.valueOf(0.25f), ModItems.coin_25.m_5456_());
        denominations.put(Float.valueOf(0.5f), ModItems.coin_50.m_5456_());
        denominations.put(Float.valueOf(1.0f), ModItems.bill_1.m_5456_());
        denominations.put(Float.valueOf(2.0f), ModItems.bill_2.m_5456_());
        denominations.put(Float.valueOf(5.0f), ModItems.bill_5.m_5456_());
        denominations.put(Float.valueOf(10.0f), ModItems.bill_10.m_5456_());
        denominations.put(Float.valueOf(20.0f), ModItems.bill_20.m_5456_());
        denominations.put(Float.valueOf(50.0f), ModItems.bill_50.m_5456_());
        denominations.put(Float.valueOf(100.0f), ModItems.bill_100.m_5456_());
        denominations.put(Float.valueOf(500.0f), ModItems.bill_500.m_5456_());
        denominations.put(Float.valueOf(1000.0f), ModItems.bill_1000.m_5456_());
        denominations.put(Float.valueOf(5000.0f), ModItems.bill_5000.m_5456_());
        denominations.put(Float.valueOf(10000.0f), ModItems.bill_10000.m_5456_());
        denominations.put(Float.valueOf(50000.0f), ModItems.bill_50000.m_5456_());
        denominations.put(Float.valueOf(100000.0f), ModItems.bill_100000.m_5456_());
        denominations.put(Float.valueOf(500000.0f), ModItems.bill_500000.m_5456_());
        denominations.put(Float.valueOf(1000000.0f), ModItems.bill_1000000.m_5456_());
        denominations.put(Float.valueOf(5000000.0f), ModItems.bill_5000000.m_5456_());
        ArrayList sorted = new ArrayList(denominations.entrySet());
        sorted.sort((a, b) -> Float.compare(((Float)b.getKey()).floatValue(), ((Float)a.getKey()).floatValue()));
        for (Map.Entry entry : sorted) {
            while (value >= ((Float)entry.getKey()).floatValue()) {
                output.add(new ItemStack((ItemLike)entry.getValue()));
                value -= ((Float)entry.getKey()).floatValue();
            }
        }
        return output;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.items.deserializeNBT(tag.m_128469_("items"));
        this.progress = tag.m_128451_("progress");
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("items", (Tag)this.items.serializeNBT());
        tag.m_128405_("progress", this.progress);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.handler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.handler.invalidate();
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }
}

