/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.clickthrough.helpers;

import cc.cassian.clickthrough.ClickThrough;
import cc.cassian.clickthrough.compat.FastItemFramesCompat;
import cc.cassian.clickthrough.config.ModConfig;
import cc.cassian.clickthrough.config.ModLists;
import cc.cassian.clickthrough.helpers.neoforge.ModHelpersImpl;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.lang.reflect.Field;
import java.util.function.Consumer;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WallBannerBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class ModHelpers {
    public static ModConfig config = ModConfig.get();

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isLoaded(String mod) {
        return ModHelpersImpl.isLoaded(mod);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean clothConfigInstalled() {
        return ModHelpersImpl.clothConfigInstalled();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerKeybind() {
        ModHelpersImpl.registerKeybind();
    }

    public static String getSignRowText(SignBlockEntity sign, int row) {
        StringBuilder builder = new StringBuilder();
        return sign.getFrontText().getMessage(row, true).getString();
    }

    public static Component fieldName(Field field) {
        return Component.translatable((String)("clickthrough.config." + field.getName()));
    }

    public static <T> T fieldGet(Object instance, Field field) {
        try {
            return (T)field.get(instance);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> Consumer<T> fieldSetter(Object instance, Field field) {
        return t -> {
            try {
                field.set(instance, t);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        };
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isTaggedAsContainer(BlockState state) {
        return ModHelpersImpl.isTaggedAsContainer(state);
    }

    public static boolean isClickableBlockAt(BlockPos pos, ClientLevel world) {
        if (!ModConfig.get().onlycontainers) {
            return true;
        }
        BlockEntity entity = world.getBlockEntity(pos);
        BlockState state = world.getBlockState(pos);
        if (entity instanceof BaseContainerBlockEntity) {
            return true;
        }
        return ModHelpers.isTaggedAsContainer(state) || ModLists.containers.contains(state.getBlock());
    }

    public static HitResult switchCrosshairTarget(HitResult crosshairTarget, LocalPlayer player, ClientLevel world) {
        if (!ModConfig.get().isActive) {
            return crosshairTarget;
        }
        ClickThrough.isDyeOnSign = false;
        if (crosshairTarget != null) {
            Entity entity;
            if (crosshairTarget.getType() == HitResult.Type.ENTITY && (entity = ((EntityHitResult)crosshairTarget).getEntity()) instanceof ItemFrame) {
                ItemFrame itemFrame = (ItemFrame)entity;
                BlockPos attachedPos = itemFrame.getPos().relative(itemFrame.getDirection().getOpposite());
                if (!player.isShiftKeyDown() && ModHelpers.isClickableBlockAt(attachedPos, world)) {
                    return new BlockHitResult(crosshairTarget.getLocation(), itemFrame.getDirection(), attachedPos, false);
                }
            } else if (crosshairTarget instanceof BlockHitResult) {
                BlockHitResult blockHitResult = (BlockHitResult)crosshairTarget;
                BlockPos blockPos = blockHitResult.getBlockPos();
                BlockState state = world.getBlockState(blockPos);
                Block block = state.getBlock();
                if (block instanceof WallSignBlock) {
                    BlockPos attachedPos = blockPos.relative(((Direction)state.getValue((Property)WallSignBlock.FACING)).getOpposite());
                    if (!ModHelpers.isClickableBlockAt(attachedPos, world)) {
                        return crosshairTarget;
                    }
                    BlockEntity entity2 = world.getBlockEntity(blockPos);
                    if (!(entity2 instanceof SignBlockEntity)) {
                        return crosshairTarget;
                    }
                    Item item = player.getItemInHand(InteractionHand.MAIN_HAND).getItem();
                    if (item instanceof DyeItem || item == Items.GLOW_INK_SAC) {
                        if (ModConfig.get().sneaktodye) {
                            ClickThrough.isDyeOnSign = true;
                            if (!player.isShiftKeyDown()) {
                                return new BlockHitResult(crosshairTarget.getLocation(), blockHitResult.getDirection(), attachedPos, false);
                            }
                        }
                    } else if (!player.isShiftKeyDown()) {
                        return new BlockHitResult(crosshairTarget.getLocation(), blockHitResult.getDirection(), attachedPos, false);
                    }
                } else if (block instanceof WallBannerBlock) {
                    BlockPos attachedPos = blockPos.relative(((Direction)state.getValue((Property)WallBannerBlock.FACING)).getOpposite());
                    if (ModHelpers.isClickableBlockAt(attachedPos, world)) {
                        return new BlockHitResult(crosshairTarget.getLocation(), blockHitResult.getDirection(), attachedPos, false);
                    }
                } else if (ModHelpers.isLoaded("fastitemframes")) {
                    return FastItemFramesCompat.passthrough(block, state, blockPos, world, crosshairTarget, player);
                }
            }
        }
        return crosshairTarget;
    }
}

