/*
 * Decompiled with CFR 0.152.
 */
package com.choculaterie.gui;

import com.choculaterie.SaveManagerMod;
import com.choculaterie.gui.AccountLinkingScreen;
import com.choculaterie.network.NetworkManager;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.Key;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_4264;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_526;

@Environment(value=EnvType.CLIENT)
public class CloudSaveManagerScreen
extends class_437 {
    private final class_437 parent;
    private final NetworkManager networkManager = new NetworkManager();
    private boolean firstRenderLogged = false;
    private boolean loading = true;
    private String status = "Loading...";
    private String quotaLine = "";
    private final List<SaveItem> saves = new ArrayList<SaveItem>();
    private int currentPage = 0;
    private static final int PAGE_SIZE = 6;
    private class_4185 backBtn;
    private class_4185 refreshBtn;
    private class_4185 prevBtn;
    private class_4185 nextBtn;
    private class_4185 settingsBtn;
    private class_4185 downloadBtn;
    private class_4185 deleteBtn;
    private int selectedIndex = -1;
    private static final int COL_WORLD_W = 260;
    private static final int COL_SIZE_W = 80;
    private static final int COL_CREATED_W = 120;
    private static final int COL_UPDATED_W = 140;
    private static final ActiveOp ACTIVE = new ActiveOp();
    private static final long QUOTA_LIMIT_BYTES = 0x140000000L;
    private final List<class_4264> rowHitBoxes = new ArrayList<class_4264>();

    private static boolean sm$isOpActive() {
        return CloudSaveManagerScreen.ACTIVE.dlActive || CloudSaveManagerScreen.ACTIVE.unzipActive;
    }

    public CloudSaveManagerScreen(class_437 parent) {
        super((class_2561)class_2561.method_43470((String)"Choculaterie Cloud Saves"));
        this.parent = parent;
    }

    protected void method_25426() {
        int cx = this.field_22789 / 2;
        int topY = this.field_22790 / 4;
        int bottomY = this.field_22790 - 28;
        this.backBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2190"), b -> {
            if (this.field_22787 != null) {
                class_437 rootParent = CloudSaveManagerScreen.sm$resolveWorldRootParent(this.parent);
                this.field_22787.method_1507((class_437)new class_526(rootParent));
            }
        }).method_46434(10, 10, 20, 20).method_46431();
        this.method_37063((class_364)this.backBtn);
        this.refreshBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\ud83d\udd04"), b -> {
            this.selectedIndex = -1;
            this.fetchList();
        }).method_46434(35, 10, 20, 20).method_46431();
        this.method_37063((class_364)this.refreshBtn);
        int btnSize = 20;
        int margin = 6;
        this.settingsBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2699"), b -> {
            if (this.field_22787 != null) {
                class_437 rootParent = CloudSaveManagerScreen.sm$resolveWorldRootParent(this.parent);
                this.field_22787.method_1507((class_437)new AccountLinkingScreen(rootParent));
            }
        }).method_46434(this.field_22789 - margin - btnSize, margin, btnSize, btnSize).method_46431();
        this.method_37063((class_364)this.settingsBtn);
        this.prevBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"<"), b -> {
            if (this.currentPage > 0) {
                --this.currentPage;
                this.selectedIndex = -1;
                this.method_41843();
            }
        }).method_46434(this.field_22789 - 55, bottomY, 20, 20).method_46431();
        this.method_37063((class_364)this.prevBtn);
        this.nextBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)">"), b -> {
            if ((this.currentPage + 1) * 6 < this.saves.size()) {
                ++this.currentPage;
                this.selectedIndex = -1;
                this.method_41843();
            }
        }).method_46434(this.field_22789 - 30, bottomY, 20, 20).method_46431();
        this.method_37063((class_364)this.nextBtn);
        this.downloadBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Download"), b -> {
            SaveItem s = this.getSelected();
            if (s != null) {
                this.onDownload(s);
            }
        }).method_46434(cx - 110, bottomY, 100, 20).method_46431();
        this.method_37063((class_364)this.downloadBtn);
        this.deleteBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Delete"), b -> {
            SaveItem s = this.getSelected();
            if (s != null) {
                this.confirmDelete(s);
            }
        }).method_46434(cx + 10, bottomY, 100, 20).method_46431();
        this.method_37063((class_364)this.deleteBtn);
        String apiKey = this.loadApiKeyFromDisk();
        if (apiKey == null || apiKey.isBlank()) {
            this.loading = false;
            this.status = "No API key configured";
        } else {
            this.networkManager.setApiKey(apiKey);
            if (this.saves.isEmpty()) {
                this.fetchList();
            }
        }
        this.buildRowHitBoxes();
        this.rebuildPagerState();
        this.updateActionButtons();
    }

    public void method_25410(class_310 client, int width, int height) {
        super.method_25410(client, width, height);
        this.method_41843();
    }

    private static boolean sm$isInvalidKey(String raw, String friendly) {
        String r = (raw == null ? "" : raw).toLowerCase(Locale.ROOT);
        if (friendly != null && friendly.equalsIgnoreCase("Invalid Save Manager API key")) {
            return true;
        }
        return r.contains("401") && r.contains("invalid save manager api key");
    }

    private void fetchList() {
        this.loading = true;
        this.status = "Loading...";
        this.updateActionButtons();
        SaveManagerMod.LOGGER.info("CloudSaveManager: fetchList() start");
        this.networkManager.listWorldSaves().whenComplete((json, err) -> {
            block23: {
                if (json != null) {
                    try {
                        String pretty = new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)json);
                        if (pretty.length() > 2000) {
                            SaveManagerMod.LOGGER.info("CloudSaveManager: list response (truncated, totalLen={}) : {}", (Object)pretty.length(), (Object)(pretty.substring(0, 2000) + "...(truncated)"));
                            break block23;
                        }
                        SaveManagerMod.LOGGER.info("CloudSaveManager: list response: {}", (Object)pretty);
                    }
                    catch (Throwable logEx) {
                        try {
                            SaveManagerMod.LOGGER.info("CloudSaveManager: list response (raw): {}", (Object)json.toString());
                        }
                        catch (Throwable throwable) {}
                    }
                } else {
                    SaveManagerMod.LOGGER.info("CloudSaveManager: list response is null");
                }
            }
            if (err != null) {
                SaveManagerMod.LOGGER.error("CloudSaveManager: list failed", err);
                String raw = CloudSaveManagerScreen.sm$rawFromThrowable(err);
                this.runOnClient(() -> {
                    this.loading = false;
                    this.status = "List failed";
                    this.saves.clear();
                    this.quotaLine = "";
                    this.selectedIndex = -1;
                    this.buildRowHitBoxes();
                    this.rebuildPagerState();
                    this.updateActionButtons();
                    this.sm$showErrorDialog(raw, "List failed");
                });
                return;
            }
            ArrayList<SaveItem> tmp = new ArrayList<SaveItem>();
            String newQuota = "";
            try {
                JsonArray arr = CloudSaveManagerScreen.sm$findArray(json, "saves", "items", "data", "list", "worlds");
                if (newQuota.isEmpty()) {
                    newQuota = this.sm$parseQuota((JsonObject)json);
                }
                if (arr == null && json.has("result") && json.get("result").isJsonObject()) {
                    JsonObject result = json.getAsJsonObject("result");
                    if (newQuota.isEmpty()) {
                        newQuota = this.sm$parseQuota(result);
                    }
                    arr = CloudSaveManagerScreen.sm$findArray(result, "saves", "items", "data", "list", "worlds");
                }
                if (arr == null && json.has("meta") && json.get("meta").isJsonObject()) {
                    JsonObject meta = json.getAsJsonObject("meta");
                    if (newQuota.isEmpty()) {
                        newQuota = this.sm$parseQuota(meta);
                    }
                    if (arr == null) {
                        arr = CloudSaveManagerScreen.sm$findArray(meta, "saves", "items", "data", "list", "worlds");
                    }
                }
                if (arr == null) {
                    for (Map.Entry e : json.entrySet()) {
                        if (e.getValue() != null && ((JsonElement)e.getValue()).isJsonArray()) {
                            arr = ((JsonElement)e.getValue()).getAsJsonArray();
                            break;
                        }
                        if (e.getValue() != null && ((JsonElement)e.getValue()).isJsonObject() && arr == null) {
                            for (Map.Entry e2 : ((JsonElement)e.getValue()).getAsJsonObject().entrySet()) {
                                if (e2.getValue() == null || !((JsonElement)e2.getValue()).isJsonArray()) continue;
                                arr = ((JsonElement)e2.getValue()).getAsJsonArray();
                                break;
                            }
                        }
                        if (arr == null) continue;
                        break;
                    }
                }
                if (arr != null) {
                    for (int i = 0; i < arr.size(); ++i) {
                        if (!arr.get(i).isJsonObject()) continue;
                        tmp.add(SaveItem.from(arr.get(i).getAsJsonObject()));
                    }
                }
            }
            catch (Throwable parseEx) {
                SaveManagerMod.LOGGER.error("CloudSaveManager: parse error", parseEx);
                newQuota = "";
            }
            String quotaOut = newQuota;
            this.runOnClient(() -> {
                this.saves.clear();
                this.saves.addAll(tmp);
                this.loading = false;
                this.status = tmp.isEmpty() ? "No saves found" : "";
                this.quotaLine = quotaOut == null ? "" : quotaOut;
                this.selectedIndex = -1;
                this.buildRowHitBoxes();
                this.rebuildPagerState();
                this.updateActionButtons();
            });
        });
    }

    private static JsonArray sm$findArray(JsonObject obj, String ... names) {
        for (String n : names) {
            JsonElement e;
            if (!obj.has(n) || (e = obj.get(n)) == null) continue;
            if (e.isJsonArray()) {
                return e.getAsJsonArray();
            }
            if (!e.isJsonObject()) continue;
            JsonObject o = e.getAsJsonObject();
            if (o.has("items") && o.get("items").isJsonArray()) {
                return o.getAsJsonArray("items");
            }
            if (!o.has("saves") || !o.get("saves").isJsonArray()) continue;
            return o.getAsJsonArray("saves");
        }
        return null;
    }

    private static String sm$getString(JsonObject obj, String ... names) {
        for (String n : names) {
            JsonElement first;
            JsonElement e;
            if (!obj.has(n) || (e = obj.get(n)) == null || e.isJsonNull()) continue;
            if (e.isJsonPrimitive()) {
                JsonPrimitive p = e.getAsJsonPrimitive();
                if (p.isString()) {
                    return p.getAsString();
                }
                if (p.isNumber()) {
                    return String.valueOf(p.getAsLong());
                }
                if (!p.isBoolean()) continue;
                return String.valueOf(p.getAsBoolean());
            }
            if (e.isJsonObject()) {
                String s;
                JsonObject o = e.getAsJsonObject();
                if (o.has("text") && !(s = CloudSaveManagerScreen.sm$getString(o, "text")).isEmpty()) {
                    return s;
                }
                if (o.has("value") && !(s = CloudSaveManagerScreen.sm$getString(o, "value")).isEmpty()) {
                    return s;
                }
                if (!o.has("iso") || (s = CloudSaveManagerScreen.sm$getString(o, "iso")).isEmpty()) continue;
                return s;
            }
            if (!e.isJsonArray() || e.getAsJsonArray().size() <= 0 || !(first = e.getAsJsonArray().get(0)).isJsonPrimitive() || !first.getAsJsonPrimitive().isString()) continue;
            return first.getAsString();
        }
        return "";
    }

    private static long sm$getLong(JsonObject obj, String ... names) {
        for (String n : names) {
            JsonElement first;
            JsonObject o;
            long v;
            JsonElement e;
            block9: {
                if (!obj.has(n) || (e = obj.get(n)) == null || e.isJsonNull()) continue;
                if (e.isJsonPrimitive()) {
                    JsonPrimitive p = e.getAsJsonPrimitive();
                    if (p.isNumber()) {
                        return p.getAsLong();
                    }
                    if (p.isString()) {
                        String s = p.getAsString();
                        String digits = s.replaceAll("[_,\\s]", "");
                        try {
                            return Long.parseLong(digits);
                        }
                        catch (NumberFormatException ex) {
                            String only = digits.replaceAll("[^0-9-]", "");
                            if (only.isEmpty()) break block9;
                            try {
                                return Long.parseLong(only);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
            if (e.isJsonObject() && (v = CloudSaveManagerScreen.sm$getLong(o = e.getAsJsonObject(), "bytes", "value", "size", "sizeBytes", "length", "amount")) != 0L) {
                return v;
            }
            if (!e.isJsonArray() || e.getAsJsonArray().size() <= 0 || !(first = e.getAsJsonArray().get(0)).isJsonPrimitive() || !first.getAsJsonPrimitive().isNumber()) continue;
            return first.getAsLong();
        }
        return 0L;
    }

    private String sm$parseQuota(JsonObject obj) {
        long total;
        long used;
        JsonObject q;
        String direct = CloudSaveManagerScreen.sm$getString(obj, "quotaLine", "quotaText", "storageText");
        if (!direct.isEmpty()) {
            return direct;
        }
        if (obj.has("quota") && obj.get("quota").isJsonObject()) {
            q = obj.getAsJsonObject("quota");
            used = CloudSaveManagerScreen.sm$getLong(q, "usedBytes", "used", "usageBytes", "bytesUsed", "current");
            total = CloudSaveManagerScreen.sm$getLong(q, "totalBytes", "limitBytes", "total", "capacityBytes", "maxBytes", "limit");
            if (used == 0L && q.has("used") && q.get("used").isJsonObject()) {
                used = CloudSaveManagerScreen.sm$getLong(q.getAsJsonObject("used"), "bytes", "value");
            }
            if (total == 0L && q.has("total") && q.get("total").isJsonObject()) {
                total = CloudSaveManagerScreen.sm$getLong(q.getAsJsonObject("total"), "bytes", "value", "limitBytes");
            }
            if (used > 0L || total > 0L) {
                return "Used " + CloudSaveManagerScreen.formatBytes(used) + " of " + (total > 0L ? CloudSaveManagerScreen.formatBytes(total) : "?");
            }
        }
        if (obj.has("usage") && obj.get("usage").isJsonObject()) {
            q = obj.getAsJsonObject("usage");
            used = CloudSaveManagerScreen.sm$getLong(q, "usedBytes", "used", "bytesUsed", "current");
            total = CloudSaveManagerScreen.sm$getLong(q, "totalBytes", "limitBytes", "total", "capacityBytes", "maxBytes", "limit");
            if (used > 0L || total > 0L) {
                return "Used " + CloudSaveManagerScreen.formatBytes(used) + " of " + (total > 0L ? CloudSaveManagerScreen.formatBytes(total) : "?");
            }
        }
        return "";
    }

    private void rebuildPagerState() {
        boolean allowPager;
        boolean bl = allowPager = !this.loading || CloudSaveManagerScreen.sm$isOpActive();
        if (this.prevBtn != null) {
            boolean bl2 = this.prevBtn.field_22763 = this.currentPage > 0 && allowPager;
        }
        if (this.nextBtn != null) {
            this.nextBtn.field_22763 = (this.currentPage + 1) * 6 < this.saves.size() && allowPager;
        }
    }

    private SaveItem getSelected() {
        if (this.selectedIndex < 0 || this.selectedIndex >= this.saves.size()) {
            return null;
        }
        return this.saves.get(this.selectedIndex);
    }

    private void updateActionButtons() {
        boolean enabled;
        boolean bl = enabled = this.getSelected() != null && !this.loading && !CloudSaveManagerScreen.sm$isOpActive();
        if (this.downloadBtn != null) {
            this.downloadBtn.field_22763 = enabled;
        }
        if (this.deleteBtn != null) {
            this.deleteBtn.field_22763 = enabled;
        }
    }

    private void buildRowHitBoxes() {
        for (class_4264 w : this.rowHitBoxes) {
            try {
                this.method_37066((class_364)w);
            }
            catch (Throwable throwable) {}
        }
        this.rowHitBoxes.clear();
        Geometry g = this.computeGeometry();
        int start = this.currentPage * 6;
        int end = Math.min(start + 6, this.saves.size());
        for (int i = start; i < end; ++i) {
            int globalIndex = i;
            int ry = g.rowStartY + (i - start) * g.rowHeight;
            class_4185 hit = class_4185.method_46430((class_2561)class_2561.method_43470((String)""), b -> {
                this.selectedIndex = globalIndex;
                if (!this.loading && !CloudSaveManagerScreen.sm$isOpActive()) {
                    this.status = "";
                }
                this.updateActionButtons();
            }).method_46434(g.listX, ry - 4, g.listW, g.rowHeight).method_46431();
            try {
                hit.method_25350(0.0f);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            hit.field_22764 = true;
            hit.field_22763 = true;
            this.method_37063((class_364)hit);
            this.rowHitBoxes.add((class_4264)hit);
        }
    }

    private void confirmDelete(SaveItem s) {
        class_5250 title = class_2561.method_43470((String)"Delete Cloud Save");
        class_5250 message = class_2561.method_43470((String)("Are you sure you want to permanently delete \"" + CloudSaveManagerScreen.safe(s.worldName) + "\"?"));
        this.field_22787.method_1507((class_437)new class_410(confirmed -> {
            if (!confirmed) {
                this.field_22787.method_1507((class_437)this);
                return;
            }
            this.loading = true;
            this.status = "Deleting...";
            this.updateActionButtons();
            this.networkManager.deleteWorldSave(s.id).whenComplete((resp, err) -> this.runOnClient(() -> {
                if (err != null) {
                    SaveManagerMod.LOGGER.error("Delete failed", err);
                    this.status = "Delete failed";
                    this.loading = false;
                    this.field_22787.method_1507((class_437)this);
                    return;
                }
                this.status = "Deleted";
                this.loading = false;
                this.selectedIndex = -1;
                this.fetchList();
                this.field_22787.method_1507((class_437)this);
            }));
        }, (class_2561)title, (class_2561)message));
    }

    private void onDownload(SaveItem s) {
        Path tmpDir;
        this.loading = true;
        this.status = "Preparing...";
        this.updateActionButtons();
        Path savesDir = this.field_22787.field_1697.toPath().resolve("saves");
        try {
            Files.createDirectories(savesDir, new FileAttribute[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            tmpDir = Files.createTempDirectory("savemanager-dl-", new FileAttribute[0]);
        }
        catch (Exception e) {
            SaveManagerMod.LOGGER.error("CloudSaveManager: temp dir error", (Throwable)e);
            this.status = "Failed to prepare temp dir";
            this.loading = false;
            this.updateActionButtons();
            return;
        }
        CloudSaveManagerScreen.ACTIVE.dlActive = true;
        CloudSaveManagerScreen.ACTIVE.unzipActive = false;
        CloudSaveManagerScreen.ACTIVE.downloaded = 0L;
        CloudSaveManagerScreen.ACTIVE.total = -1L;
        CloudSaveManagerScreen.ACTIVE.lastTickNanos = CloudSaveManagerScreen.ACTIVE.startNanos = System.nanoTime();
        CloudSaveManagerScreen.ACTIVE.lastBytes = 0L;
        CloudSaveManagerScreen.ACTIVE.speedBps = 0.0;
        long fallbackTotal = s != null && s.fileSizeBytes > 0L ? s.fileSizeBytes : -1L;
        this.networkManager.downloadWorldSave(s.id, tmpDir, (downloaded, total) -> {
            long effTotal = total > 0L ? total : fallbackTotal;
            CloudSaveManagerScreen.ACTIVE.downloaded = Math.max(0L, downloaded);
            if (effTotal > 0L) {
                CloudSaveManagerScreen.ACTIVE.total = effTotal;
            }
            long now = System.nanoTime();
            long dtNs = now - CloudSaveManagerScreen.ACTIVE.lastTickNanos;
            long dBytes = CloudSaveManagerScreen.ACTIVE.downloaded - CloudSaveManagerScreen.ACTIVE.lastBytes;
            if (dtNs > 50000000L) {
                double instBps = dBytes > 0L ? (double)dBytes * 1.0E9 / (double)dtNs : 0.0;
                double alpha = 0.2;
                CloudSaveManagerScreen.ACTIVE.speedBps = CloudSaveManagerScreen.ACTIVE.speedBps <= 0.0 ? instBps : alpha * instBps + (1.0 - alpha) * CloudSaveManagerScreen.ACTIVE.speedBps;
                CloudSaveManagerScreen.ACTIVE.lastTickNanos = now;
                CloudSaveManagerScreen.ACTIVE.lastBytes = CloudSaveManagerScreen.ACTIVE.downloaded;
            }
            this.runOnClient(this::updateActionButtons);
        }).whenComplete((zipPath, err) -> {
            CloudSaveManagerScreen.ACTIVE.dlActive = false;
            if (err != null) {
                SaveManagerMod.LOGGER.error("CloudSaveManager: download failed", err);
                String raw = CloudSaveManagerScreen.sm$rawFromThrowable(err);
                this.runOnClient(() -> {
                    this.status = "Download failed";
                    this.loading = false;
                    this.updateActionButtons();
                    this.sm$showErrorDialog(raw, "Download failed");
                });
                return;
            }
            this.runOnClient(() -> {
                CloudSaveManagerScreen.ACTIVE.unzipActive = true;
                this.status = "Unzipping...";
            });
            String baseName = CloudSaveManagerScreen.sanitizeFolderName(s.worldName);
            if (baseName.isEmpty()) {
                baseName = CloudSaveManagerScreen.stripExtSafe(zipPath.getFileName().toString(), "world");
            }
            Path targetBase = CloudSaveManagerScreen.ensureUniqueDir(savesDir, baseName);
            String tmpEndMsg = "";
            try {
                Files.createDirectories(targetBase, new FileAttribute[0]);
                CloudSaveManagerScreen.unzipSmart(zipPath, targetBase);
            }
            catch (Exception ex) {
                SaveManagerMod.LOGGER.error("CloudSaveManager: unzip failed", (Throwable)ex);
                tmpEndMsg = "Unzip failed";
            }
            finally {
                try {
                    Files.deleteIfExists(zipPath);
                }
                catch (Exception ex) {}
                try {
                    Files.deleteIfExists(tmpDir);
                }
                catch (Exception ex) {}
            }
            String endMsg = tmpEndMsg;
            this.runOnClient(() -> {
                CloudSaveManagerScreen.ACTIVE.unzipActive = false;
                this.status = endMsg;
                this.loading = false;
                this.updateActionButtons();
            });
        });
    }

    private static void unzipSmart(Path zipFile, Path targetBase) throws Exception {
        String root = CloudSaveManagerScreen.detectSingleRootDir(zipFile);
        try (ZipInputStream zis = new ZipInputStream(Files.newInputStream(zipFile, new OpenOption[0]));){
            ZipEntry e;
            while ((e = zis.getNextEntry()) != null) {
                if (e.isDirectory()) continue;
                String name = e.getName().replace('\\', '/');
                if (root != null && name.startsWith(root + "/")) {
                    name = name.substring(root.length() + 1);
                }
                if (name.isBlank()) continue;
                Path out = CloudSaveManagerScreen.safeResolve(targetBase, name);
                Files.createDirectories(out.getParent(), new FileAttribute[0]);
                Files.copy(zis, out, StandardCopyOption.REPLACE_EXISTING);
                zis.closeEntry();
            }
        }
    }

    private static String detectSingleRootDir(Path zipFile) throws Exception {
        try (ZipFile zf = new ZipFile(zipFile.toFile());){
            String root = null;
            Enumeration<? extends ZipEntry> en = zf.entries();
            while (en.hasMoreElements()) {
                ZipEntry e = en.nextElement();
                String name = e.getName().replace('\\', '/');
                if (name.isBlank()) continue;
                String top = name.split("/", 2)[0];
                if (top.isBlank()) {
                    String string = null;
                    return string;
                }
                if (root == null) {
                    root = top;
                    continue;
                }
                if (root.equals(top)) continue;
                String string = null;
                return string;
            }
            String string = root;
            return string;
        }
    }

    private static Path safeResolve(Path base, String entryName) {
        Path out = base.resolve(entryName).normalize();
        if (!out.startsWith(base)) {
            throw new IllegalArgumentException("Blocked suspicious zip entry: " + entryName);
        }
        return out;
    }

    private static String sanitizeFolderName(String s) {
        if (s == null) {
            return "";
        }
        String clean = s.trim().replaceAll("[\\\\/:*?\"<>|]+", "_");
        return clean.isBlank() ? "" : clean;
    }

    private static String stripExtSafe(String name, String fallback) {
        int i = name.lastIndexOf(46);
        String base = i > 0 ? name.substring(0, i) : name;
        base = CloudSaveManagerScreen.sanitizeFolderName(base);
        return base.isBlank() ? fallback : base;
    }

    private static Path ensureUniqueDir(Path parent, String baseName) {
        Path p = parent.resolve(baseName);
        if (!Files.exists(p, new LinkOption[0])) {
            return p;
        }
        int idx = 1;
        Path cand;
        while (Files.exists(cand = parent.resolve(baseName + "-" + idx), new LinkOption[0])) {
            ++idx;
        }
        return cand;
    }

    private void runOnClient(Runnable r) {
        if (this.field_22787 != null) {
            this.field_22787.execute(r);
        }
    }

    public void method_25394(class_332 ctx, int mouseX, int mouseY, float delta) {
        super.method_25394(ctx, mouseX, mouseY, delta);
        try {
            ctx.method_44380();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        int cx = this.field_22789 / 2;
        int top = this.field_22790 / 4;
        ctx.method_27534(this.field_22793, this.field_22785, cx, 10, -1);
        ctx.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)this.sm$quotaLineComputed()), cx, 22, -5592406);
        Geometry g = this.computeGeometry();
        int col1 = g.listX();
        int col2 = col1 + 260;
        int col3 = col2 + 80;
        int col4 = col3 + 120;
        int headerY = this.field_22790 / 4 + 10;
        this.drawColText(ctx, "World", col1, headerY, -1);
        this.drawColText(ctx, "Size", col2, headerY, -1);
        this.drawColText(ctx, "Created", col3, headerY, -1);
        this.drawColText(ctx, "Updated", col4, headerY, -1);
        ctx.method_44379(g.listX(), g.listY(), g.listX() + g.listW(), g.listY() + g.listH());
        int start = this.currentPage * 6;
        int end = Math.min(start + 6, this.saves.size());
        for (int i = start; i < end; ++i) {
            SaveItem s = this.saves.get(i);
            int ry = g.rowStartY() + (i - start) * g.rowHeight();
            if (i == this.selectedIndex) {
                int h = Math.max(1, g.rowHeight() - 4);
                int x1 = g.listX();
                int x2 = g.listX() + g.listW();
                ctx.method_25294(x1, ry - 4, x2, ry - 1 + h, 0x66FFFFFF);
            }
            this.drawColText(ctx, CloudSaveManagerScreen.safe(s.worldName), col1, ry, -2236963);
            this.drawColText(ctx, CloudSaveManagerScreen.formatBytes(s.fileSizeBytes), col2, ry, -2236963);
            this.drawColText(ctx, CloudSaveManagerScreen.shortDate(s.createdAt), col3, ry, -2236963);
            this.drawColText(ctx, CloudSaveManagerScreen.shortDate(s.updatedAt), col4, ry, -2236963);
            ctx.method_25294(g.listX(), ry + g.rowHeight() - 5, g.listX() + g.listW(), ry + g.rowHeight() - 4, 0x22FFFFFF);
        }
        ctx.method_44380();
        boolean opActive = CloudSaveManagerScreen.sm$isOpActive();
        boolean unzipActiveV = CloudSaveManagerScreen.ACTIVE.unzipActive;
        long dlDownloadedV = CloudSaveManagerScreen.ACTIVE.downloaded;
        long dlTotalV = CloudSaveManagerScreen.ACTIVE.total;
        double speedV = CloudSaveManagerScreen.ACTIVE.speedBps;
        int baseStatusY = this.field_22790 - 56;
        int statusY = opActive ? baseStatusY - 16 : baseStatusY;
        String displayStatus = this.status;
        if (opActive) {
            String string = unzipActiveV ? "Unzipping..." : (displayStatus = dlDownloadedV <= 0L ? "Preparing..." : "");
        }
        if (this.loading || displayStatus != null && !displayStatus.isEmpty()) {
            ctx.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)displayStatus), cx, statusY, -1);
        }
        if (opActive) {
            if (unzipActiveV || dlDownloadedV <= 0L) {
                int radius = 8;
                int dots = 12;
                int cx0 = this.field_22789 / 2;
                int cy0 = statusY + 24;
                long t = System.currentTimeMillis();
                int head = (int)(t / 100L % (long)dots);
                for (int i = 0; i < dots; ++i) {
                    double ang = Math.PI * 2 * (double)i / (double)dots;
                    int dx = (int)Math.round(Math.cos(ang) * (double)radius);
                    int dy = (int)Math.round(Math.sin(ang) * (double)radius);
                    int x = cx0 + dx;
                    int y = cy0 + dy;
                    int dist = (i - head + dots) % dots;
                    int alpha = switch (dist) {
                        case 0 -> 255;
                        case 1 -> 204;
                        case 2 -> 153;
                        case 3 -> 102;
                        default -> 51;
                    };
                    int col = alpha << 24 | 0xCCCCCC;
                    ctx.method_25294(x - 1, y - 1, x + 2, y + 2, col);
                }
            } else {
                int barW = 360;
                int barH = 8;
                int bx = cx - barW / 2;
                int by = statusY + 14;
                ctx.method_25294(bx, by, bx + barW, by + barH, -12303292);
                double frac = dlTotalV > 0L ? Math.min(1.0, (double)dlDownloadedV / (double)dlTotalV) : 0.0;
                int filled = (int)((double)barW * frac);
                ctx.method_25294(bx, by, bx + filled, by + barH, -3355444);
                if (dlTotalV > 0L) {
                    int pct = (int)Math.min(100.0, Math.floor((double)dlDownloadedV * 100.0 / (double)dlTotalV));
                    ctx.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)(pct + "%")), cx, by - 10, -1);
                    String info = CloudSaveManagerScreen.formatBytes(dlDownloadedV) + " / " + CloudSaveManagerScreen.formatBytes(dlTotalV);
                    if (speedV > 1.0) {
                        String sp = CloudSaveManagerScreen.formatBytes((long)speedV) + "/s";
                        long remaining = Math.max(0L, dlTotalV - dlDownloadedV);
                        long etaSec = Math.max(0L, (long)Math.ceil((double)remaining / Math.max(1.0, speedV)));
                        info = info + " \u2022 " + sp + " \u2022 ETA " + CloudSaveManagerScreen.formatDurationShort(etaSec);
                    }
                    ctx.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)info), cx, by + barH + 2, -3355444);
                }
            }
        }
        this.rebuildPagerState();
        this.updateActionButtons();
        if (!this.firstRenderLogged) {
            this.firstRenderLogged = true;
            SaveManagerMod.LOGGER.info("CloudSaveManager: first render; saves={}, page={}", (Object)this.saves.size(), (Object)this.currentPage);
        }
    }

    private static String formatDurationShort(long seconds) {
        if (seconds <= 0L) {
            return "0s";
        }
        long h = seconds / 3600L;
        long m = seconds % 3600L / 60L;
        long s = seconds % 60L;
        if (h > 0L) {
            return String.format("%dh %02dm", h, m);
        }
        if (m > 0L) {
            return String.format("%dm %02ds", m, s);
        }
        return String.format("%ds", s);
    }

    private String sm$quotaLineComputed() {
        long used = this.sm$sumUsedBytes();
        long left = Math.max(0L, 0x140000000L - used);
        String usedStr = CloudSaveManagerScreen.sm$formatBytesFloor(used);
        String leftStr = CloudSaveManagerScreen.sm$formatBytesFloor(left);
        return String.format("%s of 5 GB (%s left)", usedStr, leftStr);
    }

    private static String sm$formatBytesFloor(long bytes) {
        String unit;
        double value;
        if (bytes < 0L) {
            bytes = 0L;
        }
        long KB = 1024L;
        long MB = 0x100000L;
        long GB = 0x40000000L;
        long TB = 0x10000000000L;
        if (bytes >= 0x10000000000L) {
            value = (double)bytes / 1.099511627776E12;
            unit = "TB";
        } else if (bytes >= 0x40000000L) {
            value = (double)bytes / 1.073741824E9;
            unit = "GB";
        } else if (bytes >= 0x100000L) {
            value = (double)bytes / 1048576.0;
            unit = "MB";
        } else if (bytes >= 1024L) {
            value = (double)bytes / 1024.0;
            unit = "KB";
        } else {
            return bytes + " B";
        }
        double floored = Math.floor(value * 10.0) / 10.0;
        if (floored >= 100.0 || Math.abs(floored - Math.rint(floored)) < 1.0E-9) {
            return String.format("%.0f %s", floored, unit);
        }
        return String.format("%.1f %s", floored, unit);
    }

    private long sm$sumUsedBytes() {
        long sum = 0L;
        for (SaveItem s : this.saves) {
            if (s == null) continue;
            sum += Math.max(0L, s.fileSizeBytes);
        }
        return sum;
    }

    private Geometry computeGeometry() {
        int cx = this.field_22789 / 2;
        int top = this.field_22790 / 4;
        int headerY = top + 10;
        int rowStartY = headerY + 20;
        int rowHeight = 22;
        int start = this.currentPage * 6;
        int end = Math.min(start + 6, this.saves.size());
        int visible = Math.max(0, end - start);
        int contentW = 600;
        int listX = Math.max(0, cx - contentW / 2);
        int listY = rowStartY - 10;
        int listW = contentW;
        int listH = Math.max(visible * rowHeight, rowHeight) + 12;
        return new Geometry(listX, listY, listW, listH, rowStartY, rowHeight);
    }

    private void drawColText(class_332 ctx, String s, int x, int y, int color) {
        ctx.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)s), x, y, color);
    }

    private static String safe(String s) {
        return s == null ? "" : s;
    }

    private static String formatBytes(long n) {
        if (n < 1024L) {
            return n + " B";
        }
        int u = -1;
        double d = n;
        String[] units = new String[]{"KB", "MB", "GB", "TB"};
        while ((d /= 1024.0) >= 1024.0 && ++u < units.length - 1) {
        }
        return String.format(Locale.ROOT, "%.1f %s", d, units[u]);
    }

    private static String shortDate(String iso) {
        if (iso == null) {
            return "";
        }
        int t = iso.indexOf(84);
        return t > 0 ? iso.substring(0, t) : iso;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String loadApiKeyFromDisk() {
        try {
            class_310 mc = class_310.method_1551();
            if (mc == null) {
                return null;
            }
            File configDir = new File(mc.field_1697, "config");
            File configFile = new File(configDir, "save-manager-settings.json");
            if (!configFile.exists()) {
                return null;
            }
            try (FileReader reader = new FileReader(configFile);){
                JsonObject json = (JsonObject)new Gson().fromJson((Reader)reader, JsonObject.class);
                if (json == null) {
                    String string = null;
                    return string;
                }
                if (json.has("encryptedApiToken")) {
                    String string = this.decrypt(json.get("encryptedApiToken").getAsString());
                    return string;
                }
                if (!json.has("apiToken")) return null;
                String string = json.get("apiToken").getAsString();
                return string;
            }
        }
        catch (Exception e) {
            SaveManagerMod.LOGGER.error("Error loading API key", (Throwable)e);
        }
        return null;
    }

    private String decrypt(String base64) throws Exception {
        byte[] data = Base64.getDecoder().decode(base64);
        if (data.length < 28) {
            throw new IllegalArgumentException("Invalid data");
        }
        byte[] iv = new byte[12];
        byte[] ct = new byte[data.length - 12];
        System.arraycopy(data, 0, iv, 0, 12);
        System.arraycopy(data, 12, ct, 0, ct.length);
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        SecretKeySpec keySpec = new SecretKeySpec(MessageDigest.getInstance("SHA-256").digest("SaveManagerSecKey.v1".getBytes(StandardCharsets.UTF_8)), "AES");
        cipher.init(2, (Key)keySpec, new GCMParameterSpec(128, iv));
        byte[] pt = cipher.doFinal(ct);
        return new String(pt, StandardCharsets.UTF_8);
    }

    private static class_437 sm$resolveWorldRootParent(class_437 parent) {
        class_437 p = parent;
        int guard = 0;
        while (p instanceof class_526 && guard++ < 8) {
            try {
                Field f = class_526.class.getDeclaredField("parent");
                f.setAccessible(true);
                class_437 next = (class_437)f.get(p);
                if (next == null || next == p) break;
                p = next;
            }
            catch (Throwable ignored) {
                break;
            }
        }
        return p;
    }

    private static String sm$rawFromThrowable(Throwable t) {
        if (t == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int guard = 0;
        while (t != null && guard++ < 16) {
            String m = t.getMessage();
            if (m != null && !m.isBlank()) {
                if (sb.length() > 0) {
                    sb.append(" | ");
                }
                sb.append(m);
            }
            t = t.getCause();
        }
        return sb.toString();
    }

    private static String sm$extractFriendly(String raw) {
        int i;
        if (raw == null) {
            raw = "";
        }
        String friendly = "";
        int start = raw.indexOf(123);
        while (start >= 0 && start < raw.length()) {
            try {
                JsonObject obj;
                String sub = raw.substring(start).trim();
                JsonElement el = new JsonParser().parse(sub);
                if (el.isJsonObject() && (obj = el.getAsJsonObject()).has("error") && obj.get("error").isJsonPrimitive() && (friendly = obj.get("error").getAsString()) != null && !friendly.isBlank()) {
                    return friendly;
                }
            }
            catch (Throwable sub) {
                // empty catch block
            }
            start = raw.indexOf(123, start + 1);
        }
        if (raw.contains("401") && raw.toLowerCase(Locale.ROOT).contains("invalid save manager api key")) {
            return "Invalid Save Manager API key";
        }
        if (raw.toLowerCase(Locale.ROOT).contains("exceed storage quota") && (i = raw.indexOf(123)) >= 0) {
            try {
                String s;
                JsonObject obj = new JsonParser().parse(raw.substring(i)).getAsJsonObject();
                if (obj.has("error") && (s = obj.get("error").getAsString()) != null && !s.isBlank()) {
                    return s;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return friendly;
    }

    private void sm$showErrorDialog(String raw, String fallbackTitle) {
        String friendly = CloudSaveManagerScreen.sm$extractFriendly(raw);
        class_5250 title = class_2561.method_43470((String)"Error");
        class_5250 message = class_2561.method_43470((String)(friendly == null || friendly.isBlank() ? fallbackTitle : friendly));
        boolean invalidKey = CloudSaveManagerScreen.sm$isInvalidKey(raw, friendly);
        this.field_22787.method_1507((class_437)new class_410(confirmed -> {
            if (!confirmed) {
                try {
                    if (this.field_22787 != null && this.field_22787.field_1774 != null) {
                        this.field_22787.field_1774.method_1455(raw == null ? "" : raw);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return;
            }
            if (invalidKey) {
                if (this.field_22787 != null) {
                    class_437 rootParent = CloudSaveManagerScreen.sm$resolveWorldRootParent(this.parent);
                    this.field_22787.method_1507((class_437)new AccountLinkingScreen(rootParent));
                }
                return;
            }
            if (this.field_22787 != null) {
                class_437 rootParent = CloudSaveManagerScreen.sm$resolveWorldRootParent(this.parent);
                this.field_22787.method_1507((class_437)new class_526(rootParent));
            }
        }, (class_2561)title, (class_2561)message, (class_2561)class_2561.method_43470((String)"OK"), (class_2561)class_2561.method_43470((String)"Copy error")));
    }

    @Environment(value=EnvType.CLIENT)
    private static final class ActiveOp {
        volatile boolean dlActive = false;
        volatile boolean unzipActive = false;
        volatile long downloaded = 0L;
        volatile long total = -1L;
        volatile long lastBytes = 0L;
        volatile long lastTickNanos = 0L;
        volatile long startNanos = 0L;
        volatile double speedBps = 0.0;

        private ActiveOp() {
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class SaveItem {
        String id;
        String worldName;
        long fileSizeBytes;
        String createdAt;
        String updatedAt;

        private SaveItem() {
        }

        static SaveItem from(JsonObject o) {
            long size;
            SaveItem s = new SaveItem();
            s.id = CloudSaveManagerScreen.sm$getString(o, "id", "saveId", "guid");
            s.worldName = CloudSaveManagerScreen.sm$getString(o, "worldName", "name", "world", "title");
            s.fileSizeBytes = size = CloudSaveManagerScreen.sm$getLong(o, "sizeBytes", "fileSizeBytes", "fileSize", "size", "bytes", "length");
            s.createdAt = CloudSaveManagerScreen.sm$getString(o, "createdAt", "created", "created_on", "createdOn");
            s.updatedAt = CloudSaveManagerScreen.sm$getString(o, "updatedAt", "updated", "updated_on", "lastModified", "modifiedOn");
            return s;
        }
    }

    @Environment(value=EnvType.CLIENT)
    private record Geometry(int listX, int listY, int listW, int listH, int rowStartY, int rowHeight) {
    }
}

