/*
 * Decompiled with CFR 0.152.
 */
package com.iamkaf.kafhud;

import com.iamkaf.kafhud.registry.Keybinds;
import com.iamkaf.kafhud.util.StringUtil;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4597;
import net.minecraft.class_5134;
import net.minecraft.class_5250;
import net.minecraft.class_6880;
import net.minecraft.class_746;
import net.minecraft.class_9779;
import org.jetbrains.annotations.NotNull;

public class KafHUDClient {
    public static final int WHITE = 0xFFFFFF;
    public static final int RED = 14366041;
    public static final int OUTLINE_COLOR = 729927;
    public static final int TRANSPARENT = -1;
    public static boolean enabled = true;

    public static void init() {
        Keybinds.init();
    }

    public static void onRenderHUD(class_332 guiGraphics, class_9779 deltaTracker) {
        class_310 mc = class_310.method_1551();
        if (mc.method_53526().method_53536()) {
            return;
        }
        if (mc.field_1690.field_1842) {
            return;
        }
        if (!enabled) {
            return;
        }
        class_327 textRenderer = mc.field_1772;
        class_746 player = mc.field_1724;
        int xPadding = 2;
        int yPadding = 2;
        int lineSpacing = 10;
        int xGlobalOffset = 1 + xPadding;
        int yOffset = 1 + yPadding;
        if (player == null) {
            return;
        }
        class_1937 level = player.method_37908();
        double x = player.method_23317();
        double y = player.method_23318();
        double z = player.method_23321();
        class_2350 direction = player.method_5735();
        String directionName = class_2561.method_43471((String)String.format("text.kafhud.direction.%s", direction.method_10151())).getString();
        class_6880 biome = level.method_23753(player.method_24515());
        String biomeNamespace = biome.method_55840().split(":")[0];
        String biomePath = biome.method_55840().split(":")[1];
        class_5250 coordinatesComponent = class_2561.method_43470((String)String.format("XYZ: %.1f / %.1f / %.1f", x, y, z));
        class_5250 directionComponent = class_2561.method_43470((String)String.format("(%s)", directionName));
        class_5250 biomeComponent = class_2561.method_43471((String)String.format("biome.%s.%s", biomeNamespace, biomePath));
        if (biomeComponent.getString().startsWith("biome.")) {
            biomeComponent = class_2561.method_43470((String)StringUtil.toReadableSentence(biomePath));
        }
        int coordinatesWidth = textRenderer.method_1727(coordinatesComponent.getString()) + 4;
        KafHUDClient.text(guiGraphics, textRenderer, (class_2561)coordinatesComponent, xGlobalOffset, yOffset, 0xFFFFFF, 729927);
        KafHUDClient.text(guiGraphics, textRenderer, (class_2561)directionComponent, xGlobalOffset + coordinatesWidth, yOffset, KafHUDClient.getDirectionColor(direction), 729927);
        KafHUDClient.text(guiGraphics, textRenderer, (class_2561)biomeComponent, xGlobalOffset, yOffset + lineSpacing, 0xFFFFFF, 729927);
    }

    private static int getDirectionColor(class_2350 direction) {
        return switch (direction) {
            case class_2350.field_11043 -> 4360181;
            case class_2350.field_11035 -> 16109122;
            case class_2350.field_11039 -> 10026925;
            case class_2350.field_11034 -> 15430569;
            default -> 0xFFFFFF;
        };
    }

    private static void text(class_332 context, class_327 font, class_2561 message, int x, int y, int color, int outlineColor) {
        if (outlineColor == -1) {
            context.method_51439(font, message, x, y, color, false);
            return;
        }
        class_4597.class_4598 buffers = class_310.method_1551().method_22940().method_23000();
        font.method_37296(message.method_30937(), (float)x, (float)y, color, outlineColor, context.method_51448().method_23760().method_23761(), (class_4597)buffers, 0xF000F0);
        context.method_51452();
    }

    public static void toggle() {
        enabled = !enabled;
        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.5f));
    }

    public static void copyCoordinates() {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        String coordinates = String.format("%.2f %.2f %.2f", player.method_23317(), player.method_23318(), player.method_23321());
        class_310.method_1551().field_1774.method_1455(coordinates);
        player.method_7353((class_2561)class_2561.method_43469((String)"text.kafhud.coordinates_copied", (Object[])new Object[]{coordinates}).method_27696(class_2583.field_24360.method_36139(16562398)), false);
        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_14793, (float)1.5f));
    }

    public static void onClientTick() {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        while (Keybinds.TOGGLE_HUD.method_1436()) {
            if (!player.method_5715()) {
                KafHUDClient.toggle();
                return;
            }
            KafHUDClient.copyCoordinates();
        }
    }

    @NotNull
    public static class_3965 raytrace(class_1937 level, class_1657 player) {
        class_243 eyePosition = player.method_33571();
        class_243 rotation = player.method_5828(1.0f);
        double reach = player.method_45325(class_5134.field_47758);
        class_243 combined = eyePosition.method_1031(rotation.field_1352 * reach, rotation.field_1351 * reach, rotation.field_1350 * reach);
        return level.method_17742(new class_3959(eyePosition, combined, class_3959.class_3960.field_17559, class_3959.class_242.field_1348, (class_1297)player));
    }
}

