/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.portingdeadlibs.api.gui.menus.slots;

import com.portingdeadmods.portingdeadlibs.api.gui.menus.slots.ReferenceSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.Nullable;

public class FluidReferenceSlot
extends ReferenceSlot<FluidStack> {
    public FluidReferenceSlot(int index, int x, int y, int width, int height, @Nullable ReferenceSlot.ReferenceListener<FluidStack> listener) {
        super(index, x, y, width, height, listener);
    }

    @Override
    protected FluidStack getEmptyReference() {
        return FluidStack.EMPTY;
    }

    @Override
    public boolean setReference(ItemStack stack) {
        FluidStack fluid;
        IFluidHandlerItem fluidHandler = (IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM);
        if (fluidHandler != null && !(fluid = fluidHandler.getFluidInTank(0)).isEmpty()) {
            return this.setReferenceDirectly(fluid);
        }
        return false;
    }

    @Override
    protected FluidStack copyReference(FluidStack reference) {
        FluidStack copy = reference.copy();
        copy.setAmount(1000);
        return copy;
    }

    @Override
    protected boolean areReferencesEqual(FluidStack reference1, FluidStack reference2) {
        return FluidStack.isSameFluidSameComponents((FluidStack)reference1, (FluidStack)reference2);
    }

    @Override
    protected boolean isReferenceEmpty(FluidStack reference) {
        return reference.isEmpty();
    }

    @Override
    public boolean handleSpecialClick(Player player, ClickType clickType, ClickAction clickAction) {
        ItemStack heldItem = player.getInventory().getSelected();
        if (!heldItem.isEmpty()) {
            FluidStack fluid;
            IFluidHandlerItem fluidHandler = (IFluidHandlerItem)heldItem.getCapability(Capabilities.FluidHandler.ITEM);
            if (fluidHandler != null && !(fluid = fluidHandler.getFluidInTank(0)).isEmpty()) {
                return this.setReferenceDirectly(fluid);
            }
        } else if (clickAction == ClickAction.SECONDARY) {
            this.clearReference();
            return true;
        }
        return false;
    }

    public FluidStack getFluidStack() {
        return (FluidStack)this.reference;
    }
}

