/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.portingdeadlibs.utils.capabilities;

import com.portingdeadmods.portingdeadlibs.api.blockentities.ContainerBlockEntity;
import com.portingdeadmods.portingdeadlibs.api.data.PDLDataComponents;
import com.portingdeadmods.portingdeadlibs.api.ghost.SimpleGhostMultiblockPartBE;
import com.portingdeadmods.portingdeadlibs.api.items.IEnergyItem;
import com.portingdeadmods.portingdeadlibs.api.items.IFluidItem;
import com.portingdeadmods.portingdeadlibs.api.items.IItemItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.MutableDataComponentHolder;
import net.neoforged.neoforge.energy.ComponentEnergyStorage;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidHandlerItemStack;
import net.neoforged.neoforge.items.ComponentItemHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public final class CapabilityRegistrationHelper {
    public static void registerItemCaps(RegisterCapabilitiesEvent event, DeferredRegister<Item> registry) {
        for (DeferredHolder item : registry.getEntries()) {
            if (item instanceof IFluidItem) {
                IFluidItem fluidItem = (IFluidItem)item;
                event.registerItem(Capabilities.FluidHandler.ITEM, (stack, ctx) -> new FluidHandlerItemStack(PDLDataComponents.FLUID, stack, fluidItem.getFluidCapacity()), new ItemLike[]{(ItemLike)item.get()});
            }
            if (item instanceof IEnergyItem) {
                IEnergyItem energyItem = (IEnergyItem)item;
                event.registerItem(Capabilities.EnergyStorage.ITEM, (stack, ctx) -> new ComponentEnergyStorage((MutableDataComponentHolder)stack, PDLDataComponents.ENERGY.get(), energyItem.getEnergyCapacity(), energyItem.getMaxInput(), energyItem.getMaxOutput()), new ItemLike[]{(ItemLike)item.get()});
            }
            if (!(item instanceof IItemItem)) continue;
            IItemItem itemItem = (IItemItem)item;
            event.registerItem(Capabilities.ItemHandler.ITEM, (stack, ctx) -> new ComponentItemHandler((MutableDataComponentHolder)stack, DataComponents.CONTAINER, itemItem.getSlots()), new ItemLike[]{(ItemLike)item.get()});
        }
    }

    public static void registerBECaps(RegisterCapabilitiesEvent event, DeferredRegister<BlockEntityType<?>> registry) {
        for (DeferredHolder be : registry.getEntries()) {
            Block validBlock = (Block)((BlockEntityType)be.get()).getValidBlocks().stream().iterator().next();
            BlockEntity testBE = ((BlockEntityType)be.get()).create(BlockPos.ZERO, validBlock.defaultBlockState());
            if (testBE instanceof ContainerBlockEntity) {
                ContainerBlockEntity containerBE = (ContainerBlockEntity)testBE;
                if (containerBE.getItemHandler() != null) {
                    event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)be.get(), (blockEntity, dir) -> ((ContainerBlockEntity)((Object)blockEntity)).getItemHandlerOnSide((Direction)dir));
                }
                if (containerBE.getFluidHandler() != null) {
                    event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)be.get(), (blockEntity, dir) -> ((ContainerBlockEntity)((Object)blockEntity)).getFluidHandlerOnSide((Direction)dir));
                }
                if (containerBE.getEnergyStorage() != null) {
                    event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, (BlockEntityType)be.get(), (blockEntity, dir) -> ((ContainerBlockEntity)((Object)blockEntity)).getEnergyStorageOnSide((Direction)dir));
                }
            }
            if (!(testBE instanceof SimpleGhostMultiblockPartBE)) continue;
            SimpleGhostMultiblockPartBE partBE = (SimpleGhostMultiblockPartBE)testBE;
            event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)be.get(), (blockEntity, dir) -> (IItemHandler)((SimpleGhostMultiblockPartBE)blockEntity).tryAndGetCapability(Capabilities.ItemHandler.BLOCK));
            event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)be.get(), (blockEntity, dir) -> (IFluidHandler)((SimpleGhostMultiblockPartBE)blockEntity).tryAndGetCapability(Capabilities.FluidHandler.BLOCK));
            event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, (BlockEntityType)be.get(), (blockEntity, dir) -> (IEnergyStorage)((SimpleGhostMultiblockPartBE)blockEntity).tryAndGetCapability(Capabilities.EnergyStorage.BLOCK));
        }
    }
}

