/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.portingdeadlibs.api.capabilities;

import java.util.function.Predicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.IFluidTank;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.UnknownNullability;

public class DynamicFluidTank
implements IFluidTank,
IFluidHandler,
INBTSerializable<CompoundTag> {
    protected Predicate<FluidStack> validator;
    protected FluidStack fluid = FluidStack.EMPTY;
    protected int capacity;

    public DynamicFluidTank(int capacity) {
        this(capacity, e -> true);
    }

    public DynamicFluidTank(int capacity, Predicate<FluidStack> validator) {
        this.capacity = capacity;
        this.validator = validator;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    public void setValidator(Predicate<FluidStack> validator) {
        if (validator != null) {
            this.validator = validator;
        }
    }

    public boolean isFluidValid(FluidStack stack) {
        return this.validator.test(stack);
    }

    public int getCapacity() {
        return this.capacity;
    }

    public FluidStack getFluid() {
        return this.fluid;
    }

    public int getFluidAmount() {
        return this.fluid.getAmount();
    }

    private DynamicFluidTank readFromNBT(HolderLookup.Provider lookupProvider, CompoundTag nbt) {
        this.fluid = FluidStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("Fluid"));
        return this;
    }

    private CompoundTag writeToNBT(HolderLookup.Provider lookupProvider, CompoundTag nbt) {
        if (!this.fluid.isEmpty()) {
            nbt.put("Fluid", this.fluid.save(lookupProvider));
        }
        return nbt;
    }

    public int getTanks() {
        return 1;
    }

    public FluidStack getFluidInTank(int tank) {
        return this.getFluid();
    }

    public int getTankCapacity(int tank) {
        return this.getCapacity();
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return this.isFluidValid(stack);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty() || !this.isFluidValid(resource)) {
            return 0;
        }
        if (action.simulate()) {
            if (this.fluid.isEmpty()) {
                return Math.min(this.capacity, resource.getAmount());
            }
            if (!FluidStack.isSameFluidSameComponents((FluidStack)this.fluid, (FluidStack)resource)) {
                return 0;
            }
            return Math.min(this.capacity - this.fluid.getAmount(), resource.getAmount());
        }
        if (this.fluid.isEmpty()) {
            this.fluid = resource.copyWithAmount(Math.min(this.capacity, resource.getAmount()));
            this.onContentsChanged();
            return this.fluid.getAmount();
        }
        if (!FluidStack.isSameFluidSameComponents((FluidStack)this.fluid, (FluidStack)resource)) {
            return 0;
        }
        int filled = this.capacity - this.fluid.getAmount();
        if (resource.getAmount() < filled) {
            this.fluid.grow(resource.getAmount());
            filled = resource.getAmount();
        } else {
            this.fluid.setAmount(this.capacity);
        }
        if (filled > 0) {
            this.onContentsChanged();
        }
        return filled;
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty() || !FluidStack.isSameFluidSameComponents((FluidStack)resource, (FluidStack)this.fluid)) {
            return FluidStack.EMPTY;
        }
        return this.drain(resource.getAmount(), action);
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        int drained = maxDrain;
        if (this.fluid.getAmount() < drained) {
            drained = this.fluid.getAmount();
        }
        FluidStack stack = this.fluid.copyWithAmount(drained);
        if (action.execute() && drained > 0) {
            this.fluid.shrink(drained);
            this.onContentsChanged();
        }
        return stack;
    }

    protected void onContentsChanged() {
    }

    public void setFluid(FluidStack stack) {
        this.fluid = stack;
    }

    public boolean isEmpty() {
        return this.fluid.isEmpty();
    }

    public int getSpace() {
        return Math.max(0, this.capacity - this.fluid.getAmount());
    }

    public @UnknownNullability CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag nbt = new CompoundTag();
        nbt.putInt("capacity", this.capacity);
        return this.writeToNBT(provider, nbt);
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        this.capacity = nbt.getInt("capacity");
        this.fluid = this.readFromNBT(provider, nbt).getFluid();
    }
}

