/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.portingdeadlibs.api.client.renderers.multiblocks;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.portingdeadmods.portingdeadlibs.api.multiblocks.Multiblock;
import com.portingdeadmods.portingdeadlibs.api.multiblocks.MultiblockDefinition;
import com.portingdeadmods.portingdeadlibs.api.multiblocks.MultiblockLayer;
import com.portingdeadmods.portingdeadlibs.api.utils.HorizontalDirection;
import com.portingdeadmods.portingdeadlibs.utils.MultiblockHelper;
import com.portingdeadmods.portingdeadlibs.utils.renderers.AlphaRenderTypeBuffer;
import com.portingdeadmods.portingdeadlibs.utils.renderers.PDLRenderTypes;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.joml.Matrix4f;

public final class MultiblockPreviewRenderer {
    public static void renderPreview(Multiblock multiblock, BlockPos controllerPos, Level level, HorizontalDirection direction, PoseStack poseStack, MultiBufferSource multiBufferSource, Vec3 cameraPos) {
        double camX = cameraPos.x;
        double camY = cameraPos.y;
        double camZ = cameraPos.z;
        Minecraft mc = Minecraft.getInstance();
        BlockRenderDispatcher blockRenderer = mc.getBlockRenderer();
        Vec3i relativeControllerPos = MultiblockHelper.getRelativeControllerPos(multiblock);
        BlockPos firstPos = MultiblockHelper.getFirstBlockPos(direction, controllerPos, relativeControllerPos);
        MultiblockLayer[] layout = multiblock.getLayout();
        MultiblockDefinition def = multiblock.getDefinition();
        int y = 0;
        for (MultiblockLayer layer : layout) {
            for (int i = 0; i < (Integer)layer.range().getMax(); ++i) {
                int x = 0;
                int z = 0;
                int width = multiblock.getWidths().get(y).leftInt();
                for (int blockIndex : layer.layer()) {
                    BlockPos curPos = MultiblockHelper.getCurPos((Vec3i)firstPos, new Vec3i(x, y, z), HorizontalDirection.NORTH);
                    Block block = def.getDefaultBlock(blockIndex);
                    if (block != null) {
                        BlockState blockState = level.getBlockState(curPos);
                        if (!def.getPredicate(blockIndex).test(blockState)) {
                            if (blockState.isEmpty()) {
                                if (i < (Integer)layer.range().getMin()) {
                                    MultiblockPreviewRenderer.renderSmallBlock(poseStack, curPos, camX, camY, camZ, blockRenderer, multiBufferSource, (Level)mc.level, block);
                                } else {
                                    MultiblockPreviewRenderer.renderSmallOptionalBlock(poseStack, curPos, camX, camY, camZ, blockRenderer, multiBufferSource, (Level)mc.level, block);
                                }
                            } else {
                                MultiblockPreviewRenderer.renderErrorBlock(poseStack, curPos, camX, camY, camZ, multiBufferSource, (Level)mc.level);
                            }
                        }
                    }
                    if (x + 1 < width) {
                        ++x;
                        continue;
                    }
                    x = 0;
                    ++z;
                }
                ++y;
            }
        }
    }

    private static void renderSmallOptionalBlock(PoseStack poseStack, BlockPos blockPos, double camX, double camY, double camZ, BlockRenderDispatcher blockRenderer, MultiBufferSource bufferSource, Level level, Block block) {
        poseStack.pushPose();
        poseStack.translate((double)blockPos.getX() - camX, (double)blockPos.getY() - camY, (double)blockPos.getZ() - camZ);
        poseStack.scale(0.5f, 0.5f, 0.5f);
        poseStack.translate(0.5, 0.5, 0.5);
        blockRenderer.renderSingleBlock(block.defaultBlockState(), poseStack, (MultiBufferSource)new AlphaRenderTypeBuffer(bufferSource), MultiblockPreviewRenderer.getLightLevel(level, blockPos), OverlayTexture.NO_OVERLAY, ModelData.EMPTY, RenderType.translucent());
        poseStack.popPose();
    }

    private static void renderSmallBlock(PoseStack poseStack, BlockPos blockPos, double camX, double camY, double camZ, BlockRenderDispatcher blockRenderer, MultiBufferSource bufferSource, Level level, Block block) {
        poseStack.pushPose();
        poseStack.translate((double)blockPos.getX() - camX, (double)blockPos.getY() - camY, (double)blockPos.getZ() - camZ);
        poseStack.scale(0.5f, 0.5f, 0.5f);
        poseStack.translate(0.5, 0.5, 0.5);
        blockRenderer.renderSingleBlock(block.defaultBlockState(), poseStack, bufferSource, MultiblockPreviewRenderer.getLightLevel(level, blockPos), OverlayTexture.NO_OVERLAY, ModelData.EMPTY, RenderType.solid());
        poseStack.popPose();
    }

    private static void renderErrorBlock(PoseStack poseStack, BlockPos blockPos, double camX, double camY, double camZ, MultiBufferSource bufferSource, Level level) {
        poseStack.pushPose();
        poseStack.translate((double)blockPos.getX() - camX, (double)blockPos.getY() - camY, (double)blockPos.getZ() - camZ);
        int r = 255;
        int g = 0;
        int b = 0;
        int a = 100;
        VertexConsumer consumer = bufferSource.getBuffer(PDLRenderTypes.SIMPLE_SOLID);
        Matrix4f matrix = poseStack.last().pose();
        MultiblockPreviewRenderer.renderCube(consumer, matrix, r, g, b, a);
        poseStack.popPose();
    }

    private static void renderCube(VertexConsumer consumer, Matrix4f matrix, int r, int g, int b, int a) {
        consumer.addVertex(matrix, -0.1f, 1.1f, -0.1f).setColor(r, g, b, a).setNormal(0.0f, 1.0f, 0.0f);
        consumer.addVertex(matrix, -0.1f, 1.1f, 1.1f).setColor(r, g, b, a).setNormal(0.0f, 1.0f, 0.0f);
        consumer.addVertex(matrix, 1.1f, 1.1f, 1.1f).setColor(r, g, b, a).setNormal(0.0f, 1.0f, 0.0f);
        consumer.addVertex(matrix, 1.1f, 1.1f, -0.1f).setColor(r, g, b, a).setNormal(0.0f, 1.0f, 0.0f);
        consumer.addVertex(matrix, -0.1f, -0.1f, -0.1f).setColor(r, g, b, a).setNormal(0.0f, -1.0f, 0.0f);
        consumer.addVertex(matrix, 1.1f, -0.1f, -0.1f).setColor(r, g, b, a).setNormal(0.0f, -1.0f, 0.0f);
        consumer.addVertex(matrix, 1.1f, -0.1f, 1.1f).setColor(r, g, b, a).setNormal(0.0f, -1.0f, 0.0f);
        consumer.addVertex(matrix, -0.1f, -0.1f, 1.1f).setColor(r, g, b, a).setNormal(0.0f, -1.0f, 0.0f);
        consumer.addVertex(matrix, -0.1f, -0.1f, 1.1f).setColor(r, g, b, a).setNormal(0.0f, 0.0f, 1.0f);
        consumer.addVertex(matrix, 1.1f, -0.1f, 1.1f).setColor(r, g, b, a).setNormal(0.0f, 0.0f, 1.0f);
        consumer.addVertex(matrix, 1.1f, 1.1f, 1.1f).setColor(r, g, b, a).setNormal(0.0f, 0.0f, 1.0f);
        consumer.addVertex(matrix, -0.1f, 1.1f, 1.1f).setColor(r, g, b, a).setNormal(0.0f, 0.0f, 1.0f);
        consumer.addVertex(matrix, -0.1f, -0.1f, -0.1f).setColor(r, g, b, a).setNormal(0.0f, 0.0f, -1.0f);
        consumer.addVertex(matrix, -0.1f, 1.1f, -0.1f).setColor(r, g, b, a).setNormal(0.0f, 0.0f, -1.0f);
        consumer.addVertex(matrix, 1.1f, 1.1f, -0.1f).setColor(r, g, b, a).setNormal(0.0f, 0.0f, -1.0f);
        consumer.addVertex(matrix, 1.1f, -0.1f, -0.1f).setColor(r, g, b, a).setNormal(0.0f, 0.0f, -1.0f);
        consumer.addVertex(matrix, -0.1f, -0.1f, -0.1f).setColor(r, g, b, a).setNormal(-1.0f, 0.0f, 0.0f);
        consumer.addVertex(matrix, -0.1f, -0.1f, 1.1f).setColor(r, g, b, a).setNormal(-1.0f, 0.0f, 0.0f);
        consumer.addVertex(matrix, -0.1f, 1.1f, 1.1f).setColor(r, g, b, a).setNormal(-1.0f, 0.0f, 0.0f);
        consumer.addVertex(matrix, -0.1f, 1.1f, -0.1f).setColor(r, g, b, a).setNormal(-1.0f, 0.0f, 0.0f);
        consumer.addVertex(matrix, 1.1f, -0.1f, -0.1f).setColor(r, g, b, a).setNormal(1.0f, 0.0f, 0.0f);
        consumer.addVertex(matrix, 1.1f, 1.1f, -0.1f).setColor(r, g, b, a).setNormal(1.0f, 0.0f, 0.0f);
        consumer.addVertex(matrix, 1.1f, 1.1f, 1.1f).setColor(r, g, b, a).setNormal(1.0f, 0.0f, 0.0f);
        consumer.addVertex(matrix, 1.1f, -0.1f, 1.1f).setColor(r, g, b, a).setNormal(1.0f, 0.0f, 0.0f);
    }

    private static int getLightLevel(Level level, BlockPos pos) {
        int bLight = level.getBrightness(LightLayer.BLOCK, pos);
        int sLight = level.getBrightness(LightLayer.SKY, pos);
        return LightTexture.pack((int)bLight, (int)sLight);
    }
}

