/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.portingdeadlibs.networking;

import com.portingdeadmods.portingdeadlibs.PortingDeadLibs;
import com.portingdeadmods.portingdeadlibs.api.client.data.PDLClientSavedData;
import com.portingdeadmods.portingdeadlibs.api.data.saved.SavedDataHolder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record SyncSavedDataToClientPayload<T>(SavedDataHolder<T> holder, T value) implements CustomPacketPayload
{
    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return SyncSavedDataToClientPayload.type(this.holder);
    }

    public void handle(IPayloadContext context) {
        context.enqueueWork(() -> {
            this.holder.value().preSyncFunction().accept(context.player());
            PDLClientSavedData.CLIENT_SAVED_DATA_CACHE.put(this.holder.key(), this.value);
            this.holder.value().postSyncFunction().accept(context.player());
        }).exceptionally(err -> {
            PortingDeadLibs.LOGGER.error("Failed to handle SyncSavedDataPayload", err);
            return null;
        });
    }

    public static <T> CustomPacketPayload.Type<SyncSavedDataToClientPayload<T>> type(SavedDataHolder<T> dataHolder) {
        return new CustomPacketPayload.Type(dataHolder.key().withPrefix("sync_").withSuffix("_to_client_payload"));
    }

    private static <T> SyncSavedDataToClientPayload<T> untyped(SavedDataHolder<?> network, T value) {
        return new SyncSavedDataToClientPayload(network, value);
    }

    public static <T> StreamCodec<RegistryFriendlyByteBuf, SyncSavedDataToClientPayload<T>> streamCodec(SavedDataHolder<?> dataHolder) {
        return StreamCodec.composite(SavedDataHolder.STREAM_CODEC, SyncSavedDataToClientPayload::holder, dataHolder.value().streamCodec(), SyncSavedDataToClientPayload::value, SyncSavedDataToClientPayload::untyped);
    }
}

