/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.portingdeadlibs.api.ghost;

import com.portingdeadmods.portingdeadlibs.api.ghost.GhostPartMenuFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.capabilities.Capabilities;
import org.jetbrains.annotations.Nullable;

public class GhostMultiblockShape {
    private final Set<BlockPos> partPositions;
    private final BlockPos controllerPosition;
    private final AABB relativeBounds;
    private final Map<BlockPos, List<ResourceLocation>> handlerExposure;
    private final Map<BlockPos, GhostPartMenuFactory> partMenus;
    private final BlockPos placementOffset;
    private static final ResourceLocation ITEM_HANDLER_KEY = Capabilities.ItemHandler.BLOCK.name();
    private static final ResourceLocation FLUID_HANDLER_KEY = Capabilities.FluidHandler.BLOCK.name();
    private static final ResourceLocation ENERGY_HANDLER_KEY = Capabilities.EnergyStorage.BLOCK.name();

    private GhostMultiblockShape(Set<BlockPos> partPositions, BlockPos controllerPosition, Map<BlockPos, List<ResourceLocation>> handlerExposure, Map<BlockPos, GhostPartMenuFactory> partMenus, BlockPos placementOffset) {
        this.partPositions = partPositions;
        this.controllerPosition = controllerPosition;
        this.handlerExposure = handlerExposure;
        this.partMenus = partMenus;
        this.placementOffset = placementOffset;
        this.relativeBounds = this.calculateBounds();
    }

    private AABB calculateBounds() {
        if (this.controllerPosition == null) {
            return new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        }
        AABB bounds = new AABB(this.controllerPosition);
        for (BlockPos pos : this.partPositions) {
            bounds = bounds.minmax(new AABB(pos));
        }
        return new AABB(bounds.minX, bounds.minY, bounds.minZ, bounds.maxX + 1.0, bounds.maxY + 1.0, bounds.maxZ + 1.0);
    }

    public Set<BlockPos> getPartPositions() {
        return this.partPositions;
    }

    public BlockPos getControllerPosition() {
        return this.controllerPosition;
    }

    public AABB getRelativeBounds() {
        return this.relativeBounds;
    }

    public Map<BlockPos, List<ResourceLocation>> getHandlerExposure() {
        return this.handlerExposure;
    }

    public Map<BlockPos, GhostPartMenuFactory> getPartMenus() {
        return this.partMenus;
    }

    public BlockPos getPlacementOffset() {
        return this.placementOffset;
    }

    public GhostMultiblockShape getRotated(Direction direction) {
        HashSet<BlockPos> rotatedPartPositions = new HashSet<BlockPos>();
        for (BlockPos pos : this.partPositions) {
            rotatedPartPositions.add(GhostMultiblockShape.rotatePos(pos, direction));
        }
        BlockPos rotatedControllerPos = this.controllerPosition != null ? GhostMultiblockShape.rotatePos(this.controllerPosition, direction) : null;
        HashMap<BlockPos, List<ResourceLocation>> rotatedExposure = new HashMap<BlockPos, List<ResourceLocation>>();
        for (Map.Entry<BlockPos, List<ResourceLocation>> entry : this.handlerExposure.entrySet()) {
            rotatedExposure.put(GhostMultiblockShape.rotatePos(entry.getKey(), direction), entry.getValue());
        }
        HashMap<BlockPos, GhostPartMenuFactory> rotatedMenus = new HashMap<BlockPos, GhostPartMenuFactory>();
        for (Map.Entry<BlockPos, GhostPartMenuFactory> entry : this.partMenus.entrySet()) {
            rotatedMenus.put(GhostMultiblockShape.rotatePos(entry.getKey(), direction), entry.getValue());
        }
        BlockPos blockPos = GhostMultiblockShape.rotatePos(this.placementOffset, direction);
        return new GhostMultiblockShape(rotatedPartPositions, rotatedControllerPos, Collections.unmodifiableMap(rotatedExposure), Collections.unmodifiableMap(rotatedMenus), blockPos);
    }

    private static BlockPos rotatePos(BlockPos pos, Direction direction) {
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case Direction.SOUTH -> new BlockPos(-pos.getX(), pos.getY(), -pos.getZ());
            case Direction.WEST -> new BlockPos(pos.getZ(), pos.getY(), -pos.getX());
            case Direction.EAST -> new BlockPos(-pos.getZ(), pos.getY(), pos.getX());
            case Direction.NORTH, Direction.UP, Direction.DOWN -> pos;
        };
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final List<String[]> layers = new ArrayList<String[]>();
        private char controllerChar = (char)67;
        private final Map<Character, List<ResourceLocation>> explicitHandlerMap = new HashMap<Character, List<ResourceLocation>>();
        private final Map<Character, GhostPartMenuFactory> menuFactories = new HashMap<Character, GhostPartMenuFactory>();
        private final Set<Character> noMenuChars = new HashSet<Character>();
        private BlockPos placementOffset = BlockPos.ZERO;

        public Builder layer(String ... aisle) {
            if (aisle.length > 0) {
                int width = aisle[0].length();
                for (int i = 1; i < aisle.length; ++i) {
                    if (aisle[i].length() == width) continue;
                    throw new IllegalArgumentException("All aisles in a layer must have the same width.");
                }
            }
            this.layers.add(aisle);
            return this;
        }

        public Builder controllerChar(char c) {
            this.controllerChar = c;
            return this;
        }

        public Builder exposeHandlers(char c, ResourceLocation ... handlers) {
            this.explicitHandlerMap.computeIfAbsent(Character.valueOf(c), k -> new ArrayList()).addAll(Arrays.asList(handlers));
            return this;
        }

        public Builder withMenu(char c, @Nullable GhostPartMenuFactory factory) {
            if (factory == null) {
                this.noMenuChars.add(Character.valueOf(c));
                this.menuFactories.remove(Character.valueOf(c));
            } else {
                this.menuFactories.put(Character.valueOf(c), factory);
                this.noMenuChars.remove(Character.valueOf(c));
            }
            return this;
        }

        public Builder onPlaceOffset(int x, int y, int z) {
            this.placementOffset = new BlockPos(x, y, z);
            return this;
        }

        public GhostMultiblockShape build() {
            HashSet<BlockPos> partPositions = new HashSet<BlockPos>();
            BlockPos controllerPos = null;
            HashMap<BlockPos, List<ResourceLocation>> handlerExposure = new HashMap<BlockPos, List<ResourceLocation>>();
            HashMap<BlockPos, GhostPartMenuFactory> partMenus = new HashMap<BlockPos, GhostPartMenuFactory>();
            int y = 0;
            for (String[] layer : this.layers) {
                int z = 0;
                for (String aisle : layer) {
                    int x = 0;
                    for (char c : aisle.toCharArray()) {
                        if (c != ' ') {
                            BlockPos currentPos = new BlockPos(x, y, z);
                            if (c == this.controllerChar) {
                                if (controllerPos != null) {
                                    throw new IllegalStateException("Multiple controllers defined. Only one is allowed.");
                                }
                                controllerPos = currentPos;
                            } else {
                                partPositions.add(currentPos);
                            }
                            ArrayList handlerKeys = new ArrayList();
                            if (this.explicitHandlerMap.containsKey(Character.valueOf(c))) {
                                handlerKeys.addAll(this.explicitHandlerMap.get(Character.valueOf(c)));
                            }
                            if (!handlerKeys.isEmpty()) {
                                List deduped = List.copyOf(new LinkedHashSet(handlerKeys));
                                handlerExposure.put(currentPos, deduped);
                            }
                            if (this.noMenuChars.contains(Character.valueOf(c))) {
                                partMenus.put(currentPos, null);
                            } else if (this.menuFactories.containsKey(Character.valueOf(c))) {
                                partMenus.put(currentPos, this.menuFactories.get(Character.valueOf(c)));
                            }
                        }
                        ++x;
                    }
                    ++z;
                }
                ++y;
            }
            if (controllerPos == null) {
                throw new IllegalStateException("No controller defined in the shape.");
            }
            return new GhostMultiblockShape(partPositions, controllerPos, handlerExposure, partMenus, this.placementOffset);
        }
    }

    public static enum Exposes {
        ITEM_HANDLER,
        FLUID_HANDLER,
        ENERGY_STORAGE;

    }
}

