/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.portingdeadlibs;

import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import com.portingdeadmods.portingdeadlibs.api.fluids.BaseFluidType;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.CreativeModeTabs;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector4i;

@Mod(value="portingdeadlibs", dist={Dist.CLIENT})
public final class PortingDeadLibsClient {
    public static final String MODID = "portingdeadlibs";

    public static void refreshCreativeTabContents() {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player != null) {
            CreativeModeTabs.CACHED_PARAMETERS = null;
            CreativeModeTabs.tryRebuildTabContents((FeatureFlagSet)mc.player.connection.enabledFeatures(), (mc.player.canUseGameMasterBlocks() && (Boolean)mc.options.operatorItemsTab().get() != false ? 1 : 0) != 0, (HolderLookup.Provider)mc.level.registryAccess());
        }
    }

    public PortingDeadLibsClient(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::registerClientExtensions);
    }

    private void registerClientExtensions(RegisterClientExtensionsEvent event) {
        for (FluidType fluidType : NeoForgeRegistries.FLUID_TYPES) {
            if (!(fluidType instanceof BaseFluidType)) continue;
            final BaseFluidType baseFluidType = (BaseFluidType)fluidType;
            event.registerFluidType(new IClientFluidTypeExtensions(){

                @NotNull
                public ResourceLocation getStillTexture() {
                    return baseFluidType.getStillTexture();
                }

                @NotNull
                public ResourceLocation getFlowingTexture() {
                    return baseFluidType.getFlowingTexture();
                }

                @Nullable
                public ResourceLocation getOverlayTexture() {
                    return baseFluidType.getOverlayTexture();
                }

                public int getTintColor() {
                    Vector4i color = baseFluidType.getColor();
                    return FastColor.ARGB32.color((int)color.w, (int)color.x, (int)color.y, (int)color.z);
                }

                @NotNull
                public Vector3f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector3f fluidFogColor) {
                    Vector4i color = baseFluidType.getColor();
                    return new Vector3f((float)color.x / 255.0f, (float)color.y / 255.0f, (float)color.z / 255.0f);
                }

                public void modifyFogRender(Camera camera, FogRenderer.FogMode mode, float renderDistance, float partialTick, float nearDistance, float farDistance, FogShape shape) {
                    RenderSystem.setShaderFogStart((float)1.0f);
                    RenderSystem.setShaderFogEnd((float)6.0f);
                }
            }, new FluidType[]{baseFluidType});
        }
    }
}

