/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.portingdeadlibs.api.client.screens.widgets;

import com.portingdeadmods.portingdeadlibs.api.client.screens.PDLAbstractContainerScreen;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public abstract class AbstractScroller
extends AbstractWidget {
    private final PDLAbstractContainerScreen<?> parentScreen;
    private final ResourceLocation sprite;
    private final int trackLength;
    private final Mode mode;
    private final int padding;
    private int offsetY;
    private int offsetX;
    private float scrollPercentage = 0.0f;
    private int scrollOffset = 0;
    private boolean mbDown = false;

    public AbstractScroller(PDLAbstractContainerScreen<?> parentScreen, int x, int y, int width, int height, int trackLength, Mode mode, ResourceLocation sprite) {
        super(x, y, width, height, (Component)Component.empty());
        this.parentScreen = parentScreen;
        this.trackLength = trackLength;
        this.sprite = sprite;
        this.mode = mode;
        this.padding = this.mode == Mode.VERTICAL ? height / 2 + 1 : width / 2 + 1;
    }

    public void renderWidget(GuiGraphics guiGraphics) {
        this.renderWidget(guiGraphics, 0, 0, 0.0f);
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.offsetX = this.parentScreen.getGuiLeft() + this.getX();
        this.offsetY = this.parentScreen.getGuiTop() + this.getY();
        if (this.mode == Mode.VERTICAL) {
            guiGraphics.blitSprite(this.sprite, this.offsetX, this.offsetY + (int)(this.scrollPercentage * (float)this.trackLength), this.width, this.height);
        } else {
            guiGraphics.blitSprite(this.sprite, this.offsetX + (int)(this.scrollPercentage * (float)this.trackLength), this.offsetY, this.width, this.height);
        }
        if (this.mbDown) {
            this.updatePos(mouseX, mouseY);
        }
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    public void updatePos(double mouseX, double mouseY) {
        if (!this.mbDown) {
            return;
        }
        if (this.mode == Mode.VERTICAL) {
            if (mouseY >= (double)(this.offsetY + this.padding) && mouseY <= (double)(this.offsetY + this.padding + this.trackLength)) {
                float relativeY = (float)(mouseY - (double)this.offsetY - (double)this.padding);
                this.scrollPercentage = relativeY / (float)this.trackLength;
            } else if (mouseY < (double)(this.offsetY + this.padding)) {
                this.scrollPercentage = 0.0f;
            } else if (mouseY > (double)(this.offsetY + this.padding + this.trackLength)) {
                this.scrollPercentage = 1.0f;
            }
        } else if (mouseX >= (double)(this.offsetX + this.padding) && mouseX <= (double)(this.offsetX + this.padding + this.trackLength)) {
            float relativeX = (float)(mouseX - (double)this.offsetX - (double)this.padding);
            this.scrollPercentage = relativeX / (float)this.trackLength;
        } else if (mouseX < (double)(this.offsetX + this.padding)) {
            this.scrollPercentage = 0.0f;
        } else if (mouseX > (double)(this.offsetX + this.padding + this.trackLength)) {
            this.scrollPercentage = 1.0f;
        }
        this.scrollOffset = (int)((float)this.getScrollableLength() * this.scrollPercentage);
        this.onScroll();
    }

    public boolean clicked(double mouseX, double mouseY) {
        boolean flag;
        if (this.mode == Mode.VERTICAL) {
            flag = this.active && this.visible && mouseX >= (double)this.offsetX && mouseY >= (double)this.offsetY && mouseX < (double)(this.offsetX + this.width) && mouseY < (double)(this.offsetY + this.trackLength + 2 * this.padding);
        } else {
            boolean bl = flag = this.active && this.visible && mouseX >= (double)this.offsetX && mouseY >= (double)this.offsetY && mouseX < (double)(this.offsetX + this.trackLength + 2 * this.padding) && mouseY < (double)(this.offsetY + this.height);
        }
        if (flag) {
            this.mbDown = true;
        }
        this.updatePos(mouseX, mouseY);
        return flag;
    }

    public void onRelease(double mouseX, double mouseY) {
        this.mbDown = false;
    }

    public int getScrollOffset() {
        return this.scrollOffset;
    }

    public abstract int getContentLength();

    public abstract int getVisibleContentLength();

    public abstract void onScroll();

    public int getScrollableLength() {
        return this.getContentLength() - this.getVisibleContentLength();
    }

    public static enum Mode {
        VERTICAL,
        HORIZONTAL;

    }
}

