/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.portingdeadlibs.api.data.saved;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.portingdeadmods.portingdeadlibs.PortingDeadLibs;
import com.portingdeadmods.portingdeadlibs.api.data.saved.SavedDataHolder;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;

public class SavedDataWrapper<T>
extends SavedData {
    private final SavedDataHolder<T> registeredSavedDataHolder;
    private T data;

    public SavedDataWrapper(SavedDataHolder<T> registeredSavedDataHolder, T data) {
        this.registeredSavedDataHolder = registeredSavedDataHolder;
        this.data = data;
    }

    public SavedDataWrapper(SavedDataHolder<T> registeredSavedDataHolder) {
        this(registeredSavedDataHolder, registeredSavedDataHolder.value().defaultValueSupplier().get());
    }

    @NotNull
    public CompoundTag save(CompoundTag compoundTag, HolderLookup.Provider provider) {
        DataResult result = this.registeredSavedDataHolder.value().codec().encodeStart((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), this.data);
        Optional _tag = result.resultOrPartial(err -> PortingDeadLibs.LOGGER.error("Encountered error encoding {} saved data: {}", (Object)SavedDataWrapper.getName(this.registeredSavedDataHolder), err));
        _tag.ifPresent(tag -> compoundTag.put(SavedDataWrapper.getName(this.registeredSavedDataHolder) + "_data", tag));
        return compoundTag;
    }

    private static <T> T load(SavedDataHolder<T> registeredSavedDataHolder, CompoundTag compoundTag, HolderLookup.Provider provider) {
        DataResult result = registeredSavedDataHolder.value().codec().decode((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)compoundTag.get(SavedDataWrapper.getName(registeredSavedDataHolder) + "_data"));
        return result.resultOrPartial(err -> PortingDeadLibs.LOGGER.error("Encountered error decoding {} saved data: {}", (Object)SavedDataWrapper.getName(registeredSavedDataHolder), err)).map(Pair::getFirst).orElse(null);
    }

    private static <T> String getName(SavedDataHolder<T> registeredSavedDataHolder) {
        return registeredSavedDataHolder.key().toString().replace(':', '_');
    }

    private static <T> SavedData.Factory<SavedDataWrapper<T>> factory(SavedDataHolder<T> registeredSavedDataHolder) {
        return new SavedData.Factory(() -> new SavedDataWrapper(registeredSavedDataHolder), (tag, provider) -> new SavedDataWrapper(registeredSavedDataHolder, SavedDataWrapper.load(registeredSavedDataHolder, tag, provider)));
    }

    protected static <T> T getData(SavedDataHolder<T> registeredSavedDataHolder, ServerLevel serverLevel) {
        return ((SavedDataWrapper)serverLevel.getDataStorage().computeIfAbsent(SavedDataWrapper.factory(registeredSavedDataHolder), (String)SavedDataWrapper.getName(registeredSavedDataHolder))).data;
    }

    protected static <T> void setData(SavedDataHolder<T> registeredSavedDataHolder, ServerLevel serverLevel, T data) {
        SavedDataWrapper dataWrapper = (SavedDataWrapper)serverLevel.getDataStorage().computeIfAbsent(SavedDataWrapper.factory(registeredSavedDataHolder), SavedDataWrapper.getName(registeredSavedDataHolder));
        dataWrapper.data = data;
        dataWrapper.setDirty();
    }
}

