/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.portingdeadlibs.api.ghost;

import com.portingdeadmods.portingdeadlibs.api.blockentities.ContainerBlockEntity;
import com.portingdeadmods.portingdeadlibs.utils.LazyFinal;
import com.portingdeadmods.portingdeadlibs.utils.UniqueArray;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import org.jetbrains.annotations.Nullable;

public abstract class GhostMultiblockControllerBE
extends ContainerBlockEntity
implements MenuProvider {
    public final LazyFinal<List<BlockPos>> partPos = LazyFinal.create();
    public final LazyFinal<List<BlockPos>> itemHandlerPartPos = LazyFinal.create();
    public final LazyFinal<List<BlockPos>> fluidHandlerPartPos = LazyFinal.create();
    public final LazyFinal<List<BlockPos>> energyHandlerPartPos = LazyFinal.create();

    public GhostMultiblockControllerBE(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    public void setPartPositions(List<BlockPos> partPositions) {
        if (!this.partPos.isInitialized()) {
            this.partPos.initialize(partPositions);
        }
    }

    public void setPartPositions(List<BlockPos> partPositions, List<BlockPos> itemHandlerPartPos, List<BlockPos> fluidHandlerPartPos, List<BlockPos> energyHandlerPartPos) {
        this.setPartPositions(partPositions);
        if (!this.itemHandlerPartPos.isInitialized()) {
            this.itemHandlerPartPos.initialize(itemHandlerPartPos);
        }
        if (!this.fluidHandlerPartPos.isInitialized()) {
            this.fluidHandlerPartPos.initialize(fluidHandlerPartPos);
        }
        if (!this.energyHandlerPartPos.isInitialized()) {
            this.energyHandlerPartPos.initialize(energyHandlerPartPos);
        }
    }

    @Override
    protected void saveData(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveData(tag, registries);
        this.partPos.ifInitialized(pos -> tag.putLongArray("part_positions", pos.stream().mapToLong(BlockPos::asLong).toArray()));
        this.itemHandlerPartPos.ifInitialized(pos -> tag.putLongArray("item_handler_part_positions", pos.stream().mapToLong(BlockPos::asLong).toArray()));
        this.fluidHandlerPartPos.ifInitialized(pos -> tag.putLongArray("fluid_handler_part_positions", pos.stream().mapToLong(BlockPos::asLong).toArray()));
        this.energyHandlerPartPos.ifInitialized(pos -> tag.putLongArray("energy_handler_part_positions", pos.stream().mapToLong(BlockPos::asLong).toArray()));
    }

    @Override
    protected void loadData(CompoundTag tag, HolderLookup.Provider registries) {
        UniqueArray<BlockPos> positions;
        long[] partPositions;
        super.loadData(tag, registries);
        if (tag.contains("part_positions")) {
            partPositions = tag.getLongArray("part_positions");
            positions = new UniqueArray<BlockPos>();
            for (long posLong : partPositions) {
                positions.add(BlockPos.of((long)posLong));
            }
            this.setPartPositions(positions);
        }
        if (tag.contains("item_handler_part_positions")) {
            partPositions = tag.getLongArray("item_handler_part_positions");
            positions = new UniqueArray();
            for (long posLong : partPositions) {
                positions.add(BlockPos.of((long)posLong));
            }
            this.itemHandlerPartPos.initialize(positions);
        }
        if (tag.contains("fluid_handler_part_positions")) {
            partPositions = tag.getLongArray("fluid_handler_part_positions");
            positions = new UniqueArray();
            for (long posLong : partPositions) {
                positions.add(BlockPos.of((long)posLong));
            }
            this.fluidHandlerPartPos.initialize(positions);
        }
        if (tag.contains("energy_handler_part_positions")) {
            partPositions = tag.getLongArray("energy_handler_part_positions");
            positions = new UniqueArray();
            for (long posLong : partPositions) {
                positions.add(BlockPos.of((long)posLong));
            }
            this.energyHandlerPartPos.initialize(positions);
        }
    }

    public <T> boolean shouldExposeCapability(BlockCapability<T, @Nullable Direction> capability, BlockPos partPos) {
        if (capability == Capabilities.ItemHandler.BLOCK) {
            return this.itemHandlerPartPos.getOrDefault(List.of()).contains(partPos);
        }
        if (capability == Capabilities.FluidHandler.BLOCK) {
            return this.fluidHandlerPartPos.getOrDefault(List.of()).contains(partPos);
        }
        if (capability == Capabilities.EnergyStorage.BLOCK) {
            return this.energyHandlerPartPos.getOrDefault(List.of()).contains(partPos);
        }
        return true;
    }

    public abstract Component getDisplayName();

    @Nullable
    public abstract AbstractContainerMenu createMenu(int var1, Inventory var2, Player var3);
}

