/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.portingdeadlibs.api.ghost;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.AABB;

public class GhostMultiblockShape {
    private final Set<BlockPos> partPositions;
    private final BlockPos controllerPosition;
    private final AABB relativeBounds;
    private final Set<BlockPos> itemHandlerParts;
    private final Set<BlockPos> fluidHandlerParts;
    private final Set<BlockPos> energyStorageParts;

    private GhostMultiblockShape(Set<BlockPos> partPositions, BlockPos controllerPosition, Set<BlockPos> itemHandlerParts, Set<BlockPos> fluidHandlerParts, Set<BlockPos> energyStorageParts) {
        this.partPositions = partPositions;
        this.controllerPosition = controllerPosition;
        this.itemHandlerParts = itemHandlerParts;
        this.fluidHandlerParts = fluidHandlerParts;
        this.energyStorageParts = energyStorageParts;
        this.relativeBounds = this.calculateBounds();
    }

    private AABB calculateBounds() {
        if (this.controllerPosition == null) {
            return new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        }
        AABB bounds = new AABB(this.controllerPosition);
        for (BlockPos pos : this.partPositions) {
            bounds = bounds.minmax(new AABB(pos));
        }
        return new AABB(bounds.minX, bounds.minY, bounds.minZ, bounds.maxX + 1.0, bounds.maxY + 1.0, bounds.maxZ + 1.0);
    }

    public Set<BlockPos> getPartPositions() {
        return this.partPositions;
    }

    public BlockPos getControllerPosition() {
        return this.controllerPosition;
    }

    public AABB getRelativeBounds() {
        return this.relativeBounds;
    }

    public Set<BlockPos> getItemHandlerParts() {
        return this.itemHandlerParts;
    }

    public Set<BlockPos> getFluidHandlerParts() {
        return this.fluidHandlerParts;
    }

    public Set<BlockPos> getEnergyStorageParts() {
        return this.energyStorageParts;
    }

    public GhostMultiblockShape getRotated(Direction direction) {
        HashSet<BlockPos> rotatedPartPositions = new HashSet<BlockPos>();
        for (BlockPos pos : this.partPositions) {
            rotatedPartPositions.add(GhostMultiblockShape.rotatePos(pos, direction));
        }
        BlockPos rotatedControllerPos = this.controllerPosition != null ? GhostMultiblockShape.rotatePos(this.controllerPosition, direction) : null;
        HashSet<BlockPos> rotatedItemHandlerParts = new HashSet<BlockPos>();
        for (BlockPos blockPos : this.itemHandlerParts) {
            rotatedItemHandlerParts.add(GhostMultiblockShape.rotatePos(blockPos, direction));
        }
        HashSet<BlockPos> rotatedFluidHandlerParts = new HashSet<BlockPos>();
        for (BlockPos pos : this.fluidHandlerParts) {
            rotatedFluidHandlerParts.add(GhostMultiblockShape.rotatePos(pos, direction));
        }
        HashSet<BlockPos> hashSet = new HashSet<BlockPos>();
        for (BlockPos pos : this.energyStorageParts) {
            hashSet.add(GhostMultiblockShape.rotatePos(pos, direction));
        }
        return new GhostMultiblockShape(rotatedPartPositions, rotatedControllerPos, rotatedItemHandlerParts, rotatedFluidHandlerParts, hashSet);
    }

    private static BlockPos rotatePos(BlockPos pos, Direction direction) {
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case Direction.SOUTH -> new BlockPos(-pos.getX(), pos.getY(), -pos.getZ());
            case Direction.WEST -> new BlockPos(pos.getZ(), pos.getY(), -pos.getX());
            case Direction.EAST -> new BlockPos(-pos.getZ(), pos.getY(), pos.getX());
            case Direction.NORTH, Direction.UP, Direction.DOWN -> pos;
        };
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final List<String[]> layers = new ArrayList<String[]>();
        private char controllerChar = (char)67;
        private BlockPos pivot = BlockPos.ZERO;
        private final Map<Character, Set<Exposes>> whereMap = new HashMap<Character, Set<Exposes>>();

        public Builder layer(String ... aisle) {
            if (aisle.length > 0) {
                int width = aisle[0].length();
                for (int i = 1; i < aisle.length; ++i) {
                    if (aisle[i].length() == width) continue;
                    throw new IllegalArgumentException("All aisles in a layer must have the same width.");
                }
            }
            this.layers.add(aisle);
            return this;
        }

        public Builder controllerChar(char c) {
            this.controllerChar = c;
            return this;
        }

        public Builder pivot(int x, int y, int z) {
            this.pivot = new BlockPos(x, y, z);
            return this;
        }

        public Builder where(char c, Exposes ... exposes) {
            this.whereMap.computeIfAbsent(Character.valueOf(c), k -> new HashSet()).addAll(Arrays.asList(exposes));
            return this;
        }

        public GhostMultiblockShape build() {
            HashSet<BlockPos> partPositions = new HashSet<BlockPos>();
            BlockPos controllerPos = null;
            HashSet<BlockPos> itemHandlerParts = new HashSet<BlockPos>();
            HashSet<BlockPos> fluidHandlerParts = new HashSet<BlockPos>();
            HashSet<BlockPos> energyStorageParts = new HashSet<BlockPos>();
            int y = 0;
            for (String[] layer : this.layers) {
                int z = 0;
                for (String aisle : layer) {
                    int x = 0;
                    for (char c : aisle.toCharArray()) {
                        if (c != ' ') {
                            BlockPos currentPos = new BlockPos(x, y, z);
                            if (c == this.controllerChar) {
                                if (controllerPos != null) {
                                    throw new IllegalStateException("Multiple controllers defined. Only one is allowed.");
                                }
                                controllerPos = currentPos;
                            } else {
                                partPositions.add(currentPos);
                            }
                            if (this.whereMap.containsKey(Character.valueOf(c))) {
                                Set<Exposes> exposes = this.whereMap.get(Character.valueOf(c));
                                if (exposes.contains((Object)Exposes.ITEM_HANDLER)) {
                                    itemHandlerParts.add(currentPos);
                                }
                                if (exposes.contains((Object)Exposes.FLUID_HANDLER)) {
                                    fluidHandlerParts.add(currentPos);
                                }
                                if (exposes.contains((Object)Exposes.ENERGY_STORAGE)) {
                                    energyStorageParts.add(currentPos);
                                }
                            }
                        }
                        ++x;
                    }
                    ++z;
                }
                ++y;
            }
            if (controllerPos == null) {
                throw new IllegalStateException("No controller defined in the shape.");
            }
            BlockPos finalControllerPos = controllerPos.subtract((Vec3i)this.pivot);
            HashSet<BlockPos> finalPartPositions = new HashSet<BlockPos>();
            for (BlockPos blockPos : partPositions) {
                finalPartPositions.add(blockPos.subtract((Vec3i)this.pivot));
            }
            HashSet<BlockPos> finalItemHandlerParts = new HashSet<BlockPos>();
            for (BlockPos partPos : itemHandlerParts) {
                finalItemHandlerParts.add(partPos.subtract((Vec3i)this.pivot));
            }
            HashSet<BlockPos> hashSet = new HashSet<BlockPos>();
            for (BlockPos partPos : fluidHandlerParts) {
                hashSet.add(partPos.subtract((Vec3i)this.pivot));
            }
            HashSet<BlockPos> finalEnergyHandlerParts = new HashSet<BlockPos>();
            for (BlockPos partPos : energyStorageParts) {
                finalEnergyHandlerParts.add(partPos.subtract((Vec3i)this.pivot));
            }
            return new GhostMultiblockShape(finalPartPositions, finalControllerPos, finalItemHandlerParts, hashSet, finalEnergyHandlerParts);
        }
    }

    public static enum Exposes {
        ITEM_HANDLER,
        FLUID_HANDLER,
        ENERGY_STORAGE;

    }
}

