/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.portingdeadlibs.api.ghost;

import com.portingdeadmods.portingdeadlibs.api.ghost.GhostMultiblockController;
import com.portingdeadmods.portingdeadlibs.api.ghost.GhostMultiblockControllerBE;
import com.portingdeadmods.portingdeadlibs.api.ghost.GhostMultiblockPart;
import com.portingdeadmods.portingdeadlibs.api.ghost.GhostMultiblockPartBE;
import com.portingdeadmods.portingdeadlibs.api.ghost.SimpleGhostMultiblockPartBE;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

public abstract class SimpleGhostMultiblockPart
extends BaseEntityBlock
implements GhostMultiblockPart {
    protected SimpleGhostMultiblockPart(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @NotNull
    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        GhostMultiblockPartBE partBE;
        BlockEntity controllerBE;
        if (level.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof GhostMultiblockPartBE && (controllerBE = level.getBlockEntity((partBE = (GhostMultiblockPartBE)blockEntity).getControllerPos())) instanceof GhostMultiblockControllerBE && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.openMenu((MenuProvider)((GhostMultiblockControllerBE)controllerBE), partBE.getControllerPos());
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.is(newState.getBlock())) {
            this.onPartRemoved(state, level, pos, newState);
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    @Override
    public void onPartRemoved(BlockState state, Level level, BlockPos pos, BlockState newState) {
        SimpleGhostMultiblockPartBE partBE;
        BlockPos controllerPos;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof SimpleGhostMultiblockPartBE && level.getBlockState(controllerPos = (partBE = (SimpleGhostMultiblockPartBE)blockEntity).getControllerPos()).getBlock() instanceof GhostMultiblockController) {
            level.removeBlock(controllerPos, false);
        }
    }

    @NotNull
    public RenderShape getRenderShape(@NotNull BlockState state) {
        return RenderShape.INVISIBLE;
    }
}

