/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.portingdeadlibs.client.screens.widgets;

import com.portingdeadmods.portingdeadlibs.PortingDeadLibs;
import com.portingdeadmods.portingdeadlibs.api.blockentities.ContainerBlockEntity;
import com.portingdeadmods.portingdeadlibs.api.capabilities.EnergyStorageWrapper;
import com.portingdeadmods.portingdeadlibs.api.capabilities.NeoEnergyStorageWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class EnergyBarWidget
extends AbstractWidget {
    private static final ResourceLocation ENERGY_BAR = PortingDeadLibs.rl("energy_bar");
    private static final ResourceLocation ENERGY_BAR_EMPTY = PortingDeadLibs.rl("energy_bar_empty");
    private static final ResourceLocation ENERGY_BAR_BORDER = PortingDeadLibs.rl("energy_bar_border");
    private static final ResourceLocation ENERGY_BAR_EMPTY_BORDER = PortingDeadLibs.rl("energy_bar_empty_border");
    private final boolean hasBorder;
    private final EnergyStorageWrapper wrapper;
    private final String energyUnit;

    public EnergyBarWidget(int x, int y, EnergyStorageWrapper wrapper, String energyUnit, boolean hasBorder) {
        super(x, y, 12, 48, CommonComponents.EMPTY);
        this.hasBorder = hasBorder;
        this.wrapper = wrapper;
        this.energyUnit = energyUnit;
    }

    public EnergyBarWidget(int x, int y, ContainerBlockEntity blockEntity, boolean hasBorder) {
        this(x, y, new NeoEnergyStorageWrapper(blockEntity.getEnergyStorage()), "FE", hasBorder);
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        ResourceLocation loc = this.hasBorder ? ENERGY_BAR_EMPTY_BORDER : ENERGY_BAR_EMPTY;
        guiGraphics.blitSprite(loc, this.width, this.height, 0, 0, this.getX(), this.getY(), this.width, this.height);
        int energyStored = this.wrapper.getEnergyStored();
        int maxStored = this.wrapper.getEnergyCapacity();
        int progress = (int)((float)this.height * ((float)energyStored / (float)maxStored));
        ResourceLocation locFull = this.hasBorder ? ENERGY_BAR_BORDER : ENERGY_BAR;
        guiGraphics.blitSprite(locFull, this.width, this.height, 0, this.height - progress, this.getX(), this.getY() + this.height - progress, this.width, progress);
        if (this.isHovered()) {
            guiGraphics.renderTooltip(Minecraft.getInstance().font, (Component)Component.literal((String)(this.wrapper.getEnergyStored() + "/" + this.wrapper.getEnergyCapacity() + this.energyUnit)), mouseX, mouseY);
        }
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }
}

