/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.portingdeadlibs.api.blockentities;

import com.portingdeadmods.portingdeadlibs.PortingDeadLibs;
import com.portingdeadmods.portingdeadlibs.api.capabilities.DynamicFluidTank;
import com.portingdeadmods.portingdeadlibs.api.capabilities.SidedEnergyStorage;
import com.portingdeadmods.portingdeadlibs.api.capabilities.SidedFluidHandler;
import com.portingdeadmods.portingdeadlibs.api.capabilities.SidedItemHandler;
import com.portingdeadmods.portingdeadlibs.api.utils.IOAction;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.EnergyStorage;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ContainerBlockEntity
extends BlockEntity {
    @Nullable
    private ItemStackHandler itemHandler;
    @Nullable
    private DynamicFluidTank fluidTank;
    @Nullable
    private EnergyStorage energyStorage;

    public ContainerBlockEntity(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    public void commonTick() {
    }

    public IItemHandler getItemHandler() {
        return this.itemHandler;
    }

    public IFluidHandler getFluidHandler() {
        return this.fluidTank;
    }

    public IEnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    protected ItemStackHandler getItemStackHandler() {
        return this.itemHandler;
    }

    protected DynamicFluidTank getFluidTank() {
        return this.fluidTank;
    }

    protected EnergyStorage getEnergyStorageImpl() {
        return this.energyStorage;
    }

    protected final void loadAdditional(@NotNull CompoundTag nbt, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(nbt, provider);
        if (this.getFluidTank() != null) {
            this.getFluidTank().deserializeNBT(provider, nbt.getCompound("fluid_tank"));
        }
        if (this.getItemStackHandler() != null) {
            this.getItemStackHandler().deserializeNBT(provider, nbt.getCompound("itemhandler"));
        }
        if (this.getEnergyStorageImpl() != null) {
            this.getEnergyStorageImpl().deserializeNBT(provider, nbt.get("energy_storage"));
        }
        this.loadData(nbt, provider);
    }

    protected final void saveAdditional(@NotNull CompoundTag nbt, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(nbt, provider);
        if (this.getFluidTank() != null) {
            nbt.put("fluid_tank", (Tag)this.getFluidTank().serializeNBT(provider));
        }
        if (this.getItemStackHandler() != null) {
            nbt.put("itemhandler", (Tag)this.getItemStackHandler().serializeNBT(provider));
        }
        if (this.getEnergyStorageImpl() != null) {
            nbt.put("energy_storage", this.getEnergyStorageImpl().serializeNBT(provider));
        }
        this.saveData(nbt, provider);
    }

    protected void loadData(CompoundTag tag, HolderLookup.Provider provider) {
    }

    protected void saveData(CompoundTag tag, HolderLookup.Provider provider) {
    }

    protected final void addItemHandler(int slots) {
        this.addItemHandler(slots, (Integer slot, ItemStack itemStack) -> true);
    }

    protected final void addItemHandler(int slots, int slotLimit) {
        this.addItemHandler(slots, slotLimit, (Integer slot, ItemStack itemStack) -> true);
    }

    protected final void addItemHandler(int slots, BiPredicate<Integer, ItemStack> validation) {
        this.addItemHandler(slots, 64, validation);
    }

    protected final void addItemHandler(int slots, UnaryOperator<Integer> slotLimit) {
        this.addItemHandler(slots, slotLimit, (Integer slot, ItemStack itemStack) -> true);
    }

    protected final void addItemHandler(int slots, int slotLimit, BiPredicate<Integer, ItemStack> validation) {
        this.addItemHandler(slots, slot -> slotLimit, validation);
    }

    protected final void addItemHandler(int slots, final UnaryOperator<Integer> slotLimit, final BiPredicate<Integer, ItemStack> validation) {
        this.itemHandler = new ItemStackHandler(slots){

            protected void onContentsChanged(int slot) {
                ContainerBlockEntity.this.update();
                ContainerBlockEntity.this.onItemsChanged(slot);
                ContainerBlockEntity.this.invalidateCapabilities();
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return validation.test(slot, stack);
            }

            public int getSlotLimit(int slot) {
                return (Integer)slotLimit.apply(slot);
            }
        };
    }

    private static int getStackLimit(IItemHandler itemHandler, int slot, ItemStack stack) {
        return Math.min(itemHandler.getSlotLimit(slot), stack.getMaxStackSize());
    }

    public ItemStack forceExtractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.EMPTY;
        }
        ItemStack existing = this.getItemHandler().getStackInSlot(slot);
        if (existing.isEmpty()) {
            return ItemStack.EMPTY;
        }
        int toExtract = Math.min(amount, existing.getMaxStackSize());
        if (existing.getCount() <= toExtract) {
            if (!simulate) {
                this.getItemStackHandler().setStackInSlot(slot, ItemStack.EMPTY);
                this.onItemsChanged(slot);
                return existing;
            }
            return existing.copy();
        }
        if (!simulate) {
            this.getItemStackHandler().setStackInSlot(slot, existing.copyWithCount(existing.getCount() - toExtract));
            this.onItemsChanged(slot);
        }
        return existing.copyWithCount(toExtract);
    }

    public ItemStack forceInsertItem(int slot, ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack existing = this.getItemHandler().getStackInSlot(slot);
        int limit = ContainerBlockEntity.getStackLimit(this.getItemHandler(), slot, stack);
        if (!existing.isEmpty()) {
            if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)existing)) {
                return stack;
            }
            limit -= existing.getCount();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.getCount() > limit;
        if (!simulate) {
            if (existing.isEmpty()) {
                this.getItemStackHandler().setStackInSlot(slot, reachedLimit ? stack.copyWithCount(limit) : stack);
            } else {
                existing.grow(reachedLimit ? limit : stack.getCount());
            }
            this.onItemsChanged(slot);
        }
        return reachedLimit ? stack.copyWithCount(stack.getCount() - limit) : ItemStack.EMPTY;
    }

    public ItemStack forceInsertItem(List<Integer> slots, ItemStack stack, boolean simulate) {
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        for (int slot : slots) {
            boolean reachedLimit;
            int limit;
            ItemStack existing = this.getItemHandler().getStackInSlot(slot);
            int remaining_space = limit = ContainerBlockEntity.getStackLimit(this.getItemHandler(), slot, stack);
            if (!existing.isEmpty()) {
                if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)existing)) continue;
                remaining_space = limit - existing.getCount();
            }
            boolean bl = reachedLimit = stack.getCount() > remaining_space;
            if (!simulate) {
                if (existing.isEmpty()) {
                    this.getItemStackHandler().setStackInSlot(slot, reachedLimit ? stack.copyWithCount(remaining_space) : stack);
                } else {
                    existing.grow(reachedLimit ? remaining_space : stack.getCount());
                }
                this.onItemsChanged(slot);
            }
            if (reachedLimit) {
                stack.setCount(stack.getCount() - remaining_space);
                continue;
            }
            return ItemStack.EMPTY;
        }
        return stack;
    }

    protected final void addFluidTank(int capacityInMb) {
        this.addFluidTank(capacityInMb, ignored -> true);
    }

    protected final void addSecondaryFluidTank(int capacityInMb) {
        this.addSecondaryFluidTank(capacityInMb, ignored -> true);
    }

    protected final void addSecondaryFluidTank(int capacityInMb, Predicate<FluidStack> validation) {
        this.addFluidTank(capacityInMb, validation, true);
    }

    protected final void addFluidTank(int capacityInMn, Predicate<FluidStack> validation) {
        this.addFluidTank(capacityInMn, validation, false);
    }

    protected final void addFluidTank(int capacityInMb, final Predicate<FluidStack> validation, boolean secondary) {
        DynamicFluidTank tank = new DynamicFluidTank(capacityInMb){

            @Override
            protected void onContentsChanged() {
                ContainerBlockEntity.this.update();
                ContainerBlockEntity.this.onFluidChanged();
            }

            @Override
            public boolean isFluidValid(FluidStack stack) {
                return validation.test(stack);
            }
        };
        if (!secondary) {
            this.fluidTank = tank;
        }
    }

    protected final void addEnergyStorage(int energyCapacity) {
        this.energyStorage = new EnergyStorage(energyCapacity){

            public int receiveEnergy(int toReceive, boolean simulate) {
                int receivedEnergy = super.receiveEnergy(toReceive, simulate);
                if (receivedEnergy > 0) {
                    ContainerBlockEntity.this.update();
                    ContainerBlockEntity.this.setChanged();
                    ContainerBlockEntity.this.onEnergyChanged();
                }
                return receivedEnergy;
            }

            public int extractEnergy(int toExtract, boolean simulate) {
                int extractedEnergy = super.extractEnergy(toExtract, simulate);
                if (extractedEnergy > 0) {
                    ContainerBlockEntity.this.update();
                    ContainerBlockEntity.this.setChanged();
                    ContainerBlockEntity.this.onEnergyChanged();
                }
                return extractedEnergy;
            }
        };
    }

    public void update() {
        this.setChanged();
        this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
    }

    protected void onItemsChanged(int slot) {
    }

    protected void onFluidChanged() {
    }

    public void onPowerChanged() {
    }

    public void onEnergyChanged() {
    }

    public void drop() {
        ItemStack[] stacks = this.getItemHandlerStacks();
        if (stacks != null) {
            SimpleContainer inventory = new SimpleContainer(stacks);
            Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inventory);
        }
    }

    @Nullable
    public ItemStack[] getItemHandlerStacks() {
        IItemHandler itemStackHandler = this.getItemHandler();
        if (itemStackHandler == null) {
            return null;
        }
        ItemStack[] itemStacks = new ItemStack[itemStackHandler.getSlots()];
        for (int i = 0; i < itemStackHandler.getSlots(); ++i) {
            itemStacks[i] = itemStackHandler.getStackInSlot(i);
        }
        return itemStacks;
    }

    public List<ItemStack> getItemHandlerStacksList() {
        IItemHandler itemStackHandler = this.getItemHandler();
        if (itemStackHandler == null) {
            return null;
        }
        int slots = itemStackHandler.getSlots();
        ObjectArrayList itemStacks = new ObjectArrayList(slots);
        for (int i = 0; i < slots; ++i) {
            ItemStack stack = itemStackHandler.getStackInSlot(i);
            if (stack.isEmpty()) continue;
            itemStacks.add((Object)stack);
        }
        return itemStacks;
    }

    public <T> T getHandlerOnSide(BlockCapability<T, @Nullable Direction> capability, SidedHandlerSupplier<T> handlerSupplier, Direction direction, T baseHandler) {
        if (direction == null) {
            return baseHandler;
        }
        Map<Direction, Pair<IOAction, int[]>> ioPorts = this.getSidedInteractions(capability);
        if (ioPorts.containsKey(direction)) {
            if (direction == Direction.UP || direction == Direction.DOWN) {
                return handlerSupplier.get(baseHandler, ioPorts.get(direction));
            }
            if (this.getBlockState().hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
                Direction localDir = (Direction)this.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
                return this.getCapOnSide(handlerSupplier, direction, baseHandler, ioPorts, localDir);
            }
            if (this.getBlockState().hasProperty((Property)BlockStateProperties.FACING)) {
                Direction localDir = (Direction)this.getBlockState().getValue((Property)BlockStateProperties.FACING);
                return this.getCapOnSide(handlerSupplier, direction, baseHandler, ioPorts, localDir);
            }
            PortingDeadLibs.LOGGER.warn("Sided io for non facing block");
        }
        return null;
    }

    @Nullable
    private <T> T getCapOnSide(SidedHandlerSupplier<T> handlerSupplier, Direction direction, T baseHandler, Map<Direction, Pair<IOAction, int[]>> ioPorts, Direction localDir) {
        return switch (localDir) {
            case Direction.NORTH -> handlerSupplier.get(baseHandler, ioPorts.get(direction.getOpposite()));
            case Direction.EAST -> handlerSupplier.get(baseHandler, ioPorts.get(direction.getClockWise()));
            case Direction.SOUTH -> handlerSupplier.get(baseHandler, ioPorts.get(direction));
            case Direction.WEST -> handlerSupplier.get(baseHandler, ioPorts.get(direction.getCounterClockWise()));
            default -> null;
        };
    }

    public IItemHandler getItemHandlerOnSide(Direction direction) {
        return this.getHandlerOnSide(Capabilities.ItemHandler.BLOCK, SidedItemHandler::new, direction, this.getItemHandler());
    }

    public IFluidHandler getFluidHandlerOnSide(Direction direction) {
        return this.getHandlerOnSide(Capabilities.FluidHandler.BLOCK, SidedFluidHandler::new, direction, this.getFluidHandler());
    }

    public IEnergyStorage getEnergyStorageOnSide(Direction direction) {
        return this.getHandlerOnSide(Capabilities.EnergyStorage.BLOCK, SidedEnergyStorage::new, direction, this.getEnergyStorage());
    }

    public abstract <T> Map<Direction, Pair<IOAction, int[]>> getSidedInteractions(BlockCapability<T, @Nullable Direction> var1);

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @NotNull
    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithoutMetadata(provider);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookupProvider) {
        super.onDataPacket(net, pkt, lookupProvider);
    }

    @FunctionalInterface
    public static interface SidedHandlerSupplier<T> {
        public T get(T var1, Pair<IOAction, int[]> var2);
    }
}

