/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.portingdeadlibs.api.datagen;

import com.portingdeadmods.portingdeadlibs.api.utils.PDLBlockStateProperties;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.VariantBlockStateBuilder;

public class ModelBuilder {
    private Block defaultTextureBlock = Blocks.IRON_BLOCK;
    private final Block block;
    private final BlockStateProvider modelProvider;
    private boolean active;
    private boolean horizontalFacing;
    private boolean facing;
    private boolean cutout;
    private ResourceLocation up;
    private ResourceLocation down;
    private ResourceLocation north;
    private ResourceLocation east;
    private ResourceLocation south;
    private ResourceLocation west;
    private ResourceLocation defaultTexture;
    private ResourceLocation particle;

    public ModelBuilder(Block block, BlockStateProvider modelProvider) {
        this.block = block;
        this.modelProvider = modelProvider;
        this.defaultTexture = this.modelProvider.blockTexture(this.defaultTextureBlock);
    }

    public ModelBuilder cutout() {
        this.cutout = true;
        return this;
    }

    public ModelBuilder active() {
        this.active = true;
        return this;
    }

    public ModelBuilder facing() {
        this.facing = true;
        return this;
    }

    public ModelBuilder horizontalFacing() {
        this.horizontalFacing = true;
        return this;
    }

    public ModelBuilder front(ResourceLocation frontTexture) {
        this.north = frontTexture;
        return this;
    }

    public ModelBuilder front(Function<Block, ResourceLocation> frontTexture) {
        return this.front(frontTexture.apply(this.block));
    }

    public ModelBuilder front(BiFunction<Block, String, ResourceLocation> frontTexture, String suffix) {
        return this.front(frontTexture.apply(this.block, suffix));
    }

    public ModelBuilder back(ResourceLocation backTexture) {
        this.south = backTexture;
        return this;
    }

    public ModelBuilder back(Function<Block, ResourceLocation> backTexture) {
        return this.back(backTexture.apply(this.block));
    }

    public ModelBuilder back(BiFunction<Block, String, ResourceLocation> backTexture, String suffix) {
        return this.back(backTexture.apply(this.block, suffix));
    }

    public ModelBuilder sides(ResourceLocation sidesTexture) {
        this.north = sidesTexture;
        this.east = sidesTexture;
        this.south = sidesTexture;
        this.west = sidesTexture;
        return this;
    }

    public ModelBuilder sides(Function<Block, ResourceLocation> sidesTexture) {
        return this.sides(sidesTexture.apply(this.block));
    }

    public ModelBuilder sides(BiFunction<Block, String, ResourceLocation> sidesTexture, String suffix) {
        return this.sides(sidesTexture.apply(this.block, suffix));
    }

    public ModelBuilder top(ResourceLocation topTexture) {
        this.up = topTexture;
        return this;
    }

    public ModelBuilder top(Function<Block, ResourceLocation> topTexture) {
        return this.top(topTexture.apply(this.block));
    }

    public ModelBuilder top(BiFunction<Block, String, ResourceLocation> topTexture, String suffix) {
        return this.top(topTexture.apply(this.block, suffix));
    }

    public ModelBuilder bottom(ResourceLocation bottomTexture) {
        this.down = bottomTexture;
        return this;
    }

    public ModelBuilder bottom(Function<Block, ResourceLocation> bottomTexture) {
        return this.bottom(bottomTexture.apply(this.block));
    }

    public ModelBuilder bottom(BiFunction<Block, String, ResourceLocation> bottomTexture, String suffix) {
        return this.bottom(bottomTexture.apply(this.block, suffix));
    }

    public ModelBuilder defaultTexture(ResourceLocation defaultTexture) {
        this.defaultTexture = defaultTexture;
        return this;
    }

    public ModelBuilder defaultTexture(Function<Block, ResourceLocation> defaultTexture) {
        return this.defaultTexture(defaultTexture.apply(this.block));
    }

    public ModelBuilder defaultTexture(BiFunction<Block, String, ResourceLocation> defaultTexture, String suffix) {
        return this.defaultTexture(defaultTexture.apply(this.block, suffix));
    }

    public ModelBuilder particle(ResourceLocation defaultTexture) {
        this.particle = defaultTexture;
        return this;
    }

    public ModelBuilder particle(Function<Block, ResourceLocation> particleTexture) {
        return this.particle(particleTexture.apply(this.block));
    }

    public ModelBuilder particle(BiFunction<Block, String, ResourceLocation> particleTexture, String suffix) {
        return this.particle(particleTexture.apply(this.block, suffix));
    }

    public void create() {
        BlockModelBuilder activeBuilder = null;
        if (this.active) {
            activeBuilder = (BlockModelBuilder)this.modelProvider.models().withExistingParent(this.name(this.block) + "_active", "cube");
            activeBuilder.texture("down", this.activeTextureOrDefault(this.down));
            activeBuilder.texture("up", this.activeTextureOrDefault(this.up));
            activeBuilder.texture("north", this.activeTextureOrDefault(this.north));
            activeBuilder.texture("east", this.activeTextureOrDefault(this.east));
            activeBuilder.texture("south", this.activeTextureOrDefault(this.south));
            activeBuilder.texture("west", this.activeTextureOrDefault(this.west));
            activeBuilder.texture("particle", this.textureOrDefault(this.particle));
            if (this.cutout) {
                activeBuilder.renderType("cutout");
            }
        }
        BlockModelBuilder inactiveBuilder = (BlockModelBuilder)this.modelProvider.models().withExistingParent(this.name(this.block), "cube");
        inactiveBuilder.texture("down", this.textureOrDefault(this.down));
        inactiveBuilder.texture("up", this.textureOrDefault(this.up));
        inactiveBuilder.texture("north", this.textureOrDefault(this.north));
        inactiveBuilder.texture("east", this.textureOrDefault(this.east));
        inactiveBuilder.texture("south", this.textureOrDefault(this.south));
        inactiveBuilder.texture("west", this.textureOrDefault(this.west));
        inactiveBuilder.texture("particle", this.textureOrDefault(this.particle));
        if (this.cutout) {
            inactiveBuilder.renderType("cutout");
        }
        this.createBlockState(activeBuilder, inactiveBuilder);
    }

    private ResourceLocation activeTextureOrDefault(ResourceLocation texture) {
        return texture != null ? this.extend(texture, "_active") : this.defaultTexture;
    }

    private ResourceLocation textureOrDefault(ResourceLocation texture) {
        return texture != null ? texture : this.defaultTexture;
    }

    private void createBlockState(BlockModelBuilder activeBuilder, BlockModelBuilder inactiveBuilder) {
        VariantBlockStateBuilder builder = this.modelProvider.getVariantBuilder(this.block);
        if (this.facing) {
            for (Direction dir : BlockStateProperties.FACING.getPossibleValues()) {
                if (this.active) {
                    ((VariantBlockStateBuilder)builder.partialState().with((Property)PDLBlockStateProperties.ACTIVE, (Comparable)Boolean.valueOf(true)).with((Property)BlockStateProperties.FACING, (Comparable)dir).modelForState().modelFile((ModelFile)activeBuilder).rotationX(dir == Direction.DOWN ? 180 : (dir.getAxis().isHorizontal() ? 90 : 0)).rotationY(dir.getAxis().isVertical() ? 0 : ((int)dir.toYRot() + 180) % 360).addModel()).partialState().with((Property)PDLBlockStateProperties.ACTIVE, (Comparable)Boolean.valueOf(false)).with((Property)BlockStateProperties.FACING, (Comparable)dir).modelForState().modelFile((ModelFile)inactiveBuilder).rotationX(dir == Direction.DOWN ? 180 : (dir.getAxis().isHorizontal() ? 90 : 0)).rotationY(dir.getAxis().isVertical() ? 0 : ((int)dir.toYRot() + 180) % 360).addModel();
                    continue;
                }
                builder.partialState().with((Property)BlockStateProperties.FACING, (Comparable)dir).modelForState().modelFile((ModelFile)inactiveBuilder).rotationX(dir == Direction.DOWN ? 180 : (dir.getAxis().isHorizontal() ? 90 : 0)).rotationY(dir.getAxis().isVertical() ? 0 : ((int)dir.toYRot() + 180) % 360).addModel();
            }
        } else if (this.horizontalFacing) {
            for (Direction dir : BlockStateProperties.HORIZONTAL_FACING.getPossibleValues()) {
                if (this.active) {
                    ((VariantBlockStateBuilder)builder.partialState().with((Property)PDLBlockStateProperties.ACTIVE, (Comparable)Boolean.valueOf(true)).with((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)dir).modelForState().modelFile((ModelFile)activeBuilder).rotationY(((int)dir.toYRot() + 180) % 360).addModel()).partialState().with((Property)PDLBlockStateProperties.ACTIVE, (Comparable)Boolean.valueOf(false)).with((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)dir).modelForState().modelFile((ModelFile)inactiveBuilder).rotationY(((int)dir.toYRot() + 180) % 360).addModel();
                    continue;
                }
                builder.partialState().with((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)dir).modelForState().modelFile((ModelFile)inactiveBuilder).rotationY(((int)dir.toYRot() + 180) % 360).addModel();
            }
        } else if (this.active) {
            ((VariantBlockStateBuilder)builder.partialState().with((Property)PDLBlockStateProperties.ACTIVE, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)activeBuilder).addModel()).partialState().with((Property)PDLBlockStateProperties.ACTIVE, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)inactiveBuilder).addModel();
        } else {
            builder.partialState().modelForState().modelFile((ModelFile)inactiveBuilder).addModel();
        }
    }

    public void setDefaultTextureBlock(Block defaultTextureBlock) {
        this.defaultTextureBlock = defaultTextureBlock;
    }

    private ResourceLocation key(Block block) {
        return BuiltInRegistries.BLOCK.getKey((Object)block);
    }

    private String name(Block block) {
        return this.key(block).getPath();
    }

    private ResourceLocation extend(ResourceLocation rl, String suffix) {
        String var10000 = rl.getNamespace();
        String var10001 = rl.getPath();
        return ResourceLocation.fromNamespaceAndPath((String)var10000, (String)(var10001 + suffix));
    }
}

