/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.portingdeadlibs.utils;

import com.portingdeadmods.portingdeadlibs.utils.UniqueArray;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.AABB;

public final class AABBUtils {
    public static AABB move(AABB aabb, Direction direction, double distance) {
        switch (direction) {
            case UP: {
                return aabb.move(0.0, distance, 0.0);
            }
            case DOWN: {
                return aabb.move(0.0, -distance, 0.0);
            }
            case NORTH: {
                return aabb.move(0.0, 0.0, -distance);
            }
            case SOUTH: {
                return aabb.move(0.0, 0.0, distance);
            }
            case WEST: {
                return aabb.move(-distance, 0.0, 0.0);
            }
            case EAST: {
                return aabb.move(distance, 0.0, 0.0);
            }
        }
        return aabb;
    }

    public static AABB create(double left, double right, double down, double up, double front, double back, double x, double y, double z) {
        return new AABB(-left + x, -down + y, -front + z, right + x, up + y, back + z);
    }

    public static AABB create(double left, double right, double down, double up, double front, double back, BlockPos pos) {
        AABB blockPosAABB = new AABB(pos);
        return blockPosAABB.inflate((left + right) / 2.0, (down + up) / 2.0, (front + back) / 2.0).move((-left + right) / 2.0, (-down + up) / 2.0, (-front + back) / 2.0);
    }

    public static UniqueArray<BlockPos> getAllPositionsInAABB(AABB aabb) {
        int minX = (int)Math.ceil(aabb.minX);
        int maxX = (int)Math.floor(aabb.maxX);
        int minY = (int)Math.ceil(aabb.minY);
        int maxY = (int)Math.floor(aabb.maxY);
        int minZ = (int)Math.ceil(aabb.minZ);
        int maxZ = (int)Math.floor(aabb.maxZ);
        UniqueArray<BlockPos> positions = new UniqueArray<BlockPos>();
        for (int x = minX; x < maxX; ++x) {
            for (int y = minY; y < maxY; ++y) {
                for (int z = minZ; z < maxZ; ++z) {
                    positions.add(new BlockPos(x, y, z));
                }
            }
        }
        return positions;
    }
}

