/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.portingdeadlibs.utils.ranges;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.portingdeadmods.portingdeadlibs.utils.ranges.AbstractRange;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import java.util.Collection;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public class FloatRange
extends AbstractRange<Float> {
    public static final MapCodec<FloatRange> MAP_CODEC = FloatRange.rangeMapCodec(Codec.FLOAT, FloatRange::new);
    public static final StreamCodec<RegistryFriendlyByteBuf, FloatRange> STREAM_CODEC = FloatRange.rangeStreamCodec(ByteBufCodecs.FLOAT, FloatRange::new);

    protected FloatRange(Float minInclusive, Float maxInclusive, Float step) {
        super(minInclusive, maxInclusive, step);
    }

    protected FloatRange(Float minInclusive, Float maxInclusive) {
        super(minInclusive, maxInclusive);
    }

    @Override
    protected Collection<Float> collectPossibleValues(Float step) {
        FloatArrayList values = new FloatArrayList((int)Math.abs(((Float)this.getMax()).floatValue() - ((Float)this.getMin()).floatValue()) + 1);
        for (float i = ((Float)this.getMin()).floatValue(); i < ((Float)this.getMax()).floatValue(); i += step.floatValue()) {
            values.add(i);
        }
        return ImmutableList.copyOf((Collection)values);
    }

    @Override
    protected Collection<Float> collectPossibleValues() {
        return this.collectPossibleValues(Float.valueOf(1.0f));
    }

    public FloatRange shift(Float offset) {
        return new FloatRange(Float.valueOf(((Float)this.getMin()).floatValue() + offset.floatValue()), Float.valueOf(((Float)this.getMax()).floatValue() + offset.floatValue()));
    }

    public static FloatRange of(float min, float max) {
        return new FloatRange(Float.valueOf(min), Float.valueOf(max));
    }

    public static FloatRange of(float min, float max, float step) {
        if (step <= 0.0f) {
            throw new IllegalArgumentException("Step must be greater than 0");
        }
        return new FloatRange(Float.valueOf(min), Float.valueOf(max), Float.valueOf(step));
    }
}

